/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import be.tarsos.dsp.util.BiQuadFilter;
import java.util.Arrays;

public class PeakPicker {
    private double threshold;
    private int win_post;
    private int win_pre;
    private BiQuadFilter biquad = new BiQuadFilter(0.16, 0.32, 0.16, -0.5949, 0.2348);
    private float[] onset_keep;
    private float[] onset_proc;
    private float[] onset_peek;
    private float[] scratch;
    private float lastPeekValue;

    public PeakPicker(double threshold) {
        this.threshold = threshold;
        this.win_post = 5;
        this.win_pre = 1;
        this.onset_keep = new float[this.win_post + this.win_pre + 1];
        this.onset_proc = new float[this.win_post + this.win_pre + 1];
        this.scratch = new float[this.win_post + this.win_pre + 1];
        this.onset_peek = new float[3];
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public boolean pickPeak(float onset) {
        int j;
        float mean = 0.0f;
        float median = 0.0f;
        int length = this.win_post + this.win_pre + 1;
        for (int j2 = 0; j2 < length - 1; ++j2) {
            this.onset_keep[j2] = this.onset_keep[j2 + 1];
            this.onset_proc[j2] = this.onset_keep[j2];
        }
        this.onset_keep[length - 1] = onset;
        this.onset_proc[length - 1] = onset;
        this.biquad.doFiltering(this.onset_proc, this.scratch);
        float sum = 0.0f;
        for (j = 0; j < length; ++j) {
            this.scratch[j] = this.onset_proc[j];
            sum += this.scratch[j];
        }
        Arrays.sort(this.scratch);
        median = this.scratch[this.scratch.length / 2];
        mean = sum / Float.valueOf(length).floatValue();
        for (j = 0; j < 2; ++j) {
            this.onset_peek[j] = this.onset_peek[j + 1];
        }
        this.onset_peek[2] = (float)((double)(this.onset_proc[this.win_post] - median) - (double)mean * this.threshold);
        boolean isPeak = this.isPeak(1);
        this.lastPeekValue = onset;
        return isPeak;
    }

    public float getLastPeekValue() {
        return this.lastPeekValue;
    }

    private boolean isPeak(int index) {
        return this.onset_peek[index] > this.onset_peek[index - 1] && this.onset_peek[index] > this.onset_peek[index + 1] && (double)this.onset_peek[index] > 0.0;
    }
}

