/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.wavelet.HaarWaveletTransform;
import java.util.Arrays;

public class HaarWaveletCoder
implements AudioProcessor {
    private final HaarWaveletTransform transform = new HaarWaveletTransform();
    private int compression;

    public HaarWaveletCoder() {
        this(16);
    }

    public HaarWaveletCoder(int compression) {
        this.compression = compression;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioBuffer = audioEvent.getFloatBuffer();
        float[] sortBuffer = new float[audioBuffer.length];
        this.transform.transform(audioEvent.getFloatBuffer());
        for (int i = 0; i < sortBuffer.length; ++i) {
            sortBuffer[i] = Math.abs(audioBuffer[i]);
        }
        Arrays.sort(sortBuffer);
        double threshold = sortBuffer[this.compression];
        for (int i = 0; i < audioBuffer.length; ++i) {
            if (!((double)Math.abs(audioBuffer[i]) <= threshold)) continue;
            audioBuffer[i] = 0.0f;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public int getCompression() {
        return this.compression;
    }
}

