/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class HaarWaveletFileReader
implements AudioProcessor {
    private final int compression;
    private FileInputStream rawInputStream;

    public HaarWaveletFileReader(String fileName, int compression) {
        this.compression = compression;
        try {
            this.rawInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            this.rawInputStream = null;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioBuffer = new float[32];
        byte[] byteBuffer = new byte[(32 - this.compression) * 2];
        int placesWithZero = 0;
        try {
            this.rawInputStream.read(byteBuffer);
            placesWithZero += this.rawInputStream.read();
            placesWithZero += this.rawInputStream.read() << 8;
            placesWithZero += this.rawInputStream.read() << 16;
            placesWithZero += this.rawInputStream.read() << 24;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int byteBufferIndex = 0;
        for (int i = 0; i < audioBuffer.length; ++i) {
            float value;
            if ((placesWithZero & 1 << i) == 1 << i) continue;
            int x = byteBuffer[byteBufferIndex] & 0xFF;
            int y = byteBuffer[++byteBufferIndex] << 8;
            ++byteBufferIndex;
            audioBuffer[i] = value = (float)(x |= y) / 32767.0f;
        }
        audioEvent.setFloatBuffer(audioBuffer);
        boolean more = true;
        try {
            more = this.rawInputStream.available() > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return more;
    }

    @Override
    public void processingFinished() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

