/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

class PolynomialInterpolation {
    private static final int numPts = 4;
    private float[][] fourPointTable = new float[4][4];
    private float[][] twoPointTable;

    private void lagrange(float x, int N, float[] c) {
        for (int i = 0; i < N; ++i) {
            float num = 1.0f;
            float denom = 1.0f;
            for (int k = 0; k < N; ++k) {
                if (i == k) continue;
                num *= x - (float)k;
                denom *= (float)(i - k);
            }
            c[i] = num / denom;
        }
    }

    private void fillTable(int N, float[][] table) {
        float n = N;
        int i = 0;
        for (float x = 0.5f; x < n; x += 1.0f) {
            this.lagrange(x, N, table[i]);
            ++i;
        }
    }

    public PolynomialInterpolation() {
        this.fillTable(4, this.fourPointTable);
        this.twoPointTable = new float[2][2];
        this.fillTable(2, this.twoPointTable);
    }

    private void printTable(float[][] table, int N) {
        System.out.println(N + "-point interpolation table:");
        double x = 0.5;
        for (int i = 0; i < N; ++i) {
            System.out.print(x + ": ");
            for (int j = 0; j < N; ++j) {
                System.out.print(table[i][j]);
                if (j >= N - 1) continue;
                System.out.print(", ");
            }
            System.out.println();
            x += 1.0;
        }
    }

    public void printTables() {
        this.printTable(this.fourPointTable, 4);
        this.printTable(this.twoPointTable, 2);
    }

    private void getCoef(float x, int n, float[] c) {
        float[][] table = null;
        int j = (int)x;
        if (j < 0 || j >= n) {
            System.out.println("PolynomialWavelets::getCoef: n = " + n + ", bad x value");
        }
        if (n == 4) {
            table = this.fourPointTable;
        } else if (n == 2) {
            table = this.twoPointTable;
            c[2] = 0.0f;
            c[3] = 0.0f;
        } else {
            System.out.println("PolynomialWavelets::getCoef: bad value for N");
        }
        if (table != null) {
            for (int i = 0; i < n; ++i) {
                c[i] = table[j][i];
            }
        }
    }

    public float interpPoint(float x, int N, float[] d) {
        float[] c = new float[4];
        float point = 0.0f;
        int n = 4;
        if (N < 4) {
            n = N;
        }
        this.getCoef(x, n, c);
        if (n == 4) {
            point = c[0] * d[0] + c[1] * d[1] + c[2] * d[2] + c[3] * d[3];
        } else if (n == 2) {
            point = c[0] * d[0] + c[1] * d[1];
        }
        return point;
    }
}

