/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WaveHeader {
    private static final int HEADER_LENGTH = 44;
    public static final short FORMAT_PCM = 1;
    public static final short FORMAT_ALAW = 6;
    public static final short FORMAT_ULAW = 7;
    private short mFormat;
    private short mNumChannels;
    private int mSampleRate;
    private short mBitsPerSample;
    private int mNumBytes;

    public WaveHeader() {
    }

    public WaveHeader(short format, short numChannels, int sampleRate, short bitsPerSample, int numBytes) {
        this.mFormat = format;
        this.mSampleRate = sampleRate;
        this.mNumChannels = numChannels;
        this.mBitsPerSample = bitsPerSample;
        this.mNumBytes = numBytes;
    }

    public short getFormat() {
        return this.mFormat;
    }

    public WaveHeader setFormat(short format) {
        this.mFormat = format;
        return this;
    }

    public short getNumChannels() {
        return this.mNumChannels;
    }

    public WaveHeader setNumChannels(short numChannels) {
        this.mNumChannels = numChannels;
        return this;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public WaveHeader setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
        return this;
    }

    public short getBitsPerSample() {
        return this.mBitsPerSample;
    }

    public WaveHeader setBitsPerSample(short bitsPerSample) {
        this.mBitsPerSample = bitsPerSample;
        return this;
    }

    public int getNumBytes() {
        return this.mNumBytes;
    }

    public WaveHeader setNumBytes(int numBytes) {
        this.mNumBytes = numBytes;
        return this;
    }

    public int read(InputStream in) throws IOException {
        WaveHeader.readId(in, "RIFF");
        WaveHeader.readId(in, "WAVE");
        WaveHeader.readId(in, "fmt ");
        if (16 != WaveHeader.readInt(in)) {
            throw new IOException("fmt chunk length not 16");
        }
        this.mFormat = WaveHeader.readShort(in);
        this.mNumChannels = WaveHeader.readShort(in);
        this.mSampleRate = WaveHeader.readInt(in);
        int byteRate = WaveHeader.readInt(in);
        short blockAlign = WaveHeader.readShort(in);
        this.mBitsPerSample = WaveHeader.readShort(in);
        if (byteRate != this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8) {
            throw new IOException("fmt.ByteRate field inconsistent");
        }
        if (blockAlign != this.mNumChannels * this.mBitsPerSample / 8) {
            throw new IOException("fmt.BlockAlign field inconsistent");
        }
        WaveHeader.readId(in, "data");
        this.mNumBytes = WaveHeader.readInt(in);
        return 44;
    }

    private static void readId(InputStream in, String id) throws IOException {
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) == in.read()) continue;
            throw new IOException(id + " tag not present");
        }
    }

    private static int readInt(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    private static short readShort(InputStream in) throws IOException {
        return (short)(in.read() | in.read() << 8);
    }

    public int write(OutputStream out) throws IOException {
        WaveHeader.writeId(out, "RIFF");
        WaveHeader.writeInt(out, 36 + this.mNumBytes);
        WaveHeader.writeId(out, "WAVE");
        WaveHeader.writeId(out, "fmt ");
        WaveHeader.writeInt(out, 16);
        WaveHeader.writeShort(out, this.mFormat);
        WaveHeader.writeShort(out, this.mNumChannels);
        WaveHeader.writeInt(out, this.mSampleRate);
        WaveHeader.writeInt(out, this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8);
        WaveHeader.writeShort(out, (short)(this.mNumChannels * this.mBitsPerSample / 8));
        WaveHeader.writeShort(out, this.mBitsPerSample);
        WaveHeader.writeId(out, "data");
        WaveHeader.writeInt(out, this.mNumBytes);
        return 44;
    }

    private static void writeId(OutputStream out, String id) throws IOException {
        for (int i = 0; i < id.length(); ++i) {
            out.write(id.charAt(i));
        }
    }

    private static void writeInt(OutputStream out, int val) throws IOException {
        out.write(val >> 0);
        out.write(val >> 8);
        out.write(val >> 16);
        out.write(val >> 24);
    }

    private static void writeShort(OutputStream out, short val) throws IOException {
        out.write(val >> 0);
        out.write(val >> 8);
    }

    public String toString() {
        return String.format("WaveHeader format=%d numChannels=%d sampleRate=%d bitsPerSample=%d numBytes=%d", this.mFormat, this.mNumChannels, this.mSampleRate, this.mBitsPerSample, this.mNumBytes);
    }
}

