/*
 * Decompiled with CFR 0.152.
 */
package de.malban;

import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class Global {
    public static final String VideVersion = "Version 2.6 RC3 2024 Dec 22";
    public static final boolean JOGL_ENABLE;
    public static final String OSNAME;
    public static final String NATIVES_PATH;
    public static final boolean SOLARIS;
    public static final boolean LINUX;
    public static final boolean MAC_OS_X;
    public static final boolean WINDOWS;
    public static final int majorOSVersion;
    public static boolean doTestJava;
    public static final String mainPathPrefix;
    public static PrintStream devNull;
    public static PrintStream devErr;
    public static PrintStream devOut;
    public static String bootString;
    public static String mBaseDir;
    private static final Random _Rand;
    private static final long usedFirstSeed;
    public static CSAMainFrame mMainWindow;
    public static long nextSeed;
    private static boolean firstTime;
    private static Color splitLight;
    private static Color splitDark;
    public static Color linkColor;
    public static Color textColor;

    public static void setCurrentSeed(long seed) {
        _Rand.setSeed(seed);
    }

    public static long getCurrentSeed() {
        int j;
        int i;
        byte[] bar;
        byte[] ba1;
        byte[] ba0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(new Random(0L));
            ba0 = baos.toByteArray();
            baos = new ByteArrayOutputStream(128);
            oos = new ObjectOutputStream(baos);
            oos.writeObject(new Random(-1L));
            ba1 = baos.toByteArray();
            baos = new ByteArrayOutputStream(128);
            oos = new ObjectOutputStream(baos);
            oos.writeObject(_Rand);
            bar = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
        if (ba0.length != ba1.length || ba0.length != bar.length) {
            throw new RuntimeException("bad serialized length");
        }
        for (i = 0; i < ba0.length && ba0[i] == ba1[i]; ++i) {
        }
        for (j = ba0.length; j > 0 && ba0[j - 1] == ba1[j - 1]; --j) {
        }
        if (j - i != 6) {
            throw new RuntimeException("6 differing bytes not found");
        }
        return (((long)bar[i] & 0xFFL) << 40 | ((long)bar[i + 1] & 0xFFL) << 32 | ((long)bar[i + 2] & 0xFFL) << 24 | ((long)bar[i + 3] & 0xFFL) << 16 | ((long)bar[i + 4] & 0xFFL) << 8 | (long)bar[i + 5] & 0xFFL) ^ 0x5DEECE66DL;
    }

    public static Random getRand() {
        return _Rand;
    }

    public static String getOSName() {
        return ManagementFactory.getOperatingSystemMXBean().getName();
    }

    public static int getOSBit() {
        boolean is64bit = false;
        if (System.getProperty("os.name").contains("Windows")) {
            is64bit = System.getenv("ProgramFiles(x86)") != null;
        } else {
            boolean bl = is64bit = System.getProperty("os.arch").indexOf("64") != -1;
        }
        if (is64bit) {
            return 64;
        }
        return 32;
    }

    private static String getJarName() {
        return new File(Global.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
    }

    private static boolean runningFromJAR() {
        String jarName = Global.getJarName();
        return jarName.contains(".jar");
    }

    public static String getProgramDirectory() {
        if (Global.runningFromJAR()) {
            return Global.getCurrentJARDirectory();
        }
        return Global.getCurrentProjectDirectory();
    }

    private static String getCurrentProjectDirectory() {
        return new File("").getAbsolutePath();
    }

    private static String getCurrentJARDirectory() {
        try {
            return new File(Global.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
        }
        catch (URISyntaxException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getHTMLColor(Color c) {
        return (String.format("%02X", c.getRed()) + String.format("%02X", c.getGreen()) + String.format("%02X", c.getBlue())).toLowerCase();
    }

    public static void initLAF() {
        UIDefaults table;
        if (firstTime) {
            firstTime = false;
            table = UIManager.getLookAndFeelDefaults();
            splitLight = (Color)table.get("SplitPane.highlight");
            splitDark = (Color)table.get("SplitPane.darkShadow");
        }
        try {
            System.setOut(devNull);
            UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
            table = UIManager.getLookAndFeelDefaults();
            HTMLEditorKit kit = new HTMLEditorKit();
            StyleSheet styleSheet = kit.getStyleSheet();
            styleSheet.addRule("a {color:#" + Global.getHTMLColor(linkColor) + ";}");
            styleSheet.addRule("body {color:#" + Global.getHTMLColor(textColor) + ";}");
            if (splitLight != null) {
                table.put("SplitPane.highlight", splitLight);
            }
            if (splitDark != null) {
                table.put("SplitPane.darkShadow", splitDark);
            }
            if (Theme.splitPaneHightlight.getColor() != null) {
                table.put("SplitPane.highlight", Theme.splitPaneHightlight.getColor());
            }
            if (Theme.splitPaneDarkShadow.getColor() != null) {
                table.put("SplitPane.darkShadow", Theme.splitPaneDarkShadow.getColor());
            }
            table.put("Panel.foreground", table.get("TextField.foreground"));
            table.put("TextPane.foreground", table.get("TextField.foreground"));
            table.put("TextPane.background", table.get("TextField.background"));
            table.put("TextPane.selectionForeground", table.get("TextField.selectionForeground"));
            table.put("TextPane.selectionBackground", table.get("TextField.selectionBackground"));
            table.put("TextPane.caretForeground", table.get("TextField.caretForeground"));
            table.put("TextArea.caretForeground", table.get("TextField.caretForeground"));
            table.put("EditorPane.caretForeground", table.get("TextField.caretForeground"));
            Global.updateComponentTree();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            System.setOut(devOut);
        }
    }

    public static void updateComponentTree() {
        Logable d;
        Logable l;
        if (mMainWindow != null) {
            SwingUtilities.updateComponentTreeUI(mMainWindow);
        }
        if ((l = Configuration.getConfiguration().getLogEntity()) != null && l instanceof LogPanel) {
            SwingUtilities.updateComponentTreeUI((LogPanel)l);
        }
        if ((d = Configuration.getConfiguration().getDebugEntity()) != null && d instanceof LogPanel) {
            SwingUtilities.updateComponentTreeUI((LogPanel)d);
        }
    }

    public static String getVersionString() {
        return VideVersion;
    }

    static {
        doTestJava = true;
        bootString = "";
        devErr = System.err;
        devOut = System.out;
        devNull = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        StringBuilder b = new StringBuilder();
        Map<String, String> env = System.getenv();
        String VideHome = env.get("VIDE_HOME");
        String home = "";
        if (VideHome != null) {
            b.append("VIDE_HOME = " + VideHome + "\n");
            home = "";
            home = new File(UtilityFiles.convertSeperator(VideHome)).getAbsolutePath();
            if (!home.endsWith(File.separator)) {
                home = home + File.separator;
            }
            mainPathPrefix = home;
            b.append("VIDE_HOME found end read to: " + mainPathPrefix + "\n");
        } else {
            String oldDir;
            File t2;
            b.append("VIDE_HOME = NOT FOUND!\n - Scanning directories!\n");
            boolean found = false;
            String currentDir = "." + File.separator;
            try {
                currentDir = new File(currentDir).getCanonicalPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!currentDir.endsWith(File.separator)) {
                currentDir = currentDir + File.separator;
            }
            while (!found) {
                b.append("Searching vide home in: " + currentDir + "\n");
                t2 = new File(currentDir + "serialize");
                if (t2.exists() && (t2 = new File(currentDir + "cartridges")).exists()) {
                    found = true;
                }
                if (found) continue;
                oldDir = currentDir;
                try {
                    currentDir = new File(currentDir + "..").getCanonicalPath();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!currentDir.endsWith(File.separator)) {
                    currentDir = currentDir + File.separator;
                }
                if (!currentDir.equals(oldDir)) continue;
                break;
            }
            if (!found) {
                currentDir = "." + File.separator;
                try {
                    currentDir = new File(currentDir).getCanonicalPath();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                if (!currentDir.endsWith(File.separator)) {
                    currentDir = currentDir + File.separator;
                }
                currentDir = currentDir + "NetBeansProjects" + File.separator + "Vide" + File.separator;
                while (!found) {
                    b.append("Searching vide home in: " + currentDir + "\n");
                    t2 = new File(currentDir + "serialize");
                    if (t2.exists() && (t2 = new File(currentDir + "cartridges")).exists()) {
                        found = true;
                    }
                    if (found) continue;
                    oldDir = currentDir;
                    try {
                        currentDir = new File(currentDir + "..").getCanonicalPath();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!currentDir.endsWith(File.separator)) {
                        currentDir = currentDir + File.separator;
                    }
                    if (!currentDir.equals(oldDir)) continue;
                    break;
                }
            }
            if (!found) {
                currentDir = "." + File.separator;
                try {
                    currentDir = new File(currentDir).getCanonicalPath();
                }
                catch (Throwable t3) {
                    // empty catch block
                }
                if (!currentDir.endsWith(File.separator)) {
                    currentDir = currentDir + File.separator;
                }
                currentDir = currentDir + "NetBeansProjects" + File.separator + "Vide" + File.separator;
                while (!found) {
                    String currentDirWork = currentDir + "Vide" + File.separator;
                    b.append("Searching vide home in: " + currentDirWork + "\n");
                    File t4 = new File(currentDirWork + "serialize");
                    if (t4.exists() && (t4 = new File(currentDirWork + "cartridges")).exists()) {
                        found = true;
                    }
                    if (found) continue;
                    String oldDir2 = currentDir;
                    try {
                        currentDir = new File(currentDir + "..").getCanonicalPath();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!currentDir.endsWith(File.separator)) {
                        currentDir = currentDir + File.separator;
                    }
                    if (!currentDir.equals(oldDir2)) continue;
                    break;
                }
            }
            if (!found) {
                JOptionPane.showMessageDialog(null, "Vide could not find its home directory and will not run correctly!\nPlease set the environment variable VIDE_HOME!\n\n" + b.toString(), "Vide problem", 1);
                System.exit(1);
            }
            if (!(home = new File(UtilityFiles.convertSeperator(currentDir)).getAbsolutePath()).endsWith(File.separator)) {
                home = home + File.separator;
            }
            mainPathPrefix = home;
            b.append("Vide determined home at: " + mainPathPrefix + "\n");
        }
        OSNAME = System.getProperty("os.name").toLowerCase();
        if (OSNAME.startsWith("mac")) {
            LINUX = false;
            MAC_OS_X = true;
            WINDOWS = false;
            SOLARIS = false;
        } else if (OSNAME.contains("windows")) {
            LINUX = false;
            MAC_OS_X = false;
            WINDOWS = true;
            SOLARIS = false;
        } else if (OSNAME.contains("sol")) {
            LINUX = false;
            MAC_OS_X = false;
            WINDOWS = false;
            SOLARIS = true;
        } else {
            LINUX = true;
            MAC_OS_X = false;
            WINDOWS = false;
            SOLARIS = false;
        }
        if (!MAC_OS_X) {
            String osVersion = System.getProperty("os.version");
            String[] v = osVersion.split("\\.");
            majorOSVersion = (v = UtilityString.cleanStringArray(v)).length > 0 ? UtilityString.Int0(v[0]) : 0;
        } else {
            String osVersion = "";
            String[] cmd = new String[]{"/usr/bin/sw_vers", "-productVersion"};
            boolean ok = false;
            b.append("Mac OS ... trying to figure out correct version...");
            try (InputStream inputStream = new ProcessBuilder(cmd).start().getInputStream();
                 Scanner s = new Scanner(inputStream).useDelimiter("\\A");){
                osVersion = s.hasNext() ? s.next() : "";
                ok = true;
            }
            catch (IOException e) {
                b.append(" failed.\n");
                b.append("Exception: " + e.toString() + "\n");
                b.append("Message: " + e.toString());
                e.printStackTrace();
            }
            String[] v = osVersion.split("\\.");
            v = UtilityString.cleanStringArray(v);
            majorOSVersion = v.length > 0 ? UtilityString.Int0(v[0]) : 0;
            if (ok) {
                b.append(" success, version string: " + osVersion);
                b.append("->^major version: " + majorOSVersion + "\n");
            }
        }
        if (MAC_OS_X && majorOSVersion >= 13) {
            b.append("JOGL disabled for Mac OS >= Ventura\n");
            JOGL_ENABLE = false;
        } else {
            JOGL_ENABLE = true;
        }
        NATIVES_PATH = WINDOWS ? mainPathPrefix + "lib" + File.separator : (MAC_OS_X ? mainPathPrefix + "lib" : (LINUX ? mainPathPrefix + "lib" : (SOLARIS ? mainPathPrefix + "lib" : mainPathPrefix + "lib")));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String os = System.getProperty("os.name", "").trim();
                if (os.startsWith("Windows 8") || os.startsWith("Windows 1")) {
                    System.setProperty("jinput.useDefaultPlugin", "false");
                    System.setProperty("net.java.games.input.plugins", "net.java.games.input.DirectAndRawInputEnvironmentPlugin");
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("net.java.games.input.librarypath", new File(NATIVES_PATH).getAbsolutePath());
                return null;
            }
        });
        bootString = b.toString();
        mBaseDir = mainPathPrefix + "xml" + File.separator;
        _Rand = new Random();
        mMainWindow = null;
        nextSeed = -1L;
        usedFirstSeed = _Rand.nextLong();
        _Rand.setSeed(usedFirstSeed);
        firstTime = true;
        linkColor = Color.blue;
        textColor = Color.black;
    }
}

