/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config;

import de.malban.Global;
import de.malban.config.ConfigurationData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ConfigurationDataPool {
    public static final String DEFAULT_XML_NAME = new String("ConfigurationData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ConfigurationData> mConfigurationData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ConfigurationDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ConfigurationDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ConfigurationData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mConfigurationData = ConfigurationData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ConfigurationData.saveCollectionAsXML(this.mFileName, this.mConfigurationData.values());
        this.buildKlassenMap();
    }

    public void remove(ConfigurationData st) {
        this.mConfigurationData.remove(st.mName);
    }

    public void put(ConfigurationData st) {
        this.mConfigurationData.remove(st.mName);
        this.mConfigurationData.put(st.mName, st);
    }

    public void putAsNew(ConfigurationData st) {
        this.mConfigurationData.put(st.mName, st);
    }

    public ConfigurationData get(String key) {
        return this.mConfigurationData.get(key);
    }

    public HashMap<String, ConfigurationData> getHashMap() {
        return this.mConfigurationData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ConfigurationData>> entries = this.mConfigurationData.entrySet();
        for (Map.Entry<String, ConfigurationData> entry : entries) {
            ConfigurationData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ConfigurationData> getMapForKlasse(String klasse) {
        HashMap<String, ConfigurationData> ret = new HashMap<String, ConfigurationData>();
        Set<Map.Entry<String, ConfigurationData>> entries = this.mConfigurationData.entrySet();
        for (Map.Entry<String, ConfigurationData> entry : entries) {
            ConfigurationData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

