/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config;

import com.javamex.classmexer.MemoryUtil;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.ImageCache;
import de.malban.gui.ImageCacheWatchFrame;
import de.malban.gui.TimingTriggerer;
import de.malban.gui.TriggerCallback;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.sound.PlayClip;
import de.malban.vide.vecx.VecX;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.VecXState;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class ConfigurationPanel
extends JPanel
implements Windowable {
    private boolean USE_CLASSMEX = false;
    private int mClassSetting = 0;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    ImageCacheWatchFrame imageCacheWatchFrame = null;
    private JButton jButton2;
    private JButton jButton5;
    private JButton jButtonCacheWatch;
    private JButton jButtonFXCache;
    private JButton jButtonHintsCache;
    private JButton jButtonImageCache;
    private JButton jButtonSave;
    private JButton jButtonScriptCache;
    private JCheckBox jCheckBoxAutoSave;
    private JCheckBox jCheckBoxCacheActive;
    private JCheckBox jCheckBoxDebugFileOnly;
    private JCheckBox jCheckBoxDebugOff;
    private JCheckBox jCheckBoxDebugTiming;
    private JCheckBox jCheckBoxDebugWindow;
    private JCheckBox jCheckBoxDisableFileLogging;
    private JCheckBox jCheckBoxInfoInPanel;
    private JCheckBox jCheckBoxScriptCache;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel31;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextField jTextFieldClasses;
    private JTextField jTextFieldDebugLevel;
    private JTextField jTextFieldFXCache1;
    private JTextField jTextFieldFiles;
    private JTextField jTextFieldHintsCache;
    private JTextField jTextFieldImageCache;
    private JTextField jTextFieldMethods;
    private JTextField jTextFieldScriptCache;
    ArrayList<SizeableObject> sobjects = new ArrayList();
    public static int POLL_RESOLUTION;
    private static int pollResultion;
    static TimingTriggerer timer;
    boolean doTimer = false;
    TriggerCallback triggerCallback = new TriggerCallback(){

        @Override
        public void doIt(int state, Object o) {
            if (ConfigurationPanel.this.doTimer) {
                ConfigurationPanel.this.updateTableValues();
                timer.addTrigger(ConfigurationPanel.this.triggerCallback, pollResultion, 0, null);
            }
        }
    };

    @Override
    public void closing() {
        if (this.USE_CLASSMEX) {
            this.deinitObjects();
            this.deinitUpdater();
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Application configuration");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ConfigurationPanel() {
        this.initComponents();
        this.setAllFromCurrent();
        this.jScrollPane1.setVisible(this.USE_CLASSMEX);
        if (this.USE_CLASSMEX) {
            this.initTable();
            this.initUpdater();
        }
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        Configuration C = Configuration.getConfiguration();
        this.jCheckBoxDisableFileLogging.setSelected(C.isFileLoggingDisabled());
        this.jCheckBoxDebugOff.setSelected(C.isDebugOff());
        this.jTextFieldDebugLevel.setText("" + C.getDebugLevel());
        this.jTextFieldFiles.setText("" + C.getDebugFiles());
        this.jTextFieldClasses.setText("" + C.getDebugClasses());
        this.jTextFieldMethods.setText("" + C.getDebugMethods());
        this.jCheckBoxDebugTiming.setSelected(C.isDebugTiming());
        this.jCheckBoxDebugFileOnly.setSelected(C.isDebugFileOnly());
        this.jTextFieldImageCache.setText("");
        ImageCache.cacheActive = C.getCacheActive();
        this.jCheckBoxCacheActive.setSelected(ImageCache.cacheActive);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        Configuration C = Configuration.getConfiguration();
        Integer I = 100;
        try {
            C.setDebugLevel(Integer.parseInt(this.jTextFieldDebugLevel.getText()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        C.setDebugFiles(this.jTextFieldFiles.getText());
        C.setDebugClasses(this.jTextFieldClasses.getText());
        C.setDebugMethods(this.jTextFieldMethods.getText());
        C.setDebugTiming(this.jCheckBoxDebugTiming.isSelected());
        C.setDebugOff(this.jCheckBoxDebugOff.isSelected());
        C.setDebugFileOnly(this.jCheckBoxDebugFileOnly.isSelected());
        C.setFileLoggingDisabled(this.jCheckBoxDisableFileLogging.isSelected());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jTextFieldDebugLevel = new JTextField();
        this.jCheckBoxDebugWindow = new JCheckBox();
        this.jButton2 = new JButton();
        this.jCheckBoxDebugTiming = new JCheckBox();
        this.jTextFieldFiles = new JTextField();
        this.jTextFieldClasses = new JTextField();
        this.jTextFieldMethods = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jCheckBoxDebugOff = new JCheckBox();
        this.jCheckBoxDebugFileOnly = new JCheckBox();
        this.jButton5 = new JButton();
        this.jCheckBoxDisableFileLogging = new JCheckBox();
        this.jCheckBoxInfoInPanel = new JCheckBox();
        this.jCheckBoxAutoSave = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jCheckBoxScriptCache = new JCheckBox();
        this.jTextFieldScriptCache = new JTextField();
        this.jButtonScriptCache = new JButton();
        this.jButtonImageCache = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jTextFieldImageCache = new JTextField();
        this.jLabel17 = new JLabel();
        this.jTextFieldFXCache1 = new JTextField();
        this.jButtonFXCache = new JButton();
        this.jLabel18 = new JLabel();
        this.jButtonHintsCache = new JButton();
        this.jTextFieldHintsCache = new JTextField();
        this.jLabel31 = new JLabel();
        this.jButtonCacheWatch = new JButton();
        this.jCheckBoxCacheActive = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonSave = new JButton();
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Debug"));
        this.jPanel5.setName("jPanel5");
        this.jLabel8.setText("Debug level");
        this.jLabel8.setName("jLabel8");
        this.jTextFieldDebugLevel.setToolTipText("0 - only errors\n1 - errors and warning\n2 - error and warning and info\n3 - error and warning and info an verbose\n");
        this.jTextFieldDebugLevel.setName("jTextFieldDebugLevel");
        this.jCheckBoxDebugWindow.setText("Debug Window in Frame");
        this.jCheckBoxDebugWindow.setHorizontalTextPosition(10);
        this.jCheckBoxDebugWindow.setName("jCheckBoxDebugWindow");
        this.jButton2.setText("Clear Debug log");
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBoxDebugTiming.setText("Add Timing Info");
        this.jCheckBoxDebugTiming.setHorizontalTextPosition(10);
        this.jCheckBoxDebugTiming.setName("jCheckBoxDebugTiming");
        this.jTextFieldFiles.setName("jTextFieldFiles");
        this.jTextFieldClasses.setName("jTextFieldClasses");
        this.jTextFieldMethods.setName("jTextFieldMethods");
        this.jLabel10.setText("Only Files");
        this.jLabel10.setName("jLabel10");
        this.jLabel11.setText("Only Classes");
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setText("Only Methods");
        this.jLabel12.setName("jLabel12");
        this.jCheckBoxDebugOff.setText("Debug Off");
        this.jCheckBoxDebugOff.setHorizontalTextPosition(10);
        this.jCheckBoxDebugOff.setName("jCheckBoxDebugOff");
        this.jCheckBoxDebugFileOnly.setText("Debug in File only");
        this.jCheckBoxDebugFileOnly.setHorizontalTextPosition(10);
        this.jCheckBoxDebugFileOnly.setName("jCheckBoxDebugFileOnly");
        this.jButton5.setText("Clear log");
        this.jButton5.setName("jButton5");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButton5ActionPerformed(evt);
            }
        });
        this.jCheckBoxDisableFileLogging.setText("Disable file logging");
        this.jCheckBoxDisableFileLogging.setToolTipText("No logging to disk, neither debug nor log.");
        this.jCheckBoxDisableFileLogging.setHorizontalTextPosition(10);
        this.jCheckBoxDisableFileLogging.setName("jCheckBoxDisableFileLogging");
        this.jCheckBoxInfoInPanel.setText("Show Debug/Log in game info panel");
        this.jCheckBoxInfoInPanel.setToolTipText("No logging to disk, neither debug nor log.");
        this.jCheckBoxInfoInPanel.setHorizontalTextPosition(10);
        this.jCheckBoxInfoInPanel.setName("jCheckBoxInfoInPanel");
        this.jCheckBoxAutoSave.setText("Auto save");
        this.jCheckBoxAutoSave.setToolTipText("");
        this.jCheckBoxAutoSave.setHorizontalTextPosition(10);
        this.jCheckBoxAutoSave.setName("jCheckBoxAutoSave");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel11, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jTextFieldDebugLevel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDebugOff).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDebugFileOnly)).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBoxDebugTiming, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxDebugWindow, GroupLayout.Alignment.TRAILING).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING).addComponent(this.jButton5, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldClasses, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldMethods, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldFiles, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxDisableFileLogging, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxInfoInPanel, GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBoxAutoSave, GroupLayout.Alignment.TRAILING))).addContainerGap(500, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDebugLevel, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jCheckBoxDebugOff).addComponent(this.jCheckBoxDebugFileOnly)).addGap(4, 4, 4).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFiles, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldClasses, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMethods, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDebugTiming).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDebugWindow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addGap(18, 18, 18).addComponent(this.jCheckBoxDisableFileLogging).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxInfoInPanel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAutoSave).addContainerGap(295, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Debug", this.jPanel5);
        this.jPanel6.setName("jPanel6");
        this.jCheckBoxScriptCache.setText("Use script cache");
        this.jCheckBoxScriptCache.setToolTipText("<html>\nIf script cache is switched on, game will be a bit faster overall.<BR>\nIf you script new cards or AI, you may have to reset the cache manually<BR>\nfor the new scripts to be active.\n</html>");
        this.jCheckBoxScriptCache.setHorizontalTextPosition(10);
        this.jCheckBoxScriptCache.setName("jCheckBoxScriptCache");
        this.jCheckBoxScriptCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jCheckBoxScriptCacheActionPerformed(evt);
            }
        });
        this.jTextFieldScriptCache.setEnabled(false);
        this.jTextFieldScriptCache.setName("jTextFieldScriptCache");
        this.jButtonScriptCache.setText("Reset Cache");
        this.jButtonScriptCache.setName("jButtonScriptCache");
        this.jButtonScriptCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonScriptCacheActionPerformed(evt);
            }
        });
        this.jButtonImageCache.setText("Reset Cache");
        this.jButtonImageCache.setName("jButtonImageCache");
        this.jButtonImageCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonImageCacheActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Images in Cache");
        this.jLabel5.setName("jLabel5");
        this.jLabel9.setText("Scripts in Cache");
        this.jLabel9.setName("jLabel9");
        this.jTextFieldImageCache.setEnabled(false);
        this.jTextFieldImageCache.setName("jTextFieldImageCache");
        this.jLabel17.setText("FX in Cache");
        this.jLabel17.setName("jLabel17");
        this.jTextFieldFXCache1.setEnabled(false);
        this.jTextFieldFXCache1.setName("jTextFieldFXCache1");
        this.jButtonFXCache.setText("Reset Cache");
        this.jButtonFXCache.setName("jButtonFXCache");
        this.jButtonFXCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonFXCacheActionPerformed(evt);
            }
        });
        this.jLabel18.setText("Only caching for clips!");
        this.jLabel18.setName("jLabel18");
        this.jButtonHintsCache.setText("Reset Cache");
        this.jButtonHintsCache.setName("jButtonHintsCache");
        this.jButtonHintsCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonHintsCacheActionPerformed(evt);
            }
        });
        this.jTextFieldHintsCache.setEnabled(false);
        this.jTextFieldHintsCache.setName("jTextFieldHintsCache");
        this.jLabel31.setText("Hints in Cache");
        this.jLabel31.setName("jLabel31");
        this.jButtonCacheWatch.setText("Cache Watch");
        this.jButtonCacheWatch.setName("jButtonCacheWatch");
        this.jButtonCacheWatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonCacheWatchActionPerformed(evt);
            }
        });
        this.jCheckBoxCacheActive.setText("cache active");
        this.jCheckBoxCacheActive.setName("jCheckBoxCacheActive");
        this.jCheckBoxCacheActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jCheckBoxCacheActiveActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setName("jTable1");
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel31, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel17, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldHintsCache, GroupLayout.Alignment.TRAILING, -2, 43, -2).addComponent(this.jTextFieldScriptCache, GroupLayout.Alignment.TRAILING, -2, 43, -2)).addComponent(this.jTextFieldFXCache1, -2, 43, -2)).addComponent(this.jTextFieldImageCache, -2, 43, -2)).addGap(10, 10, 10).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonHintsCache).addComponent(this.jButtonScriptCache).addComponent(this.jButtonFXCache).addComponent(this.jButtonImageCache)).addGap(18, 18, 18).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18).addComponent(this.jCheckBoxScriptCache).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jButtonCacheWatch).addGap(37, 37, 37).addComponent(this.jCheckBoxCacheActive)))).addComponent(this.jScrollPane1, -2, 521, -2)).addContainerGap(327, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jButtonImageCache).addComponent(this.jTextFieldImageCache, -2, -1, -2).addComponent(this.jButtonCacheWatch).addComponent(this.jCheckBoxCacheActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jButtonFXCache).addComponent(this.jLabel18).addComponent(this.jTextFieldFXCache1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldScriptCache, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jButtonScriptCache).addComponent(this.jCheckBoxScriptCache)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel31).addComponent(this.jButtonHintsCache).addComponent(this.jTextFieldHintsCache, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 264, -2).addContainerGap(191, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Cache & Co", this.jPanel6);
        this.jButtonSave.setFont(new Font("Tahoma", 1, 11));
        this.jButtonSave.setText("Save Configuration");
        this.jButtonSave.setName("jButtonSave");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jTabbedPane1, -2, 864, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 609, -2).addContainerGap()));
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        Configuration.getConfiguration().save();
        this.setAllFromCurrent();
    }

    private void jButtonCacheWatchActionPerformed(ActionEvent evt) {
        if (this.imageCacheWatchFrame == null) {
            this.imageCacheWatchFrame = new ImageCacheWatchFrame();
        }
        this.imageCacheWatchFrame.setVisible(true);
    }

    private void jButtonHintsCacheActionPerformed(ActionEvent evt) {
    }

    private void jButtonFXCacheActionPerformed(ActionEvent evt) {
        PlayClip.resetCache();
        this.jTextFieldFXCache1.setText("" + PlayClip.mClipMap.size());
    }

    private void jButtonImageCacheActionPerformed(ActionEvent evt) {
        this.jTextFieldImageCache.setText("0");
    }

    private void jButtonScriptCacheActionPerformed(ActionEvent evt) {
        Configuration C = Configuration.getConfiguration();
        this.jTextFieldScriptCache.setText("0");
    }

    private void jCheckBoxScriptCacheActionPerformed(ActionEvent evt) {
        Configuration C = Configuration.getConfiguration();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        Configuration C = Configuration.getConfiguration();
        C.clearLog();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Configuration C = Configuration.getConfiguration();
        C.clearDebugLog();
    }

    private void jCheckBoxCacheActiveActionPerformed(ActionEvent evt) {
        ImageCache.cacheActive = this.jCheckBoxCacheActive.isSelected();
        ImageCache.clearCache();
        Configuration C = Configuration.getConfiguration();
        C.setCacheActive(ImageCache.cacheActive);
    }

    public static DisplayMode getDisplayModeForString(String s) {
        String m;
        DisplayMode displayMode;
        int i;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        DisplayMode[] modes = devices[0].getDisplayModes();
        for (i = 0; i < modes.length; ++i) {
            displayMode = modes[i];
            m = "";
            m = m + displayMode.getWidth() + "x";
            m = m + displayMode.getHeight() + " ";
            m = m + displayMode.getBitDepth() + "bit ";
            if (!s.equals(m = m + displayMode.getRefreshRate() + "Hz")) continue;
            return displayMode;
        }
        for (i = 0; i < modes.length; ++i) {
            displayMode = modes[i];
            m = "";
            m = m + displayMode.getWidth() + "x";
            m = m + displayMode.getHeight() + " ";
            m = m + displayMode.getBitDepth() + "bit ";
            m = m + displayMode.getRefreshRate() + "Hz";
            if (displayMode.getWidth() != 1024 || displayMode.getBitDepth() != 32) continue;
            return displayMode;
        }
        for (i = 0; i < modes.length; ++i) {
            displayMode = modes[i];
            m = "";
            m = m + displayMode.getWidth() + "x";
            m = m + displayMode.getHeight() + " ";
            m = m + displayMode.getBitDepth() + "bit ";
            m = m + displayMode.getRefreshRate() + "Hz";
            if (displayMode.getWidth() != 1024 || displayMode.getBitDepth() != 16) continue;
            return displayMode;
        }
        for (i = 0; i < modes.length; ++i) {
            displayMode = modes[i];
            m = "";
            m = m + displayMode.getWidth() + "x";
            m = m + displayMode.getHeight() + " ";
            m = m + displayMode.getBitDepth() + "bit ";
            m = m + displayMode.getRefreshRate() + "Hz";
            if (displayMode.getWidth() != 1024 || displayMode.getBitDepth() != 8) continue;
            return displayMode;
        }
        return null;
    }

    String buildStringForMode(DisplayMode displayMode) {
        String m = "";
        if (displayMode == null) {
            return m;
        }
        m = m + displayMode.getWidth() + "x";
        m = m + displayMode.getHeight() + " ";
        m = m + displayMode.getBitDepth() + "bit ";
        m = m + displayMode.getRefreshRate() + "Hz";
        return m;
    }

    private void correctScreenModeIfNeccessary() {
        Configuration C = Configuration.getConfiguration();
        C.setFullScrrenResString(this.buildStringForMode(ConfigurationPanel.getDisplayModeForString(C.getFullScrrenResString())));
    }

    @Override
    public void deIconified() {
    }

    void initTable() {
        SizeableObjectTableModel model = new SizeableObjectTableModel();
        this.jTable1.setModel(model);
        this.initObjects();
    }

    void initUpdater() {
        this.doTimer = true;
        timer = TimingTriggerer.getTimer();
        timer.addTrigger(this.triggerCallback, pollResultion, 0, null);
    }

    void deinitUpdater() {
        this.doTimer = false;
    }

    void deinitObjects() {
        if (this.sobjects != null) {
            this.sobjects.clear();
        }
    }

    void initObjects() {
        VecXState vs;
        CSAMainFrame main = Configuration.getConfiguration().getMainFrame();
        this.deinitObjects();
        SizeableObject so = new SizeableObject();
        so.name = main.getClass().getName();
        so.o = main;
        so.size = MemoryUtil.deepMemoryUsageOf((Object)so.o, (MemoryUtil.VisibilityFilter)MemoryUtil.VisibilityFilter.ALL);
        this.sobjects.add(so);
        VecXPanel v = main.checkVecxy();
        if (v != null && (vs = v.getVecXState()) != null && vs instanceof VecX) {
            VecX vecx = (VecX)vs;
            so = new SizeableObject();
            so.name = vecx.getClass().getName();
            so.o = vecx;
            so.size = MemoryUtil.deepMemoryUsageOf((Object)so.o, (MemoryUtil.VisibilityFilter)MemoryUtil.VisibilityFilter.ALL);
            this.sobjects.add(so);
        }
        this.jTable1.tableChanged(null);
        SizeableObjectTableModel model = (SizeableObjectTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(model.getColWidth(i));
        }
        this.updateTableValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTableValues() {
        ArrayList<SizeableObject> arrayList = this.sobjects;
        synchronized (arrayList) {
            for (SizeableObject so : this.sobjects) {
                so.size = MemoryUtil.deepMemoryUsageOf((Object)so.o, (MemoryUtil.VisibilityFilter)MemoryUtil.VisibilityFilter.ALL);
            }
        }
        this.jTable1.repaint();
    }

    String getSizeAsString(long s) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance();
        return formatter.format(s);
    }

    static {
        pollResultion = POLL_RESOLUTION = 1000;
    }

    public class SizeableObjectTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return ConfigurationPanel.this.sobjects.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ConfigurationPanel.this.sobjects.get((int)row).name;
            }
            if (col == 1) {
                return ConfigurationPanel.this.getSizeAsString(ConfigurationPanel.this.sobjects.get((int)row).size);
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "object";
            }
            if (column == 1) {
                return "size";
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public int getColWidth(int col) {
            if (col == 0) {
                return 200;
            }
            if (col == 1) {
                return 20;
            }
            return 20;
        }
    }

    class SizeableObject {
        String name = "";
        long size = 0L;
        Object o = null;

        SizeableObject() {
        }
    }
}

