/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.sound;

import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.config.sound.SoundMap;
import java.util.HashMap;
import java.util.Vector;

public class SoundEffect {
    public static final String FX_EFFECT_CARD_ANY = "Card any";
    public static final String FX_EFFECT_CARD_PLAYED = "Card played";
    public static final String FX_EFFECT_CARD_GRAVE = "Card to grave";
    public static final String FX_EFFECT_CARD_HAND = "Card to hand";
    public static final String FX_EFFECT_CARD_LIBRARY = "Card to library";
    public static final String FX_EFFECT_PLAYER_TURN = "Player turn";
    public static final String FX_EFFECT_PLAYER_END = "Player end";
    public static final String FX_EFFECT_PLAYER_ADD_LIFE = "Player add life";
    public static final String FX_EFFECT_PLAYER_LOSE_LIFE = "Player lose life";
    public static final String FX_EFFECT_GAME_START = "Game start";
    public static final String FX_EFFECT_GAME_END = "Game end";
    public static final String FX_EFFECT_CARD_ACTIVATED = "Card activated";
    public static final String FX_EFFECT_ACHIEVEMENT = "Achievement";
    public static final String[] FX_EFFECT_TRIGGERS = new String[]{"Card any", "Card played", "Card to grave", "Card to hand", "Card to library", "Player turn", "Player end", "Player add life", "Player lose life", "Game start", "Game end", "Card activated", "Achievement"};
    String mSoundFile = "";
    String mColor = "";
    String mType = "";
    String mSubtype = "";
    String mID = "";
    String mEvent = "";
    static SoundMap activeMap = null;
    static HashMap<String, String> keyPathmap = null;

    public String toString() {
        String ret = "";
        ret = ret + "File: " + this.mSoundFile;
        ret = ret + ", Color: " + this.mColor;
        ret = ret + ", Type: " + this.mType;
        ret = ret + ", Subtype: " + this.mSubtype;
        ret = ret + ", ID: " + this.mID;
        ret = ret + ", Event: " + this.mEvent;
        return ret;
    }

    static Vector<SoundEffect> buildEffectVector(SoundMap data2) {
        Vector<SoundEffect> v = new Vector<SoundEffect>();
        for (int i = 0; i < data2.mEvent.size(); ++i) {
            v.addElement(SoundEffect.getEffectData(data2, i));
        }
        return v;
    }

    public static Vector<SoundEffect> getEffects(SoundMap data2, String trigger) {
        Vector<SoundEffect> effects = new Vector<SoundEffect>();
        for (int i = 0; i < data2.mEvent.size(); ++i) {
            if (!data2.mEvent.elementAt(i).equals(trigger)) continue;
            effects.addElement(SoundEffect.getEffectData(data2, i));
        }
        return effects;
    }

    static void setEffectVector(SoundMap data2, Vector<SoundEffect> v) {
        data2.mSoundFile = new Vector();
        data2.mColor = new Vector();
        data2.mType = new Vector();
        data2.mSubtype = new Vector();
        data2.mID = new Vector();
        data2.mEvent = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            SoundEffect af = v.elementAt(i);
            SoundEffect.addEffect(data2, af);
        }
    }

    static void addEffect(SoundMap data2, SoundEffect af) {
        SoundEffect.removeEffect(data2, af);
        data2.mSoundFile.addElement(af.mSoundFile);
        data2.mType.addElement(af.mType);
        data2.mColor.addElement(af.mColor);
        data2.mSubtype.addElement(af.mSubtype);
        data2.mID.addElement(af.mID);
        data2.mEvent.addElement(af.mEvent);
    }

    public boolean equals(SoundMap data2, int pos) {
        return this.equals(SoundEffect.getEffectData(data2, pos));
    }

    public boolean equals(SoundMap data2) {
        return data2.toString().equals(this.toString());
    }

    static void removeEffect(SoundMap data2, SoundEffect af) {
        Vector v = new Vector();
        int index = -1;
        for (int i = 0; i < data2.mEvent.size(); ++i) {
            if (!af.equals(data2, i)) continue;
            index = i;
            break;
        }
        SoundEffect.removeEffect(data2, index);
    }

    static void removeEffect(SoundMap data2, int index) {
        if (index != -1) {
            data2.mSoundFile.removeElementAt(index);
            data2.mColor.removeElementAt(index);
            data2.mType.removeElementAt(index);
            data2.mSubtype.removeElementAt(index);
            data2.mID.removeElementAt(index);
            data2.mEvent.removeElementAt(index);
        }
    }

    static SoundEffect getEffectData(SoundMap data2, int i) {
        SoundEffect af = new SoundEffect();
        af.mSoundFile = data2.mSoundFile.elementAt(i);
        af.mColor = data2.mColor.elementAt(i);
        af.mType = data2.mType.elementAt(i);
        af.mSubtype = data2.mSubtype.elementAt(i);
        af.mID = data2.mID.elementAt(i);
        af.mEvent = data2.mEvent.elementAt(i);
        return af;
    }

    public static void resetMappings() {
        activeMap = null;
        keyPathmap = null;
    }

    private static void ensureMappingLoaded() {
        if (activeMap != null) {
            return;
        }
        Configuration C = Configuration.getConfiguration();
        Logable D = C.getDebugEntity();
        activeMap = C.getSoundMap();
        keyPathmap = new HashMap();
        for (int i = 0; i < SoundEffect.activeMap.mEvent.size(); ++i) {
            String key = "";
            String value = SoundEffect.activeMap.mSoundFile.elementAt(i);
            if ((key = key + SoundEffect.activeMap.mEvent.elementAt(i)).indexOf("Card") != -1) {
                key = key + SoundEffect.activeMap.mColor.elementAt(i);
                key = key + SoundEffect.activeMap.mType.elementAt(i);
                key = key + SoundEffect.activeMap.mSubtype.elementAt(i);
                key = key + SoundEffect.activeMap.mID.elementAt(i);
            }
            keyPathmap.put(key, value);
            if (SoundEffect.activeMap.mID.elementAt(i).trim().length() <= 0) continue;
            key = SoundEffect.activeMap.mEvent.elementAt(i);
            key = key + SoundEffect.activeMap.mID.elementAt(i);
            keyPathmap.put(key, value);
        }
    }
}

