/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.sound;

import de.malban.Global;
import de.malban.config.sound.SoundMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class SoundMapPool {
    public static final String DEFAULT_XML_NAME = "SoundMap.xml";
    private String mFileName = "SoundMap.xml";
    private HashMap<String, SoundMap> mSoundMap = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public SoundMapPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public SoundMapPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error SoundMap...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mSoundMap = SoundMap.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        SoundMap.saveCollectionAsXML(this.mFileName, this.mSoundMap.values());
        this.buildKlassenMap();
    }

    public void remove(SoundMap st) {
        this.mSoundMap.remove(st.mName);
    }

    public void put(SoundMap st) {
        this.mSoundMap.remove(st.mName);
        this.mSoundMap.put(st.mName, st);
    }

    public void putAsNew(SoundMap st) {
        this.mSoundMap.put(st.mName, st);
    }

    public SoundMap get(String key) {
        return this.mSoundMap.get(key);
    }

    public HashMap<String, SoundMap> getHashMap() {
        return this.mSoundMap;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, SoundMap>> entries = this.mSoundMap.entrySet();
        for (Map.Entry<String, SoundMap> entry : entries) {
            SoundMap value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, SoundMap> getMapForKlasse(String klasse) {
        HashMap<String, SoundMap> ret = new HashMap<String, SoundMap>();
        Set<Map.Entry<String, SoundMap>> entries = this.mSoundMap.entrySet();
        for (Map.Entry<String, SoundMap> entry : entries) {
            SoundMap value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

