/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.theme.InetThemeData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class InetThemeDataPool {
    public static final String DEFAULT_XML_NAME = new String("InetThemeData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, InetThemeData> mInetThemeData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public InetThemeDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public InetThemeDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error InetThemeData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mInetThemeData = InetThemeData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        InetThemeData.saveCollectionAsXML(this.mFileName, this.mInetThemeData.values());
        this.buildKlassenMap();
    }

    public void remove(InetThemeData st) {
        this.mInetThemeData.remove(st.mName);
    }

    public void put(InetThemeData st) {
        this.mInetThemeData.remove(st.mName);
        this.mInetThemeData.put(st.mName, st);
    }

    public void putAsNew(InetThemeData st) {
        this.mInetThemeData.put(st.mName, st);
    }

    public InetThemeData get(String key) {
        return this.mInetThemeData.get(key);
    }

    public HashMap<String, InetThemeData> getHashMap() {
        return this.mInetThemeData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, InetThemeData>> entries = this.mInetThemeData.entrySet();
        for (Map.Entry<String, InetThemeData> entry : entries) {
            InetThemeData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, InetThemeData> getMapForKlasse(String klasse) {
        HashMap<String, InetThemeData> ret = new HashMap<String, InetThemeData>();
        Set<Map.Entry<String, InetThemeData>> entries = this.mInetThemeData.entrySet();
        for (Map.Entry<String, InetThemeData> entry : entries) {
            InetThemeData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

