/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class ProxyPanel
extends JPanel {
    public static final Proxy.Type[] PROXY_TYPES = Proxy.Type.values();
    private int mProxyType = 0;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonPType;
    private JTextField jTextFieldProxyPort;
    private JTextField jTextFieldProxyURL;

    public ProxyPanel() {
        this.initComponents();
        this.jPanel2.removeAll();
        String[] text = new String[]{"No Proxy", "Http Proxy", "Socks Proxy"};
        for (int i = 0; i < PROXY_TYPES.length; ++i) {
            JRadioButton rb = new JRadioButton(text[i]);
            final int t = i;
            rb.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((AbstractButton)e.getSource()).isSelected()) {
                        ProxyPanel.this.mProxyType = t;
                        ProxyPanel.this.jTextFieldProxyURL.setEnabled(ProxyPanel.this.mProxyType != 0);
                        ProxyPanel.this.jTextFieldProxyPort.setEnabled(ProxyPanel.this.mProxyType != 0);
                    }
                }
            });
            this.buttonGroup1.add(rb);
            this.jPanel2.add(rb);
            if (i != 0) continue;
            rb.setSelected(true);
        }
    }

    public Proxy getProxy() {
        Proxy p;
        if (this.mProxyType == 0) {
            p = Proxy.NO_PROXY;
        } else {
            try {
                p = new Proxy(PROXY_TYPES[this.mProxyType], new InetSocketAddress(this.jTextFieldProxyURL.getText(), UtilityString.IntX(this.jTextFieldProxyPort.getText(), 21)));
            }
            catch (Exception e) {
                Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.ERROR);
                return Proxy.NO_PROXY;
            }
        }
        return p;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTextFieldProxyURL = new JTextField();
        this.jTextFieldProxyPort = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButtonPType = new JRadioButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Proxy Settings"));
        this.jTextFieldProxyURL.setText("Proxy Adress");
        this.jTextFieldProxyURL.setToolTipText("URL");
        this.jTextFieldProxyPort.setText("Port Number");
        this.jTextFieldProxyPort.setToolTipText("Port");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jRadioButtonPType.setText("jRadioButton1");
        this.jPanel2.add(this.jRadioButtonPType);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jTextFieldProxyURL, -2, 229, -2).addPreferredGap(0).add((Component)this.jTextFieldProxyPort, -1, 68, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.jPanel2, -1, 272, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldProxyURL, -2, -1, -2).add((Component)this.jTextFieldProxyPort, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
    }
}

