/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.theme.INetPictureImportPanel;
import de.malban.config.theme.INetThemeConstants;
import de.malban.config.theme.InetImageBaseData;
import de.malban.config.theme.InetThemeData;
import de.malban.config.theme.InetThemeDataPool;
import de.malban.config.theme.ProxyPanel;
import de.malban.config.theme.ThemeData;
import de.malban.config.theme.ThemeDataPool;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.panels.LogPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ThemeBuilderPanel
extends JPanel
implements Windowable,
INetThemeConstants {
    static final HashMap<Integer, HW> hwMap = new HashMap();
    int currentId = -1;
    Vector<InetImageBaseData> data = new Vector();
    InetImageBaseData currentData = null;
    private int mClassSetting = 0;
    private InetThemeData mInetThemeData = new InetThemeData();
    private InetThemeDataPool mInetThemeDataPool;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    Proxy proxy = Proxy.NO_PROXY;
    int inEvent = 0;
    private INetPictureImportPanel iNetPictureImportPanel1;
    private JButton jButton2;
    private JButton jButtonCreateLocalTheme;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBoxScaleBack;
    private JCheckBox jCheckBoxScaleTitle;
    private JComboBox jComboBoxName;
    private JComboBox jComboBoxThemeID;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JTextField jTextField2;
    private JTextField jTextFieldGameBack;
    private JTextField jTextFieldName;

    @Override
    public void closing() {
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
        this.iNetPictureImportPanel1.setParentWindow(this.mParent);
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Theme builder");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public ThemeBuilderPanel() {
        this.initComponents();
        ++this.inEvent;
        this.jComboBoxThemeID.removeAllItems();
        for (int i = 0; i < THEME_ID_NAME.length; ++i) {
            this.jComboBoxThemeID.addItem(THEME_ID_NAME[i]);
        }
        this.jComboBoxThemeID.setSelectedIndex(-1);
        this.jTextField2.setText("");
        this.mInetThemeDataPool = new InetThemeDataPool();
        this.resetConfigPool(false, "");
        this.iNetPictureImportPanel1.hideSave();
        --this.inEvent;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonCreateLocalTheme = new JButton();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jComboBoxName = new JComboBox();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonNew = new JButton();
        this.jPanel2 = new JPanel();
        this.iNetPictureImportPanel1 = new INetPictureImportPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldGameBack = new JTextField();
        this.jCheckBoxScaleBack = new JCheckBox();
        this.jCheckBoxScaleTitle = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxThemeID = new JComboBox();
        this.jTextField2 = new JTextField();
        this.setPreferredSize(new Dimension(914, 600));
        this.jPanel1.setName("jPanel1");
        this.jButtonCreateLocalTheme.setText("Create local theme");
        this.jButtonCreateLocalTheme.setName("jButtonCreateLocalTheme");
        this.jButtonCreateLocalTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButtonCreateLocalThemeActionPerformed(evt);
            }
        });
        this.jButton2.setText("Proxy Configuration");
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel3.setName("jLabel3");
        this.jTextFieldName.setName("jTextFieldName");
        this.jComboBoxName.setName("jComboBoxName");
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setName("jButtonSave");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.setName("jButtonSaveAsNew");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setName("jButtonDelete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonNew.setText("New");
        this.jButtonNew.setName("jButtonNew");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -2, 100, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxName, 0, 133, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addGap(52, 52, 52).addComponent(this.jButtonCreateLocalTheme)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(484, 484, 484).addComponent(this.jButton2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxName, -2, -1, -2).addComponent(this.jButtonSave).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNew).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete).addComponent(this.jButtonCreateLocalTheme))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("One Image setting"));
        this.jPanel2.setName("jPanel2");
        this.iNetPictureImportPanel1.setName("iNetPictureImportPanel1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iNetPictureImportPanel1, -1, 912, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.iNetPictureImportPanel1, -2, 390, -2));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("General Theme settings"));
        this.jPanel4.setName("jPanel4");
        this.jLabel1.setText("Game background filename");
        this.jLabel1.setName("jLabel1");
        this.jTextFieldGameBack.setName("jTextFieldGameBack");
        this.jCheckBoxScaleBack.setText("Scale background");
        this.jCheckBoxScaleBack.setName("jCheckBoxScaleBack");
        this.jCheckBoxScaleTitle.setText("Scale title");
        this.jCheckBoxScaleTitle.setName("jCheckBoxScaleTitle");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldGameBack, -2, 166, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxScaleBack).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxScaleTitle).addContainerGap(291, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldGameBack, -2, -1, -2).addComponent(this.jCheckBoxScaleBack).addComponent(this.jCheckBoxScaleTitle)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("Theme ID");
        this.jLabel2.setName("jLabel2");
        this.jComboBoxThemeID.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxThemeID.setName("jComboBoxThemeID");
        this.jComboBoxThemeID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeBuilderPanel.this.jComboBoxThemeIDActionPerformed(evt);
            }
        });
        this.jTextField2.setEnabled(false);
        this.jTextField2.setName("jTextField2");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(51, 51, 51).addComponent(this.jComboBoxThemeID, -2, 295, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 204, -2).addContainerGap(287, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxThemeID, -2, -1, -2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addGap(124, 124, 124)));
    }

    private void jButtonCreateLocalThemeActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().length() == 0) {
            return;
        }
        String name = this.jTextFieldName.getText();
        String dirName = Global.mainPathPrefix + "theme" + File.separator + name;
        File dir = new File(dirName);
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.ERROR);
            }
        } else {
            int result = Configuration.getConfiguration().showConfirmDialog("Theme already exists, do you want to overwrite existing files?", "Overwrite?");
            if (result != 1) {
                return;
            }
        }
        ThemeData themeData = new ThemeData();
        themeData.mGameImage = Global.mainPathPrefix + "theme" + File.separator + name + File.separator + this.jTextFieldGameBack.getText();
        themeData.mResizeGameImage = this.jCheckBoxScaleBack.isSelected();
        themeData.mResizeTitleImage = this.jCheckBoxScaleTitle.isSelected();
        themeData.mName = name;
        themeData.mClass = "Themes";
        ThemeDataPool mThemeDataPool = new ThemeDataPool(".." + File.separator + "theme" + File.separator + name + File.separator + "Theme.xml");
        mThemeDataPool.put(themeData);
        mThemeDataPool.save();
        for (int i = 0; i < this.data.size(); ++i) {
            InetImageBaseData inetImageBaseData = this.data.elementAt(i);
            this.iNetPictureImportPanel1.importImage(inetImageBaseData, name, this.data);
        }
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mInetThemeData = this.mInetThemeDataPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        InetImageBaseData.fromBase(this.mInetThemeData, this.data);
        this.mInetThemeDataPool.put(this.mInetThemeData);
        this.mInetThemeDataPool.save();
        ++this.mClassSetting;
        String klasse = "ALL";
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mInetThemeData.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mInetThemeData = new InetThemeData();
        this.readAllToCurrent();
        InetImageBaseData.fromBase(this.mInetThemeData, this.data);
        this.mInetThemeDataPool.putAsNew(this.mInetThemeData);
        this.mInetThemeDataPool.save();
        ++this.mClassSetting;
        String klasse = "ALL";
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mInetThemeData.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        InetImageBaseData.fromBase(this.mInetThemeData, this.data);
        this.mInetThemeDataPool.remove(this.mInetThemeData);
        this.mInetThemeDataPool.save();
        ++this.mClassSetting;
        String klasse = "ALL";
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mInetThemeData = this.mInetThemeDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mInetThemeData = new InetThemeData();
        this.currentId = -1;
        this.data = new Vector();
        this.currentData = null;
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        ProxyPanel panel = new ProxyPanel();
        this.mParent.showPanelModal(panel, "Proxy settings", 500, 300);
        this.proxy = panel.getProxy();
        this.iNetPictureImportPanel1.setProxy(this.proxy);
    }

    private void jComboBoxThemeIDActionPerformed(ActionEvent evt) {
        if (this.inEvent != 0) {
            return;
        }
        int id = this.jComboBoxThemeID.getSelectedIndex();
        if (id == -1) {
            return;
        }
        if (this.currentId != -1) {
            this.readCurrentEdit();
        }
        this.currentId = id;
        this.writeCurrentEdit();
        this.jTextField2.setText(THEME_IMAGE_NAME[this.currentId]);
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        int i = 0;
        Collection<InetThemeData> colC = this.mInetThemeDataPool.getHashMap().values();
        Iterator<InetThemeData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            InetThemeData item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mInetThemeData = this.mInetThemeDataPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mInetThemeData = new InetThemeData();
        this.iNetPictureImportPanel1.clearAll();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mInetThemeData.mName);
        this.jTextFieldName.setText(this.mInetThemeData.mName);
        this.jComboBoxThemeID.setSelectedIndex(-1);
        this.jTextField2.setText("");
        this.jTextFieldGameBack.setText(this.mInetThemeData.mGameBackgroundImageName);
        this.jCheckBoxScaleBack.setSelected(this.mInetThemeData.mThemeResizeBackImage);
        this.jCheckBoxScaleTitle.setSelected(this.mInetThemeData.mThemeResizeTitleImage);
        this.data = InetImageBaseData.toBase(this.mInetThemeData);
        this.currentId = -1;
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mInetThemeData.mName = this.jTextFieldName.getText();
        this.mInetThemeData.mGameBackgroundImageName = this.jTextFieldGameBack.getText();
        this.mInetThemeData.mThemeResizeBackImage = this.jCheckBoxScaleBack.isSelected();
        this.mInetThemeData.mThemeResizeTitleImage = this.jCheckBoxScaleTitle.isSelected();
        this.readCurrentEdit();
    }

    void readCurrentEdit() {
        if (this.currentData != null) {
            this.currentData.id = this.currentId;
            this.iNetPictureImportPanel1.readData(this.currentData);
        } else {
            this.currentData = new InetImageBaseData();
            this.currentData.id = this.currentId;
            this.iNetPictureImportPanel1.readData(this.currentData);
            this.data.addElement(this.currentData);
        }
    }

    void writeCurrentEdit() {
        this.currentData = null;
        for (int i = 0; i < this.data.size(); ++i) {
            InetImageBaseData c = this.data.elementAt(i);
            if (this.currentId != c.id) continue;
            this.currentData = c;
            break;
        }
        if (this.currentData != null) {
            this.currentData.id = this.currentId;
            this.iNetPictureImportPanel1.writeData(this.currentData, this.data);
        } else {
            this.currentData = new InetImageBaseData();
            this.data.addElement(this.currentData);
            this.currentData.id = this.currentId;
            this.currentData.saveName = THEME_IMAGE_NAME[this.currentId];
            if (this.jTextFieldGameBack.getText().length() != 0 && this.currentData.id == 0) {
                this.currentData.saveName = this.jTextFieldGameBack.getText();
            }
            this.iNetPictureImportPanel1.writeData(this.currentData, this.data);
        }
        HW hw = hwMap.get(this.currentId);
        if (hw != null && hw.h != -1) {
            this.iNetPictureImportPanel1.setScale(true, hw.h, hw.w);
        }
    }

    @Override
    public void deIconified() {
    }

    static {
        hwMap.put(0, new HW());
        hwMap.put(1, new HW());
        hwMap.put(2, new HW());
        hwMap.put(3, new HW());
        hwMap.put(4, new HW(100, 100));
        hwMap.put(5, new HW(90, 90));
        hwMap.put(6, new HW(90, 90));
        hwMap.put(7, new HW(90, 90));
        hwMap.put(8, new HW(90, 90));
        hwMap.put(9, new HW(90, 90));
        hwMap.put(10, new HW(16, 16));
        hwMap.put(11, new HW(16, 16));
        hwMap.put(12, new HW(16, 16));
        hwMap.put(13, new HW(16, 16));
        hwMap.put(14, new HW(16, 16));
        hwMap.put(15, new HW(285, 200));
        hwMap.put(16, new HW(250, 250));
        hwMap.put(17, new HW(30, 30));
        hwMap.put(18, new HW(285, 200));
        hwMap.put(19, new HW(285, 200));
        hwMap.put(20, new HW());
        hwMap.put(21, new HW(155, 155));
        hwMap.put(22, new HW(16, 16));
        hwMap.put(23, new HW());
    }

    static final class HW {
        public int w = -1;
        public int h = -1;

        public HW() {
        }

        public HW(int _w, int _h) {
            this.w = _w;
            this.h = _h;
        }
    }
}

