/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.config.Configuration;
import de.malban.config.theme.ThemeData;
import de.malban.config.theme.ThemeDataPool;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.Utility;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ThemeDataPanel
extends JPanel {
    private ThemeData mThemeData = new ThemeData();
    private ThemeDataPool mThemeDataPool;
    private int mClassSetting = 0;
    private String mName = "";
    private JButton jButton12;
    private JButton jButtonSave;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextFieldAIImagePath;

    public ThemeDataPanel(String name) {
        this.mName = name;
        this.initComponents();
        this.mThemeDataPool = new ThemeDataPool(".." + File.separator + "theme" + File.separator + name + File.separator + "Theme.xml");
        this.clearAll();
        this.resetConfigPool();
    }

    private void resetConfigPool() {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mThemeDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        boolean i = false;
        String klasse = "Themes";
        Collection<ThemeData> colC = this.mThemeDataPool.getMapForKlasse(klasse).values();
        Iterator<ThemeData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        this.jComboBoxName.addItem(this.mName);
        this.jComboBoxName.setSelectedIndex(0);
        boolean wasSet = false;
        while (iterC.hasNext()) {
            ThemeData item = iterC.next();
            if (!item.mName.equals(this.mName)) continue;
            this.mThemeData = this.mThemeDataPool.get(item.mName);
            this.setAllFromCurrent();
            wasSet = true;
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mThemeData = new ThemeData();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mThemeData.mName);
        this.jCheckBox1.setSelected(this.mThemeData.mResizeTitleImage);
        this.jCheckBox2.setSelected(this.mThemeData.mResizeGameImage);
        this.jTextFieldAIImagePath.setText(this.mThemeData.mGameImage);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mThemeData.mResizeTitleImage = this.jCheckBox1.isSelected();
        this.mThemeData.mResizeGameImage = this.jCheckBox2.isSelected();
        this.mThemeData.mGameImage = this.jTextFieldAIImagePath.getText();
        this.mThemeData.mName = this.mName;
        this.mThemeData.mClass = "Themes";
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButtonSave = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jTextFieldAIImagePath = new JTextField();
        this.jButton12 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxName.setEnabled(false);
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeDataPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxName, 0, 146, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addGap(313, 313, 313)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxName, -2, -1, -2).addComponent(this.jButtonSave)).addContainerGap(3, Short.MAX_VALUE)));
        this.jCheckBox1.setText("Resize Title Image");
        this.jCheckBox2.setText("Resize Back Image");
        this.jTextFieldAIImagePath.setToolTipText("Image path Info");
        this.jButton12.setText("...");
        this.jButton12.setMargin(new Insets(0, 1, 0, -1));
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeDataPanel.this.jButton12ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Back Image");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAIImagePath, -2, 155, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2))).addContainerGap(100, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldAIImagePath, -2, -1, -2).addComponent(this.jButton12).addComponent(this.jCheckBox2)).addContainerGap(186, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mThemeDataPool.put(this.mThemeData);
        this.mThemeDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPool();
        this.jComboBoxName.setSelectedItem(this.mThemeData.mName);
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mThemeData = this.mThemeDataPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File("images"));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String fullPath = fc.getSelectedFile().getPath();
        fullPath = Utility.makeVideRelative(fullPath);
        this.jTextFieldAIImagePath.setText(fullPath);
    }
}

