/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.theme.ThemeData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ThemeDataPool {
    public static final String DEFAULT_XML_NAME = new String("ThemeData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ThemeData> mThemeData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public ThemeDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ThemeDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ThemeData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mThemeData = ThemeData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ThemeData.saveCollectionAsXML(this.mFileName, this.mThemeData.values());
        this.buildKlassenMap();
    }

    public void remove(ThemeData st) {
        this.mThemeData.remove(st.mName);
    }

    public void put(ThemeData st) {
        this.mThemeData.remove(st.mName);
        this.mThemeData.put(st.mName, st);
    }

    public void putAsNew(ThemeData st) {
        this.mThemeData.put(st.mName, st);
    }

    public ThemeData get(String key) {
        return this.mThemeData.get(key);
    }

    public HashMap<String, ThemeData> getHashMap() {
        return this.mThemeData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ThemeData>> entries = this.mThemeData.entrySet();
        for (Map.Entry<String, ThemeData> entry : entries) {
            ThemeData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ThemeData> getMapForKlasse(String klasse) {
        HashMap<String, ThemeData> ret = new HashMap<String, ThemeData>();
        Set<Map.Entry<String, ThemeData>> entries = this.mThemeData.entrySet();
        for (Map.Entry<String, ThemeData> entry : entries) {
            ThemeData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

