/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.config.Configuration;
import de.malban.graphics.SingleImagePanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.image.OctTreeQuantizer;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ColorReduceJPanel
extends JPanel
implements Windowable {
    int inSetting;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private BufferedImage orgImage = null;
    private JButton jButton1;
    private JButton jButtonFileSelect;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSlider jSliderSourceScale;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextFieldImageSource;
    private SingleImagePanel singleImagePanel1;

    @Override
    public void closing() {
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("Color Reducer");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ColorReduceJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.singleImagePanel1 = new SingleImagePanel();
        this.jSliderSourceScale = new JSlider();
        this.jTextFieldImageSource = new JTextField();
        this.jButtonFileSelect = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jTextField2 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.singleImagePanel1.setPreferredSize(new Dimension(100, 100));
        GroupLayout singleImagePanel1Layout = new GroupLayout(this.singleImagePanel1);
        this.singleImagePanel1.setLayout(singleImagePanel1Layout);
        singleImagePanel1Layout.setHorizontalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 590, Short.MAX_VALUE));
        singleImagePanel1Layout.setVerticalGroup(singleImagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 377, Short.MAX_VALUE));
        this.jSliderSourceScale.setMajorTickSpacing(1);
        this.jSliderSourceScale.setMaximum(11);
        this.jSliderSourceScale.setMinimum(1);
        this.jSliderSourceScale.setMinorTickSpacing(1);
        this.jSliderSourceScale.setOrientation(1);
        this.jSliderSourceScale.setPaintTicks(true);
        this.jSliderSourceScale.setSnapToTicks(true);
        this.jSliderSourceScale.setValue(6);
        this.jSliderSourceScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ColorReduceJPanel.this.jSliderSourceScaleStateChanged(evt);
            }
        });
        this.jTextFieldImageSource.setToolTipText("Image path Info");
        this.jTextFieldImageSource.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ColorReduceJPanel.this.jTextFieldImageSourceFocusLost(evt);
            }
        });
        this.jButtonFileSelect.setText("...");
        this.jButtonFileSelect.setToolTipText("If multiple files are selected, an \"Add Series\" is done automatically for all images.");
        this.jButtonFileSelect.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorReduceJPanel.this.jButtonFileSelectActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Image source");
        this.jTextField1.setText("16");
        this.jButton1.setText("Reduce by Octree");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorReduceJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Color Count");
        this.jLabel4.setText("Reduce To");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.singleImagePanel1, -2, 590, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldImageSource, -2, 388, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect)).addComponent(this.jTextField1, -2, 48, -2).addComponent(this.jTextField2, -2, 47, -2).addComponent(this.jButton1)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 67, Short.MAX_VALUE).addComponent(this.jSliderSourceScale, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.singleImagePanel1, -2, 377, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldImageSource, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButtonFileSelect))).addComponent(this.jSliderSourceScale, -2, 384, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel3)).addGap(0, 55, Short.MAX_VALUE)));
    }

    private void jSliderSourceScaleStateChanged(ChangeEvent evt) {
        if (this.inSetting > 0) {
            return;
        }
        int value = this.jSliderSourceScale.getValue();
        double scale = value - 5;
        if (value < 6) {
            int invScale = 7 - value;
            scale = 1.0 / (double)invScale;
        }
    }

    private void jTextFieldImageSourceFocusLost(FocusEvent evt) {
        this.setImage();
    }

    private void jButtonFileSelectActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File("."));
        fc.setCurrentDirectory(new File("images"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "jpeg", "png", "bmp", "gif");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String fullPath = fc.getSelectedFile().getAbsolutePath();
        this.jTextFieldImageSource.setText(Utility.makeVideRelative(fullPath));
        this.setImage();
        ++this.inSetting;
        this.jSliderSourceScale.setValue(6);
        this.singleImagePanel1.setScale(1);
        --this.inSetting;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.orgImage == null) {
            return;
        }
        OctTreeQuantizer quant = new OctTreeQuantizer(UtilityString.IntX(this.jTextField1.getText(), 2));
        int[] pixels = ColorReduceJPanel.convertTo2DUsingGetRGB(this.orgImage);
        quant.addPixels(pixels, 0, pixels.length);
        int[] ctable = quant.buildColorTable();
        int width = this.orgImage.getWidth();
        int height = this.orgImage.getHeight();
        int[] newPixels = new int[height * width];
        int c = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int rgba = this.orgImage.getRGB(col, row);
                int orgAlpha = rgba >> 24 & 0xFF;
                int color = ctable[quant.getIndexForColor(pixels[c])];
                color &= 0xFFFFFF;
                newPixels[c] = color += (orgAlpha & 0xFF) << 24;
                ++c;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        WritableRaster wr = image.getRaster();
        wr.setDataElements(0, 0, width, height, newPixels);
        this.singleImagePanel1.setImage(image);
        this.showColorCount(image);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    int showColorCount(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
        int[] pixels = ColorReduceJPanel.convertTo2DUsingGetRGB(image);
        int c = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                colors.put(pixels[c], pixels[c]);
                ++c;
            }
        }
        this.jTextField2.setText("" + colors.size());
        return colors.size();
    }

    private static int[] convertTo2DUsingGetRGB(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] result = new int[height * width];
        int c = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                result[c++] = image.getRGB(col, row);
            }
        }
        return result;
    }

    void setImage() {
        this.singleImagePanel1.setImage(this.jTextFieldImageSource.getText());
        this.orgImage = this.singleImagePanel1.getImage();
        this.showColorCount(this.orgImage);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void deIconified() {
    }
}

