/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.config.Configuration;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Vertex;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class GFXVectorAnimation {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public ArrayList<GFXVectorList> list = new ArrayList();
    public boolean isAnimation = true;

    public GFXVectorAnimation() {
    }

    public GFXVectorAnimation(String filename) {
        this.loadFromXML(filename);
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public int getIndexFromUID(int uid) {
        if (uid == -1) {
            return -1;
        }
        int i = 0;
        for (GFXVectorList v : this.list) {
            if (uid == v.uid) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean replace(GFXVectorList newList, int indexToReplace) {
        if (indexToReplace < 0) {
            return false;
        }
        if (indexToReplace >= this.list.size()) {
            return false;
        }
        this.list.remove(indexToReplace);
        this.list.add(indexToReplace, newList);
        this.correctOrder();
        return true;
    }

    public GFXVectorList get(int i) {
        return this.list.get(i);
    }

    public boolean remove(int i) {
        this.list.remove(i);
        return true;
    }

    public boolean remove(GFXVectorList v) {
        return this.list.remove(v);
    }

    public boolean add(GFXVectorList v) {
        v.order = this.getHighestOrder() + 1;
        return this.list.add(v);
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "isAnimation", this.isAnimation);
        for (GFXVectorList v : this.list) {
            ok &= v.toXML(s, "GFXVectorList");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(String xml, XMLSupport xmlSupport) {
        this.list = new ArrayList();
        int errorCode = 0;
        StringBuilder xmlBuffer = new StringBuilder(xml);
        this.isAnimation = xmlSupport.getBooleanElement("isAnimation", xmlBuffer);
        errorCode |= xmlSupport.errorCode;
        StringBuilder oneElement = null;
        while ((oneElement = xmlSupport.removeTag("GFXVectorList", xmlBuffer)) != null) {
            errorCode |= xmlSupport.errorCode;
            GFXVectorList v = new GFXVectorList();
            v.fromXML(oneElement, xmlSupport);
            errorCode |= xmlSupport.errorCode;
            this.list.add(v);
        }
        this.correctOrder();
        return errorCode == 0;
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        this.correctOrder();
        boolean ok = this.toXML(xml, "VectorAnimation");
        if (!ok) {
            this.log.addLog("VectorAnimation save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("VectorAnimation create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean loadFromXML(String filename) {
        this.list.clear();
        String xml = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(filename)));
        boolean ok = this.fromXML(xml, new XMLSupport());
        if (!ok) {
            this.log.addLog("VectorAnimation load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    private void correctOrder() {
        int o = 0;
        GFXVectorList v = null;
        do {
            if ((v = this.getLowestOrder(o)) == null) continue;
            v.order = o++;
        } while (v != null);
    }

    private GFXVectorList getLowestOrder(int min) {
        int currentMin = Integer.MAX_VALUE;
        GFXVectorList currentVectorList = null;
        for (GFXVectorList v : this.list) {
            if (v.order < min || v.order >= currentMin) continue;
            currentVectorList = v;
            currentMin = v.order;
        }
        return currentVectorList;
    }

    private int getHighestOrder() {
        int max = -1;
        for (GFXVectorList v : this.list) {
            if (v.order <= max) continue;
            max = v.order;
        }
        return max;
    }

    public double getMaxAbsValue() {
        double max = 0.0;
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            double vmax = al.get(i).getMaxAbsValue();
            if (!(max < vmax)) continue;
            max = vmax;
        }
        return max;
    }

    public double getMaxAbsLenValue() {
        double max = 0.0;
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            double vmax = al.get(i).getMaxAbsLenValue();
            if (!(max < vmax)) continue;
            max = vmax;
        }
        return max;
    }

    public void scaleAll(double scale, HashMap<Vertex, Boolean> safetyMap) {
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            al.get(i).scaleAll(scale, safetyMap);
        }
    }

    public boolean isAllSamePattern() {
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).isAllSamePattern()) continue;
            return false;
        }
        return true;
    }

    public boolean isCompleteRelative() {
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).isCompleteRelative()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllPatternHigh(boolean zeroOk) {
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).isAllPatternHigh(zeroOk)) continue;
            return false;
        }
        return true;
    }

    public boolean isOrdered() {
        GFXVectorAnimation al = this;
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).isOrdered()) continue;
            return false;
        }
        return true;
    }

    public boolean isMov_Draw_VLc_a() {
        if (!this.isOrdered()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isAllSamePattern()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not same pattern!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VLc() {
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VLc failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isAllSamePattern()) {
            this.log.addLog("isDraw_VLc failed, not same pattern!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VLc failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VLp() {
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VLp failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VLp failed, not continuous!", LogPanel.WARN);
            return false;
        }
        if (!this.isAllPatternHigh(true)) {
            this.log.addLog("isDraw_VLp failed, low patterns found!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VL_mode() {
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VL_mode failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VL_mode failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_CodeGen() {
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_CodeGen failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_CodeGen failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public String createASMDraw_VL_mode(String name, boolean includeInitialMove, boolean factor) {
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            String asm = vl.createASMDraw_VL_mode(name + "_" + count, includeInitialMove, factor);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createASMDraw_VL_mode failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("\n");
        table.append((CharSequence)source);
        String text = table.toString();
        return text;
    }

    public String createCDraw_VL_mode(String name, boolean includeInitialMove, boolean factor) {
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append("const signed char* const " + name).append("[]=\n{");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append("\t " + name + "_" + count);
            if (count == 0) {
                table.append(", // list of all single vectorlists in this\n");
            } else {
                table.append(",\n");
            }
            String asm = vl.createCDraw_VL_mode(name + "_" + count, includeInitialMove, factor, false);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createCDraw_VL_mode failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("};\n");
        return source.toString() + "\n" + table.toString();
    }

    public String createASMDraw_VLc(String name, boolean factor) {
        if (!this.isDraw_VLc()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            String asm = vl.createASMMov_Draw_VLc_a(false, name + "_" + count, factor);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createASMDraw_VLc failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("\n");
        table.append((CharSequence)source);
        String text = table.toString();
        return text;
    }

    public String createCDraw_VLc(String name, boolean factor) {
        if (!this.isDraw_VLc()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append("const signed char* const " + name).append("[]=\n{");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append("\t " + name + "_" + count);
            if (count == 0) {
                table.append(", // list of all single vectorlists in this\n");
            } else {
                table.append(",\n");
            }
            String asm = vl.createCMov_Draw_VLc_a(false, name + "_" + count, factor, false);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createCDraw_VLc failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("};\n");
        return source.toString() + "\n" + table.toString();
    }

    public String createCMov_Draw_VLc_a(String name, boolean factor) {
        if (!this.isMov_Draw_VLc_a()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append("const signed char* const " + name).append("[]=\n{");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append("\t " + name + "_" + count);
            if (count == 0) {
                table.append(", // list of all single vectorlists in this\n");
            } else {
                table.append(",\n");
            }
            String asm = vl.createCMov_Draw_VLc_a(true, name + "_" + count, factor, false);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createCMov_Draw_VLc_a failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("};\n");
        return source.toString() + "\n" + table.toString();
    }

    public String createASMMov_Draw_VLc_a(String name, boolean factor) {
        if (!this.isMov_Draw_VLc_a()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            String asm = vl.createASMMov_Draw_VLc_a(true, name + "_" + count, factor);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createASMMov_Draw_VLc_a failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("\n");
        table.append((CharSequence)source);
        String text = table.toString();
        return text;
    }

    public String createCDraw_VLp(String name, boolean factor, boolean keepPosition) {
        if (!this.isDraw_VLp()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append("const signed char* const " + name).append("[]=\n{");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append("\t " + name + "_" + count);
            if (count == 0) {
                table.append(", // list of all single vectorlists in this\n");
            } else {
                table.append(",\n");
            }
            String asm = vl.createCDraw_VLp(name + "_" + count, factor, keepPosition);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createCDraw_VLp failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("};\n");
        return source.toString() + "\n" + table.toString();
    }

    public String createASMDraw_VLp(String name, boolean factor) {
        if (!this.isDraw_VLp()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            String asm = vl.createASMDraw_VLp(name + "_" + count, factor, false);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createASMDraw_VLp failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("\n");
        table.append((CharSequence)source);
        String text = table.toString();
        return text;
    }

    public boolean createCDraw_syncList(StringBuilder table, String name, boolean factor, int resync, int splitter) {
        return this.createCDraw_syncList(table, name, factor, resync, false, splitter);
    }

    public boolean createASMDraw_syncList(StringBuilder table, String name, boolean factor, int resync, int splitter) {
        return this.createASMDraw_syncList(table, name, factor, resync, false, splitter);
    }

    public boolean createASMDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter) {
        return this.createASMDraw_syncList(table, name, factor, resync, extended, splitter, false, "BLOW_UP");
    }

    public boolean createCDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter) {
        return this.createCDraw_syncList(table, name, factor, resync, extended, splitter, false, "BLOW_UP");
    }

    public boolean createASMDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter, boolean noAdditionalOptimization) {
        return this.createASMDraw_syncList(table, name, factor, resync, extended, splitter, noAdditionalOptimization, "BLOW_UP");
    }

    public boolean createCDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter, boolean noAdditionalOptimization) {
        return this.createCDraw_syncList(table, name, factor, resync, extended, splitter, noAdditionalOptimization, "BLOW_UP");
    }

    public boolean createASMDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter, boolean noAdditionalOptimization, String blowString) {
        StringBuilder source = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            boolean genOk = vl.createASMDraw_syncList(source, name + "_" + count, factor, resync, extended, splitter, noAdditionalOptimization, blowString);
            if (!genOk) {
                this.log.addLog("Anim: createASMDraw_syncList failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return false;
            }
            ++count;
        }
        table.append(" DW 0\n\n");
        table.append((CharSequence)source);
        return true;
    }

    public boolean createCDraw_syncList(StringBuilder table, String name, boolean factor, int resync, boolean extended, int splitter, boolean noAdditionalOptimization, String blowString) {
        StringBuilder source = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append("const signed char* const " + name).append("[]=\n{");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append("\t " + name + "_" + count);
            if (count == 0) {
                table.append(", // list of all single vectorlists in this\n");
            } else {
                table.append(",\n");
            }
            boolean genOk = vl.createCDraw_syncList(source, name + "_" + count, factor, resync, extended, splitter, noAdditionalOptimization, blowString);
            if (!genOk) {
                this.log.addLog("Anim: createCDraw_syncList failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return false;
            }
            ++count;
        }
        table.append("};\n");
        table.insert(0, source.toString());
        return true;
    }

    public String createASMCodeGen(String name) {
        if (!this.isDraw_CodeGen()) {
            return "";
        }
        StringBuilder source = new StringBuilder();
        StringBuilder table = new StringBuilder();
        GFXVectorAnimation al = this;
        table.append(name).append(":\n");
        int count = 0;
        for (GFXVectorList vl : al.list) {
            table.append(" " + GFXVectorList.getDW() + " " + name + "_" + count);
            if (count == 0) {
                table.append(" ; list of all single vectorlists in this");
            }
            table.append("\n");
            String asm = vl.createASMCodeGen(name + "_" + count);
            if (asm.length() == 0) {
                this.log.addLog("Anim: createASMCodeGen failed, VL(" + count + ") returned error!", LogPanel.WARN);
                return "";
            }
            source.append(asm);
            ++count;
        }
        table.append("\n");
        table.append((CharSequence)source);
        String text = table.toString();
        return text;
    }
}

