/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.graphics.Face;
import de.malban.graphics.GFXVector;
import de.malban.graphics.Vertex;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.XMLSupport;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GFXVectorList {
    public static String hexSign = "$";
    public static boolean hex = true;
    public static boolean db = true;
    public static boolean avoidConnectMoreThan2 = true;
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private static int UID = 0;
    public int load_uid;
    public final int uid = ++UID;
    public int order = 0;
    static long tuid = 0L;
    public ArrayList<GFXVector> list = new ArrayList();
    static int SH_NONE = 0;
    static int SH_P_START_PATH_END = 1;
    static int SH_P_START_PATH_START = 2;
    static int SH_P_END_PATH_END = 3;
    static int SH_P_END_PATH_START = 4;
    static final int TYPE_START_START = 1;
    static final int TYPE_START_END = 2;
    static final int TYPE_END_START = 3;
    static final int TYPE_END_END = 4;
    HashMap<String, Position> posMap = new HashMap();
    public static int GOOD_ENOUGH_FOR_MAX = 20;
    int recursionCount;

    public static String getDW() {
        if (db) {
            return "DW";
        }
        return "fdb";
    }

    public static String getDB() {
        if (db) {
            return "DB";
        }
        return "fcb";
    }

    static String hex(int b) {
        String s = "";
        int idata = b;
        if ((idata &= 0xFF) >= 128) {
            idata -= 256;
            idata *= -1;
            s = s + "-";
        } else {
            s = s + "+";
        }
        if (hex) {
            s = s + hexSign;
            s = s + String.format("%02X", idata);
        } else {
            s = s + idata;
        }
        return s;
    }

    static String hexU(int b) {
        String s = "";
        int idata = b;
        idata &= 0xFF;
        if (!hex) {
            return GFXVectorList.hex(b);
        }
        s = s + hexSign;
        s = s + String.format("%02X", idata);
        return s;
    }

    public GFXVectorList() {
        this.order = this.uid;
    }

    public GFXVectorList(String filename) {
        this.loadFromXML(filename);
    }

    public String toString() {
        String out = "";
        for (GFXVector v : this.list) {
            out = out + v.toString() + "\n";
        }
        return out + "----\n";
    }

    public GFXVectorList clone() {
        GFXVectorList ret = new GFXVectorList();
        HashMap<String, Vertex> doubleTestMap = new HashMap<String, Vertex>();
        for (GFXVector v : this.list) {
            GFXVector cv = v.clone();
            if (v.start != null) {
                if (doubleTestMap.get("" + v.start.uid) == null) {
                    doubleTestMap.put("" + v.start.uid, cv.start);
                } else {
                    cv.start = (Vertex)doubleTestMap.get("" + v.start.uid);
                }
            }
            if (v.end != null) {
                if (doubleTestMap.get("" + v.end.uid) == null) {
                    doubleTestMap.put("" + v.end.uid, cv.end);
                } else {
                    cv.end = (Vertex)doubleTestMap.get("" + v.end.uid);
                }
            }
            cv.setRelativ(v.relativ);
            ret.add(cv);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            GFXVector oldv = this.list.get(i);
            GFXVector newv = ret.list.get(i);
            ret.setCloneStart(newv, oldv.uid_start_connect, oldv);
            ret.setCloneEnd(newv, oldv.uid_end_connect, oldv);
        }
        return ret;
    }

    public GFXVectorList cloneSetOrg() {
        GFXVectorList ret = new GFXVectorList();
        HashMap<String, Vertex> doubleTestMap = new HashMap<String, Vertex>();
        for (GFXVector v : this.list) {
            GFXVector cv = v.cloneSetOrg();
            if (v.start != null) {
                if (doubleTestMap.get("" + v.start.uid) == null) {
                    doubleTestMap.put("" + v.start.uid, cv.start);
                } else {
                    cv.start = (Vertex)doubleTestMap.get("" + v.start.uid);
                }
            }
            if (v.end != null) {
                if (doubleTestMap.get("" + v.end.uid) == null) {
                    doubleTestMap.put("" + v.end.uid, cv.end);
                } else {
                    cv.end = (Vertex)doubleTestMap.get("" + v.end.uid);
                }
            }
            cv.setRelativ(v.relativ);
            ret.add(cv);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            GFXVector oldv = this.list.get(i);
            GFXVector newv = ret.list.get(i);
            ret.setCloneStart(newv, oldv.uid_start_connect, oldv);
            ret.setCloneEnd(newv, oldv.uid_end_connect, oldv);
        }
        return ret;
    }

    public void resetSelection() {
        for (GFXVector v : this.list) {
            v.resetSelection();
        }
    }

    public void resetDisplay() {
        for (GFXVector v : this.list) {
            v.resetDisplay();
        }
    }

    private void setCloneStart(GFXVector vec, int oldCloneId, GFXVector oldv) {
        if (oldCloneId == -1) {
            return;
        }
        for (GFXVector v : this.list) {
            if (v.getOldCloneUID() != oldCloneId) continue;
            vec.uid_start_connect = v.uid;
            vec.start_connect = v;
            if (oldv.start.equals(v.start)) {
                vec.start = v.start;
            }
            if (oldv.start.equals(v.end)) {
                vec.start = v.end;
            }
            return;
        }
    }

    private void setCloneEnd(GFXVector vec, int oldCloneId, GFXVector oldv) {
        if (oldCloneId == -1) {
            return;
        }
        for (GFXVector v : this.list) {
            if (v.getOldCloneUID() != oldCloneId) continue;
            vec.uid_end_connect = v.uid;
            vec.end_connect = v;
            if (oldv.end.equals(v.end)) {
                vec.end = v.end;
            }
            if (oldv.end.equals(v.start)) {
                vec.end = v.start;
            }
            return;
        }
    }

    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<GFXVector> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    public GFXVector get(int i) {
        return this.list.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(GFXVector v) {
        ArrayList<GFXVector> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(GFXVector v) {
        ArrayList<GFXVector> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int pos, GFXVector v) {
        ArrayList<GFXVector> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(pos, v);
            return true;
        }
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "id", this.uid);
        ok &= XMLSupport.addElement(s, "order", this.order);
        for (GFXVector v : this.list) {
            ok &= v.toXML(s, "GFXVector");
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        this.list = new ArrayList();
        int errorCode = 0;
        this.load_uid = xmlSupport.getIntElement("id", xml);
        errorCode |= xmlSupport.errorCode;
        this.order = xmlSupport.getIntElement("order", xml);
        errorCode |= xmlSupport.errorCode;
        StringBuilder oneElement = null;
        while ((oneElement = xmlSupport.removeTag("GFXVector", xml)) != null) {
            errorCode |= xmlSupport.errorCode;
            GFXVector v = new GFXVector();
            v.fromXML(oneElement, xmlSupport);
            errorCode |= xmlSupport.errorCode;
            this.list.add(v);
        }
        HashMap<String, Vertex> noDoubles = new HashMap<String, Vertex>();
        for (GFXVector v : this.list) {
            String cid;
            if (v.start != null) {
                cid = v.start.buildCompareId();
                if (noDoubles.get(cid) == null) {
                    noDoubles.put(cid, v.start);
                } else {
                    v.start = (Vertex)noDoubles.get(cid);
                }
            }
            if (v.end == null) continue;
            cid = v.end.buildCompareId();
            if (noDoubles.get(cid) == null) {
                noDoubles.put(cid, v.end);
                continue;
            }
            v.end = (Vertex)noDoubles.get(cid);
        }
        this.correctVectorUIDs();
        this.setRelativeWherePossible();
        return errorCode == 0;
    }

    private void correctVectorUIDs() {
        for (GFXVector v : this.list) {
            int luid = v.load_uid;
            for (GFXVector v2 : this.list) {
                if (v2.uid_end_connect == luid) {
                    v2.uid_end_connect = v.uid;
                }
                if (v2.uid_start_connect != luid) continue;
                v2.uid_start_connect = v.uid;
            }
        }
    }

    public boolean saveAsXML(String filename) {
        StringBuilder xml = new StringBuilder();
        this.correctOrder();
        boolean ok = this.toXML(xml, "GFXVectorList");
        if (!ok) {
            this.log.addLog("GFXVectorList save 'toXML' return false", LogPanel.WARN);
            return false;
        }
        ok = UtilityFiles.createTextFile(filename, xml.toString());
        if (!ok) {
            this.log.addLog("GFXVectorList create file '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean loadFromXML(String filename) {
        String xml = UtilityString.readTextFileToOneString(new File(UtilityFiles.convertSeperator(filename)));
        boolean ok = this.fromXML(new StringBuilder(xml), new XMLSupport());
        if (!ok) {
            this.log.addLog("GFXVectorList load from xml '" + filename + "' return false", LogPanel.WARN);
            return false;
        }
        this.correctOrder();
        return true;
    }

    public void setRelativeWherePossible() {
        for (GFXVector v : this.list) {
            v.start_connect = this.getVectorID(v.uid_start_connect);
            if (v.start_connect != null) {
                if (v.start.equals(v.start_connect.end)) {
                    v.start = v.start_connect.end;
                } else if (v.start.equals(v.start_connect.start)) {
                    v.start = v.start_connect.start;
                }
            }
            v.end_connect = this.getVectorID(v.uid_end_connect);
            if (v.end_connect == null) continue;
            if (v.end.equals(v.end_connect.start)) {
                v.end = v.end_connect.start;
                continue;
            }
            if (!v.end.equals(v.end_connect.start)) continue;
            v.end = v.end_connect.end;
        }
        for (GFXVector v : this.list) {
            v.setRelativ(v.uid_end_connect != -1 && v.uid_start_connect != -1);
        }
        for (GFXVector v : this.list) {
            Vertex start = v.start;
            if (v.uid_start_connect != -1 && v.start_connect != null) continue;
            for (GFXVector v2 : this.list) {
                if (v.uid == v2.uid) continue;
                if (v2.end.uid == start.uid) {
                    v.uid_start_connect = -1;
                    v.start_connect = null;
                    v2.uid_end_connect = -1;
                    v2.end_connect = null;
                    v2.end = new Vertex(v2.end);
                }
                if (v2.start.uid != start.uid) continue;
                v.uid_start_connect = -1;
                v.start_connect = null;
                v2.uid_end_connect = -1;
                v2.start_connect = null;
                v2.start = new Vertex(v2.start);
            }
        }
    }

    private GFXVector getVectorID(int id) {
        for (GFXVector v : this.list) {
            if (v.uid != id) continue;
            return v;
        }
        return null;
    }

    private void correctOrder() {
        int o = 0;
        GFXVector v = null;
        do {
            if ((v = this.getLowestOrder(o)) == null) continue;
            v.order = o++;
        } while (v != null);
    }

    private GFXVector getLowestOrder(int min) {
        int currentMin = Integer.MAX_VALUE;
        GFXVector currentVector = null;
        for (GFXVector v : this.list) {
            if (v.order < min || v.order >= currentMin) continue;
            currentVector = v;
            currentMin = v.order;
        }
        return currentVector;
    }

    public double getMaxAbsValue() {
        double max = 0.0;
        GFXVectorList vl = this;
        for (int i = 0; i < vl.size(); ++i) {
            double vmax = vl.get(i).getMaxAbsValue();
            if (!(max < vmax)) continue;
            max = vmax;
        }
        return max;
    }

    public double getMaxAbsLenValue() {
        double max = 0.0;
        GFXVectorList vl = this;
        for (int i = 0; i < vl.size(); ++i) {
            double vmax = vl.get(i).getMaxAbsLenValue();
            if (!(max < vmax)) continue;
            max = vmax;
        }
        return max;
    }

    public void intAll() {
        GFXVectorList al = this;
        for (int i = 0; i < al.size(); ++i) {
            al.get(i).intAll();
        }
    }

    public void scaleAll(double scale, HashMap<Vertex, Boolean> safetyMap, boolean yScale, boolean xScale, boolean zScale) {
        GFXVectorList al = this;
        for (int i = 0; i < al.size(); ++i) {
            al.get(i).scaleAll(scale, safetyMap, yScale, xScale, zScale);
        }
    }

    public void scaleAll(double scale, HashMap<Vertex, Boolean> safetyMap) {
        this.scaleAll(scale, safetyMap, true, true, true);
    }

    public void disconnectAll() {
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        GFXVectorList listThan = new GFXVectorList();
        for (int i = 0; i < listNow.size(); ++i) {
            GFXVector v = listNow.get(i).clone();
            v.setRelativ(false);
            listThan.add(v);
        }
        this.list = listThan.list;
    }

    public void removeMoveVectors() {
        this.disconnectAll();
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        GFXVectorList listThan = new GFXVectorList();
        for (int i = 0; i < listNow.size(); ++i) {
            GFXVector v = listNow.get(i).clone();
            if (v.pattern == 0) continue;
            listThan.add(v);
        }
        this.list = listThan.list;
    }

    public void connectLongestPaths() {
        GFXVectorList listThan = new GFXVectorList();
        ArrayList<GFXVectorList> paths = this.clpPart();
        int o = 0;
        for (GFXVectorList vl : paths) {
            vl.connectWherePossible(true);
            for (GFXVector v : vl.list) {
                v.order = o++;
                listThan.list.add(v);
            }
        }
        this.list = listThan.list;
    }

    public void connectLongestPathsPlus(boolean respectZero) {
        this.log.addLog("connectLongestPathsPlus() entered: ", LogPanel.INFO);
        GFXVectorList listThan = new GFXVectorList();
        ArrayList<GFXVectorList> paths = this.clpPart();
        for (GFXVectorList vl : paths) {
            vl.connectWherePossible(true);
        }
        this.log.addLog("connectLongestPathsPlus() connecting paths: ", LogPanel.INFO);
        ArrayList<GFXVectorList> donePaths = new ArrayList<GFXVectorList>();
        while (paths.size() > 0) {
            GFXVectorList p1 = paths.get(0);
            paths.remove(p1);
            boolean changed = GFXVectorList.connectAndRemoveShortesPath(p1, paths, donePaths, respectZero);
            if (!changed) continue;
            while (donePaths.size() > 0) {
                paths.add(donePaths.get(0));
                donePaths.remove(0);
            }
        }
        this.log.addLog("connectLongestPathsPlus() ordering: ", LogPanel.INFO);
        int o = 0;
        for (GFXVectorList vl : donePaths) {
            for (GFXVector v : vl.list) {
                v.order = o++;
                listThan.list.add(v);
            }
        }
        this.list = listThan.list;
    }

    private static double getDistance(Vertex v1, Vertex v2) {
        double x = v1.x() - v2.x();
        double y = v1.y() - v2.y();
        double z = v1.z() - v2.z();
        double xsq = x * x;
        double ysq = y * y;
        double zsq = z * z;
        double sum = xsq + ysq + zsq;
        double d = Math.sqrt(sum);
        return d;
    }

    private static GFXVectorList inverse(GFXVectorList vl) {
        ArrayList<GFXVector> ilist = new ArrayList<GFXVector>();
        for (GFXVector o : vl.list) {
            ilist.add(0, o);
        }
        int i = 0;
        while (i < ilist.size()) {
            GFXVector v = (GFXVector)ilist.get(i);
            v.inverse();
            v.order = i++;
        }
        vl.list = ilist;
        return vl;
    }

    public GFXVectorList isidroAll() {
        this.removeMoveVectors();
        this.removeDouble();
        this.removeiDouble();
        this.removePoints(true);
        this.connectLongestPathsPlus(false);
        return this;
    }

    public double optimizeSize() {
        int splitEnd;
        int splitStart;
        int maxSize;
        int syncFactor;
        this.log.addLog("optimize() entered: ", LogPanel.INFO);
        int assumedScale = 255;
        int optimalSplit = 0;
        int optimalCycles = Integer.MAX_VALUE;
        double referenceLength = this.getMaxAbsLenValue();
        int maxDimension = Math.abs(this.getXMax() - this.getXMin());
        if (Math.abs(this.getYMax() - this.getYMin()) > maxDimension) {
            maxDimension = Math.abs(this.getYMax() - this.getYMin());
        }
        if (Math.abs(this.getZMax() - this.getZMin()) > maxDimension) {
            maxDimension = Math.abs(this.getZMax() - this.getZMin());
        }
        if ((maxDimension /= 2) < 1) {
            maxDimension = 1;
        }
        if ((syncFactor = this.size() * (maxDimension / 127)) == 0) {
            syncFactor = this.size();
        }
        if ((maxSize = this.getXMaxLength()) < this.getYMaxLength()) {
            maxSize = this.getYMaxLength();
        }
        if (maxSize < this.getZMaxLength()) {
            maxSize = this.getZMaxLength();
        }
        if ((splitStart = (splitEnd = maxSize) / 3) == 0) {
            splitStart = 1;
        }
        this.log.addLog("optimize() splitting: ", LogPanel.INFO);
        for (int split = splitStart; split < splitEnd; ++split) {
            this.log.addLog("optimize() splitting: " + split, LogPanel.INFO);
            GFXVectorList test = this.clone();
            test.splitWhereNeeded(split);
            double factor = referenceLength / (double)split;
            int cycles = GFXVectorList.getCyclesNeeded(test, (double)assumedScale / factor);
            double splitFactor = 127 / split;
            double tmpSyncFactor = (double)syncFactor * splitFactor;
            cycles = (int)((double)cycles + tmpSyncFactor * ((double)assumedScale / factor + 40.0));
            if (cycles >= optimalCycles) continue;
            optimalCycles = cycles;
            optimalSplit = split;
        }
        if (optimalSplit != 0) {
            this.log.addLog("optimize() optimal split found: " + optimalSplit, LogPanel.INFO);
            this.splitWhereNeeded(optimalSplit);
            double factor = referenceLength / (double)optimalSplit;
            HashMap<Vertex, Boolean> safetyMap = new HashMap<Vertex, Boolean>();
            this.scaleAll(factor, safetyMap);
        }
        if (optimalSplit == 0) {
            return 1.0;
        }
        return referenceLength / (double)optimalSplit;
    }

    static int getCyclesNeeded(GFXVectorList test, double scale) {
        int waste = 0;
        for (GFXVector v : test.list) {
            double d = Math.abs(GFXVectorList.getDistance(v.start, v.end));
            waste = (int)((double)waste + (65.0 + scale));
        }
        return waste;
    }

    private static boolean connectAndRemoveShortesPath(GFXVectorList p1, ArrayList<GFXVectorList> paths, ArrayList<GFXVectorList> resultpath, boolean respectZero) {
        if (p1.size() == 0) {
            resultpath.add(p1);
            return false;
        }
        if (paths.size() == 0) {
            resultpath.add(p1);
            return false;
        }
        boolean found = false;
        double min = Double.MAX_VALUE;
        GFXVectorList candidate = null;
        int candidateType = SH_NONE;
        Vertex zero = new Vertex(0.0, 0.0, 0.0);
        double zeroDistance1Start = Math.abs(GFXVectorList.getDistance(p1.get((int)0).start, zero));
        double zeroDistance1End = Math.abs(GFXVectorList.getDistance(p1.get((int)(p1.size() - 1)).end, zero));
        for (GFXVectorList searchPath : paths) {
            double zeroDistanceCandidateStart = Math.abs(GFXVectorList.getDistance(searchPath.get((int)0).start, zero));
            double zeroDistanceCandidateEnd = Math.abs(GFXVectorList.getDistance(searchPath.get((int)(searchPath.size() - 1)).end, zero));
            double d = GFXVectorList.getDistance(p1.get((int)0).start, searchPath.get((int)(searchPath.size() - 1)).end);
            if ((d = Math.abs(d)) < min && (!respectZero || !(d >= zeroDistance1Start) && !(d >= zeroDistanceCandidateEnd))) {
                min = d;
                candidate = searchPath;
                candidateType = SH_P_START_PATH_END;
            }
            d = GFXVectorList.getDistance(p1.get((int)0).start, searchPath.get((int)0).start);
            if ((d = Math.abs(d)) < min && (!respectZero || !(d >= zeroDistance1Start) && !(d >= zeroDistanceCandidateStart))) {
                min = d;
                candidate = searchPath;
                candidateType = SH_P_START_PATH_START;
            }
            d = GFXVectorList.getDistance(p1.get((int)(p1.size() - 1)).end, searchPath.get((int)(searchPath.size() - 1)).end);
            if ((d = Math.abs(d)) < min && (!respectZero || !(d >= zeroDistance1End) && !(d >= zeroDistanceCandidateEnd))) {
                min = d;
                candidate = searchPath;
                candidateType = SH_P_END_PATH_END;
            }
            d = GFXVectorList.getDistance(p1.get((int)(p1.size() - 1)).end, searchPath.get((int)0).start);
            if (!((d = Math.abs(d)) < min) || respectZero && (d >= zeroDistance1End || d >= zeroDistanceCandidateStart)) continue;
            min = d;
            candidate = searchPath;
            candidateType = SH_P_END_PATH_START;
        }
        if (min > 127.0) {
            candidateType = SH_NONE;
        }
        if (candidateType == SH_NONE) {
            resultpath.add(p1);
            return false;
        }
        paths.remove(candidate);
        resultpath.add(candidate);
        if (candidateType == SH_P_END_PATH_END) {
            GFXVectorList.inverse(candidate);
            candidateType = SH_P_END_PATH_START;
        }
        if (candidateType == SH_P_START_PATH_START) {
            GFXVectorList.inverse(p1);
            candidateType = SH_P_END_PATH_START;
        }
        if (candidateType == SH_P_START_PATH_END) {
            GFXVectorList.inverse(candidate);
            GFXVectorList.inverse(p1);
            candidateType = SH_P_END_PATH_START;
        }
        if (candidateType == SH_P_END_PATH_START) {
            GFXVector newInsertVector = new GFXVector();
            newInsertVector.pattern = 0;
            newInsertVector.start = p1.get((int)(p1.size() - 1)).end;
            newInsertVector.end = candidate.get((int)0).start;
            newInsertVector.start_connect = p1.get(p1.size() - 1);
            newInsertVector.end_connect = candidate.get(0);
            newInsertVector.uid_start_connect = newInsertVector.start_connect.uid;
            newInsertVector.uid_end_connect = newInsertVector.end_connect.uid;
            newInsertVector.setRelativ(true);
            p1.get((int)(p1.size() - 1)).end_connect = newInsertVector;
            p1.get((int)(p1.size() - 1)).uid_end_connect = newInsertVector.uid;
            if (p1.size() > 1) {
                p1.get(p1.size() - 1).setRelativ(true);
            }
            candidate.get((int)0).start_connect = newInsertVector;
            candidate.get((int)0).uid_start_connect = newInsertVector.uid;
            if (candidate.size() > 1) {
                candidate.get(0).setRelativ(true);
            }
            candidate.list.add(0, newInsertVector);
            for (int i = p1.size() - 1; i >= 0; --i) {
                GFXVector v = p1.get(i);
                p1.remove(v);
                candidate.list.add(0, v);
            }
        }
        return true;
    }

    private static void removeIdenticalVectors(GFXVectorList removeFrom, GFXVectorList removeWhat) {
        block0: for (GFXVector cloneVector : removeWhat.list) {
            for (int i = 0; i < removeFrom.size(); ++i) {
                GFXVector orgVector = removeFrom.get(i);
                if (!GFXVectorList.isSameOrgUID(cloneVector, orgVector)) continue;
                removeFrom.remove(orgVector);
                continue block0;
            }
        }
    }

    public void removeDouble() {
        this.disconnectAll();
        GFXVectorList originalList = this.cloneSetOrg();
        GFXVectorList listThan = new GFXVectorList();
        while (originalList.size() != 0) {
            GFXVector v1 = originalList.get(0);
            originalList.remove(v1);
            listThan.list.add(v1);
            for (int i = originalList.size() - 1; i >= 0; --i) {
                GFXVector v2 = originalList.get(i);
                if (!v1.equals(v2)) continue;
                originalList.remove(v2);
            }
        }
        this.list = listThan.list;
    }

    public void removeiDouble() {
        this.disconnectAll();
        GFXVectorList originalList = this.cloneSetOrg();
        GFXVectorList listThan = new GFXVectorList();
        while (originalList.size() != 0) {
            GFXVector v1 = originalList.get(0);
            originalList.remove(v1);
            listThan.list.add(v1);
            for (int i = originalList.size() - 1; i >= 0; --i) {
                GFXVector v2 = originalList.get(i);
                if (!v1.equalsIgnoreDirection(v2)) continue;
                originalList.remove(v2);
            }
        }
        this.list = listThan.list;
    }

    private ArrayList<GFXVectorList> clpPart() {
        this.log.addLog("clpPart() - starting!", LogPanel.INFO);
        ArrayList<GFXVectorList> paths = new ArrayList<GFXVectorList>();
        this.disconnectAll();
        this.removePoints(true);
        GFXVectorList originalList = this.cloneSetOrg();
        originalList.posMap = new HashMap();
        originalList.initPosMap();
        while (originalList.size() > 0) {
            int i;
            this.log.addLog("Seeking longest path in vectorlist size: " + originalList.size(), LogPanel.INFO);
            ArrayList<GFXVector> longestPathV = originalList.getLongestPath();
            GFXVectorList longestPath = new GFXVectorList();
            if (longestPathV.size() > 0) {
                longestPath.add(longestPathV.get(0));
                originalList.removeFromPosMap(longestPathV.get(0));
                originalList.remove(longestPathV.get(0));
            }
            for (i = 0; i < longestPathV.size() - 1; ++i) {
                GFXVector v2;
                GFXVector v1 = longestPathV.get(i);
                int isConnecting = GFXVectorList.isConnecting(v1, v2 = longestPathV.get(i + 1));
                if (isConnecting == 0) {
                    this.log.addLog("Warning not connecting optimzed vector found", LogPanel.WARN);
                    continue;
                }
                originalList.removeFromPosMap(v2);
                originalList.remove(v2);
                if (isConnecting == 1) {
                    longestPath.add(v2);
                }
                if (isConnecting != -1) continue;
                longestPath.add(v2.inverse());
            }
            paths.add(longestPath);
            for (i = originalList.size() - 1; i >= 0; --i) {
                GFXVector v0 = originalList.get(i);
                if (v0.maxConnectCount == 0) {
                    this.log.addLog("Warning not connecting 0 vector found", LogPanel.INFO);
                    continue;
                }
                if (v0.maxConnectCount != 1) continue;
                originalList.removeFromPosMap(v0);
                originalList.remove(v0);
                GFXVectorList list1 = new GFXVectorList();
                list1.add(v0);
                paths.add(list1);
            }
        }
        boolean didConnect = false;
        block3: do {
            didConnect = false;
            for (int i1 = 0; i1 < paths.size(); ++i1) {
                GFXVectorList vl = (GFXVectorList)paths.get(i1);
                Vertex start1 = vl.get((int)0).start;
                Vertex end1 = vl.get((int)(vl.size() - 1)).end;
                for (int i2 = i1 + 1; i2 < paths.size(); ++i2) {
                    GFXVectorList vlTest = paths.get(i2);
                    Vertex start2 = vlTest.get((int)0).start;
                    Vertex end2 = vlTest.get((int)(vlTest.size() - 1)).end;
                    int type = 0;
                    if (start1.x() == start2.x() && start1.y() == start2.y() && start1.z() == start2.z()) {
                        type = 1;
                    }
                    if (start1.x() == end2.x() && start1.y() == end2.y() && start1.z() == end2.z()) {
                        type = 2;
                    }
                    if (end1.x() == start2.x() && end1.y() == start2.y() && end1.z() == start2.z()) {
                        type = 3;
                    }
                    if (end1.x() == end2.x() && end1.y() == end2.y() && end1.z() == end2.z()) {
                        type = 4;
                    }
                    if (type == 0) continue;
                    this.connectLists(vl, vlTest, type);
                    paths.remove(vlTest);
                    didConnect = true;
                    break;
                }
                if (didConnect) continue block3;
            }
        } while (didConnect);
        return paths;
    }

    private void connectLists(GFXVectorList vl, GFXVectorList vl2, int type) {
        for (int i = 0; i < vl2.size(); ++i) {
            if (type == 2) {
                vl.add(0, vl2.get(vl2.size() - 1 - i));
            }
            if (type == 3) {
                vl.add(vl2.get(i));
            }
            if (type == 1) {
                vl.add(0, vl2.get(vl2.size() - 1 - i).inverse());
            }
            if (type != 4) continue;
            vl.add(vl2.get(i).inverse());
        }
    }

    private void initPosMap() {
        this.posMap = new HashMap();
        for (int i = 0; i < this.list.size(); ++i) {
            GFXVector v = this.list.get(i);
            v.key1 = v.start.x() + "_" + v.start.y() + "_" + v.start.z();
            v.key2 = v.end.x() + "_" + v.end.y() + "_" + v.end.z();
            Position startpos = this.posMap.get(v.key1);
            if (startpos == null) {
                startpos = new Position();
                this.posMap.put(v.key1, startpos);
            }
            startpos.vectors.add(v);
            Position endpos = this.posMap.get(v.key2);
            if (endpos == null) {
                endpos = new Position();
                this.posMap.put(v.key2, endpos);
            }
            endpos.vectors.add(v);
            v.isPosUsed = 0;
        }
    }

    private int getMaxTailCount(GFXVector v, ArrayList<GFXVector> vlist, boolean startUsed) {
        boolean pos1used;
        ArrayList vlistTest;
        ++v.isPosUsed;
        ++this.recursionCount;
        if (vlist.size() >= GOOD_ENOUGH_FOR_MAX) {
            --v.isPosUsed;
            return vlist.size();
        }
        this.log.addLog("getMaxTailCount() recursion: " + this.recursionCount, LogPanel.INFO);
        ArrayList vlistmax = null;
        int compareSize = vlist.size();
        if (!startUsed) {
            Position pos1 = this.posMap.get(v.key1);
            if (pos1 != null) {
                for (GFXVector v1 : pos1.vectors) {
                    if (v1.isPosUsed != 0) continue;
                    vlistTest = (ArrayList)vlist.clone();
                    vlistTest.add(v1);
                    pos1used = v.key1.equals(v1.key1);
                    this.getMaxTailCount(v1, vlistTest, pos1used);
                    if (vlistTest.size() <= compareSize || (compareSize = (vlistmax = vlistTest).size()) < GOOD_ENOUGH_FOR_MAX) continue;
                    break;
                }
            }
        } else {
            Position pos2 = this.posMap.get(v.key2);
            if (pos2 != null) {
                for (GFXVector v2 : pos2.vectors) {
                    if (v2.isPosUsed != 0) continue;
                    vlistTest = (ArrayList)vlist.clone();
                    vlistTest.add(v2);
                    pos1used = v.key2.equals(v2.key1);
                    this.getMaxTailCount(v2, vlistTest, pos1used);
                    if (vlistTest.size() <= compareSize || (compareSize = (vlistmax = vlistTest).size()) < GOOD_ENOUGH_FOR_MAX) continue;
                    break;
                }
            }
        }
        --v.isPosUsed;
        if (vlistmax != null) {
            vlist.clear();
            for (GFXVector v0 : vlistmax) {
                vlist.add(v0);
            }
        }
        return vlist.size();
    }

    private ArrayList<GFXVector> getLongestPath() {
        ArrayList<GFXVector> maxList = new ArrayList<GFXVector>();
        ArrayList<GFXVector> currentTestList = new ArrayList<GFXVector>();
        int i = 0;
        for (GFXVector v : this.list) {
            this.log.addLog("getLongestPath(): " + i++, LogPanel.INFO);
            currentTestList.clear();
            currentTestList.add(v);
            this.recursionCount = 0;
            if (v.maxConnectCount >= maxList.size()) {
                v.maxConnectCount = this.getMaxTailCount(v, currentTestList, true);
            }
            if (currentTestList.size() <= maxList.size()) continue;
            maxList = currentTestList;
            currentTestList = new ArrayList();
            if (maxList.size() < GOOD_ENOUGH_FOR_MAX) continue;
            break;
        }
        return maxList;
    }

    private void removeFromPosMap(GFXVector v) {
        Position pos = this.posMap.get(v.key1);
        pos.vectors.remove(v);
        if (pos.vectors.size() == 0) {
            this.posMap.remove(v.key1);
        }
        pos = this.posMap.get(v.key2);
        pos.vectors.remove(v);
        if (pos.vectors.size() == 0) {
            this.posMap.remove(v.key2);
        }
    }

    private void resetPosUsage() {
        for (GFXVector v : this.list) {
            v.isPosUsed = 0;
            v.maxConnectCount = 0;
        }
    }

    private static int isConnecting(GFXVector v1, GFXVector v2) {
        if (v1.end.x() == v2.start.x() && v1.end.y() == v2.start.y() && v1.end.z() == v2.start.z()) {
            return 1;
        }
        if (v1.end.x() == v2.end.x() && v1.end.y() == v2.end.y() && v1.end.z() == v2.end.z()) {
            return -1;
        }
        return 0;
    }

    private static boolean isSameOrgUID(GFXVector cloneVector, GFXVector orgVector) {
        return orgVector.getOrgUID() == cloneVector.getOrgUID();
    }

    private static boolean isSame(GFXVector v1, GFXVector v2) {
        boolean endEnd = v1.end.x() == v2.end.x() && v1.end.y() == v2.end.y() && v1.end.z() == v2.end.z();
        boolean startStart = v1.start.x() == v2.start.x() && v1.start.y() == v2.start.y() && v1.start.z() == v2.start.z();
        boolean endStart = v1.end.x() == v2.start.x() && v1.end.y() == v2.start.y() && v1.end.z() == v2.start.z();
        boolean startEnd = v1.start.x() == v2.end.x() && v1.start.y() == v2.end.y() && v1.start.z() == v2.end.z();
        return endEnd && startStart || endStart && startEnd;
    }

    public void connectWherePossible(boolean ignoreFirst) {
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        GFXVector first = new GFXVector();
        GFXVector last = new GFXVector();
        if (ignoreFirst) {
            first = listNow.list.get(0);
            last = listNow.list.get(listNow.list.size() - 1);
        }
        ArrayList<GFXVector> startConnect1 = new ArrayList<GFXVector>();
        ArrayList<GFXVector> endConnect1 = new ArrayList<GFXVector>();
        ArrayList<GFXVector> startConnect2 = new ArrayList<GFXVector>();
        ArrayList<GFXVector> endConnect2 = new ArrayList<GFXVector>();
        for (int i = 0; i < listNow.size(); ++i) {
            GFXVector v1 = listNow.get(i);
            for (int i2 = i + 1; i2 < listNow.size(); ++i2) {
                GFXVector v2 = listNow.get(i2);
                if (v1.uid != first.uid) {
                    this.getConnectingStart(v1, startConnect1, endConnect1);
                    this.getConnectingEnd(v2, startConnect2, endConnect2);
                    if ((startConnect1.size() + endConnect1.size() < 1 && startConnect2.size() + endConnect2.size() < 1 || !avoidConnectMoreThan2) && v1.start.x() == v2.end.x() && v1.start.y() == v2.end.y() && v1.start.z() == v2.end.z()) {
                        if (v1.start_connect == null) {
                            v1.start_connect = v2;
                            v1.uid_start_connect = v2.uid;
                        }
                        if (v2.end_connect == null) {
                            v2.end_connect = v1;
                            v2.end = v1.start;
                            v2.uid_end_connect = v1.uid;
                        }
                    }
                }
                if (v1.uid == last.uid) continue;
                this.getConnectingEnd(v1, startConnect1, endConnect1);
                this.getConnectingStart(v2, startConnect2, endConnect2);
                if ((startConnect1.size() + endConnect1.size() >= 1 || startConnect2.size() + endConnect2.size() >= 1) && avoidConnectMoreThan2 || v1.end.x() != v2.start.x() || v1.end.y() != v2.start.y() || v1.end.z() != v2.start.z()) continue;
                if (v1.end_connect == null) {
                    v1.end_connect = v2;
                    v1.uid_end_connect = v2.uid;
                }
                if (v2.start_connect != null) continue;
                v2.start_connect = v1;
                v2.start = v1.end;
                v2.uid_start_connect = v1.uid;
            }
            v1.setRelativ(v1.uid_end_connect != -1 && v1.uid_start_connect != -1);
        }
        if (avoidConnectMoreThan2) {
            this.ensureNotMoreThan2Connect();
        }
    }

    void getConnectingStart(GFXVector vector, ArrayList<GFXVector> startConnect, ArrayList<GFXVector> endConnect) {
        startConnect.clear();
        endConnect.clear();
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        if (vector.start == null) {
            return;
        }
        for (int i = 0; i < listNow.size(); ++i) {
            GFXVector v = listNow.get(i);
            if (v.uid == vector.uid) continue;
            if (v.start != null && v.start.uid == vector.start.uid) {
                startConnect.add(v);
            }
            if (v.end == null || v.end.uid != vector.start.uid) continue;
            endConnect.add(v);
        }
    }

    void getConnectingEnd(GFXVector vector, ArrayList<GFXVector> startConnect, ArrayList<GFXVector> endConnect) {
        startConnect.clear();
        endConnect.clear();
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        if (vector.end == null) {
            return;
        }
        for (int i = 0; i < listNow.size(); ++i) {
            GFXVector v = listNow.get(i);
            if (v.uid == vector.uid) continue;
            if (v.start != null && v.start.uid == vector.end.uid) {
                startConnect.add(v);
            }
            if (v.end == null || v.end.uid != vector.end.uid) continue;
            endConnect.add(v);
        }
    }

    public void ensureNotMoreThan2Connect() {
        GFXVectorList listNow = this;
        if (listNow.size() == 0) {
            return;
        }
        ArrayList<GFXVector> startConnect = new ArrayList<GFXVector>();
        ArrayList<GFXVector> endConnect = new ArrayList<GFXVector>();
        for (int i = 0; i < listNow.size(); ++i) {
            int j;
            GFXVector v1 = listNow.get(i);
            this.getConnectingStart(v1, startConnect, endConnect);
            if (startConnect.size() + endConnect.size() > 1) {
                if (endConnect.size() >= 1) {
                    for (GFXVector v : startConnect) {
                        this.removeStartConnection(v);
                    }
                    for (j = 1; j < endConnect.size(); ++j) {
                        this.removeEndConnection(endConnect.get(j));
                    }
                    v1.start_connect = endConnect.get(0);
                    endConnect.get((int)0).end_connect = v1;
                    v1.uid_start_connect = endConnect.get((int)0).uid;
                    endConnect.get((int)0).uid_end_connect = v1.uid;
                } else {
                    for (j = 1; j < startConnect.size(); ++j) {
                        this.removeStartConnection(startConnect.get(j));
                    }
                    v1.start_connect = startConnect.get(0);
                    startConnect.get((int)0).start_connect = v1;
                    v1.uid_start_connect = startConnect.get((int)0).uid;
                    startConnect.get((int)0).uid_start_connect = v1.uid;
                }
            }
            this.getConnectingEnd(v1, startConnect, endConnect);
            if (startConnect.size() + endConnect.size() <= 1) continue;
            if (startConnect.size() >= 1) {
                for (GFXVector v : endConnect) {
                    this.removeEndConnection(v);
                }
                for (j = 1; j < startConnect.size(); ++j) {
                    this.removeStartConnection(startConnect.get(j));
                }
                v1.end_connect = startConnect.get(0);
                startConnect.get((int)0).start_connect = v1;
                v1.uid_end_connect = startConnect.get((int)0).uid;
                startConnect.get((int)0).uid_start_connect = v1.uid;
                continue;
            }
            for (j = 1; j < endConnect.size(); ++j) {
                this.removeEndConnection(endConnect.get(j));
            }
            v1.end_connect = endConnect.get(0);
            endConnect.get((int)0).end_connect = v1;
            v1.uid_end_connect = endConnect.get((int)0).uid;
            endConnect.get((int)0).uid_end_connect = v1.uid;
        }
    }

    private void removeStartConnection(GFXVector vector) {
        vector.setRelativ(false);
        vector.start_connect = null;
        vector.uid_start_connect = -1;
        vector.start = new Vertex(vector.start);
    }

    private void removeEndConnection(GFXVector vector) {
        vector.setRelativ(false);
        vector.end_connect = null;
        vector.uid_end_connect = -1;
        vector.end = new Vertex(vector.end);
    }

    public void add(GFXVectorList vl) {
        for (GFXVector v : vl.clone().list) {
            this.list.add(v);
        }
    }

    public boolean isAllSameIntensity() {
        if (this.list.isEmpty()) {
            return true;
        }
        int in = this.list.get((int)0).intensity;
        for (GFXVector v : this.list) {
            if (v.intensity == in) continue;
            return false;
        }
        return true;
    }

    public boolean isAllSamePattern() {
        if (this.list.isEmpty()) {
            return true;
        }
        int pa = this.list.get((int)0).pattern;
        for (GFXVector v : this.list) {
            if (v.pattern == pa) continue;
            return false;
        }
        return true;
    }

    public boolean isAllPatternHigh(boolean zeroOk) {
        if (this.list.isEmpty()) {
            return true;
        }
        int pa = this.list.get((int)0).pattern & 0xFF;
        for (GFXVector v : this.list) {
            if (v.pattern >= 128 || zeroOk && v.pattern == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isPure2d() {
        if (this.list.isEmpty()) {
            return true;
        }
        for (GFXVector v : this.list) {
            if (v.start.z() != 0.0) {
                return false;
            }
            if (v.end.z() == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isCompleteRelative() {
        if (this.list.size() < 2) {
            return true;
        }
        if (this.list.size() == 2) {
            GFXVector v1 = this.list.get(0);
            GFXVector v2 = this.list.get(1);
            if (v1.uid_end_connect == -1) {
                return false;
            }
            return v1.uid_end_connect == v2.uid && v2.uid_start_connect == v1.uid;
        }
        for (int i = 1; i < this.list.size() - 1; ++i) {
            GFXVector v = this.list.get(i);
            if (v.isRelativ()) continue;
            return false;
        }
        GFXVector v1 = this.list.get(0);
        if (v1.uid_end_connect == -1) {
            return false;
        }
        v1 = this.list.get(this.list.size() - 1);
        return v1.uid_start_connect != -1;
    }

    public boolean isClosed() {
        if (this.list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            GFXVector v = this.list.get(i);
            if (v.isRelativ()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnePath() {
        if (this.list.size() == 0) {
            return true;
        }
        HashMap<String, String> safetyNet = new HashMap<String, String>();
        ArrayList copy = (ArrayList)this.list.clone();
        GFXVector v = (GFXVector)copy.get(0);
        while (true) {
            copy.remove(v);
            safetyNet.put("" + v.uid, "");
            if (copy.size() == 0) break;
            if (v.end_connect == null) {
                return false;
            }
            if (safetyNet.get("" + v.end_connect.uid) != null) {
                return false;
            }
            v = v.end_connect;
        }
        return true;
    }

    public boolean isOrderedClosed() {
        if (!this.isClosed()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            GFXVector v1 = this.list.get(i);
            GFXVector v2 = i == 0 ? this.list.get(this.list.size() - 1) : this.list.get(i - 1);
            if (v1.uid_start_connect != v2.uid) {
                return false;
            }
            if (v2.uid_end_connect == v1.uid) continue;
            return false;
        }
        return true;
    }

    public int getXMin() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double min = 2.147483647E9;
        for (GFXVector v : this.list) {
            if (v.start.x() < min) {
                min = v.start.x();
            }
            if (!(v.end.x() < min)) continue;
            min = v.end.x();
        }
        return (int)min;
    }

    public int getYMin() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double min = 2.147483647E9;
        for (GFXVector v : this.list) {
            if (v.start.y() < min) {
                min = v.start.y();
            }
            if (!(v.end.y() < min)) continue;
            min = v.end.y();
        }
        return (int)min;
    }

    public int getZMin() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double min = 2.147483647E9;
        for (GFXVector v : this.list) {
            if (v.start.z() < min) {
                min = v.start.z();
            }
            if (!(v.end.z() < min)) continue;
            min = v.end.z();
        }
        return (int)min;
    }

    public int getXMax() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            if (v.start.x() > max) {
                max = v.start.x();
            }
            if (!(v.end.x() > max)) continue;
            max = v.end.x();
        }
        return (int)max;
    }

    public int getYMax() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            if (v.start.y() > max) {
                max = v.start.y();
            }
            if (!(v.end.y() > max)) continue;
            max = v.end.y();
        }
        return (int)max;
    }

    public int getZMax() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            if (v.start.z() > max) {
                max = v.start.z();
            }
            if (!(v.end.z() > max)) continue;
            max = v.end.z();
        }
        return (int)max;
    }

    public int getXMaxLength() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            double e;
            double s = v.start.x();
            double dif = Math.abs(s - (e = v.end.x()));
            if (!(dif > max)) continue;
            max = dif;
        }
        return (int)max;
    }

    public int getYMaxLength() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            double e;
            double s = v.start.y();
            double dif = Math.abs(s - (e = v.end.y()));
            if (!(dif > max)) continue;
            max = dif;
        }
        return (int)max;
    }

    public int getZMaxLength() {
        if (this.list.isEmpty()) {
            return 0;
        }
        double max = -2.147483648E9;
        for (GFXVector v : this.list) {
            double e;
            double s = v.start.z();
            double dif = Math.abs(s - (e = v.end.z()));
            if (!(dif > max)) continue;
            max = dif;
        }
        return (int)max;
    }

    void cleanupStartEnd() {
        for (GFXVector vA : this.list) {
            GFXVector ec;
            int ue;
            Vertex e;
            GFXVector vB = vA.start_connect;
            if (vB != null && vA.start.uid == vB.start.uid && vB.uid_start_connect == vA.uid && vA.pattern != 0) {
                e = vA.end;
                ue = vA.uid_end_connect;
                ec = vA.end_connect;
                vA.end = vA.start;
                vA.start = e;
                vA.uid_end_connect = vA.uid_start_connect;
                vA.uid_start_connect = ue;
                vA.end_connect = vA.start_connect;
                vA.start_connect = ec;
            }
            if ((vB = vA.end_connect) == null || vA.end.uid != vB.end.uid || vB.uid_end_connect != vA.uid || vB.pattern == 0) continue;
            e = vB.end;
            ue = vB.uid_end_connect;
            ec = vB.end_connect;
            vB.end = vB.start;
            vB.start = e;
            vB.uid_end_connect = vB.uid_start_connect;
            vB.uid_start_connect = ue;
            vB.end_connect = vB.start_connect;
            vB.start_connect = ec;
        }
    }

    boolean isOrdered() {
        GFXVectorList clone = this;
        String oldUID = "";
        int count = 0;
        for (GFXVector gFXVector : clone.list) {
            oldUID = oldUID + "(" + count++ + ")" + gFXVector.uid + "_" + gFXVector.start.uid + "_" + gFXVector.end.uid;
        }
        clone.doOrder();
        String newUID = "";
        count = 0;
        for (GFXVector v : clone.list) {
            newUID = newUID + "(" + count++ + ")" + v.uid + "_" + v.start.uid + "_" + v.end.uid;
        }
        boolean bl = newUID.equals(oldUID);
        if (!bl) {
            // empty if block
        }
        return bl;
    }

    public boolean testOrdered() {
        GFXVectorList clone = this.clone();
        StringBuilder oldUID = new StringBuilder();
        int count = 0;
        for (GFXVector gFXVector : clone.list) {
            oldUID.append("(").append(count++).append(")").append(gFXVector.uid).append("_").append(gFXVector.start.uid).append("_").append(gFXVector.end.uid);
        }
        clone.doOrder();
        StringBuilder newUID = new StringBuilder();
        count = 0;
        for (GFXVector v : clone.list) {
            newUID.append("(").append(count++).append(")").append(v.uid).append("_").append(v.start.uid).append("_").append(v.end.uid);
        }
        boolean bl = newUID.toString().equals(oldUID.toString());
        if (!bl) {
            // empty if block
        }
        return bl;
    }

    public void doOrder() {
        HashMap<String, String> safetyNet = new HashMap<String, String>();
        ArrayList<GFXVector> newList = new ArrayList<GFXVector>();
        for (GFXVector v : this.list) {
            v.order = -1;
        }
        this.cleanupStartEnd();
        int pos = 0;
        block1: while (this.list.size() > 0) {
            GFXVector v = this.list.get(0);
            safetyNet.put("" + v.uid, "");
            int uidStart = v.uid;
            GFXVector start = v;
            while (v.start_connect != null && v.start_connect.order < 0) {
                v = v.start_connect;
                safetyNet.put("" + v.uid, "");
                if (v.start_connect == null || safetyNet.get("" + v.start_connect.uid) == null) continue;
                v = start;
                break;
            }
            this.list.remove(v);
            v.order = pos++;
            newList.add(v);
            safetyNet = new HashMap();
            uidStart = v.uid;
            safetyNet.put("" + v.uid, "");
            while (v.end_connect != null && v.end_connect.order <= 0) {
                v = v.end_connect;
                safetyNet.put("" + v.uid, "");
                this.list.remove(v);
                v.order = pos++;
                newList.add(v);
                if (v.end_connect == null || safetyNet.get("" + v.end_connect.uid) == null) continue;
                continue block1;
            }
        }
        this.list = newList;
    }

    public void fillgaps(boolean doLine) {
        GFXVector v2;
        GFXVector v;
        this.connectWherePossible(true);
        this.doOrder();
        ArrayList<GFXVector> newList = new ArrayList<GFXVector>();
        int pos = 0;
        int pattern = doLine ? 255 : 0;
        GFXVector startv = this.list.get(0);
        GFXVector endv = this.list.get(0);
        while (this.list.size() > 0) {
            v = this.list.get(0);
            this.list.remove(v);
            v.order = pos++;
            newList.add(v);
            if (this.list.size() == 0 || v.uid_end_connect != -1) continue;
            v2 = new GFXVector();
            v2.order = pos++;
            v2.pattern = pattern;
            v2.intensity = v.intensity;
            v.uid_end_connect = v2.uid;
            v.end_connect = v2;
            v2.uid_start_connect = v.uid;
            v2.start_connect = v;
            v2.start = v.end;
            v2.end_connect = this.list.get(0);
            v2.uid_end_connect = this.list.get((int)0).uid;
            v2.end = this.list.get((int)0).start;
            if (this.list.get((int)0).uid_start_connect == -1) {
                this.list.get((int)0).uid_start_connect = v2.uid;
                this.list.get((int)0).start_connect = v2;
            }
            v2.setRelativ(true);
            if (newList.size() != 1) {
                v.setRelativ(true);
            }
            if (this.list.size() != 1) {
                this.list.get(0).setRelativ(true);
            }
            newList.add(v2);
        }
        this.list = newList;
        newList = new ArrayList();
        pos = 0;
        while (this.list.size() > 0) {
            v = this.list.get(0);
            this.list.remove(v);
            if (pos == 0) {
                v.order = pos++;
                newList.add(v);
                continue;
            }
            if (v.uid_start_connect == -1) {
                v2 = new GFXVector();
                v2.order = pos++;
                v2.pattern = pattern;
                v2.intensity = v.intensity;
                v.uid_start_connect = v2.uid;
                v.start_connect = v2;
                v2.uid_end_connect = v.uid;
                v2.end_connect = v;
                v2.end = v.start;
                v2.start_connect = (GFXVector)newList.get(newList.size() - 1);
                v2.uid_start_connect = ((GFXVector)newList.get((int)(newList.size() - 1))).uid;
                v2.start = ((GFXVector)newList.get((int)(newList.size() - 1))).start;
                if (((GFXVector)newList.get((int)(newList.size() - 1))).uid_end_connect == -1) {
                    ((GFXVector)newList.get((int)(newList.size() - 1))).uid_end_connect = v2.uid;
                    ((GFXVector)newList.get((int)(newList.size() - 1))).end_connect = v2;
                }
                v2.setRelativ(true);
                if (this.list.size() != 0) {
                    v.setRelativ(true);
                }
                if (newList.size() != 1) {
                    ((GFXVector)newList.get(newList.size() - 1)).setRelativ(true);
                }
                newList.add(v2);
            }
            v.order = pos++;
            newList.add(v);
        }
        this.list = newList;
        this.splitWhereNeeded(127);
    }

    public ArrayList<GFXVectorList> seperatePaths() {
        return this.seperatePaths(false);
    }

    public ArrayList<GFXVectorList> seperatePaths(boolean noAdditionalOptimization) {
        ArrayList<GFXVectorList> seps = new ArrayList<GFXVectorList>();
        GFXVectorList vl = this.clone();
        if (!noAdditionalOptimization) {
            vl.connectWherePossible(true);
            vl.doOrder();
        }
        if (vl.isOnePath()) {
            seps.add(vl);
            return seps;
        }
        while (vl.size() > 0) {
            GFXVector v;
            HashMap<String, String> safetyNet = new HashMap<String, String>();
            GFXVectorList newList = new GFXVectorList();
            int pos = 0;
            GFXVector start = v = vl.get(0);
            int uidStart = v.uid;
            safetyNet.put("" + v.uid, "");
            if (v.start_connect != null) {
                while (v.start_connect != null && vl.list.contains(v.start_connect)) {
                    v = v.start_connect;
                    safetyNet.put("" + v.uid, "");
                    if (safetyNet.get("" + v.uid) == null) continue;
                    v = start;
                    break;
                }
            }
            v.order = pos++;
            vl.list.remove(v);
            newList.add(v);
            uidStart = v.uid;
            safetyNet = new HashMap();
            safetyNet.put("" + v.uid, "");
            while (v.end_connect != null && vl.list.contains(v.end_connect)) {
                v = v.end_connect;
                safetyNet.put("" + v.uid, "");
                vl.list.remove(v);
                v.order = pos++;
                newList.add(v);
                if (safetyNet.get("" + v.uid_end_connect) == null) continue;
            }
            seps.add(newList);
        }
        return seps;
    }

    private void swapPoints(GFXVector v) {
        GFXVector start = v.start_connect;
        GFXVector end2 = v.end_connect;
        Vertex startVertex = v.start;
        Vertex endVertex = v.end;
        v.end_connect = start;
        v.start_connect = end2;
        v.uid_end_connect = v.end_connect != null ? v.end_connect.uid : -1;
        v.uid_start_connect = v.start_connect != null ? v.start_connect.uid : -1;
        v.start = endVertex;
        v.end = startVertex;
    }

    private int getVectorPosFromVertexStart(Vertex here) {
        int count = 0;
        int found = -1;
        for (GFXVector v : this.list) {
            if (v.start.uid == here.uid) {
                found = count;
                break;
            }
            ++count;
        }
        return found;
    }

    private int getVectorPosFromVertexEnd(Vertex here) {
        int count = 0;
        int found = -1;
        for (GFXVector v : this.list) {
            if (v.end.uid == here.uid) {
                found = count;
                break;
            }
            ++count;
        }
        return found;
    }

    public void setPointZero(Vertex here) {
        this.setPointZero(here, 0, true);
    }

    private void setPointZero(Vertex here, int depth, boolean reoderOnStart) {
        int index;
        int i;
        int found;
        ++depth;
        boolean count = false;
        boolean isEnd = false;
        if (reoderOnStart) {
            this.doOrder();
        }
        if ((found = this.getVectorPosFromVertexStart(here)) == -1) {
            isEnd = true;
            found = this.getVectorPosFromVertexEnd(here);
        }
        if (found == -1) {
            return;
        }
        if (isEnd) {
            GFXVector v = this.list.get(found);
            this.swapPoints(v);
            this.setPointZero(here, depth, false);
            return;
        }
        ArrayList<GFXVector> newList = new ArrayList<GFXVector>();
        for (i = 0; i < this.list.size(); ++i) {
            index = (i + found) % this.size();
            newList.add(this.list.get(index));
        }
        this.list = newList;
        this.doOrder();
        found = this.getVectorPosFromVertexStart(here);
        if (found == -1) {
            return;
        }
        newList = new ArrayList();
        for (i = 0; i < this.list.size(); ++i) {
            index = (i + found) % this.size();
            newList.add(this.list.get(index));
        }
        this.list = newList;
    }

    String getRelativeCoordString(GFXVector v, boolean factor) {
        return this.getRelativeCoordString(v, factor, "BLOW_UP");
    }

    String getRelativeCoordString(GFXVector v, boolean factor, String blowString) {
        String ret = "";
        ret = !factor ? ret + GFXVectorList.hex((int)this.getRelY(v)) + ", " + GFXVectorList.hex((int)this.getRelX(v)) : ret + GFXVectorList.hex((int)this.getRelY(v)) + "*" + blowString + ", " + GFXVectorList.hex((int)this.getRelX(v)) + "*" + blowString;
        return ret;
    }

    String getRelativeCoordStringReverse(GFXVector v, boolean factor) {
        return this.getRelativeCoordStringReverse(v, factor, "BLOW_UP");
    }

    String getRelativeCoordStringReverse(GFXVector v, boolean factor, String blowString) {
        String ret = "";
        ret = !factor ? ret + GFXVectorList.hex((int)this.getRelX(v)) + ", " + GFXVectorList.hex((int)this.getRelY(v)) : ret + GFXVectorList.hex((int)this.getRelX(v)) + "*" + blowString + ", " + GFXVectorList.hex((int)this.getRelY(v)) + "*" + blowString;
        return ret;
    }

    String getCoordStringReverse(GFXVector v, boolean factor) {
        String ret = "";
        ret = !factor ? ret + GFXVectorList.hex((int)v.end.x()) + ", " + GFXVectorList.hex((int)v.end.y()) : ret + GFXVectorList.hex((int)v.end.x()) + "*BLOW_UP, " + GFXVectorList.hex((int)v.end.y()) + "*BLOW_UP";
        return ret;
    }

    double getRelX(GFXVector v) {
        return v.end.x() - v.start.x();
    }

    double getRelY(GFXVector v) {
        return v.end.y() - v.start.y();
    }

    public boolean isMov_Draw_VLc_a() {
        if (this.getXMaxLength() > 127 || this.getYMaxLength() > 127 || this.getZMaxLength() > 127) {
            this.log.addLog("isMov_Draw_VLc_a failed, single vectors to large!", LogPanel.WARN);
            return false;
        }
        if (!this.isOrdered()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isAllSamePattern()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not same pattern!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isMov_Draw_VLc_a failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VLc() {
        if (this.getXMaxLength() > 127 || this.getYMaxLength() > 127 || this.getZMaxLength() > 127) {
            this.log.addLog("isDraw_VLc failed, single vectors to large!", LogPanel.WARN);
            return false;
        }
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VLc failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isAllSamePattern()) {
            this.log.addLog("isDraw_VLc failed, not same pattern!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VLc failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VLp() {
        if (this.getXMaxLength() > 127 || this.getYMaxLength() > 127 || this.getZMaxLength() > 127) {
            this.log.addLog("isDraw_VLp failed, single vectors to large!", LogPanel.WARN);
            return false;
        }
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VLp failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VLp failed, not continuous!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_VL_mode() {
        if (this.getXMaxLength() > 127 || this.getYMaxLength() > 127 || this.getZMaxLength() > 127) {
            this.log.addLog("isDraw_VL_mode failed, single vectors to large!", LogPanel.WARN);
            return false;
        }
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_VL_mode failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_VL_mode failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public boolean isDraw_CodeGen() {
        if (this.getXMaxLength() > 127 || this.getYMaxLength() > 127 || this.getZMaxLength() > 127) {
            this.log.addLog("isDraw_CodeGen failed, single vectors to large!", LogPanel.WARN);
            return false;
        }
        if (!this.isOrdered()) {
            this.log.addLog("isDraw_CodeGen failed, not ordered!", LogPanel.WARN);
            return false;
        }
        if (!this.isCompleteRelative()) {
            this.log.addLog("isDraw_CodeGen failed, not continuos!", LogPanel.WARN);
            return false;
        }
        return true;
    }

    public String createPCMov_Draw_VLc_a(boolean includeMove, String name, boolean factor) {
        if (includeMove) {
            if (!this.isMov_Draw_VLc_a()) {
                return "";
            }
            if (!this.isDraw_VLc()) {
                return "";
            }
        }
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this.clone();
        int count = vl.size();
        if (!includeMove) {
            --count;
        }
        s.append("const struct vector_t vectors_" + name + "[] =\n{\n");
        boolean init = includeMove;
        for (GFXVector v : vl.list) {
            if (init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append("\t{").append(this.getRelativeCoordString(v, factor)).append("}, // move to y, x\n");
                }
            }
            s.append("\t{").append(this.getRelativeCoordString(v, factor)).append("}, // draw to y, x\n");
        }
        s.append("};\n");
        s.append("const struct vector_list_t " + name + " =\n");
        s.append("{\n");
        if (includeMove) {
            s.append("\t.type = DUFFY,\n");
        } else {
            s.append("\t.type = DIFFY,\n");
        }
        s.append("\t.size = " + GFXVectorList.hex(count) + ",\n");
        s.append("\t.vectors = &vectors_" + name + "\n");
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    void addUsage(HashMap<String, String> map, String v) {
        v = UtilityString.replace(v, "_N_0_0", "_1_0_0");
        v = UtilityString.replace(v, "_N_N_0", "_1_1_0");
        v = UtilityString.replace(v, "_N_0_N", "_1_0_1");
        v = UtilityString.replace(v, "_N_N_N", "_1_1_1");
        v = UtilityString.replace(v, "_0_N_0", "_0_1_0");
        v = UtilityString.replace(v, "_0_N_N", "_0_1_1");
        v = UtilityString.replace(v, "_0_0_N", "_0_0_1");
        v = UtilityString.replace(v, "_1_N_0", "_N_1_0");
        v = UtilityString.replace(v, "_1_0_N", "_N_0_1");
        v = UtilityString.replace(v, "_0_1_N", "_0_N_1");
        v = UtilityString.replace(v, "_1_N_N", "_N_1_1");
        v = UtilityString.replace(v, "_N_1_N", "_1_N_1");
        v = UtilityString.replace(v, "_N_N_1", "_1_1_N");
        map.put(v, v);
    }

    public String createC3dPattern(String name, boolean factor, boolean createNon3ds, boolean shift, boolean absolut) {
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this.clone();
        int count = vl.size();
        if (shift) {
            if (absolut) {
                s.append("/* Format: (absolut values)\n");
                s.append(" * pattern, y0,x0,z0,y1,x1,z1\n");
                s.append(" */\n");
            } else {
                s.append("/* Format: (relative values)\n");
                s.append(" * pattern, y_len,x_len,z_len\n");
                s.append(" */\n");
            }
            s.append("const struct Line_3d " + name).append("[]=\n{\n");
            boolean first = true;
            for (GFXVector v : vl.list) {
                StringBuilder s2 = new StringBuilder();
                if (first) {
                    first = false;
                    s.append("\n");
                } else {
                    s.append(",\n");
                }
                s2.append("\t{");
                int pattern = v.pattern;
                if (pattern == 0) {
                    s2.append("0x00, ");
                } else {
                    s2.append("0xff, ");
                }
                if (absolut) {
                    s2.append(GFXVectorList.hex((int)v.start.y())).append(", ");
                    s2.append(GFXVectorList.hex((int)v.start.x())).append(", ");
                    s2.append(GFXVectorList.hex((int)v.start.z())).append(", ");
                    s2.append(GFXVectorList.hex((int)v.end.y())).append(", ");
                    s2.append(GFXVectorList.hex((int)v.end.x())).append(", ");
                    s2.append(GFXVectorList.hex((int)v.end.z())).append("}");
                } else {
                    int width = (int)(v.end.x() - v.start.x());
                    int height = (int)(v.end.y() - v.start.y());
                    int depth = (int)(v.end.z() - v.start.z());
                    s2.append(GFXVectorList.hex(height)).append(", ");
                    s2.append(GFXVectorList.hex(width)).append(", ");
                    s2.append(GFXVectorList.hex(depth)).append("}");
                }
                s.append((CharSequence)s2);
            }
            s.append("\n");
            s.append("};\n");
            String text = s.toString();
            hexSign = oldHex;
            return text;
        }
        if (createNon3ds) {
            s.append("const struct Line3d " + name).append("[]=\n{\n");
        } else {
            s.append("const struct Line3ds " + name).append("[]=\n{\n");
        }
        HashMap<String, String> usageMap = new HashMap<String, String>();
        for (GFXVector v : vl.list) {
            StringBuilder s2 = new StringBuilder();
            s2.append("\t{");
            int pattern = v.pattern;
            if (pattern == 0) {
                s2.append("  0, ");
            } else {
                s2.append("255, ");
            }
            StringBuilder t = new StringBuilder();
            t.append("_");
            double width = v.end.x() - v.start.x();
            if (width == 0.0) {
                t.append("0");
            } else if (width > 0.0) {
                t.append("1");
            } else if (width < 0.0) {
                t.append("N");
            }
            double height = v.end.y() - v.start.y();
            t.append("_");
            if (height == 0.0) {
                t.append("0");
            } else if (height > 0.0) {
                t.append("1");
            } else if (height < 0.0) {
                t.append("N");
            }
            double depth = v.end.z() - v.start.z();
            t.append("_");
            if (depth == 0.0) {
                t.append("0");
            } else if (depth > 0.0) {
                t.append("1");
            } else if (depth < 0.0) {
                t.append("N");
            }
            this.addUsage(usageMap, t.toString());
            boolean error2 = false;
            int size = 0;
            if (width != 0.0) {
                size = (int)width;
                if (height != 0.0 && Math.abs(width) != Math.abs(height)) {
                    error2 = true;
                }
                if (depth != 0.0 && Math.abs(width) != Math.abs(depth)) {
                    error2 = true;
                }
            }
            if (height != 0.0) {
                size = (int)height;
                if (depth != 0.0 && Math.abs(height) != Math.abs(depth)) {
                    error2 = true;
                }
            }
            if (depth != 0.0) {
                size = (int)depth;
            }
            if (error2) {
                this.log.addLog("Error creating 3d list vector length not conform. (" + v.uid + ")", LogPanel.WARN);
            }
            if (!createNon3ds) {
                s2.append(name.toUpperCase() + "_STRENGTH*" + Math.abs(size) + ", ");
            }
            s2.append(t.toString());
            s2.append("},\n");
            if (createNon3ds) {
                for (int tt = 0; tt < Math.abs(size); ++tt) {
                    s.append(s2.toString());
                }
                continue;
            }
            s.append(s2.toString());
        }
        if (createNon3ds) {
            s.append("\t{  1, _0_0_N}\n};\n");
        } else {
            s.append("\t{  1, 0, _0_0_N}\n};\n");
        }
        s.append("\n/* usage: \n");
        Set entries = usageMap.entrySet();
        for (Map.Entry entry : entries) {
            String pattern = (String)entry.getValue();
        }
        s.append("\tcalc_000 = 0; \n");
        s.append("\tcalc_100 = " + (usageMap.get("_1_0_0") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_110 = " + (usageMap.get("_1_1_0") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_101 = " + (usageMap.get("_1_0_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_111 = " + (usageMap.get("_1_1_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_010 = " + (usageMap.get("_0_1_0") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_111 = " + (usageMap.get("_1_1_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_001 = " + (usageMap.get("_0_0_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_N10 = " + (usageMap.get("_N_1_0") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_N01 = " + (usageMap.get("_N_0_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_0N1 = " + (usageMap.get("_0_N_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_N11 = " + (usageMap.get("_N_1_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_1N1 = " + (usageMap.get("_1_N_1") != null ? 1 : 0) + "; \n");
        s.append("\tcalc_11N = " + (usageMap.get("_1_1_N") != null ? 1 : 0) + "; \n");
        boolean usage = false;
        String us = "\n\tvectorBits = 0";
        if (usageMap.get("_0_0_0") != null) {
            us = us + " + TEST_0_0_0";
        }
        if (usageMap.get("_1_0_0") != null) {
            us = us + " + TEST_1_0_0";
        }
        if (usageMap.get("_1_1_0") != null) {
            us = us + " + TEST_1_1_0";
        }
        if (usageMap.get("_1_0_1") != null) {
            us = us + " + TEST_1_0_1";
        }
        if (usageMap.get("_1_1_1") != null) {
            us = us + " + TEST_1_1_1";
        }
        if (usageMap.get("_0_1_0") != null) {
            us = us + " + TEST_0_1_0";
        }
        if (usageMap.get("_0_1_1") != null) {
            us = us + " + TEST_0_1_1";
        }
        if (usageMap.get("_0_0_1") != null) {
            us = us + " + TEST_0_0_1";
        }
        if (usageMap.get("_N_1_0") != null) {
            us = us + " + TEST_N_1_0";
        }
        if (usageMap.get("_N_0_1") != null) {
            us = us + " + TEST_N_0_1";
        }
        if (usageMap.get("_0_N_1") != null) {
            us = us + " + TEST_0_N_1";
        }
        if (usageMap.get("_N_1_1") != null) {
            us = us + " + TEST_N_1_1";
        }
        if (usageMap.get("_1_N_1") != null) {
            us = us + " + TEST_1_N_1";
        }
        if (usageMap.get("_1_1_N") != null) {
            us = us + " + TEST_1_1_N";
        }
        us = us + ";\n";
        s.append(us);
        s.append("*/\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createCMov_Draw_VLc_a(boolean includeMove, String name, boolean factor, boolean pc) {
        if (pc) {
            return this.createPCMov_Draw_VLc_a(includeMove, name, factor);
        }
        if (includeMove) {
            if (!this.isMov_Draw_VLc_a()) {
                return "";
            }
            if (!this.isDraw_VLc()) {
                return "";
            }
        }
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this.clone();
        int count = vl.size();
        if (!includeMove) {
            --count;
        }
        s.append("const signed char " + name).append("[]=\n{");
        s.append("\t" + GFXVectorList.hex(count)).append(",\n");
        boolean init = includeMove;
        for (GFXVector v : vl.list) {
            if (init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append("\t").append(GFXVectorList.hex((int)v.start.y())).append(", ").append(GFXVectorList.hex((int)v.start.x())).append(", // move to y, x\n");
                }
            }
            s.append("\t").append(this.getRelativeCoordString(v, factor)).append(", // draw to y, x\n");
        }
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createASMMov_Draw_VLc_a(boolean includeMove, String name, boolean factor) {
        if (includeMove) {
            if (!this.isMov_Draw_VLc_a()) {
                return "";
            }
            if (!this.isDraw_VLc()) {
                return "";
            }
        }
        StringBuilder s = new StringBuilder();
        GFXVectorList vl = this.clone();
        int count = vl.size();
        if (!includeMove) {
            --count;
        }
        s.append(name).append(":\n");
        s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hex(count)).append(" ; number of lines to draw\n");
        boolean init = includeMove;
        for (GFXVector v : vl.list) {
            if (init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hex((int)v.start.y())).append(", ").append(GFXVectorList.hex((int)v.start.x())).append(" ; move to y, x\n");
                }
            }
            s.append(" " + GFXVectorList.getDB() + " ").append(this.getRelativeCoordString(v, factor)).append(" ; draw to y, x\n");
        }
        String text = s.toString();
        return text;
    }

    public String createCDraw_VLp(String name, boolean factor, boolean keepPosition) {
        if (!this.isDraw_VLp()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        s.append("const signed char " + name).append("[]=\n{");
        GFXVectorList vl = this;
        if (keepPosition && vl.list.size() > 0) {
            GFXVector v = vl.list.get(0);
            if ((int)v.start.x() != 0 || (int)v.start.y() != 0) {
                s.append("\t(signed char) ").append(GFXVectorList.hexU(0)).append(", ");
                GFXVector vDummy = new GFXVector();
                vDummy.end = v.start;
                s.append(this.getRelativeCoordString(vDummy, factor)).append(", ");
                s.append(" // pattern, y, x\n");
            }
        }
        for (GFXVector v : vl.list) {
            boolean warn = false;
            int pattern = v.pattern & 0xFF;
            if (pattern < 128 && pattern != 0) {
                warn = true;
                pattern += 128;
            }
            s.append("\t(signed char) ").append(GFXVectorList.hexU(pattern)).append(", ");
            s.append(this.getRelativeCoordString(v, factor)).append(", ");
            if (warn) {
                s.append(" // WARN pattern high bit set!\n");
                continue;
            }
            s.append(" // pattern, y, x\n");
        }
        s.append("\t(signed char) ").append(GFXVectorList.hexU(1)).append(" // endmarker (high bit in pattern not set)\n");
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createASMDraw_VLp(String name, boolean factor, boolean keepPosition) {
        if (!this.isDraw_VLp()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(name).append(":\n");
        GFXVectorList vl = this;
        if (keepPosition && vl.list.size() > 0) {
            GFXVector v = vl.list.get(0);
            if ((int)v.start.x() != 0 || (int)v.start.y() != 0) {
                s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(0)).append(", ");
                GFXVector vDummy = new GFXVector();
                vDummy.end = v.start;
                s.append(this.getRelativeCoordString(vDummy, factor));
                s.append(" ; pattern, y, x\n");
            }
        }
        for (GFXVector v : vl.list) {
            boolean warn = false;
            int pattern = v.pattern & 0xFF;
            if (pattern < 128 && pattern != 0) {
                warn = true;
                pattern += 128;
            }
            s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(pattern)).append(", ");
            s.append(this.getRelativeCoordString(v, factor));
            if (warn) {
                s.append(" ; WARN pattern high bit set!\n");
                continue;
            }
            s.append(" ; pattern, y, x\n");
        }
        s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(1)).append(" ; endmarker (high bit in pattern not set)\n");
        String text = s.toString();
        return text;
    }

    public String createCDraw_VL_mode(String name, boolean includeInitialMove, boolean factor, boolean pc) {
        if (pc) {
            return this.createPCDraw_VL_mode(name, includeInitialMove, factor);
        }
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this;
        s.append("const signed char " + name).append("[]=\n{");
        boolean init = true;
        for (GFXVector v : vl.list) {
            if (includeInitialMove && init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append("\t(signed char) ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex((int)v.start.y())).append(", ").append(GFXVectorList.hex((int)v.start.x())).append(", // move to y, x\n");
                }
            }
            boolean warn = false;
            int pattern = v.pattern & 0xFF;
            if (pattern != 0 && pattern < 128) {
                warn = true;
                pattern += 128;
            }
            int mode = pattern == 0 ? 0 : (pattern == 255 && !warn ? 2 : -1);
            s.append("\t(signed char) ").append(GFXVectorList.hexU(mode)).append(", ");
            s.append(this.getRelativeCoordString(v, factor));
            s.append(", // mode, y, x\n");
        }
        s.append("\t(signed char) ").append(GFXVectorList.hexU(1)).append(" // endmarker (1)\n");
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createPCDraw_VL_mode(String name, boolean includeInitialMove, boolean factor) {
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this;
        s.append("const struct packet_t vectors_" + name + "[] =\n{\n");
        int count = 0;
        boolean stopped = false;
        for (GFXVector v : vl.list) {
            int mode;
            boolean warn = false;
            int pattern = v.pattern & 0xFF;
            if (pattern != 0 && pattern < 128) {
                warn = true;
                pattern += 128;
            }
            if ((mode = pattern == 0 ? 0 : (pattern == 255 && !warn ? 2 : -1)) == 0) {
                s.append("\t{MOVE, ");
            }
            if (mode == 2) {
                s.append("\t{DRAW, ");
            }
            if (mode == -1) {
                stopped = true;
                s.append("\t{STOP, ");
            }
            s.append("{").append(this.getRelativeCoordString(v, factor)).append("}}");
            if (mode != -1) {
                s.append(",\n");
            } else {
                s.append("\n");
            }
            ++count;
        }
        if (!stopped) {
            s.append("\t{STOP, ");
            s.append("{").append(GFXVectorList.hex(0) + ", " + GFXVectorList.hex(0)).append("}}");
            s.append("\n");
            ++count;
        }
        s.append("};\n");
        s.append("const struct vector_list_t " + name + " =\n");
        s.append("{\n");
        s.append("\t.type = PACKET,\n");
        s.append("\t.size = " + GFXVectorList.hex(count) + ",\n");
        s.append("\t.vectors = &vectors_" + name + "\n");
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createAbsolutListC(String name, boolean start, boolean end2, boolean factor) {
        StringBuilder s = new StringBuilder();
        String oldHex = hexSign;
        hexSign = "0x";
        GFXVectorList vl = this;
        s.append("const signed char " + name).append("[]=\n{");
        String f = "";
        if (factor) {
            f = "*BLOW_UP";
        }
        s.append("\t(signed char) ").append("" + vl.list.size()).append(", // count of vectors\n");
        for (GFXVector v : vl.list) {
            s.append("\t(signed char) ").append(GFXVectorList.hexU((int)v.start.y()) + f).append(", ");
            s.append("(signed char) ").append(GFXVectorList.hexU((int)v.start.x()) + f).append(", ");
            s.append("(signed char) ").append(GFXVectorList.hexU((int)v.end.y()) + f).append(", ");
            s.append("(signed char) ").append(GFXVectorList.hexU((int)v.end.x()) + f).append(",");
            s.append("\t// y0, x0, y1, x1\n");
        }
        s.append("};\n");
        String text = s.toString();
        hexSign = oldHex;
        return text;
    }

    public String createAbsolutList(String name, boolean start, boolean end2) {
        StringBuilder s = new StringBuilder();
        GFXVectorList vl = this;
        s.append(name).append(":\n");
        boolean init = true;
        for (GFXVector v : vl.list) {
            s.append(" " + GFXVectorList.getDB() + " ");
            if (start & end2) {
                s.append(GFXVectorList.hex((int)v.start.y()) + ", " + GFXVectorList.hex((int)v.start.x()) + ", " + GFXVectorList.hex((int)v.end.y()) + ", " + GFXVectorList.hex((int)v.end.x()) + " ; y0, x0, y1, x1 [pattern:" + GFXVectorList.hexU(v.pattern & 0xFF) + "]\n");
                continue;
            }
            if (start) {
                s.append(GFXVectorList.hex((int)v.start.y()) + ", " + GFXVectorList.hex((int)v.start.x()) + " ; y0, x0 [pattern:" + GFXVectorList.hexU(v.pattern & 0xFF) + "]\n");
                continue;
            }
            if (!end2) continue;
            s.append(GFXVectorList.hex((int)v.end.y()) + ", " + GFXVectorList.hex((int)v.end.x()) + " ; y1, x1 [pattern:" + GFXVectorList.hexU(v.pattern & 0xFF) + "]\n");
        }
        String text = s.toString();
        return text;
    }

    public String createASMDraw_VL_mode(String name, boolean includeInitialMove, boolean factor) {
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        GFXVectorList vl = this;
        s.append(name).append(":\n");
        boolean init = true;
        for (GFXVector v : vl.list) {
            if (includeInitialMove && init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex((int)v.start.y())).append(", ").append(GFXVectorList.hex((int)v.start.x())).append(" ; move to y, x\n");
                }
            }
            boolean warn = false;
            int pattern = v.pattern & 0xFF;
            if (pattern != 0 && pattern < 128) {
                warn = true;
                pattern += 128;
            }
            int mode = pattern == 0 ? 0 : (pattern == 255 && !warn ? 2 : -1);
            s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(mode)).append(", ");
            s.append(this.getRelativeCoordString(v, factor));
            s.append(" ; mode, y, x\n");
        }
        s.append(" " + GFXVectorList.getDB() + " ").append(GFXVectorList.hexU(1)).append(" ; endmarker (1)\n");
        String text = s.toString();
        return text;
    }

    public String createASMDraw_VL_modeBASIC(String name) {
        if (!this.isDraw_VL_mode()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        GFXVectorList vl = this;
        s.append(name).append("={_\n");
        boolean init = true;
        for (GFXVector v : vl.list) {
            if (!init) {
                s.append(", _\n");
            }
            init = false;
            int pattern = v.pattern & 0xFF;
            boolean mode = pattern != 0;
            s.append("        {");
            if (mode) {
                s.append("DrawTo, ");
            } else {
                s.append("MoveTo, ");
            }
            s.append(this.getCoordStringReverse(v, false));
            s.append("}");
        }
        s.append("}\n");
        String text = s.toString();
        return text;
    }

    public void splitHalf(ArrayList<GFXVector> aList, GFXVector v, int newPos) {
        double halfX = v.start.x() + (v.end.x() - v.start.x()) / 2.0;
        double halfY = v.start.y() + (v.end.y() - v.start.y()) / 2.0;
        double halfZ = v.start.z() + (v.end.z() - v.start.z()) / 2.0;
        GFXVector nv = v.clone();
        nv.relativ = v.relativ;
        nv.order = newPos;
        nv.end_connect = v.end_connect;
        nv.end = v.end;
        nv.uid_end_connect = v.uid_end_connect;
        HashMap<String, String> saftyNet = new HashMap<String, String>();
        saftyNet.put("" + v.uid, "");
        saftyNet.put("" + nv.uid, "");
        if (nv.end != null) {
            for (int i = 0; i < aList.size(); ++i) {
                GFXVector vv = aList.get(i);
                if (saftyNet.get("" + vv.uid) != null) continue;
                if (vv.start == nv.end && vv.uid_start_connect == v.uid) {
                    vv.start_connect = nv;
                    vv.uid_start_connect = nv.uid;
                    continue;
                }
                if (vv.end != nv.end || vv.uid_end_connect != v.uid) continue;
                vv.end_connect = nv;
                vv.uid_end_connect = nv.uid;
            }
        }
        nv.start_connect = v;
        nv.uid_start_connect = v.uid;
        v.end = nv.start;
        v.uid_end_connect = nv.uid;
        v.end_connect = nv;
        v.end.x((int)halfX);
        v.end.y((int)halfY);
        v.end.z((int)halfZ);
        int pos = aList.indexOf(v);
        aList.add(pos + 1, nv);
        saftyNet = new HashMap();
        saftyNet.put("" + v.uid, "");
        saftyNet.put("" + nv.uid, "");
        for (int i = 0; i < aList.size(); ++i) {
            GFXVector vv = aList.get(i);
            if (saftyNet.get("" + vv.uid) != null || vv.order < newPos) continue;
            ++vv.order;
        }
    }

    public void splitWhereNeeded(int splitValue) {
        for (int i = 0; i < this.list.size(); ++i) {
            boolean didSplit;
            do {
                didSplit = false;
                GFXVector v = this.list.get(i);
                if (!(Math.abs(v.start.x() - v.end.x()) > (double)splitValue) && !(Math.abs(v.start.y() - v.end.y()) > (double)splitValue) && !(Math.abs(v.start.z() - v.end.z()) > (double)splitValue)) continue;
                this.splitHalf(this.list, v, v.order + 1);
                didSplit = true;
            } while (didSplit);
        }
    }

    String templateInsert(String ret, double y, double x, int pattern, int intensity) {
        ret = UtilityString.replace(ret, "%XRELPOS%", GFXVectorList.hexU((int)x));
        ret = UtilityString.replace(ret, "%YRELPOS%", GFXVectorList.hexU((int)y));
        ret = UtilityString.replace(ret, "%PATTERN%", GFXVectorList.hexU(pattern));
        ret = UtilityString.replace(ret, "%INTENSITY%", GFXVectorList.hexU(intensity));
        ret = UtilityString.replace(ret, "%UID%", "" + tuid++);
        return ret;
    }

    public String createASMCodeGen(String name) {
        if (!this.isDraw_CodeGen()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        Path template = Paths.get(Global.mainPathPrefix, "template", "codeGenDraw.template");
        String drawASM = UtilityString.readTextFileToOneString(new File(template.toString()));
        template = Paths.get(Global.mainPathPrefix, "template", "codeGenMove.template");
        String moveASM = UtilityString.readTextFileToOneString(new File(template.toString()));
        template = Paths.get(Global.mainPathPrefix, "template", "codeGenPattern.template");
        String patternASM = UtilityString.readTextFileToOneString(new File(template.toString()));
        template = Paths.get(Global.mainPathPrefix, "template", "codeGenInit.template");
        String initASM = UtilityString.readTextFileToOneString(new File(template.toString()));
        template = Paths.get(Global.mainPathPrefix, "template", "codeGenDeInit.template");
        String deinitASM = UtilityString.readTextFileToOneString(new File(template.toString()));
        GFXVectorList vl = this;
        s.append(name).append(":\n");
        boolean init = true;
        s.append(initASM);
        for (GFXVector v : vl.list) {
            if (init) {
                init = false;
                if ((int)v.start.y() != 0 || (int)v.start.x() != 0) {
                    s.append(this.templateInsert(moveASM, v.start.y(), v.start.x(), v.pattern, v.intensity));
                }
            }
            if (v.pattern == 0) {
                s.append(this.templateInsert(moveASM, this.getRelY(v), this.getRelX(v), v.pattern, v.intensity));
                continue;
            }
            if (v.pattern == 255) {
                s.append(this.templateInsert(drawASM, this.getRelY(v), this.getRelX(v), v.pattern, v.intensity));
                continue;
            }
            s.append(this.templateInsert(patternASM, this.getRelY(v), this.getRelX(v), v.pattern, v.intensity));
        }
        s.append(deinitASM);
        String text = s.toString();
        return text;
    }

    GFXVectorList optimizeMove(GFXVectorList vl, int maxLen, boolean useMaxLen) {
        vl = vl.clone();
        vl.connectWherePossible(true);
        vl.doOrder();
        boolean optimizeDone = false;
        block0: do {
            optimizeDone = false;
            for (int index = 0; index < vl.size() - 1; ++index) {
                GFXVector v1 = vl.get(index);
                GFXVector v2 = vl.get(index + 1);
                if (v1.pattern != 0 || v2.pattern != 0) continue;
                double xDelta1 = v1.start.x() - v1.end.x();
                double yDelta1 = v1.start.y() - v1.end.y();
                double zDelta1 = v1.start.z() - v1.end.z();
                double xDelta2 = v2.start.x() - v2.end.x();
                double yDelta2 = v2.start.y() - v2.end.y();
                double zDelta2 = v2.start.z() - v2.end.z();
                double sumXDelta = xDelta1 + xDelta2;
                double sumYDelta = yDelta1 + yDelta2;
                double sumZDelta = zDelta1 + zDelta2;
                if (!useMaxLen) continue;
                if (!(sumXDelta <= (double)maxLen) || !(sumXDelta >= (double)(-maxLen)) || !(sumYDelta <= (double)maxLen) || !(sumYDelta >= (double)(-maxLen)) || !(sumZDelta <= (double)maxLen) || !(sumZDelta >= (double)(-maxLen))) continue;
                optimizeDone = true;
                v1.end = v2.end;
                v1.end_connect = v2.end_connect;
                if (v2.end_connect != null && v2.end_connect.start.uid == v2.end.uid) {
                    v2.end_connect.start_connect = v1;
                }
                vl.remove(v2);
                continue block0;
            }
        } while (optimizeDone);
        return vl;
    }

    void splitList(GFXVectorList vl, int maxResync, ArrayList<GFXVectorList> subLists) {
        if (maxResync <= 0) {
            subLists.add(vl);
            return;
        }
        if (vl.size() < maxResync) {
            subLists.add(vl);
            return;
        }
        int s = vl.size() / 2;
        GFXVectorList vl2 = new GFXVectorList();
        for (int i = s; i < vl.size(); ++i) {
            GFXVector v = vl.get(i);
            if (i == s && i > 0) {
                vl.get((int)(i - 1)).end_connect = null;
                vl.get((int)(i - 1)).end = new Vertex(vl.get((int)(i - 1)).end);
                vl.get((int)i).start_connect = null;
            }
            vl2.add(v);
        }
        for (GFXVector v : vl2.list) {
            vl.remove(v);
        }
        if (vl2.size() > 0 && vl2.get((int)(vl2.size() - 1)).end_connect != null && vl2.get((int)(vl2.size() - 1)).end_connect == vl.get((int)0).start_connect) {
            vl.get((int)0).start_connect = null;
            vl.get((int)0).start = new Vertex(vl.get((int)0).start);
            vl2.get((int)(vl2.size() - 1)).end_connect = null;
        }
        this.splitList(vl, maxResync, subLists);
        this.splitList(vl2, maxResync, subLists);
    }

    public boolean createCDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, int splitter) {
        return this.createCDraw_syncList(source, name, factor, maxResync, false, splitter);
    }

    public boolean createCDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter) {
        return this.createCDraw_syncList(source, name, factor, maxResync, extended, splitter, false);
    }

    public boolean createCDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter, boolean noAdditionalOptimization) {
        return this.createCDraw_syncList(source, name, factor, maxResync, extended, splitter, false, "BLOW_UP");
    }

    public boolean createCDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter, boolean noAdditionalOptimization, String blowString) {
        int maxLen = (int)this.getMaxAbsLenValue();
        ArrayList<GFXVectorList> subLists1 = this.seperatePaths(noAdditionalOptimization);
        ArrayList<GFXVectorList> subLists = new ArrayList<GFXVectorList>();
        for (GFXVectorList vl : subLists1) {
            this.splitList(vl, maxResync, subLists);
        }
        int intensity = 256;
        String oldHex = hexSign;
        hexSign = "0x";
        source.append("const signed char " + name).append("[]=\n{");
        for (GFXVectorList vectorlist : subLists) {
            boolean first = true;
            vectorlist = this.optimizeMove(vectorlist, maxLen, true);
            vectorlist.splitWhereNeeded(splitter);
            if (maxLen < splitter) {
                splitter = maxLen;
            }
            for (GFXVector vector : vectorlist.list) {
                int newIntensity = vector.intensity;
                Vertex start = vector.start;
                Vertex end2 = vector.end;
                int pattern = vector.pattern & 0xFF;
                if (newIntensity != intensity && extended) {
                    source.append("\t(signed char) ").append(GFXVectorList.hexU(3)).append(", ").append(GFXVectorList.hex(newIntensity)).append(", // new intensity\n");
                }
                if (first) {
                    int y = (int)start.y();
                    int x = (int)start.x();
                    do {
                        int useX;
                        int useY;
                        if (y > splitter) {
                            useY = splitter;
                            y -= splitter;
                        } else if (y < -splitter) {
                            useY = -splitter;
                            y += splitter;
                        } else {
                            useY = y;
                            y -= useY;
                        }
                        if (x > splitter) {
                            useX = splitter;
                            x -= splitter;
                        } else if (x < -splitter) {
                            useX = -splitter;
                            x += splitter;
                        } else {
                            useX = x;
                            x -= useX;
                        }
                        if (factor) {
                            if (first) {
                                source.append("\t(signed char) ").append(GFXVectorList.hexU(1)).append(", ").append(GFXVectorList.hex(useY)).append("*").append(blowString).append(", ").append(GFXVectorList.hex(useX)).append("*").append(blowString).append(", // sync and move to y, x\n");
                            } else {
                                source.append("\t(signed char) ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex(useY)).append("*").append(blowString).append(", ").append(GFXVectorList.hex(useX)).append("*").append(blowString).append(", // additional sync move to y, x\n");
                            }
                        } else if (first) {
                            source.append("\t(signed char) ").append(GFXVectorList.hexU(1)).append(", ").append(GFXVectorList.hex(useY)).append(", ").append(GFXVectorList.hex(useX)).append(", // sync and move to y, x\n");
                        } else {
                            source.append("\t(signed char) ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex(useY)).append(", ").append(GFXVectorList.hex(useX)).append(", // additional sync move to y, x\n");
                        }
                        first = false;
                    } while (y != 0 || x != 0);
                }
                if (pattern == 0) {
                    source.append("\t(signed char) ").append(GFXVectorList.hexU(0)).append(", ");
                    source.append(this.getRelativeCoordString(vector, factor, blowString));
                    source.append(", // mode, y, x\n");
                } else {
                    source.append("\t(signed char) ").append(GFXVectorList.hexU(255)).append(", ");
                    source.append(this.getRelativeCoordString(vector, factor, blowString));
                    source.append(", // draw, y, x\n");
                }
                intensity = newIntensity;
            }
        }
        source.append("\t(signed char) ").append(GFXVectorList.hexU(2)).append(" // endmarker \n");
        source.append("};\n");
        hexSign = oldHex;
        return true;
    }

    public boolean createASMDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, int splitter) {
        return this.createASMDraw_syncList(source, name, factor, maxResync, false, splitter);
    }

    public boolean createASMDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter) {
        return this.createASMDraw_syncList(source, name, factor, maxResync, extended, splitter, false);
    }

    public boolean createASMDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter, boolean noAdditionalOptimization) {
        return this.createASMDraw_syncList(source, name, factor, maxResync, extended, splitter, false, "BLOW_UP");
    }

    public boolean createASMDraw_syncList(StringBuilder source, String name, boolean factor, int maxResync, boolean extended, int splitter, boolean noAdditionalOptimization, String blowString) {
        int maxLen = (int)this.getMaxAbsLenValue();
        ArrayList<GFXVectorList> subLists1 = this.seperatePaths(noAdditionalOptimization);
        ArrayList<GFXVectorList> subLists = new ArrayList<GFXVectorList>();
        for (GFXVectorList vl : subLists1) {
            this.splitList(vl, maxResync, subLists);
        }
        int intensity = 256;
        source.append(name).append(":\n");
        for (GFXVectorList vectorlist : subLists) {
            boolean first = true;
            vectorlist = this.optimizeMove(vectorlist, maxLen, true);
            vectorlist.splitWhereNeeded(splitter);
            if (maxLen < splitter) {
                splitter = maxLen;
            }
            for (GFXVector vector : vectorlist.list) {
                int newIntensity = vector.intensity;
                Vertex start = vector.start;
                Vertex end2 = vector.end;
                int pattern = vector.pattern & 0xFF;
                if (newIntensity != intensity && extended) {
                    source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(3)).append(", ").append(GFXVectorList.hex(newIntensity)).append(" ; new intensity\n");
                }
                if (first) {
                    int y = (int)start.y();
                    int x = (int)start.x();
                    do {
                        int useX;
                        int useY;
                        if (y > splitter) {
                            useY = splitter;
                            y -= splitter;
                        } else if (y < -splitter) {
                            useY = -splitter;
                            y += splitter;
                        } else {
                            useY = y;
                            y -= useY;
                        }
                        if (x > splitter) {
                            useX = splitter;
                            x -= splitter;
                        } else if (x < -splitter) {
                            useX = -splitter;
                            x += splitter;
                        } else {
                            useX = x;
                            x -= useX;
                        }
                        if (factor) {
                            if (first) {
                                source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(1)).append(", ").append(GFXVectorList.hex(useY)).append("*").append(blowString).append(", ").append(GFXVectorList.hex(useX)).append("*").append(blowString).append(" ; sync and move to y, x\n");
                            } else {
                                source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex(useY)).append("*").append(blowString).append(", ").append(GFXVectorList.hex(useX)).append("*").append(blowString).append(" ; additional sync move to y, x\n");
                            }
                        } else if (first) {
                            source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(1)).append(", ").append(GFXVectorList.hex(useY)).append(", ").append(GFXVectorList.hex(useX)).append(" ; sync and move to y, x\n");
                        } else {
                            source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(0)).append(", ").append(GFXVectorList.hex(useY)).append(", ").append(GFXVectorList.hex(useX)).append(" ; additional sync move to y, x\n");
                        }
                        first = false;
                    } while (y != 0 || x != 0);
                }
                if (pattern == 0) {
                    source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(0)).append(", ");
                    source.append(this.getRelativeCoordString(vector, factor, blowString));
                    source.append(" ; mode, y, x\n");
                } else {
                    source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(255)).append(", ");
                    source.append(this.getRelativeCoordString(vector, factor, blowString));
                    source.append(" ; draw, y, x\n");
                }
                intensity = newIntensity;
            }
        }
        source.append(" ").append(GFXVectorList.getDB()).append(" ").append(GFXVectorList.hexU(2)).append(" ; endmarker \n");
        return true;
    }

    public ArrayList<Face> buildFacelist() {
        ArrayList<Face> faces = new ArrayList<Face>();
        HashMap<String, Face> faceMap = new HashMap<String, Face>();
        for (GFXVector vector : this.list) {
            Face face;
            Vertex a = vector.start;
            if (a != null) {
                for (String fas : a.face) {
                    face = (Face)faceMap.get(fas = fas.substring(0, fas.indexOf("|")));
                    if (face == null) {
                        face = new Face();
                        face.faceID = UtilityString.Int0(fas);
                        faceMap.put(fas, face);
                        faces.add(face);
                    }
                    face.vertice.remove(a);
                    face.vertice.add(a);
                }
            }
            if ((a = vector.end) == null) continue;
            for (String fas : a.face) {
                face = (Face)faceMap.get(fas = fas.substring(0, fas.indexOf("|")));
                if (face == null) {
                    face = new Face();
                    face.faceID = UtilityString.Int0(fas);
                    faceMap.put(fas, face);
                    faces.add(face);
                }
                face.vertice.remove(a);
                face.vertice.add(a);
            }
        }
        for (Face face : faces) {
            face.order();
        }
        return faces;
    }

    public void removePoints(boolean d3Dots) {
        ArrayList<GFXVector> toRemove = new ArrayList<GFXVector>();
        for (int i = 0; i < this.size(); ++i) {
            boolean test;
            GFXVector v = this.get(i);
            if (d3Dots) {
                test = v.start.x() == v.end.x() && v.start.y() == v.end.y() && v.start.z() == v.end.z();
            } else {
                boolean bl = test = v.start.x() == v.end.x() && v.start.y() == v.end.y();
            }
            if (!test) continue;
            if (v.start_connect != null && v.end_connect != null) {
                v.start_connect.end_connect = v.end_connect;
                v.start_connect.uid_end_connect = v.uid_end_connect;
                v.end_connect.start_connect = v.start_connect;
                v.end_connect.uid_start_connect = v.uid_start_connect;
            } else if (v.start_connect != null) {
                v.start_connect.end_connect = null;
                v.start_connect.uid_end_connect = -1;
                v.start_connect.setRelativ(false);
            } else if (v.end_connect != null) {
                v.end_connect.start_connect = null;
                v.end_connect.uid_start_connect = -1;
                v.end_connect.setRelativ(false);
            }
            toRemove.add(v);
        }
        for (GFXVector v : toRemove) {
            this.remove(v);
        }
    }

    public void removeDoubles() {
        this.doOrder();
        ArrayList toRemove = new ArrayList();
        for (int i = 0; i < this.size(); ++i) {
            GFXVector v1 = this.get(i);
            for (int j = i + 1; j < this.size(); ++j) {
                GFXVector v2 = this.get(j);
                if (!v1.start.equals(v2.start) && !v1.start.equals(v2.end) || !v1.end.equals(v2.start) && !v1.end.equals(v2.end)) continue;
                this.remove(v2);
                j = i;
            }
        }
    }

    public boolean contains(Vertex v) {
        for (int i = 0; i < this.size(); ++i) {
            GFXVector v1 = this.get(i);
            if (!v1.contains(v)) continue;
            return true;
        }
        return false;
    }

    public int getMoveCount() {
        int m = 0;
        for (int i = 0; i < this.size(); ++i) {
            GFXVector v1 = this.get(i);
            if (v1.pattern != 0) continue;
            ++m;
        }
        return m;
    }

    public void changeOrientation(GFXVector v) {
        int old_uid_end;
        GFXVector oldStartVector;
        Vertex oldStart = v.start;
        Vertex oldEnd = v.end;
        v.end = oldStart;
        v.start = oldEnd;
        GFXVector oldEndVector = v.end_connect;
        v.end_connect = oldStartVector = v.start_connect;
        v.start_connect = oldEndVector;
        int old_uid_start = v.uid_start_connect;
        v.uid_start_connect = old_uid_end = v.uid_end_connect;
        v.uid_end_connect = old_uid_start;
    }

    public boolean joinVectors(ArrayList<GFXVector> vlist) {
        if (vlist.size() != 2) {
            return false;
        }
        GFXVector v1 = vlist.get(0);
        GFXVector v2 = vlist.get(1);
        if (v1.end_connect != null && v1.end_connect.uid == v2.uid) {
            this.list.remove(v2);
            if (v1.end.uid == v2.start.uid) {
                GFXVector newEnd = v2.end_connect;
                v1.end = v2.end;
                v1.uid_end_connect = v2.uid_end_connect;
                v1.end_connect = v2.end_connect;
                if (newEnd != null) {
                    if (newEnd.start_connect != null && newEnd.start_connect.uid == v2.uid) {
                        newEnd.start_connect = v2.start_connect;
                        newEnd.start = v1.end;
                        newEnd.uid_start_connect = v2.uid_start_connect;
                    }
                    if (newEnd.end_connect != null && newEnd.end_connect.uid == v2.uid) {
                        newEnd.end_connect = v2.start_connect;
                        newEnd.end = v1.end;
                        newEnd.uid_end_connect = v2.uid_start_connect;
                    }
                }
            } else if (v1.end.uid == v2.end.uid) {
                GFXVector newEnd = v2.start_connect;
                v1.end = v2.start;
                v1.uid_end_connect = v2.uid_start_connect;
                v1.end_connect = v2.start_connect;
                if (newEnd != null) {
                    if (newEnd.start_connect != null && newEnd.start_connect.uid == v2.uid) {
                        newEnd.start_connect = v2.start_connect;
                        newEnd.start = v1.end;
                        newEnd.uid_start_connect = v2.uid_start_connect;
                    }
                    if (newEnd.end_connect != null && newEnd.end_connect.uid == v2.uid) {
                        newEnd.end_connect = v2.start_connect;
                        newEnd.end = v1.end;
                        newEnd.uid_end_connect = v2.uid_start_connect;
                    }
                }
            }
        } else if (v1.start_connect != null && v1.start_connect.uid == v2.uid) {
            this.list.remove(v2);
            if (v1.start.uid == v2.start.uid) {
                GFXVector newEnd = v2.end_connect;
                v1.start = v2.end;
                v1.uid_start_connect = v2.uid_end_connect;
                v1.start_connect = v2.end_connect;
                if (newEnd != null) {
                    if (newEnd.start_connect != null && newEnd.start_connect.uid == v2.uid) {
                        newEnd.start_connect = v2.start_connect;
                        newEnd.start = v1.start;
                        newEnd.uid_start_connect = v2.uid_start_connect;
                    }
                    if (newEnd.end_connect != null && newEnd.end_connect.uid == v2.uid) {
                        newEnd.end_connect = v2.start_connect;
                        newEnd.end = v1.start;
                        newEnd.uid_end_connect = v2.uid_start_connect;
                    }
                }
            } else if (v1.start.uid == v2.end.uid) {
                GFXVector newEnd = v2.start_connect;
                v1.start = v2.start;
                v1.uid_start_connect = v2.uid_start_connect;
                v1.start_connect = v2.start_connect;
                if (newEnd != null) {
                    if (newEnd.start_connect != null && newEnd.start_connect.uid == v2.uid) {
                        newEnd.start_connect = v2.start_connect;
                        newEnd.start = v1.start;
                        newEnd.uid_start_connect = v2.uid_start_connect;
                    }
                    if (newEnd.end_connect != null && newEnd.end_connect.uid == v2.uid) {
                        newEnd.end_connect = v2.start_connect;
                        newEnd.end = v1.start;
                        newEnd.uid_end_connect = v2.uid_start_connect;
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    class Position {
        public ArrayList<GFXVector> vectors = new ArrayList();

        Position() {
        }
    }
}

