/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.Global;
import de.malban.graphics.BaseImageData;
import de.malban.graphics.ImageSequence;
import de.malban.gui.ImageCache;
import de.malban.gui.TimingTriggerer;
import de.malban.gui.TriggerCallback;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private static int counter = 0;
    private ImageSequence mImageSequence = null;
    final int UID = counter++;
    Vector<BufferedImage> imagesUse = new Vector();
    Vector<BufferedImage> imagesOrg = new Vector();
    Vector<Integer> imagesOrgOffsetX = new Vector();
    Vector<Integer> imagesOrgOffsetY = new Vector();
    Vector<Integer> imagesUseOffsetX = new Vector();
    Vector<Integer> imagesUseOffsetY = new Vector();
    boolean useOffset = true;
    boolean useScale = false;
    int scaleW = 0;
    int scaleH = 0;
    boolean doRun = false;
    int index = -1;
    int animDelay = 25;
    boolean anim = true;
    boolean isOpaque = false;
    boolean randomAnim = false;
    TriggerCallback tt;
    boolean started = false;

    public ImageComponent() {
    }

    private ImageComponent(Vector<BufferedImage> i, boolean d) {
        this.imagesOrg = i;
        this.imagesOrgOffsetX = new Vector();
        this.imagesOrgOffsetY = new Vector();
        this.imagesUseOffsetX = new Vector();
        this.imagesUseOffsetY = new Vector();
        for (int j = 0; j < i.size(); ++j) {
            this.imagesUse.addElement(i.elementAt(j));
            this.imagesOrgOffsetX.addElement(0);
            this.imagesOrgOffsetY.addElement(0);
            this.imagesUseOffsetX.addElement(0);
            this.imagesUseOffsetY.addElement(0);
        }
    }

    public void deinit() {
        this.setVisible(false);
        this.started = false;
        this.imagesUse = null;
        this.imagesOrg = null;
        this.imagesOrgOffsetX = null;
        this.imagesOrgOffsetY = null;
        this.imagesUseOffsetX = null;
        this.imagesUseOffsetY = null;
        this.mImageSequence = null;
    }

    private void setImages(Vector<BufferedImage> i) {
        boolean v = this.isVisible();
        if (v) {
            this.setVisible(false);
        }
        this.mImageSequence = null;
        this.imagesOrg = i;
        this.imagesUse = new Vector();
        this.imagesOrgOffsetX = new Vector();
        this.imagesOrgOffsetY = new Vector();
        this.imagesUseOffsetX = new Vector();
        this.imagesUseOffsetY = new Vector();
        for (int j = 0; j < i.size(); ++j) {
            this.imagesUse.addElement(i.elementAt(j));
            this.imagesOrgOffsetX.addElement(0);
            this.imagesOrgOffsetY.addElement(0);
            this.imagesUseOffsetX.addElement(0);
            this.imagesUseOffsetY.addElement(0);
        }
        if (v) {
            this.setVisible(true);
        }
    }

    public void setImage(BufferedImage im) {
        boolean v = this.isVisible();
        if (v) {
            this.setVisible(false);
        }
        this.mImageSequence = null;
        this.imagesOrg = new Vector();
        this.imagesOrg.addElement(im);
        this.imagesUse = new Vector();
        this.imagesOrgOffsetX = new Vector();
        this.imagesOrgOffsetY = new Vector();
        this.imagesUseOffsetX = new Vector();
        this.imagesUseOffsetY = new Vector();
        for (int j = 0; j < this.imagesOrg.size(); ++j) {
            this.imagesUse.addElement(this.imagesOrg.elementAt(j));
            this.imagesOrgOffsetX.addElement(0);
            this.imagesOrgOffsetY.addElement(0);
            this.imagesUseOffsetX.addElement(0);
            this.imagesUseOffsetY.addElement(0);
        }
        if (v) {
            this.setVisible(true);
        }
    }

    public void setSequence(ImageSequence is) {
        if (is == null) {
            this.setImages(new Vector<BufferedImage>());
            return;
        }
        this.setDelay(is.getDelay());
        this.setImages(is.getImageVector());
        this.useOffset = true;
        this.imagesOrgOffsetX = new Vector();
        this.imagesOrgOffsetY = new Vector();
        this.imagesUseOffsetX = new Vector();
        this.imagesUseOffsetY = new Vector();
        for (int i = 0; i < is.getBaseImageData().size(); ++i) {
            BaseImageData data2 = is.getBaseImageData().elementAt(i);
            this.imagesOrgOffsetX.addElement(data2.ox);
            this.imagesOrgOffsetY.addElement(data2.oy);
            this.imagesUseOffsetX.addElement(data2.ox);
            this.imagesUseOffsetY.addElement(data2.oy);
        }
        this.randomAnim = is.mData.mRandomAnimationStart;
        this.mImageSequence = is;
    }

    public ImageSequence getSequence() {
        return this.mImageSequence;
    }

    public void setDelay(int d) {
        boolean iv = this.isVisible();
        this.setVisible(false);
        this.animDelay = d;
        if (this.imagesUse.size() <= 1) {
            this.animDelay = -1;
        }
        if (iv) {
            this.setVisible(true);
        }
    }

    public void setScaled(boolean scaled, int h, int w) {
        BufferedImage image;
        int i;
        this.useScale = scaled;
        this.scaleW = w;
        this.scaleH = h;
        boolean v = this.isVisible();
        if (v) {
            this.setVisible(false);
        }
        this.imagesUse = new Vector();
        int maxW = 0;
        int maxH = 0;
        this.imagesUseOffsetX.clear();
        this.imagesUseOffsetY.clear();
        for (i = 0; i < this.imagesOrg.size(); ++i) {
            image = this.imagesOrg.elementAt(i);
            if (image == null) continue;
            if (maxW == 0) {
                maxW = image.getWidth(null);
            }
            if (maxH == 0) {
                maxH = image.getHeight(null);
            }
            if (this.imagesOrgOffsetX.size() <= i) continue;
            if (maxW < image.getWidth(null) + this.imagesOrgOffsetX.elementAt(i)) {
                maxW = image.getWidth(null) + this.imagesOrgOffsetX.elementAt(i);
            }
            if (maxH >= image.getHeight(null) + this.imagesOrgOffsetY.elementAt(i)) continue;
            maxH = image.getHeight(null) + this.imagesOrgOffsetY.elementAt(i);
        }
        for (i = 0; i < this.imagesOrg.size(); ++i) {
            image = this.imagesOrg.elementAt(i);
            if (image == null) continue;
            int xo = 0;
            int yo = 0;
            if (this.imagesOrgOffsetX.size() > i) {
                xo = this.imagesOrgOffsetX.elementAt(i);
                yo = this.imagesOrgOffsetY.elementAt(i);
            }
            if (scaled) {
                BufferedImage scaledImage;
                if (this.useOffset) {
                    double scaleX = (double)w / (double)maxW;
                    double scaleY = (double)h / (double)maxH;
                    scaledImage = ImageCache.getImageCache().getDerivatScale(image, (int)((double)image.getWidth(null) * scaleX), (int)((double)image.getHeight(null) * scaleY));
                    if (this.imagesOrgOffsetX.size() > i) {
                        int scaledOffsetY = (int)(scaleY * (double)yo);
                        int scaledOffsetX = (int)(scaleX * (double)xo);
                        this.imagesUseOffsetX.addElement(scaledOffsetX);
                        this.imagesUseOffsetY.addElement(scaledOffsetY);
                    }
                } else {
                    scaledImage = ImageCache.getImageCache().getDerivatScale(image, w, h);
                    this.imagesUseOffsetX.addElement(0);
                    this.imagesUseOffsetY.addElement(0);
                }
                this.imagesUse.addElement(scaledImage);
                continue;
            }
            this.imagesUseOffsetX.addElement(xo);
            this.imagesUseOffsetY.addElement(yo);
            this.imagesUse.addElement(image);
        }
        this.setSize(new Dimension(w, h));
        this.setPreferredSize(new Dimension(w, h));
        if (v) {
            this.setVisible(true);
        }
    }

    @Override
    public void setVisible(boolean b) {
        boolean oldVisibility = this.isVisible();
        super.setVisible(b);
        if (oldVisibility == b) {
            return;
        }
        if (this.imagesUse.isEmpty()) {
            this.index = -1;
            return;
        }
        if (this.imagesUse.size() == 1) {
            this.index = 0;
            return;
        }
        if (this.animDelay == -1) {
            this.index = 0;
            return;
        }
        if (this.randomAnim) {
            this.index = Global.getRand().nextInt(this.imagesUse.size());
        }
        final TimingTriggerer timer = TimingTriggerer.getTimer();
        if (b) {
            this.started = true;
            timer.setResolution(10);
            if (this.tt != null) {
                timer.removeTrigger(this.tt);
                this.tt = null;
            }
            this.tt = new TriggerCallback(){

                @Override
                public void doIt(int state, Object o) {
                    if (!ImageComponent.this.isVisible()) {
                        return;
                    }
                    if (ImageComponent.this.animDelay != -1) {
                        ImageComponent.this.index = !ImageComponent.this.imagesUse.isEmpty() ? (ImageComponent.this.index + 1) % ImageComponent.this.imagesUse.size() : -1;
                        if (ImageComponent.this.started) {
                            timer.addTrigger(ImageComponent.this.tt, ImageComponent.this.animDelay, 0, null);
                        }
                    }
                    ImageComponent.this.repaint();
                }
            };
            timer.addTrigger(this.tt, this.animDelay, 0, null);
        } else {
            timer.removeTrigger(this.tt);
            this.tt = null;
            this.started = false;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int clearWidth = this.getWidth();
        int clearHeight = this.getHeight();
        if (!this.isOpaque) {
            g.clearRect(0, 0, clearWidth, clearHeight);
        }
        if (this.index == -1) {
            return;
        }
        if (this.imagesUse == null || this.imagesUse.isEmpty()) {
            return;
        }
        if (this.index > this.imagesUse.size() - 1) {
            return;
        }
        if (!this.useOffset) {
            g.drawImage(this.imagesUse.elementAt(this.index), 0, 0, null);
        } else {
            g.drawImage(this.imagesUse.elementAt(this.index), this.imagesUseOffsetX.elementAt(this.index), this.imagesUseOffsetY.elementAt(this.index), null);
        }
    }

    public void setUseOffsets(boolean b) {
        this.useOffset = b;
        this.setScaled(this.useScale, this.scaleH, this.scaleW);
    }
}

