/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.graphics.BaseImageData;
import de.malban.graphics.ImageSequenceData;
import de.malban.graphics.ImageSequenceDataPool;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ImageSequence {
    protected ImageSequenceData mData = new ImageSequenceData();
    Vector<BaseImageData> mBIData = null;

    public ImageSequence() {
    }

    public int getDelay() {
        return this.mData.mDelay;
    }

    public ImageSequence(ImageSequenceData data2) {
        if (data2 == null) {
            data2 = new ImageSequenceData();
        }
        this.mData = data2;
    }

    public ImageSequence(ImageSequenceData data2, Vector<BaseImageData> mbid) {
        if (data2 == null) {
            data2 = new ImageSequenceData();
        }
        this.mData = data2;
        this.mBIData = mbid;
    }

    public ImageSequence(Vector<BaseImageData> mbid) {
        this.mData = new ImageSequenceData();
        BaseImageData.fromBase(this.mData, mbid);
        this.mBIData = mbid;
    }

    public static ImageSequence createImageSequence(String filename, String _class, String name) {
        return ImageSequence.createImageSequence(filename, name);
    }

    public static ImageSequence createImageSequence(String filename, String name) {
        ImageSequenceDataPool dataPool = new ImageSequenceDataPool(filename);
        ImageSequenceData data2 = dataPool.getHashMap().get(name);
        return new ImageSequence(data2);
    }

    public static Vector<String> getClasses(String filename) {
        ImageSequenceDataPool dataPool = new ImageSequenceDataPool(filename);
        HashMap<String, String> map = dataPool.getKlassenHashMap();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        Vector<String> classes = new Vector<String>();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String _class = entry.getValue();
            classes.add(_class);
        }
        Collections.sort(classes, new Comparator<String>(){

            @Override
            public final int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        return classes;
    }

    public static Vector<String> getNames(String filename, String _class) {
        ImageSequenceDataPool dataPool = new ImageSequenceDataPool(filename);
        HashMap<String, ImageSequenceData> map = dataPool.getMapForKlasse(_class);
        Set<Map.Entry<String, ImageSequenceData>> entries = map.entrySet();
        Iterator<Map.Entry<String, ImageSequenceData>> it = entries.iterator();
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Map.Entry<String, ImageSequenceData> entry = it.next();
            ImageSequenceData value = entry.getValue();
            names.add(value.mName);
        }
        Collections.sort(names, new Comparator<String>(){

            @Override
            public final int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        return names;
    }

    public static Vector<String> getAllNames(String filename) {
        ImageSequenceDataPool dataPool = new ImageSequenceDataPool(filename);
        HashMap<String, ImageSequenceData> map = dataPool.getHashMap();
        Set<Map.Entry<String, ImageSequenceData>> entries = map.entrySet();
        Iterator<Map.Entry<String, ImageSequenceData>> it = entries.iterator();
        Vector<String> names = new Vector<String>();
        while (it.hasNext()) {
            Map.Entry<String, ImageSequenceData> entry = it.next();
            ImageSequenceData value = entry.getValue();
            names.add(value.mName);
        }
        Collections.sort(names, new Comparator<String>(){

            @Override
            public final int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        return names;
    }

    public Vector<BaseImageData> getBaseImageData() {
        if (this.mBIData == null) {
            this.mBIData = BaseImageData.toBase(this.mData);
        }
        return this.mBIData;
    }

    public Vector<BufferedImage> getImageVector() {
        Vector<BaseImageData> bdata = this.getBaseImageData();
        Vector<BufferedImage> images = new Vector<BufferedImage>();
        for (int i = 0; i < bdata.size(); ++i) {
            BaseImageData baseImageData = bdata.elementAt(i);
            images.addElement(baseImageData.image);
        }
        return images;
    }

    public BufferedImage getImageAt(int i) {
        return this.getBaseImageData().elementAt((int)i).image;
    }

    public int getImageCount() {
        return this.getBaseImageData().size();
    }
}

