/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.Global;
import de.malban.graphics.ImageSequenceDataXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ImageSequenceData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mImageSourceFile = new Vector();
    protected Vector<Integer> mXPos = new Vector();
    protected Vector<Integer> mYPos = new Vector();
    protected Vector<Integer> mWidth = new Vector();
    protected Vector<Integer> mHeight = new Vector();
    protected int mDelay = 0;
    protected Vector<Integer> mPosition = new Vector();
    protected String mOriginNotice = "";
    protected Vector<Integer> mCropXPos = new Vector();
    protected Vector<Integer> mCropYPos = new Vector();
    protected Vector<Integer> mCropWidth = new Vector();
    protected Vector<Integer> mCropHeight = new Vector();
    protected Vector<Integer> moptimzeCropOffsetX = new Vector();
    protected Vector<Integer> moptimzeCropOffsetY = new Vector();
    protected boolean mRandomAnimationStart = false;
    private static ImageSequenceDataXMLHandler XMLHANDLER = new ImageSequenceDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public String getCClass() {
        return this.mClass;
    }

    public int getMaxHeight() {
        int h = 0;
        for (int i = 0; i < this.mHeight.size(); ++i) {
            int s = this.mHeight.elementAt(i);
            if (this.moptimzeCropOffsetY.size() > i) {
                s += this.moptimzeCropOffsetY.elementAt(i).intValue();
            }
            if (s <= h) continue;
            h = s;
        }
        return h;
    }

    public int getMaxWidth() {
        int w = 0;
        for (int i = 0; i < this.mWidth.size(); ++i) {
            int s = this.mWidth.elementAt(i);
            if (this.moptimzeCropOffsetX.size() > i) {
                s += this.moptimzeCropOffsetX.elementAt(i).intValue();
            }
            if (s <= w) continue;
            w = s;
        }
        return w;
    }

    public int size() {
        return this.mHeight.size();
    }

    public Vector<String> getImageSourceFile() {
        return this.mImageSourceFile;
    }

    public void setImageSourceFile(Vector<String> ImageSourceFile) {
        this.mImageSourceFile = ImageSourceFile;
    }

    public Vector<Integer> getXPos() {
        return this.mXPos;
    }

    public void setXPos(Vector<Integer> XPos) {
        this.mXPos = XPos;
    }

    public Vector<Integer> getYPos() {
        return this.mYPos;
    }

    public void setYPos(Vector<Integer> YPos) {
        this.mYPos = YPos;
    }

    public Vector<Integer> getWidth() {
        return this.mWidth;
    }

    public void setWidth(Vector<Integer> Width) {
        this.mWidth = Width;
    }

    public Vector<Integer> getHeight() {
        return this.mHeight;
    }

    public void setHeight(Vector<Integer> Height) {
        this.mHeight = Height;
    }

    public int getDelay() {
        return this.mDelay;
    }

    public void setDelay(int Delay) {
        this.mDelay = Delay;
    }

    public Vector<Integer> getPosition() {
        return this.mPosition;
    }

    public void setPosition(Vector<Integer> Position2) {
        this.mPosition = Position2;
    }

    public String getOriginNotice() {
        return this.mOriginNotice;
    }

    public void setOriginNotice(String OriginNotice) {
        this.mOriginNotice = OriginNotice;
    }

    public Vector<Integer> getCropXPos() {
        return this.mCropXPos;
    }

    public void setCropXPos(Vector<Integer> CropXPos) {
        this.mCropXPos = CropXPos;
    }

    public Vector<Integer> getCropYPos() {
        return this.mCropYPos;
    }

    public void setCropYPos(Vector<Integer> CropYPos) {
        this.mCropYPos = CropYPos;
    }

    public Vector<Integer> getCropWidth() {
        return this.mCropWidth;
    }

    public void setCropWidth(Vector<Integer> CropWidth) {
        this.mCropWidth = CropWidth;
    }

    public Vector<Integer> getCropHeight() {
        return this.mCropHeight;
    }

    public void setCropHeight(Vector<Integer> CropHeight) {
        this.mCropHeight = CropHeight;
    }

    public Vector<Integer> getoptimzeCropOffsetX() {
        return this.moptimzeCropOffsetX;
    }

    public void setoptimzeCropOffsetX(Vector<Integer> optimzeCropOffsetX) {
        this.moptimzeCropOffsetX = optimzeCropOffsetX;
    }

    public Vector<Integer> getoptimzeCropOffsetY() {
        return this.moptimzeCropOffsetY;
    }

    public void setoptimzeCropOffsetY(Vector<Integer> optimzeCropOffsetY) {
        this.moptimzeCropOffsetY = optimzeCropOffsetY;
    }

    public boolean getRandomAnimationStart() {
        return this.mRandomAnimationStart;
    }

    public void setRandomAnimationStart(boolean RandomAnimationStart) {
        this.mRandomAnimationStart = RandomAnimationStart;
    }

    private String exportXML() {
        int i;
        String s = new String();
        s = s + "\t<ImageSequenceData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<IMAGESOURCEFILEs>\n";
        for (i = 0; i < this.mImageSourceFile.size(); ++i) {
            s = s + "\t\t\t<IMAGESOURCEFILE>" + UtilityString.toXML(this.mImageSourceFile.elementAt(i)) + "</IMAGESOURCEFILE>\n";
        }
        s = s + "\t\t</IMAGESOURCEFILEs>\n";
        s = s + "\t\t<XPOSs>\n";
        for (i = 0; i < this.mXPos.size(); ++i) {
            s = s + "\t\t\t<XPOS>" + this.mXPos.elementAt(i) + "</XPOS>\n";
        }
        s = s + "\t\t</XPOSs>\n";
        s = s + "\t\t<YPOSs>\n";
        for (i = 0; i < this.mYPos.size(); ++i) {
            s = s + "\t\t\t<YPOS>" + this.mYPos.elementAt(i) + "</YPOS>\n";
        }
        s = s + "\t\t</YPOSs>\n";
        s = s + "\t\t<WIDTHs>\n";
        for (i = 0; i < this.mWidth.size(); ++i) {
            s = s + "\t\t\t<WIDTH>" + this.mWidth.elementAt(i) + "</WIDTH>\n";
        }
        s = s + "\t\t</WIDTHs>\n";
        s = s + "\t\t<HEIGHTs>\n";
        for (i = 0; i < this.mHeight.size(); ++i) {
            s = s + "\t\t\t<HEIGHT>" + this.mHeight.elementAt(i) + "</HEIGHT>\n";
        }
        s = s + "\t\t</HEIGHTs>\n";
        s = s + "\t\t<DELAY>" + this.mDelay + "</DELAY>\n";
        s = s + "\t\t<POSITIONs>\n";
        for (i = 0; i < this.mPosition.size(); ++i) {
            s = s + "\t\t\t<POSITION>" + this.mPosition.elementAt(i) + "</POSITION>\n";
        }
        s = s + "\t\t</POSITIONs>\n";
        s = s + "\t\t<OriginNotice>" + UtilityString.toXML(this.mOriginNotice) + "</OriginNotice>\n";
        s = s + "\t\t<CropXPoss>\n";
        for (i = 0; i < this.mCropXPos.size(); ++i) {
            s = s + "\t\t\t<CropXPos>" + this.mCropXPos.elementAt(i) + "</CropXPos>\n";
        }
        s = s + "\t\t</CropXPoss>\n";
        s = s + "\t\t<CropYPoss>\n";
        for (i = 0; i < this.mCropYPos.size(); ++i) {
            s = s + "\t\t\t<CropYPos>" + this.mCropYPos.elementAt(i) + "</CropYPos>\n";
        }
        s = s + "\t\t</CropYPoss>\n";
        s = s + "\t\t<CropWidths>\n";
        for (i = 0; i < this.mCropWidth.size(); ++i) {
            s = s + "\t\t\t<CropWidth>" + this.mCropWidth.elementAt(i) + "</CropWidth>\n";
        }
        s = s + "\t\t</CropWidths>\n";
        s = s + "\t\t<CropHeights>\n";
        for (i = 0; i < this.mCropHeight.size(); ++i) {
            s = s + "\t\t\t<CropHeight>" + this.mCropHeight.elementAt(i) + "</CropHeight>\n";
        }
        s = s + "\t\t</CropHeights>\n";
        s = s + "\t\t<optimzeCropOffsetXs>\n";
        for (i = 0; i < this.moptimzeCropOffsetX.size(); ++i) {
            s = s + "\t\t\t<optimzeCropOffsetX>" + this.moptimzeCropOffsetX.elementAt(i) + "</optimzeCropOffsetX>\n";
        }
        s = s + "\t\t</optimzeCropOffsetXs>\n";
        s = s + "\t\t<optimzeCropOffsetYs>\n";
        for (i = 0; i < this.moptimzeCropOffsetY.size(); ++i) {
            s = s + "\t\t\t<optimzeCropOffsetY>" + this.moptimzeCropOffsetY.elementAt(i) + "</optimzeCropOffsetY>\n";
        }
        s = s + "\t\t</optimzeCropOffsetYs>\n";
        s = s + "\t\t<RandomAnimationStart>" + this.mRandomAnimationStart + "</RandomAnimationStart>\n";
        s = s + "\t</ImageSequenceData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static ImageSequenceDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ImageSequenceData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllImageSequenceData>\n");
            for (ImageSequenceData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllImageSequenceData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, ImageSequenceData> getHashMapFromXML(String filename) {
        HashMap<String, ImageSequenceData> filters = new HashMap<String, ImageSequenceData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ImageSequenceDataXMLHandler h = ImageSequenceData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ImageSequenceData Load Error...", 1);
        }
        return filters;
    }
}

