/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.Global;
import de.malban.graphics.ImageSequenceData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class ImageSequenceDataPool {
    public static final String DEFAULT_XML_NAME = new String("ImageSequenceData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, ImageSequenceData> mImageSequenceData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public String getFilename() {
        return this.mFileName;
    }

    public ImageSequenceDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public ImageSequenceDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error ImageSequenceData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mImageSequenceData = ImageSequenceData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        ImageSequenceData.saveCollectionAsXML(this.mFileName, this.mImageSequenceData.values());
        this.buildKlassenMap();
    }

    public void remove(ImageSequenceData st) {
        this.mImageSequenceData.remove(st.mName);
    }

    public void put(ImageSequenceData st) {
        this.mImageSequenceData.remove(st.mName);
        this.mImageSequenceData.put(st.mName, st);
    }

    public void putAsNew(ImageSequenceData st) {
        this.mImageSequenceData.put(st.mName, st);
    }

    public ImageSequenceData get(String key) {
        return this.mImageSequenceData.get(key);
    }

    public HashMap<String, ImageSequenceData> getHashMap() {
        return this.mImageSequenceData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, ImageSequenceData>> entries = this.mImageSequenceData.entrySet();
        for (Map.Entry<String, ImageSequenceData> entry : entries) {
            ImageSequenceData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, ImageSequenceData> getMapForKlasse(String klasse) {
        HashMap<String, ImageSequenceData> ret = new HashMap<String, ImageSequenceData>();
        Set<Map.Entry<String, ImageSequenceData>> entries = this.mImageSequenceData.entrySet();
        for (Map.Entry<String, ImageSequenceData> entry : entries) {
            ImageSequenceData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

