/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.graphics.GFXVector;
import de.malban.graphics.Vertex;

public class Matrix4x4 {
    double[][] m = new double[4][4];

    public Matrix4x4() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.m[x][y] = x == y ? 1.0 : 0.0;
            }
        }
    }

    public static Matrix4x4 getTranslocation(double xmove, double ymove, double zmove) {
        Matrix4x4 ma = new Matrix4x4();
        ma.m[3][0] = xmove;
        ma.m[3][1] = ymove;
        ma.m[3][2] = zmove;
        return ma;
    }

    public static Matrix4x4 getScaling(double xscale, double yscale, double zscale) {
        Matrix4x4 ma = new Matrix4x4();
        ma.m[0][0] = xscale;
        ma.m[1][1] = yscale;
        ma.m[2][2] = zscale;
        return ma;
    }

    public static Matrix4x4 getRotationX(double xangle) {
        Matrix4x4 ma = new Matrix4x4();
        ma.m[1][1] = Math.cos(xangle);
        ma.m[2][1] = -Math.sin(xangle);
        ma.m[1][2] = Math.sin(xangle);
        ma.m[2][2] = Math.cos(xangle);
        return ma;
    }

    public static Matrix4x4 getRotationY(double yangle) {
        Matrix4x4 ma = new Matrix4x4();
        ma.m[0][0] = Math.cos(yangle);
        ma.m[2][0] = Math.sin(yangle);
        ma.m[0][2] = -Math.sin(yangle);
        ma.m[2][2] = Math.cos(yangle);
        return ma;
    }

    public static Matrix4x4 getRotationZ(double zangle) {
        Matrix4x4 ma = new Matrix4x4();
        ma.m[0][0] = Math.cos(zangle);
        ma.m[1][0] = -Math.sin(zangle);
        ma.m[0][1] = Math.sin(zangle);
        ma.m[1][1] = Math.cos(zangle);
        return ma;
    }

    public static Matrix4x4 getIdentity(double x, double y, double z) {
        Matrix4x4 ma = new Matrix4x4();
        return ma;
    }

    public void transpose() {
        double[][] t = new double[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                t[x][y] = this.m[y][x];
            }
        }
        this.m = t;
    }

    public void setValue(int x, int y, double value) {
        this.m[x][y] = value;
    }

    public Vertex multiply(Vertex v) {
        Vertex r = new Vertex(v);
        r.x(this.m[0][0] * v.x() + this.m[1][0] * v.y() + this.m[2][0] * v.z() + this.m[3][0] * v.w());
        r.y(this.m[0][1] * v.x() + this.m[1][1] * v.y() + this.m[2][1] * v.z() + this.m[3][1] * v.w());
        r.z(this.m[0][2] * v.x() + this.m[1][2] * v.y() + this.m[2][2] * v.z() + this.m[3][2] * v.w());
        r.w(this.m[0][3] * v.x() + this.m[1][3] * v.y() + this.m[2][3] * v.z() + this.m[3][3] * v.w());
        return r;
    }

    public Vertex multiplyVariant(Vertex v) {
        double x = this.m[0][0] * v.x() + this.m[1][0] * v.y() + this.m[2][0] * v.z() + this.m[3][0] * v.w();
        double y = this.m[0][1] * v.x() + this.m[1][1] * v.y() + this.m[2][1] * v.z() + this.m[3][1] * v.w();
        double z = this.m[0][2] * v.x() + this.m[1][2] * v.y() + this.m[2][2] * v.z() + this.m[3][2] * v.w();
        double w = this.m[0][3] * v.x() + this.m[1][3] * v.y() + this.m[2][3] * v.z() + this.m[3][3] * v.w();
        v.x(x);
        v.y(y);
        v.z(z);
        v.w(w);
        return v;
    }

    public GFXVector multiply(GFXVector v) {
        GFXVector n = v.clone();
        n.start = this.multiply(v.start);
        n.end = this.multiply(v.end);
        return n;
    }

    public Matrix4x4 add(Matrix4x4 o) {
        Matrix4x4 n = new Matrix4x4();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                n.m[x][y] = this.m[x][y] + o.m[x][y];
            }
        }
        return n;
    }

    public Matrix4x4 sub(Matrix4x4 o) {
        Matrix4x4 n = new Matrix4x4();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                n.m[x][y] = this.m[x][y] - o.m[x][y];
            }
        }
        return n;
    }

    public Matrix4x4 mul(Matrix4x4 o) {
        Matrix4x4 n = new Matrix4x4();
        for (int x = 0; x < 4; ++x) {
            Vertex v1 = o.columnToVertex(x);
            Vertex r = this.multiply(v1);
            n.vertexIntoColumn(r, 0);
        }
        return n;
    }

    private void vertexIntoColumn(Vertex v, int c) {
        this.m[c][0] = v.coord()[0];
        this.m[c][1] = v.coord()[1];
        this.m[c][2] = v.coord()[2];
        this.m[c][3] = v.coord()[3];
    }

    private Vertex columnToVertex(int c) {
        Vertex n = new Vertex();
        n.x(this.m[c][0]);
        n.y(this.m[c][1]);
        n.z(this.m[c][2]);
        n.w(this.m[c][3]);
        return n;
    }
}

