/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Matrix4x4;
import de.malban.graphics.SingleVectorPanel;
import de.malban.graphics.VectorColors;
import de.malban.graphics.Vertex;
import de.malban.gui.Scaler;
import de.malban.gui.TimingTriggerer;
import de.malban.gui.TriggerCallback;
import de.malban.util.UtilityImage;
import de.malban.vide.veccy.StoryboardElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.SwingUtilities;

public class Single3dDisplayPanel
extends SingleVectorPanel {
    int inSetting = 0;
    boolean doRun = false;
    int index = -1;
    int animDelay = 25;
    boolean anim = true;
    boolean isOpaque = false;
    GFXVector xAxis = new GFXVector();
    GFXVector yAxis = new GFXVector();
    GFXVector zAxis = new GFXVector();
    GFXVectorAnimation animation = new GFXVectorAnimation();
    boolean axisShown = false;
    boolean repaint = true;
    TriggerCallback tt;
    boolean started = false;
    int axisXAngle = 38;
    int axisYAngle = 49;
    int axisZAngle = 31;
    int angleX = 0;
    int angleY = 0;
    int angleZ = 0;
    int transX = 0;
    int transY = 0;
    int transZ = 0;
    double scale = 1.0;
    GFXVectorList lastDisplayList = new GFXVectorList();
    boolean singleRepaint = false;
    boolean oldSingleRepaint = false;
    Color vectorBackground = VectorColors.VECCI_BACKGROUND_COLOR;
    BufferedImage[] paintBufferImage = new BufferedImage[2];
    int bufferUsed = -1;
    boolean noRepaint = false;
    boolean dumpMode = false;

    public void setRepaint(boolean rp) {
        this.repaint = rp;
    }

    public GFXVectorAnimation getAnimation() {
        return this.animation;
    }

    public void setAnimation(GFXVectorAnimation a) {
        this.animation = a;
        this.index = 0;
        if (this.animation.size() > 0) {
            this.setForegroundVectorList(this.animation.get(0));
        } else {
            this.setForegroundVectorList(new GFXVectorList());
        }
    }

    public void setAxisShown(boolean s) {
        this.axisShown = s;
        this.sharedRepaint();
    }

    public Single3dDisplayPanel() {
        this.initComponents();
        this.xAxis.start.x(-2000.0);
        this.xAxis.end.x(2000.0);
        this.yAxis.start.y(-2000.0);
        this.yAxis.end.y(2000.0);
        this.zAxis.start.z(-2000.0);
        this.zAxis.end.z(2000.0);
    }

    @Override
    public void deinit() {
        this.setVisible(false);
    }

    public void setDelay(int d) {
        boolean oldRepaint = this.noRepaint;
        this.noRepaint = true;
        boolean iv = this.isVisible();
        this.setVisible(false);
        this.animDelay = d;
        if (iv) {
            this.setVisible(true);
        }
        this.noRepaint = oldRepaint;
        this.repaint();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 235, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 241, Short.MAX_VALUE));
    }

    @Override
    public synchronized void setVisible(boolean b) {
        boolean oldVisibility = this.isVisible();
        super.setVisible(b);
        if (oldVisibility == b) {
            return;
        }
        if (this.animDelay == -1) {
            this.index = 0;
            return;
        }
        final TimingTriggerer timer = TimingTriggerer.getTimer();
        if (b) {
            this.started = true;
            timer.setResolution(10);
            if (this.tt != null) {
                timer.removeTrigger(this.tt);
                this.tt = null;
            }
            this.tt = new TriggerCallback(){

                @Override
                public synchronized void doIt(int state, Object o) {
                    if (!Single3dDisplayPanel.this.isVisible()) {
                        return;
                    }
                    if (Single3dDisplayPanel.this.animDelay != -1) {
                        if (!Single3dDisplayPanel.this.animation.list.isEmpty()) {
                            Single3dDisplayPanel.this.index = (Single3dDisplayPanel.this.index + 1) % Single3dDisplayPanel.this.animation.list.size();
                            Single3dDisplayPanel.this.setForegroundVectorList(Single3dDisplayPanel.this.animation.get(Single3dDisplayPanel.this.index));
                        } else {
                            Single3dDisplayPanel.this.index = -1;
                        }
                        if (Single3dDisplayPanel.this.started) {
                            timer.addTrigger(Single3dDisplayPanel.this.tt, Single3dDisplayPanel.this.animDelay, 0, null);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Single3dDisplayPanel.this.repaint();
                        }
                    });
                }
            };
            timer.addTrigger(this.tt, this.animDelay, 0, null);
        } else {
            timer.removeTrigger(this.tt);
            this.tt = null;
            this.started = false;
        }
    }

    public void setAxisAngleX(int value) {
        this.axisXAngle = value;
        this.sharedRepaint();
    }

    public void setAxisAngleY(int value) {
        this.axisYAngle = value;
        this.sharedRepaint();
    }

    public void setAxisAngleZ(int value) {
        this.axisZAngle = value;
        this.sharedRepaint();
    }

    public void setAngleX(int value) {
        this.angleX = value;
        this.sharedRepaint();
    }

    public void setAngleY(int value) {
        this.angleY = value;
        this.sharedRepaint();
    }

    public void setAngleZ(int value) {
        this.angleZ = value;
        this.sharedRepaint();
    }

    public void setTranslocationX(int x) {
        this.transX = x;
        this.sharedRepaint();
    }

    public void setTranslocationY(int y) {
        this.transY = y;
        this.sharedRepaint();
    }

    public void setTranslocationZ(int z) {
        this.transZ = z;
        this.sharedRepaint();
    }

    @Override
    public void setScale(double s) {
        this.scale = s;
        this.updateAndRepaint();
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public GFXVectorList getDisplayVectorList() {
        return this.lastDisplayList;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.bufferUsed == -1) {
            return;
        }
        g.drawImage(this.paintBufferImage[this.bufferUsed], 0, 0, null);
    }

    @Override
    public void sharedRepaint() {
        if (this.singleRepaint) {
            return;
        }
        this.updateAndRepaint();
        super.sharedRepaint();
    }

    public void setSingleRepaint(boolean b) {
        this.singleRepaint = b;
    }

    public void disableSingleRepaint() {
        this.oldSingleRepaint = this.singleRepaint;
        this.singleRepaint = false;
    }

    public void enableSingleRepaint() {
        this.singleRepaint = this.oldSingleRepaint;
    }

    protected void setVectorBackground(Color b) {
        this.vectorBackground = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void updateAndRepaint() {
        if (this.noRepaint) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0) {
            return;
        }
        if (height == 0) {
            return;
        }
        int nextBuffer = (this.bufferUsed + 1) % 2;
        this.paintBufferImage[nextBuffer] = UtilityImage.getNewImage(width, height);
        if (this.paintBufferImage[nextBuffer] == null) {
            return;
        }
        if (!this.repaint) {
            this.bufferUsed = nextBuffer;
            return;
        }
        Graphics2D g = this.paintBufferImage[nextBuffer].createGraphics();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            if (this instanceof StoryboardElement) {
                g.setColor(this.vectorBackground);
            } else {
                g.setColor(VectorColors.VECCI_BACKGROUND_COLOR);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!this.repaint) {
                return;
            }
            this.x0Offset = this.getWidth() / 2;
            this.y0Offset = this.getHeight() / 2;
            if (this.vars.drawByteFrame) {
                g.setColor(VectorColors.VECCI_FRAME_COLOR);
                int x0 = -128;
                int x1 = 127;
                int y0 = -128;
                int y1 = 127;
                x0 = Scaler.scaleDoubleToInt(x0, this.scale);
                y0 = -Scaler.scaleDoubleToInt(y0, this.scale);
                x1 = Scaler.scaleDoubleToInt(x1, this.scale);
                y1 = -Scaler.scaleDoubleToInt(y1, this.scale);
                x0 = this.x0Offset + x0;
                y0 = this.y0Offset + y0;
                x1 = this.x0Offset + x1;
                y1 = this.y0Offset + y1;
                g.drawLine(x0, y0, x1, y0);
                g.drawLine(x0, y0, x0, y1);
                g.drawLine(x1, y0, x1, y1);
                g.drawLine(x0, y1, x1, y1);
            }
            Color c = g.getColor();
            Matrix4x4 trans = Matrix4x4.getTranslocation(this.transX, this.transY, this.transZ);
            Matrix4x4 rotx = Matrix4x4.getRotationX(Math.toRadians(this.angleX));
            Matrix4x4 roty = Matrix4x4.getRotationY(Math.toRadians(this.angleY));
            Matrix4x4 rotz = Matrix4x4.getRotationZ(Math.toRadians(this.angleZ));
            Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
            Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
            Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
            if (this.axisShown) {
                GFXVector ax = rotax.multiply(this.xAxis);
                ax = rotay.multiply(ax);
                ax = rotaz.multiply(ax);
                GFXVector ay = rotax.multiply(this.yAxis);
                ay = rotay.multiply(ay);
                ay = rotaz.multiply(ay);
                GFXVector az = rotax.multiply(this.zAxis);
                az = rotay.multiply(az);
                az = rotaz.multiply(az);
                g.setColor(VectorColors.VECCI_X_AXIS_COLOR);
                g.drawLine((int)ax.start.x() + this.x0Offset, (int)(-ax.start.y()) + this.y0Offset, (int)ax.end.x() + this.x0Offset, (int)(-ax.end.y()) + this.y0Offset);
                g.setColor(VectorColors.VECCI_Y_AXIS_COLOR);
                g.drawLine((int)ay.start.x() + this.x0Offset, (int)(-ay.start.y()) + this.y0Offset, (int)ay.end.x() + this.x0Offset, (int)(-ay.end.y()) + this.y0Offset);
                g.setColor(VectorColors.VECCI_Z_AXIS_COLOR);
                g.drawLine((int)az.start.x() + this.x0Offset, (int)(-az.start.y()) + this.y0Offset, (int)az.end.x() + this.x0Offset, (int)(-az.end.y()) + this.y0Offset);
            }
            this.lastDisplayList = this.vars.foregroundVectors.clone();
            int count = 0;
            HashMap<Vertex, Vertex> noDouble = new HashMap<Vertex, Vertex>();
            for (GFXVector v : this.lastDisplayList.list) {
                Vertex p1 = v.start;
                Vertex p2 = v.end;
                if (noDouble.get(p1) == null) {
                    noDouble.put(p1, p1);
                    p1 = trans.multiply(p1);
                    p1 = rotx.multiply(p1);
                    p1 = roty.multiply(p1);
                    p1 = rotz.multiply(p1);
                    p1 = rotax.multiply(p1);
                    p1 = rotay.multiply(p1);
                    p1 = rotaz.multiply(p1);
                    p1.coords[0] = Math.round(p1.coords[0]);
                    p1.coords[1] = Math.round(p1.coords[1]);
                    p1.coords[2] = Math.round(p1.coords[2]);
                    v.start.set(p1);
                }
                if (noDouble.get(p2) == null) {
                    noDouble.put(p2, p2);
                    p2 = trans.multiply(p2);
                    p2 = rotx.multiply(p2);
                    p2 = roty.multiply(p2);
                    p2 = rotz.multiply(p2);
                    p2 = rotax.multiply(p2);
                    p2 = rotay.multiply(p2);
                    p2 = rotaz.multiply(p2);
                    p2.coords[0] = Math.round(p2.coords[0]);
                    p2.coords[1] = Math.round(p2.coords[1]);
                    p2.coords[2] = Math.round(p2.coords[2]);
                    v.end.set(p2);
                }
                double x0 = Scaler.scaleDoubleToInt(p1.x(), this.scale);
                double y0 = -Scaler.scaleDoubleToInt(p1.y(), this.scale);
                double x1 = Scaler.scaleDoubleToInt(p2.x(), this.scale);
                double y1 = -Scaler.scaleDoubleToInt(p2.y(), this.scale);
                double x0v = (double)this.x0Offset + x0;
                double y0v = (double)this.y0Offset + y0;
                double x1v = (double)this.x0Offset + x1;
                double y1v = (double)this.y0Offset + y1;
                if (v.a > 255 || v.a < 0) {
                    v.a = 127;
                }
                g.setColor(new Color(v.r, v.g, v.b, v.a));
                if (v.highlight) {
                    g.setColor(VectorColors.VECCI_VECTOR_HIGHLIGHT_COLOR);
                }
                if (v.selected) {
                    g.setColor(VectorColors.VECCI_VECTOR_SELECTED_COLOR);
                }
                if (v.pattern != 255) {
                    float[] pattern = this.getPattern(v);
                    BasicStroke dashed = new BasicStroke(0.0f, 0, 2, 1.0f, pattern, 0.0f);
                    Graphics2D g2 = g;
                    Stroke saveStroke = g2.getStroke();
                    g2.setStroke(dashed);
                    g2.drawLine((int)x0v, (int)y0v, (int)x1v, (int)y1v);
                    g2.setStroke(saveStroke);
                } else {
                    g.drawLine((int)x0v, (int)y0v, (int)x1v, (int)y1v);
                }
                if (v.start.highlight) {
                    g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
                    g.fillRect((int)x0v, (int)y0v, 3, 3);
                }
                if (v.end.highlight) {
                    g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
                    g.fillRect((int)x1v, (int)y1v, 3, 3);
                }
                if (v.start.selected) {
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.fillRect((int)x0v, (int)y0v, 3, 3);
                }
                if (v.end.selected) {
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.fillRect((int)x1v, (int)y1v, 3, 3);
                }
                ++count;
            }
            if (!this.dumpMode) {
                this.lastDisplayList.setRelativeWherePossible();
            }
            g.setColor(c);
        }
        this.bufferUsed = nextBuffer;
        super.repaint();
    }

    @Override
    public void repaint() {
        this.updateAndRepaint();
    }

    public void suspendRepaint() {
        this.noRepaint = true;
    }

    public void continueRepaint() {
        this.noRepaint = false;
        this.repaint();
    }

    public void setDumpMode(boolean dp) {
        this.dumpMode = dp;
    }
}

