/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import com.javamex.classmexer.MemoryUtil;
import de.malban.gui.ImageCacheItem;
import de.malban.util.UtilityImage;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class ImageCache {
    private static boolean USE_SIZEOF;
    private final HashMap<Integer, ImageCacheItem> cacheByUID = new HashMap();
    private final HashMap<String, ImageCacheItem> cacheByKey = new HashMap();
    private final HashMap<BufferedImage, ImageCacheItem> cacheByImage = new HashMap();
    private static final ImageCache ICACHE;
    public static boolean cacheActive;

    public void setCacheActive(boolean a) {
        cacheActive = a;
    }

    public static void clearCache() {
        ImageCache.getImageCache().cacheByUID.clear();
        ImageCache.getImageCache().cacheByKey.clear();
        ImageCache.getImageCache().cacheByImage.clear();
    }

    public static ImageCache getImageCache() {
        return ICACHE;
    }

    private static String buildKey(String path) {
        return path;
    }

    public int getSize() {
        return this.cacheByUID.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageCacheSize() {
        if (USE_SIZEOF) {
            HashMap<Integer, ImageCacheItem> hashMap = this.cacheByUID;
            synchronized (hashMap) {
                return MemoryUtil.deepMemoryUsageOfAll(this.cacheByUID.values());
            }
        }
        return 0L;
    }

    public ImageCacheItem getImageCacheItem(String path) {
        String key = ImageCache.buildKey(path);
        ImageCacheItem item = this.cacheByKey.get(key);
        if (item == null) {
            item = ImageCacheItem.buildItem(path);
            if (item == null) {
                return null;
            }
            item.setKey(key);
            this.addItem(item);
        }
        return item;
    }

    public ImageCacheItem getImageCacheByKey(String key) {
        ImageCacheItem item = this.cacheByKey.get(key);
        return item;
    }

    public ImageCacheItem getImageCacheByImage(BufferedImage bimage) {
        ImageCacheItem item = this.cacheByImage.get(bimage);
        return item;
    }

    public ImageCacheItem getImageCacheByUID(int uid) {
        ImageCacheItem item = this.cacheByUID.get(uid);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(ImageCacheItem item) {
        if (item == null) {
            return;
        }
        HashMap<Integer, ImageCacheItem> hashMap = this.cacheByUID;
        synchronized (hashMap) {
            this.cacheByKey.remove(item.getKey());
            this.cacheByImage.remove(item.getBufferedImage());
            this.cacheByUID.remove(item.getUID());
        }
        this.invalidateDerivates(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        String key = ImageCache.buildKey(path);
        ImageCacheItem item = this.cacheByKey.get(key);
        if (item == null) {
            return;
        }
        HashMap<Integer, ImageCacheItem> hashMap = this.cacheByUID;
        synchronized (hashMap) {
            this.cacheByKey.remove(item.getKey());
            this.cacheByImage.remove(item.getBufferedImage());
            this.cacheByUID.remove(item.getUID());
        }
        this.invalidateDerivates(item);
    }

    public BufferedImage getImage(String path) {
        ImageCacheItem item = this.getImageCacheItem(path);
        if (item == null) {
            return null;
        }
        return item.getBufferedImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(ImageCacheItem item) {
        if (!cacheActive) {
            return;
        }
        HashMap<Integer, ImageCacheItem> hashMap = this.cacheByUID;
        synchronized (hashMap) {
            this.cacheByKey.remove(item.getKey());
            this.cacheByKey.put(item.getKey(), item);
            this.cacheByImage.remove(item.getBufferedImage());
            this.cacheByImage.put(item.getBufferedImage(), item);
            this.cacheByUID.remove(item.getUID());
            this.cacheByUID.put(item.getUID(), item);
        }
    }

    public BufferedImage getDerivatScale(BufferedImage sourceImage, int scaleWidth, int scaleHeight) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatScale(scaleWidth, scaleHeight);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatScale(BufferedImage sourceImage, int percent) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        int width = item.getBufferedImage().getWidth(null) * percent / 100;
        int height = item.getBufferedImage().getHeight(null) * percent / 100;
        ImageCacheItem derivatItem = item.getDerivatScale(width, height);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatOpaque(BufferedImage sourceImage, int opacity) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        this.toAlpha(item.getBufferedImage());
        ImageCacheItem derivatItem = item.getDerivatOpaque(opacity);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatCanvasResize(BufferedImage sourceImage, int w, int h) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatCanvasResize(w, h);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatRotate(BufferedImage sourceImage, double angle) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatRotate(angle);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatRotate(BufferedImage sourceImage, double angle, boolean keepSize) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatRotate(angle, keepSize);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatMirror(BufferedImage sourceImage, boolean isVerticalMirror) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatMirror(isVerticalMirror);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatSubImage(BufferedImage sourceImage, int x, int y, int w, int h) {
        if (sourceImage == null) {
            return null;
        }
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatSubImage(x, y, w, h);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatRGB(BufferedImage sourceImage, float r, float g, float b) {
        if (sourceImage == null) {
            return null;
        }
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatRGB(r, g, b);
        return derivatItem.getBufferedImage();
    }

    public BufferedImage getDerivatHSB(BufferedImage sourceImage, float h, float s, float b) {
        if (sourceImage == null) {
            return null;
        }
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item == null) {
            item = ImageCacheItem.buildItem(sourceImage);
            if (item == null) {
                return null;
            }
            this.addItem(item);
        }
        ImageCacheItem derivatItem = item.getDerivatHSB(h, s, b);
        return derivatItem.getBufferedImage();
    }

    public void invalidateDerivates(BufferedImage sourceImage) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        this.invalidateDerivates(item);
    }

    public void invalidateDerivates(ImageCacheItem item) {
        if (item == null) {
            return;
        }
        item.invalidateDerivates();
    }

    public BufferedImage toAlpha(BufferedImage sourceImage) {
        ImageCacheItem item = this.cacheByImage.get(sourceImage);
        if (item != null && item.isAlpha()) {
            return item.getBufferedImage();
        }
        BufferedImage alphaImage = UtilityImage.toAlpha(sourceImage);
        if (item != null) {
            this.removeItem(item);
            item.setBufferedImage(alphaImage);
            this.addItem(item);
        }
        return alphaImage;
    }

    public void canBeInvalidated(BufferedImage image) {
    }

    static {
        cacheActive = false;
        ICACHE = new ImageCache();
        try {
            MemoryUtil.memoryUsageOf((Object)ICACHE);
            USE_SIZEOF = true;
        }
        catch (Throwable e) {
            USE_SIZEOF = false;
        }
    }
}

