/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;

public class ImageBorder
extends AbstractBorder {
    Image topCenterImage;
    Image topLeftImage;
    Image topRight;
    Image leftCenterImage;
    Image rightCenterImage;
    Image bottomCenterImage;
    Image bottomLeftImage;
    Image bottomRightImage;
    Insets insets;

    public ImageBorder(Image top_left, Image top_center, Image top_right, Image left_center, Image right_center, Image bottom_left, Image bottom_center, Image bottom_right) {
        this.topLeftImage = top_left;
        this.topCenterImage = top_center;
        this.topRight = top_right;
        this.leftCenterImage = left_center;
        this.rightCenterImage = right_center;
        this.bottomLeftImage = bottom_left;
        this.bottomCenterImage = bottom_center;
        this.bottomRightImage = bottom_right;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.insets != null) {
            return this.insets;
        }
        return new Insets(this.topCenterImage.getHeight(null), this.leftCenterImage.getWidth(null), this.bottomCenterImage.getHeight(null), this.rightCenterImage.getWidth(null));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.white);
        g.fillRect(x, y, width, height);
        Graphics2D g2 = (Graphics2D)g;
        int tlw = this.topLeftImage.getWidth(null);
        int tlh = this.topLeftImage.getHeight(null);
        int tcw = this.topCenterImage.getWidth(null);
        int tch = this.topCenterImage.getHeight(null);
        int trw = this.topRight.getWidth(null);
        int trh = this.topRight.getHeight(null);
        int lcw = this.leftCenterImage.getWidth(null);
        int lch = this.leftCenterImage.getHeight(null);
        int rcw = this.rightCenterImage.getWidth(null);
        int rch = this.rightCenterImage.getHeight(null);
        int blw = this.bottomLeftImage.getWidth(null);
        int blh = this.bottomLeftImage.getHeight(null);
        int bcw = this.bottomCenterImage.getWidth(null);
        int bch = this.bottomCenterImage.getHeight(null);
        int brw = this.bottomRightImage.getWidth(null);
        int brh = this.bottomRightImage.getHeight(null);
        this.fillTexture(g2, this.topLeftImage, x, y, tlw, tlh);
        this.fillTexture(g2, this.topCenterImage, x + tlw, y, width - tlw - trw, tch);
        this.fillTexture(g2, this.topRight, x + width - trw, y, trw, trh);
        this.fillTexture(g2, this.leftCenterImage, x, y + tlh, lcw, height - tlh - blh);
        this.fillTexture(g2, this.rightCenterImage, x + width - rcw, y + trh, rcw, height - trh - brh);
        this.fillTexture(g2, this.bottomLeftImage, x, y + height - blh, blw, blh);
        this.fillTexture(g2, this.bottomCenterImage, x + blw, y + height - bch, width - blw - brw, bch);
        this.fillTexture(g2, this.bottomRightImage, x + width - brw, y + height - brh, brw, brh);
    }

    public void paintLateBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int tlw = this.topLeftImage.getWidth(null);
        int tlh = this.topLeftImage.getHeight(null);
        int tcw = this.topCenterImage.getWidth(null);
        int tch = this.topCenterImage.getHeight(null);
        int trw = this.topRight.getWidth(null);
        int trh = this.topRight.getHeight(null);
        int lcw = this.leftCenterImage.getWidth(null);
        int lch = this.leftCenterImage.getHeight(null);
        int rcw = this.rightCenterImage.getWidth(null);
        int rch = this.rightCenterImage.getHeight(null);
        int blw = this.bottomLeftImage.getWidth(null);
        int blh = this.bottomLeftImage.getHeight(null);
        int bcw = this.bottomCenterImage.getWidth(null);
        int bch = this.bottomCenterImage.getHeight(null);
        int brw = this.bottomRightImage.getWidth(null);
        int brh = this.bottomRightImage.getHeight(null);
        this.fillTexture(g2, this.topLeftImage, x, y, tlw, tlh);
        this.fillTexture(g2, this.topCenterImage, x + tlw, y, width - tlw - trw, tch);
        this.fillTexture(g2, this.topRight, x + width - trw, y, trw, trh);
        this.fillTexture(g2, this.leftCenterImage, x, y + tlh, lcw, height - tlh - blh);
        this.fillTexture(g2, this.rightCenterImage, x + width - rcw, y + trh, rcw, height - trh - brh);
        this.fillTexture(g2, this.bottomLeftImage, x, y + height - blh, blw, blh);
        this.fillTexture(g2, this.bottomCenterImage, x + blw, y + height - bch, width - blw - brw, bch);
        this.fillTexture(g2, this.bottomRightImage, x + width - brw, y + height - brh, brw, brh);
    }

    public void fillTexture(Graphics2D g2, Image img, int x, int y, int w, int h) {
        BufferedImage buff = this.createBufferedImage(img);
        Rectangle anchor = new Rectangle(x, y, img.getWidth(null), img.getHeight(null));
        TexturePaint paint = new TexturePaint(buff, anchor);
        g2.setPaint(paint);
        g2.fillRect(x, y, w, h);
    }

    public BufferedImage createBufferedImage(Image img) {
        BufferedImage buff = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage(img, 0, 0, null);
        gfx.dispose();
        return buff;
    }
}

