/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.gui.components.CSATablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CSATableModel
extends AbstractTableModel
implements TableCellRenderer {
    protected TableModel mOrgModel = null;
    protected static int mBufferRow = 0;
    private HashMap<Integer, Boolean> mColumnEnabled = new HashMap();
    private HashMap<Integer, Integer> mEnabledColumnMapping = new HashMap();
    private HashMap<Integer, Integer> mRealColumnMapping = new HashMap();
    private String mSheetName = "";
    private int mEnabledColumnCount = 0;
    private static boolean mLogging = false;
    private static String mLog = "";
    CSATablePanel parent = null;
    TableColumnModel mCModel = null;
    private Color tableBackColor = new Color(64, 64, 128);
    private Color tableForColor = new Color(64, 64, 128);
    private Color tableSelBackColor = new Color(64, 64, 128);
    private Color tableSelForColor = new Color(64, 64, 128);
    private Color tableFocBackColor = new Color(64, 64, 128);
    private Color tableFocForColor = new Color(64, 64, 128);

    public static CSATableModel buildTableModel(TableModel orgModel) {
        CSATableModel model = new CSATableModel();
        model.setData(orgModel);
        return model;
    }

    public void setSameModelType(CSATableModel model) {
        this.mOrgModel = model.mOrgModel;
        this.fireTableDataChanged();
    }

    public void setParent(CSATablePanel p) {
        this.parent = p;
    }

    private CSATableModel() {
    }

    public void updateModel(TableModel orgModel) {
        if (orgModel != null) {
            this.setData(orgModel);
            this.fireTableDataChanged();
            if (this.parent != null) {
                this.parent.reInit();
            }
        }
    }

    protected void setData(TableModel model) {
        this.mOrgModel = model;
        this.mColumnEnabled = new HashMap();
        for (int i = 0; i < this.mOrgModel.getColumnCount(); ++i) {
            this.mColumnEnabled.put(new Integer(i), true);
        }
        this.resetColumnInfo();
    }

    void getInfo() {
        String user = System.getProperties().getProperty("user.name");
    }

    public String getSheetName() {
        return this.mSheetName;
    }

    public int convertEnabledColToRealCol(int i) {
        return this.mEnabledColumnMapping.get(i);
    }

    public int convertRealColToEnabledCol(int i) {
        return this.mRealColumnMapping.get(i);
    }

    public int getRealColumnCount() {
        return this.mOrgModel.getColumnCount();
    }

    public String getRealColumnName(int col) {
        return this.mOrgModel.getColumnName(col);
    }

    public boolean isColumnEnabled(int col) {
        Boolean b = this.mColumnEnabled.get(new Integer(col));
        if (b == null) {
            return true;
        }
        return b;
    }

    public int getEnabledColumnCount() {
        return this.mEnabledColumnCount;
    }

    public int getRealColumnNumberByName(String name) {
        for (int i = 0; i < this.getRealColumnCount(); ++i) {
            String cn = this.getRealColumnName(i);
            if (!cn.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getEnabledColumnNumberByName(String name) {
        int col = this.getRealColumnNumberByName(name);
        return this.convertRealColToEnabledCol(col);
    }

    public void enableColumn(int col, boolean b) {
        this.mColumnEnabled.put(new Integer(col), b);
        this.resetColumnInfo();
    }

    public void enableColumn(String name, boolean b) {
        this.enableColumn(this.getRealColumnNumberByName(name), b);
    }

    public void resetColumnInfo() {
        this.mEnabledColumnCount = this.mOrgModel.getColumnCount();
        int disabledCount = 0;
        this.mEnabledColumnMapping = new HashMap();
        this.mRealColumnMapping = new HashMap();
        for (int i = 0; i < this.mEnabledColumnCount; ++i) {
            if (!this.isColumnEnabled(i)) {
                ++disabledCount;
                this.mRealColumnMapping.put(i, -1);
                continue;
            }
            this.mRealColumnMapping.put(i, i - disabledCount);
            this.mEnabledColumnMapping.put(i - disabledCount, i);
        }
        this.mEnabledColumnCount -= disabledCount;
    }

    @Override
    public String getColumnName(int col) {
        int realCol = this.mEnabledColumnMapping.get(col);
        return this.mOrgModel.getColumnName(realCol);
    }

    @Override
    public int getRowCount() {
        return this.mOrgModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.getEnabledColumnCount();
    }

    public void setColumnModel(TableColumnModel cModel) {
        this.mCModel = cModel;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Integer I = this.mEnabledColumnMapping.get(col);
        int realCol = col;
        if (I != null) {
            realCol = I;
        }
        return this.mOrgModel.getValueAt(row, realCol);
    }

    public Object getRealValueAt(int row, int col) {
        return this.mOrgModel.getValueAt(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int realCol = this.mEnabledColumnMapping.get(col);
        return this.mOrgModel.isCellEditable(row, realCol);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        int realCol = this.mEnabledColumnMapping.get(col);
        this.mOrgModel.setValueAt(o, row, realCol);
        this.parent.getTable().repaint();
    }

    public Class getColumnClass(int col) {
        int realCol = this.mEnabledColumnMapping.get(col);
        return this.mOrgModel.getColumnClass(realCol);
    }

    public Vector<String> getDistinctColumnValueStrings(int col) {
        Vector<String> distinctRepresentation = new Vector<String>();
        HashMap<String, String> mStrings = new HashMap<String, String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object o = this.getRealValueAt(i, col);
            if (o == null) continue;
            String cn = o.toString();
            mStrings.put(cn, cn);
        }
        Set entries = mStrings.entrySet();
        for (Map.Entry entry : entries) {
            String key = entry.getKey().toString();
            distinctRepresentation.addElement(key);
        }
        return distinctRepresentation;
    }

    void getColors() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        this.tableBackColor = (Color)table.get("Table.background");
        this.tableForColor = (Color)table.get("Table.foreground");
        this.tableSelForColor = (Color)table.get("Table.selectionForeground");
        this.tableSelBackColor = (Color)table.get("Table.selectionBackground");
        this.tableFocForColor = (Color)table.get("Table.focusCellForeground");
        this.tableFocBackColor = (Color)table.get("Table.focusCellBackground");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label;
        this.getColors();
        if (value == null) {
            label = new JLabel("");
        } else if (value instanceof BufferedImage) {
            ImageIcon icon = new ImageIcon((BufferedImage)value);
            label = new JLabel(icon);
        } else {
            label = new JLabel("" + value);
        }
        label.setOpaque(true);
        Border b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        label.setBorder(b);
        label.setFont(table.getFont());
        label.setForeground(this.tableForColor);
        label.setBackground(this.tableBackColor);
        if (hasFocus) {
            label.setBackground(this.tableFocBackColor);
            label.setForeground(this.tableFocForColor);
            label.setBackground(this.tableSelBackColor);
            label.setForeground(this.tableSelForColor);
        } else if (isSelected) {
            label.setBackground(this.tableSelBackColor);
            label.setForeground(this.tableSelForColor);
        } else {
            column = table.convertColumnIndexToModel(column);
            row = table.convertRowIndexToModel(row);
            label.setBackground(this.tableBackColor);
            label.setForeground(this.tableForColor);
        }
        return label;
    }
}

