/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.gui.components.CSAListener;
import de.malban.gui.components.CSATableModel;
import de.malban.gui.components.DoubleClickAction;
import de.malban.gui.components.FilterChangedListener;
import de.malban.gui.components.SelectionChangedListener;
import de.malban.gui.components.SelectionEvent;
import de.malban.gui.components.TableStateData;
import de.malban.gui.components.TableStateDataPool;
import de.malban.util.ExcelHelper;
import de.malban.util.InfoCallback;
import de.malban.util.UtilityString;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class CSATablePanel
extends JPanel
implements InfoCallback {
    public int COMBO_SIZE = -1;
    private Vector<SelectionChangedListener> mSelectionListener = new Vector();
    private Vector<FilterChangedListener> mFilterListener = new Vector();
    private Vector<CSAListener> mListener = new Vector();
    TableRowSorter<TableModel> mSorter = null;
    JFrame mFrame;
    CSATableModel mModel = null;
    private int mLastKnownSize = 0;
    private int mRow = -1;
    private int mCol = -1;
    private int inEvent = 0;
    private DoubleClickAction mDClickAction = null;
    private boolean mEnablePopup = true;
    private boolean mEnableDClick = true;
    int lastMove = -1;
    MouseAdapter ma = null;
    TableColumnModelListener tcm = null;
    AdjustmentListener adj = null;
    ChangeListener cl = null;
    ListSelectionListener lsl = null;
    String columnOrder = "";
    private JCheckBox jCheckBox4;
    private JMenu jColumnSettingMenu;
    private JComboBox jComboBox1;
    private JPanel jHeaderPanel;
    private JMenuItem jMenuItemExcel;
    private JMenuItem jMenuItemSave;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable jTable1;
    private JPopupMenu mOtherPopup = null;
    private String mXMLId = "";
    private TableStateData mData = null;

    public CSATablePanel() {
        DefaultTableModel model = new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"});
        this.mModel = CSATableModel.buildTableModel(model);
        this.initComponents();
        this.initAll();
    }

    public CSATablePanel(CSATableModel model) {
        this.mModel = model;
        this.initComponents();
        this.initAll();
    }

    public void setModel(CSATableModel model) {
        this.mModel = model;
        this.initAll();
    }

    public void setSameModelType(CSATableModel model) {
        this.mSorter.setSortsOnUpdates(true);
        this.mModel.setSameModelType(model);
        this.mSorter.setSortsOnUpdates(false);
        this.resetFilters();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.COMBO_SIZE == -1) {
            TableColumnModel cModel = this.jTable1.getColumnModel();
            try {
                int ch;
                int i = 0;
                if (i < cModel.getColumnCount() && (ch = this.jHeaderPanel.getComponent(i).getHeight()) != 0) {
                    this.COMBO_SIZE = ch;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void resetFilters() {
        ++this.inEvent;
        int x = 1;
        boolean y = false;
        int width = 0;
        this.jTable1.getColumnModel();
        TableColumnModel cModel = this.jTable1.getColumnModel();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            TableColumn tCol = cModel.getColumn(i);
            String name = (String)tCol.getHeaderValue();
            int realIndex = this.mModel.getRealColumnNumberByName(name);
            JComboBox comboBox = (JComboBox)this.jHeaderPanel.getComponent(i);
            String seleced = "";
            if (comboBox.getSelectedIndex() != -1) {
                seleced = comboBox.getSelectedItem().toString();
            }
            comboBox.removeAllItems();
            Vector<String> dinstinct = this.mModel.getDistinctColumnValueStrings(realIndex);
            Collections.sort(dinstinct, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            comboBox.addItem("");
            for (int d = 0; d < dinstinct.size(); ++d) {
                String v = dinstinct.elementAt(d);
                comboBox.addItem(v);
            }
            if (seleced.length() > 0) {
                comboBox.setSelectedItem(seleced);
            }
            this.jHeaderPanel.repaint();
            x += width + cModel.getColumnMargin() - 1;
        }
        --this.inEvent;
    }

    public void setTableStyleSwitchingEnabled(boolean b) {
        this.jPanel1.setVisible(b);
    }

    public JTable getTable() {
        return this.jTable1;
    }

    public CSATableModel getModel() {
        return this.mModel;
    }

    public void setFrame(JFrame frame) {
        this.mFrame = frame;
    }

    public void setColumnWidth(int col, int width) {
        TableColumnModel cModel = this.jTable1.getColumnModel();
        cModel.getColumn(col).setWidth(width);
        cModel.getColumn(col).setPreferredWidth(width);
        this.correctFilters();
    }

    public void deleteSelected() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        this.jTable1.tableChanged(null);
        this.buildFilters();
        this.mSorter.setRowFilter(null);
        this.reInit();
    }

    public void initAll() {
        this.jTable1.removeMouseListener(this.ma);
        this.ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CSATablePanel.this.mouseClickedOnTable(evt);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CSATablePanel.this.mousePressedOnTable(e);
            }
        };
        this.jTable1.addMouseListener(this.ma);
        this.resetPopupMenu();
        this.jTable1.setModel(this.mModel);
        this.mSorter = new TableRowSorter<CSATableModel>(this.mModel);
        this.jTable1.setRowSorter(this.mSorter);
        TableColumnModel cModel = this.jTable1.getColumnModel();
        this.mModel.setColumnModel(cModel);
        this.mModel.setParent(this);
        cModel.removeColumnModelListener(this.tcm);
        this.tcm = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                CSATablePanel.this.correctFilters();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (CSATablePanel.this.inEvent > 0) {
                    return;
                }
                if (CSATablePanel.this.lastMove == e.getToIndex()) {
                    return;
                }
                CSATablePanel.this.lastMove = e.getToIndex();
                if (CSATablePanel.this.didColumnMove()) {
                    CSATablePanel.this.buildFilters();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
        cModel.addColumnModelListener(this.tcm);
        this.buildFilters();
        this.jTable1.setDefaultRenderer(Integer.class, this.mModel);
        this.jTable1.setDefaultRenderer(String.class, this.mModel);
        this.jTable1.setDefaultRenderer(Date.class, this.mModel);
        this.jTable1.setDefaultRenderer(Double.class, this.mModel);
        this.jTable1.setDefaultRenderer(BufferedImage.class, this.mModel);
        this.jScrollPane1.getHorizontalScrollBar().removeAdjustmentListener(this.adj);
        this.adj = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                CSATablePanel.this.alignPosiitons();
            }
        };
        this.jScrollPane1.getHorizontalScrollBar().addAdjustmentListener(this.adj);
        this.jScrollPane2.getViewport().removeChangeListener(this.cl);
        this.cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CSATablePanel.this.inEvent != 0) {
                    return;
                }
                CSATablePanel.this.inEvent++;
                Point p = CSATablePanel.this.jScrollPane1.getViewport().getViewPosition();
                p.y = 0;
                CSATablePanel.this.jScrollPane2.getViewport().setViewPosition(p);
                CSATablePanel.this.inEvent--;
            }
        };
        this.jScrollPane2.getViewport().addChangeListener(this.cl);
        this.jTable1.getSelectionModel().removeListSelectionListener(this.lsl);
        this.lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    CSATablePanel.this.fireSelectionChanged();
                }
            }
        };
        this.jTable1.getSelectionModel().addListSelectionListener(this.lsl);
        this.adjustTable(this.mData);
    }

    public void reInit() {
        this.getTable().tableChanged(null);
        this.mSorter = new TableRowSorter<CSATableModel>(this.mModel);
        this.jTable1.setRowSorter(this.mSorter);
        this.buildFilters();
        if (this.mXMLId.length() != 0) {
            this.setXMLId(this.mXMLId);
        }
        this.getTable().repaint();
    }

    private void alignPosiitons() {
        Point p = this.jScrollPane1.getViewport().getViewPosition();
        p.y = 0;
        ++this.inEvent;
        this.jScrollPane2.getViewport().setViewPosition(p);
        --this.inEvent;
    }

    private void correctFilters() {
        int x = 1;
        boolean y = false;
        int width = 0;
        TableColumnModel cModel = this.jTable1.getColumnModel();
        try {
            for (int i = 0; i < cModel.getColumnCount(); ++i) {
                int ph;
                int dif;
                int difdif;
                width = cModel.getColumn(i).getWidth();
                Rectangle bounds = new Rectangle();
                bounds.setSize(width - 2, this.jHeaderPanel.getComponent(i).getHeight());
                int ch = this.jHeaderPanel.getComponent(i).getHeight();
                if (ch == 0 && this.COMBO_SIZE != -1) {
                    ch = this.COMBO_SIZE;
                }
                if ((difdif = (dif = (ph = this.jHeaderPanel.getHeight()) - ch) / 2) <= 0) {
                    difdif = 3;
                }
                bounds.setLocation(x + 1, difdif);
                this.jHeaderPanel.getComponent(i).setBounds(bounds);
                this.jHeaderPanel.getComponent(i).invalidate();
                this.jHeaderPanel.getComponent(i).validate();
                this.jHeaderPanel.getComponent(i).repaint();
                this.mLastKnownSize = x + width;
                x += width + cModel.getColumnMargin() - 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean didColumnMove() {
        this.jTable1.getColumnModel();
        TableColumnModel cModel = this.jTable1.getColumnModel();
        String currentOrder = "";
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            TableColumn tCol = cModel.getColumn(i);
            String name = (String)tCol.getHeaderValue();
            int realIndex = this.mModel.getRealColumnNumberByName(name);
            currentOrder = currentOrder + "_" + realIndex;
        }
        return !currentOrder.equals(this.columnOrder);
    }

    private void buildFilters() {
        this.jHeaderPanel.removeAll();
        this.columnOrder = "";
        int x = 1;
        boolean y = false;
        int width = 0;
        this.jTable1.getColumnModel();
        TableColumnModel cModel = this.jTable1.getColumnModel();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            TableColumn tCol = cModel.getColumn(i);
            String name = (String)tCol.getHeaderValue();
            int realIndex = this.mModel.getRealColumnNumberByName(name);
            width = tCol.getWidth();
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.setFont(comboBox.getFont().deriveFont((float)comboBox.getFont().getSize() - 2.0f));
            this.jHeaderPanel.add(comboBox);
            Vector<String> dinstinct = this.mModel.getDistinctColumnValueStrings(realIndex);
            Collections.sort(dinstinct, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareTo(s2);
                }
            });
            comboBox.addItem("");
            for (int d = 0; d < dinstinct.size(); ++d) {
                String v = dinstinct.elementAt(d);
                comboBox.addItem(v);
            }
            comboBox.setName("_" + realIndex);
            this.columnOrder = this.columnOrder + "_" + realIndex;
            comboBox.setEditable(true);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CSATablePanel.this.jFilterComboBoxActionPerformed(evt);
                }
            });
            Rectangle bounds = new Rectangle();
            bounds.setSize(width - 2, comboBox.getPreferredSize().height);
            int ch = comboBox.getHeight();
            if (ch == 0 && this.COMBO_SIZE != -1) {
                ch = this.COMBO_SIZE;
            }
            int ph = this.jHeaderPanel.getHeight();
            int dif = ph - ch;
            int difdif = dif / 2;
            bounds.setLocation(x + 1, difdif);
            comboBox.setBounds(bounds);
            this.jHeaderPanel.repaint();
            x += width + cModel.getColumnMargin() - 1;
        }
    }

    public int getViewRowCount() {
        return this.mSorter.getViewRowCount();
    }

    public int getViewColumnCount() {
        return this.mModel.getEnabledColumnCount();
    }

    public Object getViewValue(int r, int c) {
        return ((TableModel)this.mSorter.getModel()).getValueAt(this.mSorter.convertRowIndexToModel(r), c);
    }

    public int getViewIntValue(int r, int c) {
        Object o = this.getViewValue(r, c);
        if (!(o instanceof Integer)) {
            return 0;
        }
        Integer i = (Integer)o;
        return i;
    }

    public int convertRowIndexToView(int r) {
        return this.mSorter.convertRowIndexToView(r);
    }

    public int convertRowIndexToModel(int r) {
        return this.mSorter.convertRowIndexToModel(r);
    }

    public void addCSAListener(CSAListener listener) {
        this.mListener.removeElement(listener);
        this.mListener.addElement(listener);
    }

    public void removeCSAListener(CSAListener listener) {
        this.mListener.removeElement(listener);
    }

    private void resetPopupMenu() {
        this.jColumnSettingMenu.removeAll();
        for (int i = 0; i < this.mModel.getRealColumnCount(); ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            item.setText(this.mModel.getRealColumnName(i));
            item.setSelected(this.mModel.isColumnEnabled(i));
            this.jColumnSettingMenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CSATablePanel.this.tableColumnChecked(evt);
                }
            });
        }
    }

    private void tableColumnChecked(ActionEvent evt) {
        ++this.inEvent;
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)evt.getSource();
        this.mModel.enableColumn(item.getText(), item.isSelected());
        this.jTable1.tableChanged(null);
        this.buildFilters();
        this.mSorter.setRowFilter(null);
        --this.inEvent;
    }

    public void mousePressedOnTable(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.mDClickAction != null) {
            this.mDClickAction.evt = evt;
            this.mDClickAction.doIt();
        }
    }

    public void setDoubleClickAction(DoubleClickAction action) {
        this.mDClickAction = action;
    }

    private Frame getFrame() {
        Container c = this.getParent();
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public void mouseClickedOnTable(MouseEvent evt) {
        if (evt.getButton() == 3) {
            JTable table = (JTable)evt.getSource();
            this.mRow = table.convertRowIndexToModel(table.rowAtPoint(evt.getPoint()));
            this.mCol = table.convertColumnIndexToModel(table.columnAtPoint(evt.getPoint()));
            this.mCol = this.mModel.convertEnabledColToRealCol(this.mCol);
            if (this.isTablePopupEnabled()) {
                this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
            } else if (this.mOtherPopup != null) {
                this.mOtherPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    public boolean isTablePopupEnabled() {
        return this.mEnablePopup;
    }

    public void setTablePopupEnabled(boolean b) {
        this.mEnablePopup = b;
    }

    public boolean isTableDClickEnabled() {
        return this.mEnableDClick;
    }

    public void setTableDClickEnabled(boolean b) {
        this.mEnableDClick = b;
    }

    public JPopupMenu getPopUp() {
        return this.jPopupMenu1;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jSeparator1 = new JSeparator();
        this.jColumnSettingMenu = new JMenu();
        this.jMenuItemExcel = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jCheckBox4 = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jHeaderPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPopupMenu1.add(this.jSeparator1);
        this.jColumnSettingMenu.setText("Columns");
        this.jPopupMenu1.add(this.jColumnSettingMenu);
        this.jMenuItemExcel.setText("To Excel");
        this.jMenuItemExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSATablePanel.this.jMenuItemExcelActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemExcel);
        this.jMenuItemSave.setText("Save Tablestate");
        this.jMenuItemSave.setEnabled(false);
        this.jMenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSATablePanel.this.jMenuItemSaveActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemSave);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CSATablePanel.this.formComponentResized(evt);
            }
        });
        this.jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSATablePanel.this.jCheckBox4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox4).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox4));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setMinimumSize(new Dimension(8, 16));
        this.jHeaderPanel.setMinimumSize(new Dimension(0, 0));
        this.jHeaderPanel.setLayout(null);
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setFont(this.jComboBox1.getFont().deriveFont((float)this.jComboBox1.getFont().getSize() - 2.0f));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jHeaderPanel.add(this.jComboBox1);
        this.jComboBox1.setBounds(160, 0, 97, 17);
        this.jScrollPane2.setViewportView(this.jHeaderPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 395, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.jScrollPane2, -1, 395, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
    }

    public void addSelectionListerner(SelectionChangedListener listener) {
        this.mSelectionListener.removeElement(listener);
        this.mSelectionListener.addElement(listener);
    }

    public void removeSelectionListerner(SelectionChangedListener listener) {
        this.mSelectionListener.removeElement(listener);
    }

    public void fireSelectionChanged() {
        SelectionEvent evt = new SelectionEvent();
        for (int i = 0; i < this.mSelectionListener.size(); ++i) {
            this.mSelectionListener.elementAt(i).selectionChanged(evt);
        }
    }

    public void addFilterListerner(FilterChangedListener listener) {
        this.mFilterListener.removeElement(listener);
        this.mFilterListener.addElement(listener);
    }

    public void removeFilterListerner(FilterChangedListener listener) {
        this.mFilterListener.removeElement(listener);
    }

    public void fireFilterChanged() {
        for (int i = 0; i < this.mFilterListener.size(); ++i) {
            this.mFilterListener.elementAt(i).filterChanged();
        }
    }

    private void jCheckBox4ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox4.isSelected()) {
            this.jTable1.setAutoResizeMode(0);
        } else {
            this.jTable1.setAutoResizeMode(2);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.correctFilters();
        this.alignPosiitons();
    }

    private void jMenuItemExcelActionPerformed(ActionEvent evt) {
        ExcelHelper.toExcel(this.getTable());
    }

    private void jMenuItemSaveActionPerformed(ActionEvent evt) {
        this.saveTableState();
    }

    @Override
    public boolean askCancel(String text) {
        return true;
    }

    @Override
    public boolean giveInfo(String text, int currentItem, int itemCount) {
        return true;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu1) {
        this.mOtherPopup = jPopupMenu1;
    }

    public void saveTableState() {
        if (this.mXMLId.trim().length() == 0) {
            return;
        }
        TableStateDataPool pool = new TableStateDataPool("TableStateData.xml");
        pool.put(this.builtTableStateData());
        pool.save();
    }

    public void setXMLId(String id) {
        this.mXMLId = id;
        this.jMenuItemSave.setEnabled(true);
        try {
            TableStateDataPool pool = new TableStateDataPool("TableStateData.xml");
            this.mData = pool.get(this.mXMLId);
            if (this.mData != null) {
                this.adjustTable(this.mData);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void adjustTable(TableStateData data2) {
        boolean enabled;
        int c;
        if (data2 == null) {
            return;
        }
        ++this.inEvent;
        TableColumnModel cModel = this.jTable1.getColumnModel();
        int enabledCounter = 0;
        for (c = 0; c < this.mModel.getRealColumnCount(); ++c) {
            enabled = true;
            try {
                enabled = data2.getColumnEnabled().elementAt(c);
                String colName = data2.getColumnName().elementAt(c);
                int orgPos = data2.getColumnOrgNo().elementAt(c);
                int viewPos = data2.getColumnViewNo().elementAt(c);
                int width = data2.getColumnWidth().elementAt(c);
                this.mModel.enableColumn(colName, enabled);
            }
            catch (Throwable colName) {
                // empty catch block
            }
            if (!enabled) continue;
            ++enabledCounter;
        }
        this.resetPopupMenu();
        this.jTable1.tableChanged(null);
        enabledCounter = 0;
        for (c = 0; c < this.mModel.getRealColumnCount(); ++c) {
            enabled = true;
            int width = 100;
            try {
                enabled = data2.getColumnEnabled().elementAt(c);
                width = data2.getColumnWidth().elementAt(c);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!enabled) continue;
            cModel.getColumn(enabledCounter).setPreferredWidth(width);
            cModel.getColumn(enabledCounter).setWidth(width);
            cModel.getColumn(enabledCounter).setPreferredWidth(width);
            ++enabledCounter;
        }
        this.mSorter.setRowFilter(null);
        this.orderColumns(data2.mColumnViewNo, data2.mColumnName);
        this.buildFilters();
        --this.inEvent;
    }

    int getViewIndex(String id) {
        TableColumnModel cModel = this.jTable1.getColumnModel();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            TableColumn column = cModel.getColumn(i);
            String headerI = column.getHeaderValue().toString();
            if (!id.equals(headerI)) continue;
            return i;
        }
        return -1;
    }

    private TableStateData builtTableStateData() {
        TableStateData data2 = new TableStateData();
        data2.mName = this.mXMLId;
        data2.mClass = "TableState";
        TableColumnModel cModel = this.jTable1.getColumnModel();
        int enabledCounter = 0;
        for (int c = 0; c < this.mModel.getRealColumnCount(); ++c) {
            boolean enabled = this.mModel.isColumnEnabled(c);
            String colName = this.mModel.getRealColumnName(c);
            int viewPos = this.getViewIndex(colName);
            int orgPos = c;
            int width = 50;
            if (enabled) {
                width = cModel.getColumn(viewPos).getWidth();
                ++enabledCounter;
            }
            data2.mColumnEnabled.add(enabled);
            data2.mColumnOrgNo.add(orgPos);
            data2.mColumnViewNo.add(viewPos);
            data2.mColumnWidth.add(width);
            data2.mColumnName.add(colName);
        }
        return data2;
    }

    public void orderColumns(Vector<Integer> cPos, Vector<String> names) {
        class NamedPos {
            int pos;
            String name;

            NamedPos(int p, String n) {
                this.pos = p;
                this.name = n;
            }
        }
        Vector<NamedPos> namedPositions = new Vector<NamedPos>();
        for (int i = 0; i < cPos.size(); ++i) {
            Integer pos = cPos.elementAt(i);
            if (pos == -1) continue;
            namedPositions.addElement(new NamedPos(cPos.elementAt(i), names.elementAt(i)));
        }
        Collections.sort(namedPositions, new Comparator<NamedPos>(){

            @Override
            public int compare(NamedPos s1, NamedPos s2) {
                return s1.pos - s2.pos;
            }
        });
        TableColumnModel model = this.jTable1.getColumnModel();
        for (int i = 0; i < namedPositions.size(); ++i) {
            int pos = ((NamedPos)namedPositions.elementAt((int)i)).pos;
            String name = ((NamedPos)namedPositions.elementAt((int)i)).name;
            int tableCol = -1;
            for (int c = 0; c < model.getColumnCount(); ++c) {
                TableColumn column = model.getColumn(c);
                String name2 = column.getHeaderValue().toString();
                if (!name2.equals(name)) continue;
                tableCol = c;
                break;
            }
            if (tableCol == -1) continue;
            try {
                this.jTable1.moveColumn(tableCol, pos);
                continue;
            }
            catch (Throwable e) {
                System.out.println("Warning! Column Move failed. (" + tableCol + " <->" + pos + ")");
            }
        }
    }

    private void jFilterComboBoxActionPerformed(ActionEvent evt) {
        if (this.inEvent > 0) {
            return;
        }
        ++this.inEvent;
        this.jTable1.getColumnModel();
        TableColumnModel cModel = this.jTable1.getColumnModel();
        Vector filtersNot = new Vector();
        Vector filtersAnd = new Vector();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            TableColumn tCol = cModel.getColumn(i);
            String name = (String)tCol.getHeaderValue();
            JComboBox comboBox = (JComboBox)this.jHeaderPanel.getComponent(i);
            String sel = comboBox.getSelectedItem().toString();
            if (sel.trim().length() == 0) continue;
            boolean notti = false;
            if (sel.startsWith("!")) {
                notti = true;
                sel = sel.substring(1);
            }
            sel = UtilityString.escapeRegExp(sel);
            int enabledIndex = this.mModel.getEnabledColumnNumberByName(name);
            RowFilter filter = RowFilter.regexFilter(sel, enabledIndex);
            if (notti) {
                filtersNot.addElement(filter);
                continue;
            }
            filtersAnd.addElement(filter);
        }
        RowFilter allFilter = RowFilter.andFilter(filtersAnd);
        for (int i = 0; i < filtersNot.size(); ++i) {
            RowFilter rowFilter = (RowFilter)filtersNot.elementAt(i);
            allFilter = RowFilter.notFilter(rowFilter);
        }
        if (filtersAnd.size() + filtersNot.size() == 0) {
            this.mSorter.setRowFilter(null);
        } else {
            this.mSorter.setRowFilter(allFilter);
        }
        --this.inEvent;
        this.fireFilterChanged();
    }

    public void setRowHeight(int h) {
        this.jTable1.setRowHeight(h);
    }

    public int getRowHeight() {
        return this.jTable1.getRowHeight();
    }

    public int[] getSelectedRows() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length == 0) {
            int row = this.jTable1.getSelectedRow();
            if (row == -1) {
                return new int[0];
            }
            rows = new int[]{row};
        }
        int[] tRows = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            tRows[i] = this.convertRowIndexToModel(rows[i]);
        }
        return tRows;
    }

    public void setHeaderEnabled(boolean b) {
        this.jHeaderPanel.setVisible(b);
        this.jScrollPane2.setVisible(b);
    }
}

