/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.gui.ImageCache;
import de.malban.gui.image.SaveOpacityFilter;
import de.malban.util.UtilityString;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImageSequencer
extends JPanel {
    private static int id = 0;
    Vector<BufferedImage> bimages = new Vector();
    Toolkit toolkit = Toolkit.getDefaultToolkit();

    private ImageSequencer() {
    }

    public static ImageSequencer createFromImageFading(String name, int count) {
        name = UtilityString.cleanFileString(name);
        ImageSequencer i = new ImageSequencer();
        i.initImageFading(name, count);
        return i;
    }

    public static ImageSequencer createFromImageSequence(String name, int count) {
        name = UtilityString.cleanFileString(name);
        ImageSequencer i = new ImageSequencer();
        i.initImageSequence(name, count);
        return i;
    }

    public static ImageSequencer createByRotation(String name, int steps) {
        name = UtilityString.cleanFileString(name);
        ImageSequencer i = new ImageSequencer();
        i.initRotationSequence(name, steps);
        return i;
    }

    public Vector<BufferedImage> getBufferedImages() {
        return this.bimages;
    }

    public Vector<Icon> getAsIcons() {
        Vector<Icon> icons = new Vector<Icon>();
        for (int i = 0; i < this.bimages.size(); ++i) {
            BufferedImage image = this.bimages.elementAt(i);
            ImageIcon icon = new ImageIcon(image);
            icons.addElement(icon);
        }
        return icons;
    }

    private boolean initRotationSequence(String name, int steps) {
        int bigSize;
        if (!this.initImageSequence(name, 1)) {
            return false;
        }
        BufferedImage bimage = this.bimages.elementAt(0);
        this.bimages.clear();
        int angleInc = 360 / steps;
        int angleNow = 0;
        int h = bimage.getHeight();
        int w = bimage.getWidth();
        int size = h > w ? h : w;
        size = bigSize = (int)(Math.sqrt(2.0 * (double)(size * size)) + 0.999);
        for (int i = 0; i < steps; ++i) {
            BufferedImage dimg = new BufferedImage(size, size, bimage.getType());
            Graphics2D g = dimg.createGraphics();
            g.rotate(Math.toRadians(angleNow), size / 2, size / 2);
            angleNow += angleInc;
            g.drawImage(bimage, (size - w) / 2, (size - h) / 2, bimage.getWidth(), bimage.getHeight(), null);
            this.bimages.addElement(dimg);
        }
        return true;
    }

    private boolean initImageFading(String name, int steps) {
        int stepIncread;
        if (!this.initImageSequence(name, 1)) {
            return false;
        }
        int opaqueness = stepIncread = 255 / (steps - 2);
        BufferedImage bimage = this.bimages.elementAt(0);
        for (int s = 0; s < steps - 2; ++s) {
            SaveOpacityFilter filter = new SaveOpacityFilter(255 - opaqueness);
            this.bimages.addElement(filter.filter(bimage, null));
            opaqueness += stepIncread;
        }
        SaveOpacityFilter filter = new SaveOpacityFilter(0);
        this.bimages.addElement(filter.filter(bimage, null));
        return true;
    }

    private boolean initImageSequence(String name, int count) {
        if (count <= 0) {
            return false;
        }
        String extension = name.substring(name.lastIndexOf("."));
        String base = name.substring(0, name.lastIndexOf("."));
        boolean greaterTen = count > 9;
        base = greaterTen ? base.substring(0, base.length() - 2) : base.substring(0, base.length() - 1);
        for (int i = 0; i < count; ++i) {
            String path = base;
            if (i < 10 && greaterTen) {
                path = path + "0";
            }
            path = path + i;
            path = path + extension;
            if (count == 1) {
                path = name;
            }
            BufferedImage image = ImageCache.getImageCache().getImage(path);
            this.bimages.addElement(image);
        }
        return true;
    }

    public void transformScale(int h, int w) {
        Vector<BufferedImage> newBimages = new Vector<BufferedImage>();
        for (int i = 0; i < this.bimages.size(); ++i) {
            BufferedImage image = this.bimages.elementAt(i);
            BufferedImage bimage = ImageCache.getImageCache().getDerivatScale(image, w, h);
            newBimages.addElement(bimage);
        }
        this.bimages = newBimages;
    }

    public void transformOpaque(int opaqueness) {
        Vector<BufferedImage> newBimages = new Vector<BufferedImage>();
        for (int i = 0; i < this.bimages.size(); ++i) {
            BufferedImage image = this.bimages.elementAt(i);
            BufferedImage bimage = ImageCache.getImageCache().getDerivatOpaque(image, opaqueness);
            newBimages.addElement(bimage);
        }
        this.bimages = newBimages;
    }

    public void transformScale(int percent) {
    }

    public void transformRotate() {
    }
}

