/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class OverlaylPanel
extends JPanel {
    JGlassPanel glass = new JGlassPanel();
    JRootPane rootPane;
    Component desktop;

    public OverlaylPanel(JRootPane r, Component d) {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        super.setVisible(false);
        this.setForeground(Color.white);
        this.setBackground(new Color(0, 0, 0, 200));
        this.rootPane = r;
        this.desktop = d;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(new Color(0, 0, 0, 200));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    void repair(Container c) {
        if (c instanceof Container) {
            for (int j = 0; j < c.getComponentCount(); ++j) {
                Component mc = c.getComponent(j);
                this.repair((Container)mc);
            }
        }
        if (c instanceof JComboBox) {
            JComboBox cbo = (JComboBox)c;
            cbo.setLightWeightPopupEnabled(false);
            try {
                Class<?> cls = Class.forName("javax.swing.PopupFactory");
                Field field = cls.getDeclaredField("forceHeavyWeightPopupKey");
                field.setAccessible(true);
                cbo.putClientProperty(field.get(null), Boolean.TRUE);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private boolean isCombo(Object s) {
        Component p = null;
        if (!(s instanceof Component)) {
            return false;
        }
        p = (Component)s;
        do {
            if (!(p instanceof JComboBox)) continue;
            return true;
        } while ((p = p.getParent()) != null);
        return false;
    }

    public void init(JRootPane rootPane, Component desktop) {
        this.repair(this);
        this.initGlass();
        Dimension size = this.getPreferredSize();
        Dimension rootSize = desktop.getSize();
        this.setBounds((rootSize.width - size.width) / 2, (rootSize.height - size.height) / 2, size.width, size.height);
        desktop.validate();
        this.glass.add(this);
        rootPane.setGlassPane(this.glass);
        this.glass.setVisible(true);
    }

    private void initGlass() {
        this.glass.setLayout(null);
        this.glass.setOpaque(false);
        MouseInputAdapter adapter = new MouseInputAdapter(){};
        this.glass.addMouseListener(adapter);
        this.glass.addMouseMotionListener(adapter);
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.init(this.rootPane, this.desktop);
        } else if (this.glass != null) {
            this.glass.setVisible(false);
            this.glass.removeAll();
        }
        this.updateUI();
        this.validate();
        this.repaint();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    class JGlassPanel
    extends JPanel {
        JGlassPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Point myLoc = this.getLocationOnScreen();
            JRootPane startPoint = SwingUtilities.getRootPane(this);
            Point startLoc = startPoint.getLocationOnScreen();
            int dx = startLoc.x - myLoc.x;
            int dy = startLoc.y - myLoc.y;
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(dx, dy);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            this.paintPopupMenus(rootPane, rootPane, g2d);
            g2d.dispose();
        }

        public void paintPopupMenus(JRootPane rootPane, Component comp, Graphics g) {
            JPopupMenu jpm;
            if (comp instanceof JPopupMenu && (jpm = (JPopupMenu)comp).isShowing() && jpm.isVisible()) {
                Graphics2D g2d = (Graphics2D)g.create();
                Point rootPaneLoc = rootPane.getLocationOnScreen();
                Point popupLoc = jpm.getLocationOnScreen();
                g2d.translate(popupLoc.x - rootPaneLoc.x, popupLoc.y - rootPaneLoc.y);
                jpm.paint(g2d);
                g2d.dispose();
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    this.paintPopupMenus(rootPane, cont.getComponent(i), g);
                }
            }
        }
    }
}

