/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class StackOutlineArrow
extends JComponent {
    public Point start = new Point(0, 0);
    public Point end = new Point(0, 0);
    public float lineThickness = 12.0f;
    public float innerOuterRatio = 0.3f;
    public Color strokeColor = new Color(20, 20, 200);
    public Color fillColor = new Color(150, 150, 231);
    public float headSize = 0.423f;
    public String label = "";
    public Font labelFont = null;

    public StackOutlineArrow() {
        this.setOpaque(false);
    }

    @Override
    public int getHeight() {
        return 1500;
    }

    @Override
    public int getWidth() {
        return 1500;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public void drawArrow(Graphics2D g) {
        int i;
        int x = this.start.x;
        int y = this.start.y;
        int xx = this.end.x;
        int yy = this.end.y;
        float arrowWidth = this.lineThickness;
        float theta = this.headSize;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        float[] vecLine = new float[2];
        float[] vecLeft = new float[2];
        xPoints[0] = xx;
        yPoints[0] = yy;
        vecLine[0] = (float)xPoints[0] - (float)x;
        vecLine[1] = (float)yPoints[0] - (float)y;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        float fLength = (float)Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        float th = arrowWidth / (2.0f * fLength);
        float ta = arrowWidth / (2.0f * ((float)Math.tan(theta) / 2.0f) * fLength);
        float baseX = (float)xPoints[0] - ta * vecLine[0];
        float baseY = (float)yPoints[0] - ta * vecLine[1];
        xPoints[1] = (int)(baseX + th * vecLeft[0]);
        yPoints[1] = (int)(baseY + th * vecLeft[1]);
        xPoints[2] = (int)(baseX - th * vecLeft[0]);
        yPoints[2] = (int)(baseY - th * vecLeft[1]);
        float innerReduce = this.lineThickness * this.innerOuterRatio;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke lineStroke = new BasicStroke(this.lineThickness, 1, 1);
        BasicStroke lineFill = new BasicStroke(this.lineThickness - innerReduce, 1, 1);
        g.setStroke(lineStroke);
        g.setColor(this.strokeColor);
        g.drawLine(x, y, (int)baseX, (int)baseY);
        for (i = 0; i < 3; ++i) {
            g.drawLine(xPoints[i % 3], yPoints[i % 3], xPoints[(i + 1) % 3], yPoints[(i + 1) % 3]);
        }
        g.setStroke(lineFill);
        g.setColor(this.fillColor);
        for (i = 0; i < 3; ++i) {
            g.drawLine(xPoints[i % 3], yPoints[i % 3], xPoints[(i + 1) % 3], yPoints[(i + 1) % 3]);
        }
        g.fillPolygon(xPoints, yPoints, 3);
        if (this.label == null || this.label.length() == 0) {
            g.drawLine(x, y, (int)baseX, (int)baseY);
            return;
        }
        if (this.labelFont == null) {
            this.labelFont = g.getFont();
        } else {
            g.setFont(this.labelFont);
        }
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(this.label, g);
        Rectangle2D boundsM = metrics.getStringBounds("n", null);
        int labelWidthInPixels = (int)bounds.getWidth();
        int labelHeightInPixels = (int)bounds.getHeight();
        int allWidthInPixels = (int)bounds.getWidth() + 1 * (int)boundsM.getWidth();
        int allHeightInPixels = (int)bounds.getHeight() + 1 * (int)boundsM.getHeight() / 2;
        int xm = this.start.x + (this.end.x - this.start.x) / 2;
        int ym = this.start.y + (this.end.y - this.start.y) / 2;
        int sx = xm - allWidthInPixels / 2;
        int sy = ym - allHeightInPixels / 2;
        g.setStroke(lineStroke);
        g.setColor(this.strokeColor);
        g.fillArc(sx, sy, allWidthInPixels, allHeightInPixels, 0, 360);
        allWidthInPixels = (int)((float)allWidthInPixels - innerReduce);
        allHeightInPixels = (int)((float)allHeightInPixels - innerReduce);
        sx = (int)((float)sx + innerReduce / 2.0f);
        sy = (int)((float)sy + innerReduce / 2.0f);
        g.setColor(this.fillColor);
        g.fillArc(sx, sy, allWidthInPixels, allHeightInPixels, 0, 360);
        g.setStroke(lineFill);
        g.setColor(this.fillColor);
        g.drawLine(x, y, (int)baseX, (int)baseY);
        sx -= labelWidthInPixels / 2;
        sy -= labelHeightInPixels / 2;
        g.setColor(this.strokeColor);
        xm = this.start.x + (this.end.x - this.start.x) / 2;
        ym = this.start.y + (this.end.y - this.start.y) / 2;
        sx = xm - labelWidthInPixels / 2;
        sy = ym + labelHeightInPixels / 4;
        g.drawString(this.label, sx, sy);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawArrow((Graphics2D)g);
    }
}

