/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.sound.PlayMP3;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class FirePanel3
extends JPanel
implements Runnable {
    int backShade = 0;
    int notShownBottomLines = 4;
    int animDelay = 30;
    Thread animator = null;
    boolean doRun = false;
    int index = 0;
    Image im = null;
    MemoryImageSource MemImageSrc = null;
    int[] backbuffer = null;
    int[] bufferLR = null;
    int[] bufferG = null;
    int[] bufferB = null;
    int[] bufferA = null;
    int[] bufferR = null;
    int[] pixels = null;
    int fireWidth = 200;
    int fireHeight = 200;
    boolean deinit = false;
    PlayMP3 play = null;
    boolean firstUpdate = true;

    public void setDelay(int d) {
        this.animDelay = d;
    }

    public FirePanel3() {
        super.setVisible(false);
        this.initComponents();
    }

    public void deinit() {
        this.setVisible(false);
        this.removeAll();
        this.im = null;
        this.MemImageSrc = null;
        this.backbuffer = null;
        this.bufferLR = null;
        this.bufferG = null;
        this.bufferB = null;
        this.bufferA = null;
        this.bufferR = null;
        this.pixels = null;
        this.deinit = true;
        if (this.play != null) {
            this.play.close();
            this.play.deinit();
            this.play = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        if (this.deinit) {
            return;
        }
        if (b == this.isVisible()) {
            return;
        }
        super.setVisible(b);
        if (b) {
            if (this.animator == null) {
                if (!Configuration.getConfiguration().isSoundQuiet()) {
                    this.play = new PlayMP3(Global.mainPathPrefix + "sound" + File.separator + "burningFire.mp3");
                    this.play.play();
                }
                this.animator = new Thread(this);
                this.doRun = true;
                this.fireHeight = this.getHeight();
                this.fireWidth = this.getWidth();
                this.init();
                this.animator.start();
            }
        } else if (this.animator != null) {
            FirePanel3 firePanel3 = this;
            synchronized (firePanel3) {
                this.doRun = false;
                this.animator.interrupt();
                this.animator = null;
                if (this.play != null) {
                    this.play.close();
                    this.play.deinit();
                    this.play = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.deinit) {
            return;
        }
        while (this.doRun) {
            try {
                Thread.sleep(this.animDelay);
            }
            catch (InterruptedException e) {
                break;
            }
            FirePanel3 firePanel3 = this;
            synchronized (firePanel3) {
            }
            this.repaint();
        }
    }

    private void initComponents() {
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    int RGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void init() {
        if (this.deinit) {
            return;
        }
        this.backbuffer = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.bufferR = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.bufferLR = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.bufferG = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.bufferB = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.bufferA = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.pixels = new int[this.fireWidth * (this.fireHeight + this.notShownBottomLines)];
        this.MemImageSrc = new MemoryImageSource(this.fireWidth, this.fireHeight, this.pixels, 0, this.fireWidth);
        this.MemImageSrc.setAnimated(true);
        this.im = this.createImage(this.MemImageSrc);
        this.firstUpdate = true;
        for (int i = 0; i < 50; ++i) {
            this.update();
        }
    }

    private void update() {
        int index = 0;
        int color = 0;
        System.arraycopy(this.bufferLR, 0, this.backbuffer, 0, this.fireWidth * (this.fireHeight + this.notShownBottomLines));
        int flameHeight = 3;
        int flameDieSpeed = 3;
        int flameDieThreshold = 10;
        for (int cc = 0; cc < flameHeight; ++cc) {
            for (int i = 0; i < this.fireWidth; ++i) {
                if ((int)(Math.random() * 2.0) != 1) continue;
                this.backbuffer[(this.fireHeight + this.notShownBottomLines - 1 - cc) * this.fireWidth + i] = 255;
            }
        }
        int start = 1;
        if (!this.firstUpdate && this.fireHeight > 90) {
            start = 90;
        }
        for (int y = start; y < this.fireHeight + this.notShownBottomLines - 1; ++y) {
            for (int x = 1; x < this.fireWidth - 1; ++x) {
                index = y * this.fireWidth + x;
                color = this.backbuffer[index];
                color += this.backbuffer[index - 1];
                color += this.backbuffer[index + 1];
                color += this.backbuffer[index + this.fireWidth];
                color += this.backbuffer[index - this.fireWidth];
                color = (int)((double)color / 5.0);
                if (y < this.fireHeight + this.notShownBottomLines - 1 - flameDieThreshold) {
                    color = color > flameDieSpeed ? (color -= flameDieSpeed) : 0;
                } else {
                    boolean aBigOne = false;
                    if (this.backbuffer[index] == 255) {
                        aBigOne = true;
                    }
                    if (this.backbuffer[index - 1] == 255) {
                        aBigOne = true;
                    }
                    if (this.backbuffer[index + 1] == 255) {
                        aBigOne = true;
                    }
                    if (aBigOne && (int)(Math.random() * 5.0) == 1) {
                        color = 255;
                    }
                }
                this.bufferA[index - this.fireWidth] = (int)((double)color * 0.8);
                this.bufferR[index - this.fireWidth] = color;
                this.bufferG[index - this.fireWidth] = color - 100;
                if (this.bufferA[index - this.fireWidth] < this.backShade) {
                    this.bufferA[index - this.fireWidth] = this.backShade;
                }
                if (this.bufferG[index - this.fireWidth] >= 0) continue;
                this.bufferG[index - this.fireWidth] = 0;
            }
        }
        System.arraycopy(this.bufferR, 0, this.bufferLR, 0, this.fireWidth * (this.fireHeight + this.notShownBottomLines));
    }

    public void draw(Graphics g) {
        this.update();
        for (int i = 0; i < this.fireWidth * this.fireHeight; ++i) {
            this.pixels[i] = this.RGB(this.bufferA[i], this.bufferR[i], this.bufferG[i], 0);
        }
        this.MemImageSrc.newPixels(0, 0, this.fireWidth, this.fireHeight);
        g.drawImage(this.im, 0, 0, null);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.deinit) {
            return;
        }
        g.setColor(Color.red);
        this.draw(g);
    }
}

