/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.panels;

import de.malban.sound.PlayClip;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class FireworksPanel
extends JPanel
implements Runnable {
    private int fireworkProbability = 30;
    private int explosionForce = 50;
    int QA = this.fireworkProbability;
    int QB = this.explosionForce;
    int[] pix;
    int[] pr;
    int[] pg;
    int[] pb;
    int[] pa;
    int[][] s;
    int[][] c;
    float[][] vx;
    float[][] vy;
    float[][] x;
    float[][] y;
    int[] b;
    int[] rgb = new int[3];
    int[][] color = new int[this.QA][4];
    int wa = -1;
    int[][] iprgb = this.createPixels();
    MemoryImageSource source;
    int[] bx = new int[1024];
    int[] by = new int[1024];
    int size = 0;
    int iw;
    int length;
    int sh;
    int count = 0;
    int mstate = 1;
    boolean deinit = false;
    private boolean drawPartTranslucent = true;
    int animDelay = 10;
    boolean isBlur = true;
    int randTimeBetweenFirework = 1000;
    int gushFrequency = 8;
    Thread animator = null;
    boolean doRun = false;
    int index = 0;
    boolean isGush = true;
    private Dimension msize;
    private int w;
    private int h;
    private Image img = null;
    private static int backShade = 0;
    private static final int MAX = 1024;
    private static final int MAG = 2;
    private static final int OX = 1;
    private static final int OY = 1;
    private static final int ANGLE = 1024;
    private static final Random rnd = new Random();
    private static int opa = 255;
    private static final int[][] CPAL = new int[][]{{255, 255, 255, opa}, {255, 255, 100, opa}, {148, 248, 198, opa}, {20, 255, 255, opa}, {255, 128, 192, opa}, {255, 235, 165, opa}, {255, 128, 255, opa}, {128, 158, 255, opa}, {255, 128, 0, opa}, {133, 222, 20, opa}};
    private static final float[] SIN = new float[1024];
    private static final float[] COS = new float[1024];
    PlayClip startingFromGround = new PlayClip("sound" + File.separator + "Bang2.wav", 5);
    PlayClip explosionInAir = new PlayClip("sound" + File.separator + "Bang4.wav", 3);

    public FireworksPanel() {
        super.setVisible(false);
        this.initComponents();
    }

    public void deinit() {
        this.setVisible(false);
        this.removeAll();
        this.explosionInAir.deinit();
        this.startingFromGround.deinit();
        this.pix = null;
        this.pa = null;
        this.pb = null;
        this.pg = null;
        this.pr = null;
        this.c = null;
        this.s = this.c;
        this.y = null;
        this.x = this.y;
        this.vy = this.y;
        this.vx = this.y;
        this.b = null;
        this.rgb = null;
        this.color = null;
        this.iprgb = null;
        this.source = null;
        this.bx = null;
        this.by = null;
        this.animator = null;
        this.img = null;
        this.deinit = true;
    }

    private void initComponents() {
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void init() {
        if (this.deinit) {
            return;
        }
        Dimension d = this.getSize();
        this.w = d.width;
        this.h = d.height;
        this.isGush = true;
        this.QA = this.fireworkProbability;
        this.QB = this.explosionForce;
        this.s = new int[this.QA][this.QB];
        this.vx = new float[this.QA][this.QB];
        this.vy = new float[this.QA][this.QB];
        this.x = new float[this.QA][this.QB];
        this.y = new float[this.QA][this.QB];
        this.c = new int[this.QA][4];
        this.b = new int[this.QA];
        for (int n = 0; n < this.QA; ++n) {
            this.b[n] = -1;
        }
        this.wa = -1;
        this.color = new int[this.QA][4];
        this.iprgb = this.createPixels();
        this.pix = new int[this.w * this.h];
        this.pr = new int[this.w * this.h];
        this.pg = new int[this.w * this.h];
        this.pb = new int[this.w * this.h];
        this.pa = new int[this.w * this.h];
        this.source = new MemoryImageSource(this.w, this.h, this.pix, 0, this.w);
        this.source.setAnimated(true);
        this.source.setFullBufferUpdates(true);
        this.img = this.createImage(this.source);
        this.bx = new int[1024];
        this.by = new int[1024];
        this.size = 0;
        this.iw = (int)((double)this.w * 0.2);
        this.length = this.w * this.h;
        this.sh = (int)(Math.sqrt(this.h) / 2.0);
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        if (this.deinit) {
            return;
        }
        if (b == this.isVisible()) {
            return;
        }
        super.setVisible(b);
        if (b) {
            this.init();
            if (this.animator == null) {
                this.animator = new Thread(this);
                this.doRun = true;
                this.animator.start();
            }
        } else if (this.animator != null) {
            FireworksPanel fireworksPanel = this;
            synchronized (fireworksPanel) {
                this.doRun = false;
                this.animator.interrupt();
                this.animator = null;
            }
        }
    }

    private int[][] createPixels() {
        int[] ipx = new int[this.w * this.h];
        int[] ipr = new int[ipx.length];
        int[] ipg = new int[ipx.length];
        int[] ipb = new int[ipx.length];
        int[] ipa = new int[ipx.length];
        return new int[][]{ipr, ipg, ipb, ipa};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.deinit) {
            return;
        }
        while (this.doRun) {
            try {
                Thread.sleep(this.animDelay);
            }
            catch (InterruptedException e) {
                break;
            }
            FireworksPanel fireworksPanel = this;
            synchronized (fireworksPanel) {
                try {
                    this.drawFirework();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.repaint();
        }
    }

    private static final int ran(int max) {
        int i = rnd.nextInt() % max;
        return i < 0 ? -i : i;
    }

    public void drawFirework() {
        if (this.deinit) {
            return;
        }
        for (int n = 0; n < this.QA; ++n) {
            switch (this.b[n]) {
                case -1: {
                    this.x[n][0] = FireworksPanel.ran(this.w - this.iw) + this.iw / 2;
                    this.b[n] = 0;
                    this.c[n][0] = FireworksPanel.ran(this.randTimeBetweenFirework);
                    this.c[n][2] = this.isGush ? FireworksPanel.ran(this.gushFrequency) : 1;
                    this.c[n][3] = 0;
                    if (this.c[n][2] == 0) {
                        this.s[n][0] = 0;
                        this.y[n][0] = this.h - 2;
                    } else {
                        this.s[n][0] = FireworksPanel.ran(this.sh * 2 / 3) + this.sh;
                        this.y[n][0] = this.h;
                    }
                    int d = FireworksPanel.ran(CPAL.length);
                    this.color[n][0] = CPAL[d][0];
                    this.color[n][1] = CPAL[d][1];
                    this.color[n][2] = CPAL[d][2];
                    this.color[n][3] = CPAL[d][3];
                    break;
                }
                case 0: {
                    int[] nArray = this.c[n];
                    nArray[0] = nArray[0] - 1;
                    if (this.c[n][0] > 0) break;
                    this.b[n] = 1;
                    this.startingFromGround.play();
                    break;
                }
                case 1: {
                    int d;
                    float[] fArray = this.y[n];
                    fArray[0] = fArray[0] - (float)this.s[n][0];
                    int[] nArray = this.c[n];
                    int n2 = nArray[1];
                    nArray[1] = n2 + 1;
                    if (n2 % 3 == 0) {
                        int[] nArray2 = this.s[n];
                        nArray2[0] = nArray2[0] - 1;
                    }
                    if (this.s[n][0] > 1) {
                        float[] fArray2 = this.x[n];
                        fArray2[0] = fArray2[0] + (float)(rnd.nextInt() % 2);
                    }
                    if ((d = (int)this.x[n][0] + (int)this.y[n][0] * this.w) >= 0) {
                        this.pb[d] = 255;
                        this.pg[d] = 255;
                        this.pr[d] = 255;
                        this.pa[d] = 255;
                    }
                    if (this.s[n][0] > 0) break;
                    this.b[n] = 2;
                    break;
                }
                case 2: {
                    float j;
                    int i;
                    float k = rnd.nextFloat() * 2.0f + 0.4f;
                    int sm = FireworksPanel.ran(1024 / this.QB + 1);
                    if (this.c[n][2] != 0) {
                        for (i = 0; i < this.QB; ++i) {
                            this.y[n][i] = this.y[n][0];
                            this.x[n][i] = this.x[n][0];
                            int m = (2048 * i / this.QB + sm) % 1024;
                            j = rnd.nextFloat() * k;
                            this.vx[n][i] = j * COS[m];
                            this.vy[n][i] = j * SIN[m];
                        }
                    } else {
                        for (i = 0; i < this.QB; ++i) {
                            this.y[n][i] = this.y[n][0];
                            this.x[n][i] = this.x[n][0];
                            int m = (1024 * i / this.QB / 8 + 704 + sm) % 1024;
                            j = rnd.nextFloat() * (k + 1.0f);
                            this.vx[n][i] = j * COS[m];
                            this.vy[n][i] = j * SIN[m];
                        }
                    }
                    this.b[n] = 3;
                    this.c[n][1] = 0;
                    this.explosionInAir.play();
                    break;
                }
                case 3: {
                    int[] pal = this.color[n];
                    if (this.c[n][3] > 25) {
                        pal[0] = pal[0] - 8;
                        if (pal[0] < 0) {
                            pal[0] = 0;
                        }
                        pal[1] = pal[1] - 8;
                        if (pal[1] < 0) {
                            pal[1] = 0;
                        }
                        pal[2] = pal[2] - 8;
                        if (pal[2] < 0) {
                            pal[2] = 0;
                        }
                        pal[3] = pal[3] - 8;
                        if (pal[3] < 0) {
                            pal[3] = 0;
                        }
                    }
                    int[] nArray = this.c[n];
                    nArray[3] = nArray[3] + 1;
                    for (int i = 0; i < this.QB; ++i) {
                        float[] fArray = this.x[n];
                        int n3 = i;
                        fArray[n3] = fArray[n3] + this.vx[n][i];
                        float[] fArray3 = this.y[n];
                        int n4 = i;
                        fArray3[n4] = fArray3[n4] + this.vy[n][i];
                        int d = (int)this.x[n][i] + (int)this.y[n][i] * this.w;
                        if (d < 0 || d >= this.length - this.w || FireworksPanel.ran(2) != 0) continue;
                        int n5 = d;
                        this.pr[n5] = this.pr[n5] + pal[0];
                        if (this.pr[d] > 255) {
                            this.pr[d] = 255;
                        }
                        int n6 = d;
                        this.pg[n6] = this.pg[n6] + pal[1];
                        if (this.pg[d] > 255) {
                            this.pg[d] = 255;
                        }
                        int n7 = d;
                        this.pb[n7] = this.pb[n7] + pal[2];
                        if (this.pb[d] > 255) {
                            this.pb[d] = 255;
                        }
                        int n8 = d;
                        this.pa[n8] = this.pa[n8] + pal[3];
                        if (this.pa[d] <= 255) continue;
                        this.pa[d] = 255;
                    }
                    break;
                }
            }
            if (this.c[n][3] <= 60) continue;
            this.b[n] = -1;
        }
        for (int j = this.w; j < this.length - this.w; ++j) {
            int c3;
            int m;
            int n = j;
            this.pr[n] = this.pr[n] - 6;
            if (this.pr[j] < 0) {
                this.pr[j] = 0;
            }
            int c0 = (m = this.iprgb[0][j] + this.pr[j]) > 255 ? 255 : m;
            int n9 = j;
            this.pg[n9] = this.pg[n9] - 6;
            if (this.pg[j] < 0) {
                this.pg[j] = 0;
            }
            int c1 = (m = this.iprgb[1][j] + this.pg[j]) > 255 ? 255 : m;
            int n10 = j;
            this.pb[n10] = this.pb[n10] - 6;
            if (this.pb[j] < 0) {
                this.pb[j] = 0;
            }
            int c2 = (m = this.iprgb[2][j] + this.pb[j]) > 255 ? 255 : m;
            int n11 = j;
            this.pa[n11] = this.pa[n11] - 6;
            if (this.pa[j] < 0) {
                this.pa[j] = 0;
            }
            int n12 = c3 = (m = this.iprgb[3][j] + this.pa[j]) > 255 ? 255 : m;
            if (this.isBlur) {
                this.pr[j] = (this.pr[j - 1] + this.pr[j + 1] + this.pr[j] + this.pr[j + this.w]) / 4;
                this.pg[j] = (this.pg[j - 1] + this.pg[j + 1] + this.pg[j] + this.pg[j + this.w]) / 4;
                this.pb[j] = (this.pb[j - 1] + this.pb[j + 1] + this.pb[j] + this.pb[j + this.w]) / 4;
                this.pa[j] = (this.pa[j - 1] + this.pa[j + 1] + this.pa[j] + this.pa[j + this.w]) / 4;
            } else {
                int n13 = j;
                this.pr[n13] = this.pr[n13] - 10;
                int n14 = j;
                this.pg[n14] = this.pg[n14] - 10;
                int n15 = j;
                this.pb[n15] = this.pb[n15] - 10;
                int n16 = j;
                this.pa[n16] = this.pa[n16] - 10;
            }
            c3 = c2 + c1 + c0;
            if (c3 > 255) {
                c3 = 255;
            }
            if (this.drawPartTranslucent) {
                if (c3 < backShade) {
                    c3 = backShade;
                }
                this.pix[j] = c3 << 24 | c0 << 16 | c1 << 8 | c2;
                continue;
            }
            this.pix[j] = c0 + c1 + c2 != 0 ? 0xFF000000 | c0 << 16 | c1 << 8 | c2 : 0;
        }
        this.source.newPixels();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.deinit) {
            return;
        }
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    static {
        for (int g = 0; g < 1024; ++g) {
            double r = Math.PI * (double)g * 2.0 / 1024.0;
            FireworksPanel.SIN[g] = (float)Math.sin(r);
            FireworksPanel.COS[g] = (float)Math.cos(r);
        }
    }
}

