/*
 * Decompiled with CFR 0.152.
 */
package de.malban.input;

import de.malban.config.Configuration;
import de.malban.gui.TimingTriggerer;
import de.malban.gui.TriggerCallback;
import de.malban.gui.panels.LogPanel;
import de.malban.input.ControllerEvent;
import de.malban.input.ControllerListern;
import de.malban.vide.VideConfig;
import de.malban.vide.vecx.VecXPanel;
import java.util.ArrayList;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public class EventController {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static int POLL_RESOLUTION;
    private static int pollResultion;
    boolean isRemoved = false;
    private Controller controller;
    boolean isActive = false;
    boolean isMouseMode = false;
    private boolean isAvailable = true;
    private ArrayList<ControllerListern> mListener = new ArrayList();
    static TimingTriggerer timer;
    TriggerCallback triggerCallback = new TriggerCallback(){

        @Override
        public void doIt(int state, Object o) {
            EventController.this.checkStateChange();
            if (!EventController.this.isRemoved) {
                timer.addTrigger(EventController.this.triggerCallback, pollResultion, 0, null);
            }
        }
    };
    private ArrayList<ComponentWithHistory> mButtons = new ArrayList();
    private ArrayList<ComponentWithHistory> mPovs = new ArrayList();
    private ArrayList<ComponentWithHistory> mAxis = new ArrayList();
    private ArrayList<ComponentWithHistory> mRelative = new ArrayList();
    public static final int OFF = 0;
    public static final int CENTER = 0;
    public static final int UP_LEFT = 1;
    public static final int UP = 2;
    public static final int UP_RIGHT = 3;
    public static final int RIGHT = 4;
    public static final int DOWN_RIGHT = 5;
    public static final int DOWN = 6;
    public static final int DOWN_LEFT = 7;
    public static final int LEFT = 8;

    public void setRemoved(boolean b) {
        this.isRemoved = b;
    }

    public void setMouseMode(boolean b) {
        this.isMouseMode = b;
    }

    public EventController(Controller c) {
        timer = TimingTriggerer.getTimer();
        this.setController(c);
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.init();
    }

    public boolean isIsAvailable() {
        return this.isAvailable;
    }

    public void setIsAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public static int getPollResultion() {
        return pollResultion;
    }

    public static void setPollResultion(int pr) {
        pollResultion = pr;
    }

    public void addEventListerner(ControllerListern listener) {
        this.mListener.remove(listener);
        this.mListener.add(listener);
    }

    public void removeEventListerner(ControllerListern listener) {
        this.mListener.remove(listener);
    }

    public void clearEventListerner() {
        this.mListener.clear();
    }

    public void fireControllerChanged(ControllerEvent event) {
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).controllerEvent(event);
        }
    }

    public void setActive(boolean b) {
        if (this.isActive == b) {
            return;
        }
        if (b) {
            timer.setResolution(pollResultion);
            timer.addTrigger(this.triggerCallback, pollResultion, 0, null);
        } else {
            timer.removeTrigger(this.triggerCallback);
        }
        this.isActive = b;
    }

    private void checkStateChange() {
        int last;
        int i;
        if (this.controller == null) {
            ControllerEvent event = new ControllerEvent();
            this.isAvailable = false;
            this.setActive(false);
            event.type = 0;
            this.fireControllerChanged(event);
            return;
        }
        if (!this.controller.poll()) {
            ControllerEvent event = new ControllerEvent();
            this.isAvailable = false;
            this.setActive(false);
            event.type = 0;
            this.fireControllerChanged(event);
            return;
        }
        for (i = 0; i < this.getButtonCount(); ++i) {
            last = this.mButtons.get((int)i).lastButtonState;
            float lastValue = this.mButtons.get((int)i).lastValue;
            if (last == this.getButtonState(i)) continue;
            ControllerEvent event = new ControllerEvent();
            event.component = this.mButtons.get((int)i).component;
            event.type = 3;
            event.componentId = this.getButtonId(i);
            event.lastValue = lastValue;
            event.lastButtonState = last;
            event.currentButtonState = this.mButtons.get((int)i).lastButtonState;
            event.currentValue = this.mButtons.get((int)i).lastValue;
            event.index = i;
            this.fireControllerChanged(event);
        }
        for (i = 0; i < this.getAxisCount(); ++i) {
            ControllerEvent event;
            last = this.mAxis.get((int)i).lastAxisPercent;
            int current = this.getAxisPercent(i);
            float lastValue = this.mAxis.get((int)i).lastValue;
            if (VideConfig.getConfig().DACCompareDelayEmulation) {
                event = new ControllerEvent();
                event.component = this.mAxis.get((int)i).component;
                event.type = 4;
                event.componentId = this.getAxisId(i);
                event.lastValue = lastValue;
                event.lastAxisPercent = last;
                event.currentAxisPercent = current;
                event.currentValue = this.mAxis.get((int)i).lastValue;
                event.index = i;
                this.fireControllerChanged(event);
                continue;
            }
            if (last == current) continue;
            event = new ControllerEvent();
            event.component = this.mAxis.get((int)i).component;
            event.type = 4;
            event.componentId = this.getAxisId(i);
            event.lastValue = lastValue;
            event.lastAxisPercent = last;
            event.currentAxisPercent = current;
            event.currentValue = this.mAxis.get((int)i).lastValue;
            event.index = i;
            this.fireControllerChanged(event);
        }
        for (i = 0; i < this.getPOVCount(); ++i) {
            last = this.mPovs.get((int)i).lastPOV;
            float lastValue = this.mPovs.get((int)i).lastValue;
            if (last == this.getPOVPosition(i)) continue;
            ControllerEvent event = new ControllerEvent();
            event.component = this.mPovs.get((int)i).component;
            event.type = 6;
            event.componentId = this.getPOVId(i);
            event.lastValue = lastValue;
            event.lastPOV = last;
            event.currentPOV = this.mPovs.get((int)i).lastPOV;
            event.currentValue = this.mPovs.get((int)i).lastValue;
            event.index = i;
            this.fireControllerChanged(event);
        }
        for (i = 0; i < this.getRelativeCount(); ++i) {
            VecXPanel v;
            float last2 = this.mRelative.get((int)i).lastRelative;
            float lastValue = this.mRelative.get((int)i).lastValue;
            if (last2 == this.getRelativeValue(i)) continue;
            ControllerEvent event = new ControllerEvent();
            event.component = this.mRelative.get((int)i).component;
            event.type = 5;
            event.componentId = this.getRelativeId(i);
            event.lastValue = lastValue;
            event.lastRelative = last2;
            event.currentRelative = this.mRelative.get((int)i).lastRelative;
            event.currentValue = this.mRelative.get((int)i).lastValue;
            event.index = i;
            event.isRelative = true;
            if (this.isMouseMode && (v = Configuration.getConfiguration().getMainFrame().getVecxy()) != null) {
                v.setMouseCoordinates(event);
            }
            this.fireControllerChanged(event);
        }
    }

    public static boolean isButton(Component.Identifier c) {
        if (c.getName().matches("^[0-9]*$")) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.LEFT.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.MIDDLE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.RIGHT.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TRIGGER.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.THUMB.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.THUMB2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOP.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOP2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.PINKIE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE3.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE4.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE5.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BASE6.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.DEAD.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.A.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.B.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.C.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.X.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.Y.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.Z.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.LEFT_THUMB.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.RIGHT_THUMB.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.LEFT_THUMB2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.RIGHT_THUMB2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.SELECT.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.START.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.MODE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.LEFT_THUMB3.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.RIGHT_THUMB3.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_PEN.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_RUBBER.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_BRUSH.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_PENCIL.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_AIRBRUSH.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_FINGER.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_MOUSE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOOL_LENS.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.TOUCH.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.STYLUS.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.STYLUS2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.UNKNOWN.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.BACK.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.FORWARD.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.SIDE.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_1.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_2.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_3.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_4.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_5.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_6.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_7.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_8.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_9.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_10.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_11.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_12.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_13.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_14.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_15.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_16.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_17.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_18.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_19.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_20.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_21.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_22.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_23.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_24.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_25.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_26.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_27.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_28.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_29.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_30.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_31.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_32.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_33.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_34.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_35.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_36.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_37.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_38.getName())) {
            return true;
        }
        if (c.getName().equals(Component.Identifier.Button.EXTRA_39.getName())) {
            return true;
        }
        return c.getName().equals(Component.Identifier.Button.EXTRA_40.getName());
    }

    void init() {
        if (this.getController() == null) {
            return;
        }
        Component[] components = this.getController().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            Component.Identifier componentIdentifier = component.getIdentifier();
            if (EventController.isButton(componentIdentifier)) {
                this.mButtons.add(new ComponentWithHistory(component));
                continue;
            }
            if (componentIdentifier == Component.Identifier.Axis.POV) {
                this.mPovs.add(new ComponentWithHistory(component));
                continue;
            }
            if (component.isRelative()) {
                this.mRelative.add(new ComponentWithHistory(component));
                continue;
            }
            if (!component.isAnalog()) continue;
            this.mAxis.add(new ComponentWithHistory(component));
        }
    }

    public int getButtonCount() {
        return this.mButtons.size();
    }

    public boolean getButtonState(int index) {
        this.mButtons.get((int)index).lastValue = this.mButtons.get((int)index).component.getPollData();
        this.mButtons.get((int)index).lastButtonState = this.mButtons.get((int)index).lastValue != 0.0f;
        return this.mButtons.get((int)index).lastButtonState;
    }

    public String getButtonId(int index) {
        return this.mButtons.get((int)index).component.getIdentifier().getName();
    }

    public int getAxisCount() {
        return this.mAxis.size();
    }

    public String getAxisId(int index) {
        return this.mAxis.get((int)index).component.getIdentifier().getName();
    }

    public int getAxisPercent(int index) {
        this.mAxis.get((int)index).lastValue = this.mAxis.get((int)index).component.getPollData();
        this.mAxis.get((int)index).lastAxisPercent = (int)((2.0f - (1.0f - this.mAxis.get((int)index).lastValue)) * 100.0f / 2.0f);
        return this.mAxis.get((int)index).lastAxisPercent;
    }

    public int getPOVPosition(int index) {
        this.mPovs.get((int)index).lastValue = this.mPovs.get((int)index).component.getPollData();
        float hatSwitchPosition = this.mPovs.get((int)index).lastValue;
        if (Float.compare(hatSwitchPosition, 0.25f) == 0) {
            this.mPovs.get((int)index).lastPOV = 2;
            return 2;
        }
        if (Float.compare(hatSwitchPosition, 0.75f) == 0) {
            this.mPovs.get((int)index).lastPOV = 6;
            return 6;
        }
        if (Float.compare(hatSwitchPosition, 1.0f) == 0) {
            this.mPovs.get((int)index).lastPOV = 8;
            return 8;
        }
        if (Float.compare(hatSwitchPosition, 0.5f) == 0) {
            this.mPovs.get((int)index).lastPOV = 4;
            return 4;
        }
        if (Float.compare(hatSwitchPosition, 0.125f) == 0) {
            this.mPovs.get((int)index).lastPOV = 1;
            return 1;
        }
        if (Float.compare(hatSwitchPosition, 0.375f) == 0) {
            this.mPovs.get((int)index).lastPOV = 3;
            return 3;
        }
        if (Float.compare(hatSwitchPosition, 0.875f) == 0) {
            this.mPovs.get((int)index).lastPOV = 7;
            return 7;
        }
        if (Float.compare(hatSwitchPosition, 0.625f) == 0) {
            this.mPovs.get((int)index).lastPOV = 5;
            return 5;
        }
        this.mPovs.get((int)index).lastPOV = 0;
        return 0;
    }

    public int getPOVCount() {
        return this.mPovs.size();
    }

    public String getPOVId(int index) {
        return this.mPovs.get((int)index).component.getIdentifier().getName();
    }

    public int getRelativeCount() {
        return this.mRelative.size();
    }

    public String getRelativeId(int index) {
        return this.mRelative.get((int)index).component.getIdentifier().getName();
    }

    public float getRelativeValue(int index) {
        this.mRelative.get((int)index).lastRelative = this.mRelative.get((int)index).lastValue = this.mRelative.get((int)index).component.getPollData();
        return this.mRelative.get((int)index).lastValue;
    }

    static {
        pollResultion = POLL_RESOLUTION = 50;
    }

    static class ComponentWithHistory {
        public Component component;
        public float lastValue = -11.283882f;
        public boolean lastButtonState = false;
        public int lastAxisPercent = 50;
        public int lastPOV = 0;
        public float lastRelative = 0.0f;

        ComponentWithHistory(Component c) {
            this.component = c;
        }
    }
}

