/*
 * Decompiled with CFR 0.152.
 */
package de.malban.input;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.input.ControllerEvent;
import de.malban.input.ControllerListern;
import de.malban.input.EventController;
import de.malban.input.SystemController;
import de.malban.util.UtilityString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public class InputControllerDisplay
extends JPanel
implements Windowable,
Stateable {
    private ArrayList<ControllerListern> mListener = new ArrayList();
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    public static String SID = "Input Controller";
    JPanel relativesPanel;
    JPanel axesPanel;
    JPanel buttonsPanel;
    EventController selectedController = null;
    int xAxisPercentage = 0;
    int yAxisPercentage = 0;
    int hatSwitchPosition = 0;
    ArrayList<Float> headSwitchPositions = new ArrayList();
    ArrayList<Controller> controllers;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            InputControllerDisplay.this.updateMyUI();
        }
    };
    private JButton jButton1;
    private JComboBox jComboBox_controllers;
    private JLabel jLabel1;
    private JLabel jLabelXYAxis;
    private JLabel jLabelXYAxis1;
    private JLabel jLabelXYAxis2;
    private JPanel jPanelAxes;
    private JPanel jPanelButtons;
    private JPanel jPanelForRelatives;
    private JPanel jPanelHatSwitch;
    private JPanel jPanelXYAxis;
    private JPanel jPanel_forAxis;

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        return null;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", "");
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        this.removeUIListerner();
    }

    public InputControllerDisplay() {
        this.initComponents();
        this.searchControllers();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        this.jPanelXYAxis.setBorder(BorderFactory.createLineBorder((Color)table.get("TextField.foreground")));
    }

    private void initComponents() {
        this.jPanelHatSwitch = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                InputControllerDisplay.this.paintHatSwitches(g);
            }
        };
        this.jPanelButtons = new JPanel();
        this.jPanelAxes = new JPanel();
        this.jLabelXYAxis = new JLabel();
        this.jPanelXYAxis = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                InputControllerDisplay.this.paintAxis(g);
            }
        };
        this.jPanel_forAxis = new JPanel();
        this.jLabelXYAxis1 = new JLabel();
        this.jPanelForRelatives = new JPanel();
        this.jLabelXYAxis2 = new JLabel();
        this.jComboBox_controllers = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanelHatSwitch.setBorder(BorderFactory.createTitledBorder("Hat Switch"));
        GroupLayout jPanelHatSwitchLayout = new GroupLayout(this.jPanelHatSwitch);
        this.jPanelHatSwitch.setLayout(jPanelHatSwitchLayout);
        jPanelHatSwitchLayout.setHorizontalGroup(jPanelHatSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelHatSwitchLayout.setVerticalGroup(jPanelHatSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanelButtons.setBorder(BorderFactory.createTitledBorder("Buttons"));
        GroupLayout jPanelButtonsLayout = new GroupLayout(this.jPanelButtons);
        this.jPanelButtons.setLayout(jPanelButtonsLayout);
        jPanelButtonsLayout.setHorizontalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 248, Short.MAX_VALUE));
        jPanelButtonsLayout.setVerticalGroup(jPanelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 185, Short.MAX_VALUE));
        this.jPanelAxes.setBorder(BorderFactory.createTitledBorder("Axes"));
        this.jLabelXYAxis.setText("X Axis / Y Axis");
        this.jPanelXYAxis.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelXYAxis.setPreferredSize(new Dimension(111, 111));
        GroupLayout jPanelXYAxisLayout = new GroupLayout(this.jPanelXYAxis);
        this.jPanelXYAxis.setLayout(jPanelXYAxisLayout);
        jPanelXYAxisLayout.setHorizontalGroup(jPanelXYAxisLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 109, Short.MAX_VALUE));
        jPanelXYAxisLayout.setVerticalGroup(jPanelXYAxisLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 109, Short.MAX_VALUE));
        GroupLayout jPanel_forAxisLayout = new GroupLayout(this.jPanel_forAxis);
        this.jPanel_forAxis.setLayout(jPanel_forAxisLayout);
        jPanel_forAxisLayout.setHorizontalGroup(jPanel_forAxisLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        jPanel_forAxisLayout.setVerticalGroup(jPanel_forAxisLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabelXYAxis1.setText("additional axes");
        GroupLayout jPanelForRelativesLayout = new GroupLayout(this.jPanelForRelatives);
        this.jPanelForRelatives.setLayout(jPanelForRelativesLayout);
        jPanelForRelativesLayout.setHorizontalGroup(jPanelForRelativesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelForRelativesLayout.setVerticalGroup(jPanelForRelativesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabelXYAxis2.setText("relative movement");
        GroupLayout jPanelAxesLayout = new GroupLayout(this.jPanelAxes);
        this.jPanelAxes.setLayout(jPanelAxesLayout);
        jPanelAxesLayout.setHorizontalGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAxesLayout.createSequentialGroup().addGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelXYAxis).addComponent(this.jPanelXYAxis, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel_forAxis, -2, -1, -2).addComponent(this.jLabelXYAxis1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAxesLayout.createSequentialGroup().addComponent(this.jLabelXYAxis2).addContainerGap(63, Short.MAX_VALUE)).addComponent(this.jPanelForRelatives, -1, -1, Short.MAX_VALUE))));
        jPanelAxesLayout.setVerticalGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAxesLayout.createSequentialGroup().addGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelXYAxis).addComponent(this.jLabelXYAxis1).addComponent(this.jLabelXYAxis2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAxesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAxesLayout.createSequentialGroup().addComponent(this.jPanelXYAxis, -2, -1, -2).addContainerGap(52, Short.MAX_VALUE)).addComponent(this.jPanelForRelatives, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel_forAxis, -1, -1, Short.MAX_VALUE))));
        this.jComboBox_controllers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputControllerDisplay.this.jComboBox_controllersActionPerformed(evt);
            }
        });
        this.jButton1.setText("reScan");
        this.jButton1.setPreferredSize(new Dimension(65, 21));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputControllerDisplay.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox_controllers, -2, 237, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelButtons, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelHatSwitch, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanelAxes, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jComboBox_controllers, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 20, -2).addComponent(this.jButton1, -2, -1, -2)))).addGap(0, 0, 0).addComponent(this.jPanelAxes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelButtons, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelHatSwitch, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jComboBox_controllersActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.initController();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.searchControllers();
    }

    void searchControllers() {
        ++this.mClassSetting;
        this.deinitController();
        this.controllers = SystemController.getCurrentControllers();
        this.jComboBox_controllers.removeAllItems();
        for (Controller c : this.controllers) {
            this.jComboBox_controllers.addItem(c.getName());
        }
        this.jComboBox_controllers.setSelectedIndex(-1);
        --this.mClassSetting;
    }

    void deinitController() {
        if (this.selectedController != null) {
            this.selectedController.clearEventListerner();
            this.selectedController.setActive(false);
        }
        this.selectedController = null;
        this.deinitDisplay();
    }

    void initController() {
        int i;
        this.deinitController();
        int index = this.jComboBox_controllers.getSelectedIndex();
        if (index < 0) {
            this.selectedController = null;
            return;
        }
        this.selectedController = new EventController(this.controllers.get(index));
        this.selectedController.addEventListerner(new ControllerListern(){

            @Override
            public void controllerEvent(ControllerEvent e) {
                if (e.type == 0) {
                    InputControllerDisplay.this.jLabel1.setText("Disconnected");
                    return;
                }
                InputControllerDisplay.this.jLabel1.setText("connected");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InputControllerDisplay.this.updateControllerStatus();
                    }
                });
                InputControllerDisplay.this.fireControllerChanged(e);
            }
        });
        int BUTTONWIDTH = 60;
        this.buttonsPanel = new JPanel(new FlowLayout(0, 1, 1));
        this.buttonsPanel.setBounds(6, 19, BUTTONWIDTH * 4 + 6, 180);
        for (i = 0; i < this.selectedController.getButtonCount(); ++i) {
            JToggleButton aToggleButton = new JToggleButton(this.selectedController.getButtonId(i));
            aToggleButton.setPreferredSize(new Dimension(BUTTONWIDTH, 25));
            this.buttonsPanel.add(aToggleButton);
            aToggleButton.setSelected(this.selectedController.getButtonState(i));
        }
        this.axesPanel = new JPanel(new FlowLayout(0, 25, 2));
        this.axesPanel.setBounds(0, 0, 200, 190);
        for (i = 0; i < this.selectedController.getAxisCount(); ++i) {
            if (this.selectedController.getAxisId(i).equals(Component.Identifier.Axis.X.getName())) {
                this.xAxisPercentage = this.selectedController.getAxisPercent(i);
                continue;
            }
            if (this.selectedController.getAxisId(i).equals(Component.Identifier.Axis.Y.getName())) {
                this.yAxisPercentage = this.selectedController.getAxisPercent(i);
                continue;
            }
            JLabel progressBarLabel = new JLabel(this.selectedController.getAxisId(i));
            JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setValue(this.selectedController.getAxisPercent(i));
            this.axesPanel.add(progressBarLabel);
            this.axesPanel.add(progressBar);
        }
        this.relativesPanel = new JPanel(new FlowLayout(0, 10, 2));
        this.relativesPanel.setBounds(0, 0, 150, 150);
        for (i = 0; i < this.selectedController.getRelativeCount(); ++i) {
            JLabel label = new JLabel(this.selectedController.getRelativeId(i));
            label.setText("" + this.selectedController.getRelativeValue(index));
            label.setPreferredSize(new Dimension(65, 21));
            JTextField tf = new JTextField();
            tf.setPreferredSize(new Dimension(65, 21));
            tf.setText("" + (int)Math.abs(this.selectedController.getRelativeValue(index)));
            this.relativesPanel.add(label);
            this.relativesPanel.add(tf);
        }
        this.jPanelButtons.removeAll();
        this.jPanelButtons.add(this.buttonsPanel);
        this.jPanel_forAxis.removeAll();
        this.jPanel_forAxis.add(this.axesPanel);
        this.jPanel_forAxis.validate();
        this.jPanelForRelatives.removeAll();
        this.jPanelForRelatives.add(this.relativesPanel);
        this.jPanelForRelatives.validate();
        this.selectedController.setActive(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public int getCompareValue(String relativeId) {
        if (relativeId == null) {
            return 0;
        }
        if (this.selectedController == null) {
            return 0;
        }
        for (int i = 0; i < this.selectedController.getRelativeCount(); ++i) {
            if (!this.selectedController.getRelativeId(i).equals(relativeId)) continue;
            Component comp = this.relativesPanel.getComponent(i * 2 + 1);
            JTextField tf = (JTextField)comp;
            int value = UtilityString.Int0(tf.getText());
            return value;
        }
        return 0;
    }

    void deinitDisplay() {
        this.axesPanel = new JPanel(new FlowLayout(0, 25, 2));
        this.axesPanel.setBounds(0, 0, 200, 190);
        this.buttonsPanel = new JPanel(new FlowLayout(0, 1, 1));
        this.buttonsPanel.setBounds(6, 19, 246, 110);
        this.relativesPanel = new JPanel(new FlowLayout(0, 25, 2));
        this.relativesPanel.setBounds(0, 0, 110, 110);
        this.jPanelButtons.removeAll();
        this.jPanelButtons.add(this.buttonsPanel);
        this.jPanelForRelatives.removeAll();
        this.jPanelForRelatives.add(this.relativesPanel);
        this.xAxisPercentage = 50;
        this.yAxisPercentage = 50;
        this.headSwitchPositions = new ArrayList();
        this.jPanel_forAxis.removeAll();
        this.jPanel_forAxis.add(this.axesPanel);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void updateControllerStatus() {
        Component comp;
        int i;
        if (this.selectedController == null) {
            return;
        }
        for (int i2 = 0; i2 < this.selectedController.getButtonCount(); ++i2) {
            JToggleButton aToggleButton = (JToggleButton)this.buttonsPanel.getComponent(i2);
            aToggleButton.setSelected(this.selectedController.getButtonState(i2));
        }
        int additionalAxis = 0;
        for (i = 0; i < this.selectedController.getAxisCount(); ++i) {
            if (this.selectedController.getAxisId(i).equals(Component.Identifier.Axis.X.getName())) {
                this.xAxisPercentage = this.selectedController.getAxisPercent(i);
                continue;
            }
            if (this.selectedController.getAxisId(i).equals(Component.Identifier.Axis.Y.getName())) {
                this.yAxisPercentage = this.selectedController.getAxisPercent(i);
                continue;
            }
            int n = ++additionalAxis;
            ++additionalAxis;
            comp = this.axesPanel.getComponent(n);
            JProgressBar progressBar = (JProgressBar)comp;
            progressBar.setValue(this.selectedController.getAxisPercent(i));
        }
        for (i = 0; i < this.selectedController.getPOVCount(); ++i) {
            this.hatSwitchPosition = this.selectedController.getPOVPosition(i);
        }
        for (i = 0; i < this.selectedController.getRelativeCount(); ++i) {
            comp = this.relativesPanel.getComponent(i * 2);
            JLabel label = (JLabel)comp;
            label.setText("" + this.selectedController.getRelativeValue(i));
            comp = this.relativesPanel.getComponent(i * 2 + 1);
            JTextField tf = (JTextField)comp;
            int oldValue = UtilityString.Int0(tf.getText());
            int newValue = (int)Math.abs(this.selectedController.getRelativeValue(i));
            if (newValue <= oldValue) continue;
            tf.setText("" + newValue);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void paintAxis(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.jPanelXYAxis.getWidth() - 2;
        int h = this.jPanelXYAxis.getHeight() - 2;
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        g2d.setBackground((Color)table.get("Panel.background"));
        g2d.setColor((Color)table.get("Panel.foreground"));
        g2d.clearRect(1, 1, w, h);
        g2d.setColor(Color.red);
        g2d.fillOval(this.xAxisPercentage, this.yAxisPercentage, 10, 10);
    }

    void paintHatSwitches(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.setHatSwitch(this.hatSwitchPosition, g2d);
    }

    public void setHatSwitch(int hatSwitchPosition, Graphics2D g2d) {
        int circleSize = 100;
        if (g2d == null) {
            return;
        }
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        g2d.setBackground((Color)table.get("Panel.background"));
        g2d.setColor((Color)table.get("Panel.foreground"));
        g2d.clearRect(5, 15, this.jPanelHatSwitch.getWidth() - 10, this.jPanelHatSwitch.getHeight() - 22);
        g2d.drawOval(20, 22, circleSize, circleSize);
        if (hatSwitchPosition == 0) {
            return;
        }
        int smallCircleSize = 10;
        int upCircleX = 65;
        int upCircleY = 17;
        int leftCircleX = 15;
        int leftCircleY = 68;
        int betweenX = 37;
        int betweenY = 17;
        int x = 0;
        int y = 0;
        g2d.setColor(Color.blue);
        if (hatSwitchPosition == 2) {
            x = upCircleX;
            y = upCircleY;
        } else if (hatSwitchPosition == 6) {
            x = upCircleX;
            y = upCircleY + circleSize;
        } else if (hatSwitchPosition == 8) {
            x = leftCircleX;
            y = leftCircleY;
        } else if (hatSwitchPosition == 4) {
            x = leftCircleX + circleSize;
            y = leftCircleY;
        } else if (hatSwitchPosition == 1) {
            x = upCircleX - betweenX;
            y = upCircleY + betweenY;
        } else if (hatSwitchPosition == 3) {
            x = upCircleX + betweenX;
            y = upCircleY + betweenY;
        } else if (hatSwitchPosition == 7) {
            x = upCircleX - betweenX;
            y = upCircleY + circleSize - betweenY;
        } else if (hatSwitchPosition == 5) {
            x = upCircleX + betweenX;
            y = upCircleY + circleSize - betweenY;
        }
        g2d.fillOval(x, y, smallCircleSize, smallCircleSize);
    }

    public void addEventListerner(ControllerListern listener) {
        this.mListener.remove(listener);
        this.mListener.add(listener);
    }

    public void removeEventListerner(ControllerListern listener) {
        this.mListener.remove(listener);
    }

    public void clearEventListerner() {
        this.mListener.clear();
    }

    public void fireControllerChanged(ControllerEvent event) {
        for (int i = 0; i < this.mListener.size(); ++i) {
            this.mListener.get(i).controllerEvent(event);
        }
    }

    public Controller getSelectedController() {
        if (this.selectedController == null) {
            return null;
        }
        return this.selectedController.getController();
    }

    public void setSelectedController(String controllerName) {
        for (int i = 0; i < this.jComboBox_controllers.getItemCount(); ++i) {
            if (!this.jComboBox_controllers.getItemAt(i).toString().equals(controllerName)) continue;
            this.jComboBox_controllers.setSelectedIndex(i);
            return;
        }
        this.jComboBox_controllers.setSelectedIndex(-1);
    }

    @Override
    public void deIconified() {
    }
}

