/*
 * Decompiled with CFR 0.152.
 */
package de.malban.input;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class SystemController {
    public static boolean init = false;
    public static boolean supported = false;
    private static ArrayList<Controller> foundControllers;
    private static Boolean jinputAvailable;

    public static boolean isJInputAvailable() {
        if (jinputAvailable == null) {
            SystemController.createDefaultEnvironment();
        }
        return jinputAvailable;
    }

    public static boolean isJInputSupported() {
        SystemController.createDefaultEnvironment();
        return jinputAvailable;
    }

    private static ControllerEnvironment createDefaultEnvironment() {
        try {
            Constructor<?> constructor = Class.forName("net.java.games.input.DefaultControllerEnvironment").getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            String test = System.mapLibraryName("jinput-osx");
            ControllerEnvironment env = (ControllerEnvironment)constructor.newInstance(new Object[0]);
            if (!init) {
                System.setErr(Global.devNull);
                Controller[] controllers = env.getControllers();
                System.setErr(Global.devErr);
                init = true;
                Configuration.getConfiguration().getDebugEntity().addLog("JInput is supported", LogPanel.INFO);
            }
            jinputAvailable = true;
            return env;
        }
        catch (Throwable e) {
            Configuration.getConfiguration().getLogEntity().addLog(e, LogPanel.WARN);
            try {
                System.setErr(Global.devErr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            jinputAvailable = false;
            if (!init) {
                init = true;
                Configuration.getConfiguration().getDebugEntity().addLog("JInput is not supported", LogPanel.INFO);
            }
            return null;
        }
    }

    public static ArrayList<Controller> getCurrentControllers() {
        foundControllers = new ArrayList();
        ControllerEnvironment env = SystemController.createDefaultEnvironment();
        if (env == null) {
            return foundControllers;
        }
        Controller[] controllers = env.getControllers();
        for (int i = 0; i < controllers.length; ++i) {
            Controller controller = controllers[i];
            if (controller.getType() != Controller.Type.STICK && controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.WHEEL && controller.getType() != Controller.Type.MOUSE && controller.getType() != Controller.Type.TRACKBALL && controller.getType() != Controller.Type.FINGERSTICK) continue;
            foundControllers.add(controller);
        }
        return foundControllers;
    }

    public static Controller getController(String name) {
        if (foundControllers == null) {
            return null;
        }
        for (Controller c : foundControllers) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public static Controller getControllerReload(String name) {
        SystemController.getCurrentControllers();
        if (foundControllers == null) {
            return null;
        }
        for (Controller c : foundControllers) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    static {
        jinputAvailable = null;
    }
}

