/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.Global;
import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.jdbc.DBConnectionXMLHandler;
import de.malban.jdbc.JavaSQLResult;
import de.malban.jdbc.SQLResult;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class DBConnectionData
implements Serializable {
    public String mName = new String();
    public String mType = new String();
    public String mUser = new String();
    public String mPasswd = new String();
    public String mDBName = new String();
    public String mHost = new String();
    public String mPort = new String();
    public String mServer = new String();
    public String mURL = new String();
    public String mClass = new String();
    public String mDriverString = "";
    public transient String mLastError;
    public transient Throwable mLastException;
    private transient Connection mConnection = null;
    private static DBConnectionXMLHandler XMLHANDLER = new DBConnectionXMLHandler();

    private String exportXML() {
        String s = new String();
        s = s + "\t<Connection>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<Type>" + UtilityString.toXML(this.mType) + "</Type>\n";
        s = s + "\t\t<User>" + UtilityString.toXML(this.mUser) + "</User>\n";
        s = s + "\t\t<Password>" + UtilityString.toXML(this.mPasswd) + "</Password>\n";
        s = s + "\t\t<DatabaseName>" + UtilityString.toXML(this.mDBName) + "</DatabaseName>\n";
        s = s + "\t\t<Host>" + UtilityString.toXML(this.mHost) + "</Host>\n";
        s = s + "\t\t<Port>" + UtilityString.toXML(this.mPort) + "</Port>\n";
        s = s + "\t\t<DriverString>" + UtilityString.toXML(this.mDriverString) + "</DriverString>\n";
        s = s + "\t\t<Server>" + UtilityString.toXML(this.mServer) + "</Server>\n";
        s = s + "\t\t<URL>" + UtilityString.toXML(this.mURL) + "</URL>\n";
        s = s + "\t\t<CLASS>" + UtilityString.toXML(this.mClass) + "</CLASS>\n";
        s = s + "\t</Connection>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public JavaSQLResult getSQLResult() {
        SQLResult myResult = new SQLResult();
        myResult.setDBConnectionData(this);
        return myResult;
    }

    public String getConnectionString() {
        String url = new String();
        if (this.mURL != null && this.mURL.length() != 0) {
            url = this.mURL;
            return url;
        }
        if (this.mType.equalsIgnoreCase("oracle")) {
            url = "jdbc:oracle:thin:@";
            url = url + this.mHost + ":" + this.mPort + ":" + this.mDBName;
        }
        if (this.mType.equalsIgnoreCase("Derby (Java DB)")) {
            url = "jdbc:derby:";
            url = url + this.mDBName + ";user=" + this.mUser + ";password=" + this.mPasswd;
        } else if (this.mType.equalsIgnoreCase("mysql")) {
            url = "jdbc:mysql://";
            url = url + this.mHost + ":" + this.mPort + "/" + this.mDBName;
        } else if (this.mType.equalsIgnoreCase("informix")) {
            url = "jdbc:informix-sqli://";
            url = url + this.mHost + ":" + this.mPort + "/" + this.mDBName + ":informixserver=" + this.mServer + ";user=" + this.mUser + ";password=" + this.mPasswd;
        } else if (this.mType.equalsIgnoreCase("mssql")) {
            url = "jdbc:sqlserver://";
            url = url + this.mHost + ":" + this.mPort + ";databaseName=" + this.mDBName + ";user=" + this.mUser + ";password=" + this.mPasswd;
            if (this.mPort.length() != 0) {
                url = "jdbc:sqlserver://";
                url = url + this.mHost + ":" + this.mPort + ";databaseName=" + this.mDBName + ";user=" + this.mUser + ";password=" + this.mPasswd;
            } else if (this.mServer.length() != 0) {
                url = "jdbc:sqlserver://";
                url = url + this.mHost + "\\" + this.mServer + ";databaseName=" + this.mDBName + ";user=" + this.mUser + ";password=" + this.mPasswd;
            } else {
                url = "jdbc:sqlserver://";
                url = url + this.mHost + ";databaseName=" + this.mDBName + ";user=" + this.mUser + ";password=" + this.mPasswd;
            }
        } else if (this.mType.equalsIgnoreCase("postgre")) {
            url = "jdbc:postgresql://";
            url = url + this.mHost + ":" + this.mPort + "/" + this.mDBName;
        }
        return url;
    }

    public boolean isOpen() {
        return this.mConnection != null;
    }

    public Connection getConnection() {
        if (this.mConnection == null) {
            this.mLastError = "Connection is not Open!";
            return null;
        }
        this.mLastError = "OK";
        return this.mConnection;
    }

    public void commit() {
        try {
            if (this.mConnection != null) {
                this.mConnection.commit();
                this.mLastException = null;
                this.mLastError = "OK";
            }
        }
        catch (Exception e) {
            this.mLastException = e;
            this.mLastError = "Connection commit Error";
        }
    }

    public void rollback() {
        try {
            if (this.mConnection != null) {
                this.mConnection.rollback();
                this.mLastException = null;
                this.mLastError = "OK";
            }
        }
        catch (Exception e) {
            this.mLastException = e;
            this.mLastError = "Connection rollback Error";
        }
    }

    public Connection openConnection() {
        this.mConnection = null;
        String url = new String();
        if (this.mType.equalsIgnoreCase("oracle")) {
            try {
                Class.forName("oracle.jdbc.OracleDriver").newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url, this.mUser, this.mPasswd);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("mysql")) {
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url, this.mUser, this.mPasswd);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        }
        if (this.mType.equalsIgnoreCase("Derby (Java DB)")) {
            try {
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url);
                this.mConnection.setAutoCommit(false);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("informix")) {
            try {
                Class.forName("com.informix.jdbc.IfxDriver").newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("mssql")) {
            try {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("postgre")) {
            try {
                Class.forName("org.postgresql.Driver").newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url, this.mUser, this.mPasswd);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("generic PW")) {
            try {
                Class.forName(this.mClass).newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url, this.mUser, this.mPasswd);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else if (this.mType.equalsIgnoreCase("generic total")) {
            try {
                Class.forName(this.mClass).newInstance();
                url = this.getConnectionString();
                this.mConnection = DriverManager.getConnection(url);
                this.mLastException = null;
                this.mLastError = "OK";
            }
            catch (Exception e) {
                this.mLastException = e;
                this.mLastError = "Connection ERROR";
            }
        } else {
            this.mLastException = null;
            this.mLastError = "Non Supported DB Type";
        }
        return this.mConnection;
    }

    public void closeConnection() {
        try {
            if (this.mConnection != null) {
                this.mConnection.commit();
                this.mConnection.close();
                this.mLastException = null;
                this.mLastError = "OK";
            }
        }
        catch (Exception e) {
            this.mLastException = e;
            this.mLastError = "Connection close Error";
        }
        this.mConnection = null;
    }

    private static DBConnectionXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<DBConnectionData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename);
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllConnections>\n");
            for (DBConnectionData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllConnections>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, DBConnectionData> getHashMapFromXML(String filename) {
        HashMap<String, DBConnectionData> dBConnections = new HashMap<String, DBConnectionData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DBConnectionXMLHandler h = DBConnectionData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            dBConnections = h.getLastHashMap();
        }
        catch (Throwable e) {
            ShowWarningDialog.showWarningDialog("Connection Lade Problem...", e.toString());
        }
        return dBConnections;
    }

    public static String getExample(String type) {
        if (type.equalsIgnoreCase("")) {
            return "";
        }
        if (type.equalsIgnoreCase("oracle")) {
            return "jdbc:oracle:thin:@host:port:dbname";
        }
        if (type.equalsIgnoreCase("mysql")) {
            return "jdbc:mysql://host:port/dbname";
        }
        if (type.equalsIgnoreCase("Derby (Java DB)")) {
            return "jdbc:derby:<DBNAME>;user=<USERNAME>;password=<PASSWD>";
        }
        if (type.equalsIgnoreCase("informix")) {
            return "jdbc:informix-sqli://host:port/databaseName:informixserver=<SERVER>;user=<USERNAME>;password=<PASSWD>";
        }
        if (type.equalsIgnoreCase("mssql")) {
            return "jdbc:sqlserver://host[\\INSTANCE][:port];databaseName=<DBNAME>;user=<USERNAME>;password=<PASSWD>";
        }
        if (type.equalsIgnoreCase("postgre")) {
            return "jdbc:postgresql://host:port/database";
        }
        if (type.equalsIgnoreCase("generic total")) {
            return "something appropriate...";
        }
        if (type.equalsIgnoreCase("generic PW")) {
            return "something appropriate...";
        }
        return "Not Supported DB Type";
    }

    public String getHelpText() {
        String help = new String();
        if (this.mType.equalsIgnoreCase("")) {
            return "Select a Type to get Help!";
        }
        if (this.mType.equalsIgnoreCase("oracle")) {
            help = help + "Oracle";
        } else if (!this.mType.equalsIgnoreCase("mysql") && !this.mType.equalsIgnoreCase("informix")) {
            if (this.mType.equalsIgnoreCase("mssql")) {
                help = help + "Die allgemeine Form der Verbindungs-URL lautet:\njdbc:sqlserver://[serverName[\\instanceName][:portNumber]][;property=value[;property=value]]\nwobei: \n";
                help = help + "- jdbc:sqlserver:// (erforderlich) als Subprotokoll bezeichnet wird und konstant ist. \n";
                help = help + "- serverName (optional) die Adresse des Servers, darstellt, zu dem eine Verbindung hergestellt \n  werden soll. Dabei kann es sich um eine DNS- oder IP-Adresse bzw. \"localhost\" oder \n  \"127.0.0.1\" f\u00fcr den lokalen Computer handeln. Wenn der Servername nicht in der \n  Verbindungs-URL angegeben wird, muss er in der properties-Auflistung angegeben werden.\n";
                help = help + "- instanceName (optional) bezeichnet die Instanz auf \"serverName\", zu der eine Verbindung \n  hergestellt werden soll. Ohne Angabe wird eine Verbindung zur Standardinstanz erstellt.\n";
                help = help + "- portNumber (optional) bezeichnet den Port auf \"serverName\", zu dem eine Verbindung \n  hergestellt werden soll. Der Standardwert ist 1433. Wenn der Standardwert verwendet wird, \n  brauchen Sie den Port und den davor stehenden Doppelpunkt (':') in der URL nicht anzugeben.\n";
                help = help + "\nHinweis:\n";
                help = help + "Um eine optimale Leistung der Verbindung zu gew\u00e4hrleisten, sollten Sie \"portNumber\" \nfestlegen, wenn Sie eine Verbindung zu einer benannten Instanz herstellen. Dadurch \nwerden Roundtrips zum Server vermieden, um die Portnummer zu ermitteln. Wenn \"portNumber\" \nund \"instanceName\" verwendet werden, hat \"portNumber\" Vorrang und \"instanceName\" wird \nignoriert.\n";
            } else if (this.mType.equalsIgnoreCase("postgre") || this.mType.equalsIgnoreCase("generic total") || this.mType.equalsIgnoreCase("generic PW")) {
                // empty if block
            }
        }
        return help;
    }
}

