/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.jdbc.DBConnectionData;
import de.malban.jdbc.PoolFactory;
import java.util.HashMap;

public class DBConnectionDataPool {
    public static final String DEFAULT_XML_NAME = new String("dbConncetions.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private static Logable D = Configuration.getConfiguration().getDebugEntity();
    private HashMap<String, DBConnectionData> mDBConnections = new HashMap();

    public DBConnectionDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public DBConnectionDataPool() {
        this.init();
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            ShowWarningDialog.showWarningDialog("Connection Lade Problem...", e.toString());
            return false;
        }
    }

    public boolean load() {
        this.mDBConnections = DBConnectionData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        DBConnectionData.saveCollectionAsXML(this.mFileName, this.getHashMap().values());
    }

    public int getSize() {
        return this.mDBConnections.size();
    }

    public HashMap<String, DBConnectionData> getHashMap() {
        return this.mDBConnections;
    }

    public void put(String key, DBConnectionData value) {
        this.mDBConnections.put(key, value);
    }

    public DBConnectionData get(String key) {
        return this.mDBConnections.get(key);
    }

    public static DBConnectionData getConnection(String connectionName) {
        DBConnectionDataPool pool = PoolFactory.POOL.getConnectionPool();
        if (pool == null) {
            D.addLog("Connection pool could not be initialized!!");
            return null;
        }
        DBConnectionData data2 = pool.get(connectionName);
        if (data2 == null) {
            D.addLog("Connection not found in pool!");
            return null;
        }
        return data2;
    }
}

