/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.jdbc.DBConnectionData;
import de.malban.jdbc.JavaSQLResult;
import de.malban.jdbc.SQLDataObject;
import de.malban.jdbc.UserSQLStatement;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;

public class SQLResult
implements JavaSQLResult {
    private UserSQLStatement mStatement = null;
    private transient String mLastError = "uncalled";
    private transient Throwable mLastException = null;
    private Connection mConnection = null;
    private DBConnectionData mCData = null;
    private HashMap<String, SQLDataObject> mTableData = new HashMap();
    private HashMap<String, Vector<SQLDataObject>> mTableRows = new HashMap();
    private Vector<SQLDataObject> mColumnNames = new Vector();
    private Vector<HashMap<String, SQLDataObject>> mTableMappedRows = new Vector();
    private String mLastAuto = "";
    private HashMap<String, Integer> columnNameMapping = new HashMap();

    @Override
    public String getLastID() {
        return this.mLastAuto;
    }

    @Override
    public void clearAll() {
        this.mTableData = new HashMap();
        this.mTableRows = new HashMap();
        this.mColumnNames = new Vector();
        this.columnNameMapping = new HashMap();
        this.mStatement = null;
        this.mLastError = "uncalled";
        this.mLastException = null;
        this.mConnection = null;
        this.mCData = null;
    }

    @Override
    public int getRowCount() {
        if (this.mTableRows != null) {
            return this.mTableRows.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.mColumnNames != null) {
            return this.mColumnNames.size();
        }
        return 0;
    }

    @Override
    public String getColumnName(int i) {
        if (this.mColumnNames != null) {
            return this.mColumnNames.elementAt((int)i).mColumnName;
        }
        return "";
    }

    @Override
    public String getTableName(int i) {
        if (this.mColumnNames != null) {
            return this.mColumnNames.elementAt((int)i).mTableName;
        }
        return "";
    }

    @Override
    public Throwable getLastException() {
        return this.mLastException;
    }

    @Override
    public String getLastError() {
        return this.mLastError;
    }

    @Override
    public boolean doDBQuery() {
        if (this.mStatement == null) {
            this.mLastError = "Statement not set";
            this.mLastException = null;
            return false;
        }
        if (this.mCData == null) {
            this.mLastError = "DBConnectionData not set";
            this.mLastException = null;
            return false;
        }
        Statement st = null;
        String sql = "";
        ResultSet resultSet = null;
        if (!this.mCData.isOpen()) {
            this.mLastError = "Connection is not open!";
            this.mLastException = null;
            return false;
        }
        this.mConnection = this.mCData.getConnection();
        if (!this.mCData.mLastError.equalsIgnoreCase("ok")) {
            this.mLastError = this.mCData.mLastError;
            this.mLastException = this.mCData.mLastException;
            return false;
        }
        try {
            st = this.mConnection.createStatement();
        }
        catch (Exception e) {
            this.mLastError = "Create Statement error";
            this.mLastException = e;
            return false;
        }
        sql = this.mStatement.getBuildStatement();
        try {
            resultSet = st.executeQuery(sql);
        }
        catch (Exception e) {
            this.mLastError = "Execute Statement error: " + sql;
            this.mLastException = e;
            return false;
        }
        boolean ret = this.fillResultSet(resultSet);
        if (!ret) {
            return false;
        }
        this.mLastError = "OK";
        this.mLastException = null;
        return true;
    }

    private boolean fillResultSet(ResultSet resultSet) {
        ResultSetMetaData rsmd;
        this.mColumnNames = new Vector();
        int numberOfColumns = 0;
        try {
            rsmd = resultSet.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            for (int i = 0; i < numberOfColumns; ++i) {
                SQLDataObject data2 = new SQLDataObject();
                data2.mColumnName = rsmd.getColumnName(i + 1);
                data2.mSQLDataType = rsmd.getColumnTypeName(i + 1);
                data2.mPrecision = rsmd.getPrecision(i + 1);
                data2.mScale = rsmd.getScale(i + 1);
                data2.mTableName = rsmd.getTableName(i + 1);
                this.mColumnNames.add(data2);
                this.columnNameMapping.put(data2.mColumnName.toUpperCase(), i);
            }
        }
        catch (Exception e) {
            this.mLastError = "Get MetaData error";
            this.mLastException = e;
            return false;
        }
        this.mTableData = new HashMap();
        this.mTableRows = new HashMap();
        this.mTableMappedRows = new Vector();
        try {
            int rowCount = 0;
            while (resultSet.next()) {
                Vector<SQLDataObject> row = new Vector<SQLDataObject>();
                HashMap<String, SQLDataObject> mappedRow = new HashMap<String, SQLDataObject>();
                for (int i = 0; i < numberOfColumns; ++i) {
                    int type = rsmd.getColumnType(i + 1);
                    SQLDataObject data3 = (SQLDataObject)this.mColumnNames.elementAt(i).clone();
                    Object o = resultSet.getObject(i + 1);
                    if (o == null) {
                        data3.mData = "null";
                    } else {
                        data3.mData = o.toString();
                        if (data3.mData.indexOf(".DATE") != -1 || type == 91) {
                            Date d = resultSet.getDate(i + 1);
                            data3.mData = d.toString();
                        }
                        if (data3.mData.indexOf(".TIMESTAMP") != -1 || type == 93 || type == 2014) {
                            Timestamp t = resultSet.getTimestamp(i + 1);
                            data3.mData = t.toString();
                        }
                        try {
                            if (data3.mData.indexOf(".CLOB") != -1 || type == 2005) {
                                String clob = resultSet.getClob(i + 1).getSubString(1L, (int)resultSet.getClob(i + 1).length());
                                data3.mLobData = clob.getBytes();
                                data3.mIsLob = true;
                                data3.mLobBin = false;
                            }
                            if (data3.mData.indexOf(".BLOB") != -1 || type == 2004) {
                                Blob blob = (Blob)o;
                                data3.mLobData = blob.getBytes(1L, (int)blob.length());
                                data3.mIsLob = true;
                                data3.mLobBin = true;
                            }
                        }
                        catch (Throwable e) {
                            ShowWarningDialog.showWarningDialog("LOB Problem", e.toString());
                        }
                    }
                    row.addElement(data3);
                    mappedRow.put(this.mColumnNames.elementAt((int)i).mColumnName, data3);
                    this.mTableData.put("DATA_" + rowCount + "_" + i, data3);
                }
                this.mTableRows.put("ROW_" + rowCount, row);
                this.mTableMappedRows.addElement(mappedRow);
                ++rowCount;
            }
        }
        catch (Exception e) {
            this.mLastError = "Get ResultData error";
            this.mLastException = e;
            return false;
        }
        return true;
    }

    @Override
    public boolean doDBChange() {
        return this.doDBChange("");
    }

    @Override
    public boolean doDBChange(String seq) {
        if (this.mStatement == null) {
            this.mLastError = "Statement not set";
            this.mLastException = null;
            return false;
        }
        if (this.mCData == null) {
            this.mLastError = "DBConnectionData not set";
            this.mLastException = null;
            return false;
        }
        Statement st = null;
        String sql = "";
        int result = -1;
        if (!this.mCData.isOpen()) {
            this.mLastError = "Connection is not open!";
            this.mLastException = null;
            return false;
        }
        this.mConnection = this.mCData.getConnection();
        sql = this.mStatement.getBuildStatement();
        if (!this.mCData.mLastError.equalsIgnoreCase("ok")) {
            this.mLastError = this.mCData.mLastError;
            this.mLastException = this.mCData.mLastException;
            return false;
        }
        try {
            st = this.mConnection.createStatement();
        }
        catch (Exception e) {
            this.mLastError = "Create Statement error: " + sql;
            this.mLastException = e;
            return false;
        }
        try {
            Statement st2;
            ResultSet resultSet;
            result = sql.toUpperCase().startsWith("UPDATE") ? st.executeUpdate(sql, 2) : st.executeUpdate(sql, 1);
            ResultSet rSet = st.getGeneratedKeys();
            this.fillResultSet(rSet);
            if (this.mCData.mType.equalsIgnoreCase("oracle") && seq.length() > 0) {
                sql = "select " + seq + ".currval from dual";
                resultSet = null;
                try {
                    st2 = this.mConnection.createStatement();
                    resultSet = st2.executeQuery(sql);
                    resultSet.next();
                    Object o = resultSet.getObject(1);
                    this.mLastError = "Sequence getting success";
                    if (o != null) {
                        this.mLastAuto = o.toString();
                    }
                }
                catch (Exception e) {
                    this.mLastError = "LAST INSERT ID FAILED";
                    this.mLastException = e;
                    return false;
                }
            }
            if (this.mCData.mType.equalsIgnoreCase("mysql")) {
                resultSet = null;
                try {
                    st2 = this.mConnection.createStatement();
                    resultSet = st2.executeQuery("SELECT LAST_INSERT_ID()");
                    boolean valid = resultSet.first();
                    if (valid) {
                        Object o = resultSet.getObject(1);
                        this.mLastError = "LAST INSERT ID FAILED";
                        if (o != null) {
                            this.mLastAuto = o.toString();
                        }
                    } else {
                        System.out.println("Mist");
                    }
                }
                catch (Exception e) {
                    this.mLastError = "LAST INSERT ID FAILED";
                    this.mLastException = e;
                    return false;
                }
            }
            if (this.mCData.mType.toLowerCase().indexOf("derby") != -1 && this.getRowCount() > 0) {
                SQLDataObject d = this.getData(0, 0);
                this.mLastAuto = d.mData;
            }
        }
        catch (Exception e) {
            this.mLastError = "Execute Statement error: " + sql;
            this.mLastException = e;
            return false;
        }
        this.mLastError = "OK";
        this.mLastException = null;
        return true;
    }

    @Override
    public HashMap<String, SQLDataObject> getMappedRow(int row) {
        if (row < 0 || row >= this.mTableMappedRows.size()) {
            return new HashMap<String, SQLDataObject>();
        }
        return this.mTableMappedRows.elementAt(row);
    }

    @Override
    public Vector<SQLDataObject> getRow(int row) {
        return this.mTableRows.get("ROW_" + row);
    }

    @Override
    public HashMap<String, Vector<SQLDataObject>> getAllRows(int row) {
        return this.mTableRows;
    }

    @Override
    public HashMap<String, SQLDataObject> getAllData(int row) {
        return this.mTableData;
    }

    @Override
    public SQLDataObject getData(int row, int column) {
        return this.mTableData.get("DATA_" + row + "_" + column);
    }

    @Override
    public SQLDataObject getData(int row, String columnName) {
        int column = this.getColumnNumber(columnName);
        return this.getData(row, column);
    }

    @Override
    public void setStatement(UserSQLStatement s) {
        this.mStatement = s;
    }

    @Override
    public void setDBConnectionData(DBConnectionData d) {
        this.mCData = d;
    }

    public int getColumnNumber(String columnName) {
        if (this.columnNameMapping == null) {
            return -1;
        }
        if (!this.columnNameMapping.containsKey(columnName.toUpperCase())) {
            return -1;
        }
        return this.columnNameMapping.get(columnName.toUpperCase());
    }
}

