/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InputDialog;
import de.malban.gui.dialogs.ShowErrorDialog;
import de.malban.jdbc.DBConnectionData;
import de.malban.jdbc.DBConnectionDataPool;
import de.malban.jdbc.JavaSQLResult;
import de.malban.jdbc.PoolFactory;
import de.malban.jdbc.SQLDataObject;
import de.malban.jdbc.UserSQLStatement;
import de.malban.jdbc.UserSQLStatementPool;
import de.malban.util.ExcelHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class StatementWindow
extends JPanel
implements Windowable {
    private UserSQLStatementPool mStatementPool;
    private DBConnectionDataPool mConnectionPool;
    private Object mLastPopUp = null;
    private int mInComboAdd = 0;
    private int mInDBAdd = 0;
    private int mClassSetting = 0;
    JavaSQLResult mOraResult = null;
    HashMap mVComments = new HashMap();
    HashMap mSComments = new HashMap();
    UserSQLStatement mCurrentStatement = new UserSQLStatement();
    private CSAView mParentView = null;
    private JMenuItem mParentMenuItem = null;
    Logable D;
    private int mRow = -1;
    private int mCol = -1;
    private SQLDataObject mLastObject = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxDBConnection;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxSt1;
    private JComboBox jComboBoxSt2;
    private JComboBox jComboBoxSt3;
    private JComboBox jComboBoxSt4;
    private JComboBox jComboBoxSt5;
    private JComboBox jComboBoxSt6;
    private JComboBox jComboBoxStatement;
    private JLabel jLabelDBConnection;
    private JLabel jLabelDescribtion;
    private JLabel jLabelKlasse;
    private JLabel jLabelKlasse1;
    private JLabel jLabelName;
    private JLabel jLabelNoVars;
    private JLabel jLabelSt1;
    private JLabel jLabelSt2;
    private JLabel jLabelSt3;
    private JLabel jLabelSt4;
    private JLabel jLabelSt5;
    private JLabel jLabelSt6;
    private JLabel jLabelStatement;
    private JLabel jLabelStatementName;
    private JLabel jLabelStatements;
    private JLabel jLabelTableSize;
    private JLabel jLabelVar1;
    private JLabel jLabelVar2;
    private JLabel jLabelVar3;
    private JLabel jLabelVar4;
    private JLabel jLabelVar5;
    private JLabel jLabelVar6;
    private JLabel jLabelVariables;
    private JMenu jMenuExecuteHere;
    private JMenu jMenuExecuteNew;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItemAddComment;
    private JMenuItem jMenuItemExport;
    private JMenuItem jMenuItemExportTable;
    private JMenuItem jMenuItemHideColumn;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JPopupMenu jPopupMenu3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTable jTableResult;
    private JTextArea jTextAreaDescribtion;
    private JTextArea jTextAreaStatement;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldNAme;
    private JTextField jTextFieldNoVars;
    private JTextField jTextFieldVar1;
    private JTextField jTextFieldVar2;
    private JTextField jTextFieldVar3;
    private JTextField jTextFieldVar4;
    private JTextField jTextFieldVar5;
    private JTextField jTextFieldVar6;

    @Override
    public void closing() {
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParentView = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText("SQL Statement");
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public StatementWindow() {
        this.initComponents();
        this.mStatementPool = PoolFactory.POOL.getStatementPool();
        this.mConnectionPool = PoolFactory.POOL.getConnectionPool();
        Collection<String> colC = this.mStatementPool.getClasses().values();
        Iterator<String> iterC = colC.iterator();
        int i = 0;
        ++this.mClassSetting;
        while (iterC.hasNext()) {
            String item = iterC.next();
            this.jComboBoxKlasse.addItem(item);
            if (i == 0) {
                this.jComboBoxKlasse.setSelectedIndex(0);
            }
            ++i;
        }
        this.resetStatementPool(null, null);
        --this.mClassSetting;
        this.jTableResult.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                e.consume();
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, 2);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.jTableResult.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jComboBoxSt1.setVisible(false);
        this.jComboBoxSt2.setVisible(false);
        this.jComboBoxSt3.setVisible(false);
        this.jComboBoxSt4.setVisible(false);
        this.jComboBoxSt5.setVisible(false);
        this.jComboBoxSt6.setVisible(false);
        this.jLabelSt1.setVisible(false);
        this.jLabelSt2.setVisible(false);
        this.jLabelSt2.setVisible(false);
        this.jLabelSt3.setVisible(false);
        this.jLabelSt4.setVisible(false);
        this.jLabelSt5.setVisible(false);
        this.jLabelSt6.setVisible(false);
        this.jLabelStatements.setVisible(false);
        this.setVisible(true);
    }

    public void resetStatementPool(String stName, String stClass) {
        Collection<UserSQLStatement> col;
        if (stClass == null) {
            col = this.mStatementPool.getClassStatements((String)this.jComboBoxKlasse.getSelectedItem()).values();
        } else {
            ++this.mClassSetting;
            this.jComboBoxKlasse.setSelectedItem(stClass);
            col = this.mStatementPool.getClassStatements(stClass).values();
            --this.mClassSetting;
        }
        Iterator<UserSQLStatement> iter = col.iterator();
        int i = 0;
        this.jMenuExecuteNew.removeAll();
        this.jMenuExecuteHere.removeAll();
        ++this.mInComboAdd;
        this.jComboBoxStatement.removeAllItems();
        while (iter.hasNext()) {
            UserSQLStatement item = iter.next();
            this.jComboBoxStatement.addItem(item);
            if (i == 0 && stName == null) {
                this.jComboBoxStatement.setSelectedIndex(i);
                this.mCurrentStatement = item;
            }
            if (stName != null && stName.equals(item.mName)) {
                this.jComboBoxStatement.setSelectedIndex(i);
                this.mCurrentStatement = item;
            }
            ++i;
        }
        --this.mInComboAdd;
        Collection<String> colC = this.mStatementPool.getClasses().values();
        Iterator<String> iterC = colC.iterator();
        i = 0;
        while (iterC.hasNext()) {
            String item = iterC.next();
            col = this.mStatementPool.getClassStatements(item).values();
            iter = col.iterator();
            JMenu menuHere = new JMenu();
            menuHere.setText(item);
            this.jMenuExecuteHere.add(menuHere);
            JMenu menuNew = new JMenu();
            menuNew.setText(item);
            this.jMenuExecuteNew.add(menuNew);
            while (iter.hasNext()) {
                UserSQLStatement itemST = iter.next();
                JMenuItem menuItem2 = new JMenuItem();
                menuItem2.setText(itemST.mName);
                menuItem2.setActionCommand("Here");
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        StatementWindow.this.jMenuItemExecuteHereActionPerformed(evt);
                    }
                });
                menuHere.add(menuItem2);
                JMenuItem menuItem = new JMenuItem();
                menuItem.setText(itemST.mName);
                menuItem.setActionCommand("New");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        StatementWindow.this.jMenuItemExecuteNewActionPerformed(evt);
                    }
                });
                menuNew.add(menuItem);
            }
            ++i;
        }
        this.setCommentsFormST(this.mCurrentStatement);
        this.setStatementToFields(this.mCurrentStatement);
    }

    public void setStatement(UserSQLStatement st) {
        this.mCurrentStatement = st;
        this.setCommentsFormST(this.mCurrentStatement);
        this.setStatementToFields(this.mCurrentStatement);
    }

    public void setVar1(String var) {
        this.jTextFieldVar1.setText(var);
        this.mCurrentStatement.setVar(0, var, (String)this.mVComments.get(0));
        this.statementChecker();
    }

    public void executeStatement() {
        this.jButton1ActionPerformed(null);
    }

    private void jMenuItemExecuteHereActionPerformed(ActionEvent evt) {
        JMenuItem menuItem = (JMenuItem)evt.getSource();
        UserSQLStatement st = this.mStatementPool.get(menuItem.getText());
        this.resetStatementPool(st.mName, st.mKlasse);
        this.setVar1(this.mLastObject.mData);
        this.executeStatement();
    }

    private void jMenuItemExecuteNewActionPerformed(ActionEvent evt) {
        JMenuItem menuItem = (JMenuItem)evt.getSource();
        StatementWindow stw = new StatementWindow();
        Configuration.getConfiguration().getMainFrame().addAsWindow(stw, 800, 600, "SQL");
        UserSQLStatement st = this.mStatementPool.get(menuItem.getText());
        stw.resetStatementPool(st.mName, st.mKlasse);
        stw.setVar1(this.mLastObject.mData);
        stw.executeStatement();
    }

    private void setCommentsFormST(UserSQLStatement st) {
        int i;
        this.mVComments.clear();
        for (i = 0; i < st.getVarNumberStatement(); ++i) {
            this.mVComments.put(i, st.getVarComment(i));
        }
        block9: for (i = 0; i < st.getVarNumberStatement(); ++i) {
            switch (i) {
                case 0: {
                    this.jTextFieldVar1.setToolTipText(st.getVarComment(i));
                    continue block9;
                }
                case 1: {
                    this.jTextFieldVar2.setToolTipText(st.getVarComment(i));
                    continue block9;
                }
                case 2: {
                    this.jTextFieldVar3.setToolTipText(st.getVarComment(i));
                    continue block9;
                }
                case 3: {
                    this.jTextFieldVar4.setToolTipText(st.getVarComment(i));
                    continue block9;
                }
                case 4: {
                    this.jTextFieldVar6.setToolTipText(st.getVarComment(i));
                    continue block9;
                }
                case 5: {
                    this.jTextFieldVar5.setToolTipText(st.getVarComment(i));
                }
            }
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemAddComment = new JMenuItem();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItemExport = new JMenuItem();
        this.jPopupMenu3 = new JPopupMenu();
        this.jMenuExecuteNew = new JMenu();
        this.jMenuExecuteHere = new JMenu();
        this.jMenuItemExportTable = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemHideColumn = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jComboBoxStatement = new JComboBox();
        this.jLabelStatementName = new JLabel();
        this.jLabelName = new JLabel();
        this.jTextFieldNAme = new JTextField();
        this.jLabelDescribtion = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescribtion = new JTextArea();
        this.jLabelStatement = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaStatement = new JTextArea();
        this.jLabelNoVars = new JLabel();
        this.jTextFieldNoVars = new JTextField();
        this.jLabelVariables = new JLabel();
        this.jLabelVar1 = new JLabel();
        this.jTextFieldVar1 = new JTextField();
        this.jLabelVar2 = new JLabel();
        this.jTextFieldVar2 = new JTextField();
        this.jLabelVar3 = new JLabel();
        this.jTextFieldVar3 = new JTextField();
        this.jLabelVar4 = new JLabel();
        this.jTextFieldVar4 = new JTextField();
        this.jTextFieldVar6 = new JTextField();
        this.jLabelVar5 = new JLabel();
        this.jLabelVar6 = new JLabel();
        this.jTextFieldVar5 = new JTextField();
        this.jLabelStatements = new JLabel();
        this.jLabelSt5 = new JLabel();
        this.jLabelSt6 = new JLabel();
        this.jLabelSt3 = new JLabel();
        this.jLabelSt4 = new JLabel();
        this.jLabelSt1 = new JLabel();
        this.jLabelSt2 = new JLabel();
        this.jComboBoxSt1 = new JComboBox();
        this.jComboBoxSt3 = new JComboBox();
        this.jComboBoxSt5 = new JComboBox();
        this.jComboBoxSt2 = new JComboBox();
        this.jComboBoxSt4 = new JComboBox();
        this.jComboBoxSt6 = new JComboBox();
        this.jButton1 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTableResult = new JTable();
        this.jLabelDBConnection = new JLabel();
        this.jComboBoxDBConnection = new JComboBox();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jLabelTableSize = new JLabel();
        this.jLabelKlasse = new JLabel();
        this.jTextFieldKlasse = new JTextField();
        this.jComboBoxKlasse = new JComboBox();
        this.jLabelKlasse1 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jMenuItemAddComment.setLabel("Add Comment");
        this.jMenuItemAddComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jMenuItemAddCommentActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemAddComment);
        this.jMenuItemExport.setText("Export LOB");
        this.jMenuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jMenuItemExportActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItemExport);
        this.jMenuExecuteNew.setText("Execute New");
        this.jPopupMenu3.add(this.jMenuExecuteNew);
        this.jMenuExecuteHere.setText("Execute Here");
        this.jPopupMenu3.add(this.jMenuExecuteHere);
        this.jMenuItemExportTable.setText("Export as CSV");
        this.jMenuItemExportTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jMenuItemExportTableActionPerformed(evt);
            }
        });
        this.jPopupMenu3.add(this.jMenuItemExportTable);
        this.jPopupMenu3.add(this.jSeparator1);
        this.jMenuItemHideColumn.setText("Hide Column");
        this.jMenuItemHideColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jMenuItemHideColumnActionPerformed(evt);
            }
        });
        this.jPopupMenu3.add(this.jMenuItemHideColumn);
        this.jMenuItem1.setText("To Excel");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu3.add(this.jMenuItem1);
        this.jComboBoxStatement.setPreferredSize(new Dimension(160, 20));
        this.jComboBoxStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jComboBoxStatementActionPerformed(evt);
            }
        });
        this.jLabelStatementName.setText("Statement");
        this.jLabelName.setText("Name");
        this.jTextFieldNAme.setColumns(20);
        this.jLabelDescribtion.setText("Describtion");
        this.jTextAreaDescribtion.setColumns(20);
        this.jTextAreaDescribtion.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaDescribtion);
        this.jLabelStatement.setText("Statement");
        this.jTextAreaStatement.setColumns(20);
        this.jTextAreaStatement.setRows(5);
        this.jTextAreaStatement.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextAreaStatementFocusLost(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextAreaStatement);
        this.jLabelNoVars.setText("# Vars: ");
        this.jTextFieldNoVars.setEditable(false);
        this.jTextFieldNoVars.setColumns(2);
        this.jTextFieldNoVars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jTextFieldNoVarsActionPerformed(evt);
            }
        });
        this.jLabelVariables.setText("Variables");
        this.jLabelVar1.setText("1:");
        this.jTextFieldVar1.setColumns(20);
        this.jTextFieldVar1.setName("v1");
        this.jTextFieldVar1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar1MouseClicked(evt);
            }
        });
        this.jTextFieldVar1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar1FocusLost(evt);
            }
        });
        this.jLabelVar2.setText("2:");
        this.jTextFieldVar2.setColumns(20);
        this.jTextFieldVar2.setName("v2");
        this.jTextFieldVar2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar2MouseClicked(evt);
            }
        });
        this.jTextFieldVar2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar2FocusLost(evt);
            }
        });
        this.jLabelVar3.setText("3:");
        this.jTextFieldVar3.setColumns(20);
        this.jTextFieldVar3.setName("v3");
        this.jTextFieldVar3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar3MouseClicked(evt);
            }
        });
        this.jTextFieldVar3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar3FocusLost(evt);
            }
        });
        this.jLabelVar4.setText("4:");
        this.jTextFieldVar4.setColumns(20);
        this.jTextFieldVar4.setName("v4");
        this.jTextFieldVar4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar4MouseClicked(evt);
            }
        });
        this.jTextFieldVar4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jTextFieldVar4ActionPerformed(evt);
            }
        });
        this.jTextFieldVar4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar4FocusLost(evt);
            }
        });
        this.jTextFieldVar6.setColumns(20);
        this.jTextFieldVar6.setName("v6");
        this.jTextFieldVar6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar6MouseClicked(evt);
            }
        });
        this.jTextFieldVar6.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar6FocusLost(evt);
            }
        });
        this.jLabelVar5.setText("6:");
        this.jLabelVar6.setText("5:");
        this.jTextFieldVar5.setColumns(20);
        this.jTextFieldVar5.setName("v5");
        this.jTextFieldVar5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTextFieldVar5MouseClicked(evt);
            }
        });
        this.jTextFieldVar5.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StatementWindow.this.jTextFieldVar5FocusLost(evt);
            }
        });
        this.jLabelStatements.setText("Statements");
        this.jLabelSt5.setText("5:");
        this.jLabelSt6.setText("6:");
        this.jLabelSt3.setText("3:");
        this.jLabelSt4.setText("4:");
        this.jLabelSt1.setText("1:");
        this.jLabelSt2.setText("2:");
        this.jComboBoxSt1.setMinimumSize(new Dimension(80, 18));
        this.jComboBoxSt1.setName("s1");
        this.jComboBoxSt1.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxSt3.setName("s3");
        this.jComboBoxSt3.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxSt5.setName("s5");
        this.jComboBoxSt5.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxSt2.setName("s2");
        this.jComboBoxSt2.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxSt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jComboBoxSt2ActionPerformed(evt);
            }
        });
        this.jComboBoxSt4.setName("s4");
        this.jComboBoxSt4.setPreferredSize(new Dimension(120, 20));
        this.jComboBoxSt6.setName("s6");
        this.jComboBoxSt6.setPreferredSize(new Dimension(120, 20));
        this.jButton1.setText("Query");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jButton1ActionPerformed(evt);
            }
        });
        this.jScrollPane3.setPreferredSize(new Dimension(452, 200));
        this.jTableResult.setAutoCreateRowSorter(true);
        this.jTableResult.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableResult.setCellSelectionEnabled(true);
        this.jTableResult.setDragEnabled(true);
        this.jTableResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatementWindow.this.jTableResultMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableResult);
        this.jLabelDBConnection.setText("DBConnection");
        this.jLabelDBConnection.setToolTipText(" ");
        this.jComboBoxDBConnection.setPreferredSize(new Dimension(160, 20));
        this.jComboBoxDBConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jComboBoxDBConnectionActionPerformed(evt);
            }
        });
        this.jButtonNew.setText("Neu");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Accept");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jLabelTableSize.setText("Size:");
        this.jLabelKlasse.setText("Klasse");
        this.jTextFieldKlasse.setPreferredSize(new Dimension(160, 20));
        this.jComboBoxKlasse.setPreferredSize(new Dimension(160, 20));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jLabelKlasse1.setText("Klasse");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Update");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatementWindow.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCheckBox1).addComponent(this.jLabelTableSize)).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelVar3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelVar6, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelVariables).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNoVars, -2, -1, -2)).addComponent(this.jLabelStatementName).addComponent(this.jLabelKlasse)).addComponent(this.jLabelVar1).addComponent(this.jLabelNoVars)).addComponent(this.jLabelKlasse1).addComponent(this.jLabelName).addComponent(this.jLabelDescribtion).addComponent(this.jLabelStatement)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldNAme, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldKlasse, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxKlasse, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxStatement, GroupLayout.Alignment.LEADING, 0, 392, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabelDBConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDBConnection, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldVar1, -2, -1, -2).addComponent(this.jTextFieldVar3, -2, -1, -2).addComponent(this.jTextFieldVar5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabelVar2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelVar5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar6, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelVar4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldVar4, -2, -1, -2))).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelSt1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxSt1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelSt5).addComponent(this.jLabelSt3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxSt5, -2, -1, -2).addComponent(this.jComboBoxSt3, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSt2).addComponent(this.jLabelSt4).addComponent(this.jLabelSt6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxSt6, -2, -1, -2).addComponent(this.jComboBoxSt4, -2, -1, -2).addComponent(this.jComboBoxSt2, -2, -1, -2))).addComponent(this.jLabelStatements)))))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelKlasse).addComponent(this.jComboBoxKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelStatementName).addComponent(this.jComboBoxStatement, -2, -1, -2).addComponent(this.jButtonNew).addComponent(this.jButtonSave)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelKlasse1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelDescribtion).addGap(67, 67, 67).addComponent(this.jLabelStatement).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNoVars)).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldKlasse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNAme, -2, -1, -2).addComponent(this.jLabelDBConnection).addComponent(this.jComboBoxDBConnection, -2, -1, -2)).addGap(15, 15, 15).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStatements).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNoVars, -2, -1, -2).addComponent(this.jLabelVariables))).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxSt1, -2, -1, -2).addComponent(this.jLabelSt1).addComponent(this.jTextFieldVar2, -2, -1, -2).addComponent(this.jLabelVar2).addComponent(this.jLabelSt2).addComponent(this.jComboBoxSt2, -2, -1, -2).addComponent(this.jTextFieldVar1, -2, -1, -2).addComponent(this.jLabelVar1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxSt3, -2, -1, -2).addComponent(this.jLabelSt3).addComponent(this.jTextFieldVar4, -2, -1, -2).addComponent(this.jLabelVar4).addComponent(this.jLabelSt4).addComponent(this.jComboBoxSt4, -2, -1, -2).addComponent(this.jTextFieldVar3, -2, -1, -2).addComponent(this.jLabelVar3))).addGroup(layout.createSequentialGroup().addGap(52, 52, 52).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSt5).addComponent(this.jComboBoxSt5, -2, -1, -2).addComponent(this.jTextFieldVar6, -2, -1, -2).addComponent(this.jLabelVar5).addComponent(this.jLabelSt6).addComponent(this.jComboBoxSt6, -2, -1, -2).addComponent(this.jTextFieldVar5, -2, -1, -2).addComponent(this.jLabelVar6)))).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTableSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addContainerGap()).addComponent(this.jScrollPane3, -1, 131, Short.MAX_VALUE))));
    }

    private void jMenuItemAddCommentActionPerformed(ActionEvent evt) {
        String inputValue = InputDialog.showInputDialog("Enter comment:");
        JMenuItem item = (JMenuItem)evt.getSource();
        JPopupMenu pMenu = (JPopupMenu)item.getParent();
        JTextField textField = (JTextField)pMenu.getInvoker();
        String name = textField.getName();
        textField.setToolTipText(inputValue);
        if (name.indexOf("v") != -1) {
            int index = Integer.parseInt(name.substring(1));
            System.out.print("Index Var: " + index);
            this.mVComments.put(index - 1, inputValue);
        }
    }

    private void jTextFieldVar1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldVar3MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldVar5MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldVar2MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldVar4MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldVar6MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mLastPopUp = evt.getComponent();
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jTextFieldNoVarsActionPerformed(ActionEvent evt) {
    }

    public void saveTextFieldcontent() {
        block8: for (int i = 0; i < this.mCurrentStatement.getVarNumberStatement(); ++i) {
            switch (i) {
                case 0: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar1.getText(), (String)this.mVComments.get(i));
                    continue block8;
                }
                case 1: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar2.getText(), (String)this.mVComments.get(i));
                    continue block8;
                }
                case 2: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar3.getText(), this.mVComments.get(i).toString());
                    continue block8;
                }
                case 3: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar4.getText(), this.mVComments.get(i).toString());
                    continue block8;
                }
                case 4: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar6.getText(), this.mVComments.get(i).toString());
                    continue block8;
                }
                case 5: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar5.getText(), this.mVComments.get(i).toString());
                }
            }
        }
        this.mStatementPool.put(this.mCurrentStatement);
    }

    private void reReadAllFromGui() {
        this.mCurrentStatement.mDBConnection = new String();
        if (this.jComboBoxDBConnection.getSelectedItem() != null) {
            this.mCurrentStatement.mDBConnection = ((DBConnectionData)this.jComboBoxDBConnection.getSelectedItem()).toString();
        }
        UserSQLStatement newST = null;
        try {
            newST = (UserSQLStatement)this.mCurrentStatement.clone();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mCurrentStatement = newST;
        this.mCurrentStatement.mKlasse = this.jTextFieldKlasse.getText();
        this.mCurrentStatement.mName = this.jTextFieldNAme.getText();
        this.mCurrentStatement.mDescribtion = this.jTextAreaDescribtion.getText();
        this.mCurrentStatement.mStatement = this.jTextAreaStatement.getText();
        this.mCurrentStatement.clearVars();
        block10: for (int i = 0; i < this.mCurrentStatement.getVarNumberStatement(); ++i) {
            switch (i) {
                case 0: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar1.getText(), (String)this.mVComments.get(i));
                    continue block10;
                }
                case 1: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar2.getText(), (String)this.mVComments.get(i));
                    continue block10;
                }
                case 2: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar3.getText(), this.mVComments.get(i).toString());
                    continue block10;
                }
                case 3: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar4.getText(), this.mVComments.get(i).toString());
                    continue block10;
                }
                case 4: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar6.getText(), this.mVComments.get(i).toString());
                    continue block10;
                }
                case 5: {
                    this.mCurrentStatement.setVar(i, this.jTextFieldVar5.getText(), this.mVComments.get(i).toString());
                }
            }
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        Object item;
        int i;
        this.reReadAllFromGui();
        this.mStatementPool.put(this.mCurrentStatement);
        this.mStatementPool.save();
        String currentName = this.mCurrentStatement.mName;
        String currentSelectedClass = (String)this.jComboBoxKlasse.getSelectedItem();
        String currentNewKlass = this.jTextFieldKlasse.getText();
        if (!this.jTextFieldKlasse.getText().equals(currentSelectedClass)) {
            ++this.mClassSetting;
            this.jComboBoxKlasse.removeAllItems();
            Collection<String> colC = this.mStatementPool.getClasses().values();
            Iterator<String> iterC = colC.iterator();
            i = 0;
            while (iterC.hasNext()) {
                item = iterC.next();
                this.jComboBoxKlasse.addItem(item);
                if (((String)item).equals(currentNewKlass)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                }
                ++i;
            }
            this.resetStatementPool(currentName, null);
            --this.mClassSetting;
        }
        Collection<UserSQLStatement> col = this.mStatementPool.getClassStatements((String)this.jComboBoxKlasse.getSelectedItem()).values();
        Iterator<UserSQLStatement> iter = col.iterator();
        ++this.mInComboAdd;
        this.jComboBoxStatement.removeAllItems();
        this.jMenuExecuteNew.removeAll();
        this.jMenuExecuteHere.removeAll();
        while (iter.hasNext()) {
            UserSQLStatement item2 = iter.next();
            this.jComboBoxStatement.addItem(item2);
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(item2.mName);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StatementWindow.this.jMenuItemExecuteNewActionPerformed(evt);
                }
            });
            this.jMenuExecuteNew.add(menuItem);
            JMenuItem menuItem2 = new JMenuItem();
            menuItem2.setText(item2.mName);
            menuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StatementWindow.this.jMenuItemExecuteHereActionPerformed(evt);
                }
            });
            this.jMenuExecuteHere.add(menuItem2);
        }
        iter = col.iterator();
        i = 0;
        while (iter.hasNext()) {
            item = iter.next();
            if (this.mCurrentStatement.mName.equals(((UserSQLStatement)item).mName)) {
                this.jComboBoxStatement.setSelectedIndex(i);
                this.mCurrentStatement = item;
            }
            ++i;
        }
        --this.mInComboAdd;
        this.jComboBoxDBConnection.setSelectedItem(this.mCurrentStatement.mDBConnection);
    }

    private void setStatementToFields(UserSQLStatement st) {
        UserSQLStatement s = this.mStatementPool.get(st.mName);
        if (s != null) {
            ++this.mInComboAdd;
            this.jComboBoxStatement.setSelectedItem(s);
            --this.mInComboAdd;
        }
        Collection<DBConnectionData> col = this.mConnectionPool.getHashMap().values();
        Iterator<DBConnectionData> iter = col.iterator();
        int i = 0;
        ++this.mInDBAdd;
        this.jComboBoxDBConnection.removeAllItems();
        while (iter.hasNext()) {
            DBConnectionData item = iter.next();
            this.jComboBoxDBConnection.addItem(item);
            ++i;
        }
        --this.mInDBAdd;
        DBConnectionData object = this.mConnectionPool.get(st.mDBConnection);
        this.jComboBoxDBConnection.setSelectedItem(object);
        this.jTextAreaStatement.setText(st.mStatement);
        this.jTextAreaDescribtion.setText(st.mDescribtion);
        this.jTextFieldNAme.setText(st.mName);
        this.jTextFieldKlasse.setText(st.mKlasse);
        this.statementChecker();
        if (this.mOraResult != null) {
            this.mOraResult.clearAll();
            AbstractTableModel model = (AbstractTableModel)this.jTableResult.getModel();
            model.fireTableDataChanged();
            model.fireTableStructureChanged();
        }
    }

    private void statementChecker() {
        UserSQLStatement st = this.mCurrentStatement;
        this.jTextFieldVar1.setEditable(false);
        this.jTextFieldVar1.setEnabled(false);
        this.jTextFieldVar2.setEditable(false);
        this.jTextFieldVar2.setEnabled(false);
        this.jTextFieldVar3.setEditable(false);
        this.jTextFieldVar3.setEnabled(false);
        this.jTextFieldVar4.setEditable(false);
        this.jTextFieldVar4.setEnabled(false);
        this.jTextFieldVar6.setEditable(false);
        this.jTextFieldVar6.setEnabled(false);
        this.jTextFieldVar5.setEditable(false);
        this.jTextFieldVar5.setEnabled(false);
        this.jTextFieldNoVars.setText("" + st.getVarNumberStatement());
        block8: for (int i = 0; i < st.getVarNumberStatement(); ++i) {
            switch (i) {
                case 0: {
                    this.jTextFieldVar1.setText(st.getVarString(i));
                    this.jTextFieldVar1.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar1.setEditable(true);
                    this.jTextFieldVar1.setEnabled(true);
                    continue block8;
                }
                case 1: {
                    this.jTextFieldVar2.setText(st.getVarString(i));
                    this.jTextFieldVar2.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar2.setEditable(true);
                    this.jTextFieldVar2.setEnabled(true);
                    continue block8;
                }
                case 2: {
                    this.jTextFieldVar3.setText(st.getVarString(i));
                    this.jTextFieldVar3.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar3.setEditable(true);
                    this.jTextFieldVar3.setEnabled(true);
                    continue block8;
                }
                case 3: {
                    this.jTextFieldVar4.setText(st.getVarString(i));
                    this.jTextFieldVar4.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar4.setEditable(true);
                    this.jTextFieldVar4.setEnabled(true);
                    continue block8;
                }
                case 4: {
                    this.jTextFieldVar6.setText(st.getVarString(i));
                    this.jTextFieldVar6.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar6.setEditable(true);
                    this.jTextFieldVar6.setEnabled(true);
                    continue block8;
                }
                case 5: {
                    this.jTextFieldVar5.setText(st.getVarString(i));
                    this.jTextFieldVar5.setToolTipText(st.getVarComment(i));
                    this.jTextFieldVar5.setEditable(true);
                    this.jTextFieldVar5.setEnabled(true);
                }
            }
        }
    }

    private void jTextAreaStatementFocusLost(FocusEvent evt) {
        this.mCurrentStatement.mStatement = this.jTextAreaStatement.getText();
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
        this.statementChecker();
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        this.mCurrentStatement = new UserSQLStatement();
        this.jTextFieldVar1.setText("");
        this.jTextFieldVar2.setText("");
        this.jTextFieldVar3.setText("");
        this.jTextFieldVar4.setText("");
        this.jTextFieldVar6.setText("");
        this.jTextFieldVar5.setText("");
        this.setCommentsFormST(this.mCurrentStatement);
        this.setStatementToFields(this.mCurrentStatement);
        this.jComboBoxDBConnection.setSelectedItem(-1);
        String klasse = (String)this.jComboBoxKlasse.getSelectedItem();
        if (klasse == null) {
            klasse = new String();
        }
        this.jTextFieldKlasse.setText(klasse);
    }

    private void jComboBoxStatementActionPerformed(ActionEvent evt) {
        if (this.mInComboAdd > 0) {
            return;
        }
        Object item = this.jComboBoxStatement.getSelectedItem();
        this.mCurrentStatement = item == null ? new UserSQLStatement() : this.mStatementPool.get(item.toString());
        this.jTextFieldVar1.setText("");
        this.jTextFieldVar2.setText("");
        this.jTextFieldVar3.setText("");
        this.jTextFieldVar4.setText("");
        this.jTextFieldVar6.setText("");
        this.jTextFieldVar5.setText("");
        this.setCommentsFormST(this.mCurrentStatement);
        this.setStatementToFields(this.mCurrentStatement);
        DBConnectionData object = this.mConnectionPool.get(this.mCurrentStatement.mDBConnection);
        this.jComboBoxDBConnection.setSelectedItem(object);
        this.jTextFieldKlasse.setText(this.mCurrentStatement.mKlasse);
        if (this.mOraResult != null) {
            this.mOraResult.clearAll();
            AbstractTableModel model = (AbstractTableModel)this.jTableResult.getModel();
            model.fireTableDataChanged();
            model.fireTableStructureChanged();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        DBConnectionData c = null;
        try {
            this.reReadAllFromGui();
            c = this.mConnectionPool.get(this.mCurrentStatement.mDBConnection);
            if (c == null) {
                ShowErrorDialog.showErrorDialog("Keine DB Verbindung", "Keine DB-Verbindung ausgew\u00e4hlt");
                return;
            }
            this.mOraResult = c.getSQLResult();
            this.mOraResult.setStatement(this.mCurrentStatement);
            c.openConnection();
            if (!this.mOraResult.doDBQuery()) {
                ShowErrorDialog.showErrorDialog(this.mOraResult.getLastError(), this.mOraResult.getLastException().toString());
            } else {
                this.setTableData();
            }
            c.closeConnection();
        }
        catch (Throwable e) {
            c.closeConnection();
            e.printStackTrace();
            ShowErrorDialog.showErrorDialog("Unexpected Exception", e.toString());
        }
    }

    private void jTextFieldVar1FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(0, this.jTextFieldVar1.getText(), (String)this.mVComments.get(0));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jTextFieldVar2FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(1, this.jTextFieldVar2.getText(), (String)this.mVComments.get(1));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jTextFieldVar3FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(2, this.jTextFieldVar3.getText(), (String)this.mVComments.get(2));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jTextFieldVar4FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(3, this.jTextFieldVar4.getText(), (String)this.mVComments.get(3));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jTextFieldVar5FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(4, this.jTextFieldVar5.getText(), (String)this.mVComments.get(4));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jTextFieldVar6FocusLost(FocusEvent evt) {
        this.mCurrentStatement.setVar(5, this.jTextFieldVar6.getText(), (String)this.mVComments.get(5));
        this.jTextAreaStatement.setToolTipText(this.mCurrentStatement.getBuildStatement());
    }

    private void jComboBoxDBConnectionActionPerformed(ActionEvent evt) {
        if (this.mInDBAdd > 0) {
            return;
        }
        this.mCurrentStatement.mDBConnection = new String();
        if (this.jComboBoxDBConnection.getSelectedItem() != null) {
            this.mCurrentStatement.mDBConnection = ((DBConnectionData)this.jComboBoxDBConnection.getSelectedItem()).toString();
        }
    }

    private void jTableResultMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            JTable table = (JTable)evt.getSource();
            this.mRow = table.convertRowIndexToModel(table.rowAtPoint(evt.getPoint()));
            this.mCol = table.convertColumnIndexToModel(table.columnAtPoint(evt.getPoint()));
            try {
                this.mLastObject = this.mOraResult.getData(this.mRow, this.mCol);
                if (this.mLastObject.mIsLob) {
                    this.mLastPopUp = evt.getComponent();
                    this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.mLastPopUp = evt.getComponent();
                    this.jPopupMenu3.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void jMenuItemExportActionPerformed(ActionEvent evt) {
        try {
            File destPath = new File(Global.mBaseDir + "LOB_" + this.mLastObject.mTableName + "_" + this.mLastObject.mColumnName + "_" + this.mRow + "_" + this.mCol + ".lob");
            FileOutputStream fout = new FileOutputStream(destPath);
            fout.write(this.mLastObject.mLobData);
            fout.close();
        }
        catch (Throwable e) {
            ShowErrorDialog.showErrorDialog("Write Error", e.toString());
        }
    }

    private void jTextFieldVar4ActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxSt2ActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        this.clearAllFields();
        String klasse = (String)this.jComboBoxKlasse.getSelectedItem();
        if (klasse == null) {
            klasse = new String();
        }
        this.jTextFieldKlasse.setText(klasse);
        this.resetStatementPool(null, null);
    }

    private void jMenuItemExportTableActionPerformed(ActionEvent evt) {
        String name = InputDialog.showInputDialog("Enter Filename:");
        try {
            PrintWriter pw = new PrintWriter(name);
            int colCount = this.jTableResult.getColumnCount();
            int rowCount = this.jTableResult.getRowCount();
            for (int i = 0; i < colCount; ++i) {
                if (i != 0) {
                    pw.print(";");
                }
                pw.print(this.jTableResult.getColumnName(i));
            }
            pw.print("\n");
            TableModel model = this.jTableResult.getModel();
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    if (c != 0) {
                        pw.print(";");
                    }
                    pw.print(model.getValueAt(r, c));
                }
                pw.print("\n");
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    private void jMenuItemHideColumnActionPerformed(ActionEvent evt) {
        JTable table = (JTable)evt.getSource();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.jTableResult.setAutoResizeMode(0);
        } else {
            this.jTableResult.setAutoResizeMode(2);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        ExcelHelper.toExcel(this.jTableResult);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DBConnectionData c = null;
        try {
            this.reReadAllFromGui();
            c = this.mConnectionPool.get(this.mCurrentStatement.mDBConnection);
            if (c == null) {
                ShowErrorDialog.showErrorDialog("Keine DB Verbindung", "Keine DB-Verbindung ausgew\u00e4hlt");
                return;
            }
            this.mOraResult = c.getSQLResult();
            this.mOraResult.setStatement(this.mCurrentStatement);
            c.openConnection();
            if (!this.mOraResult.doDBChange()) {
                ShowErrorDialog.showErrorDialog(this.mOraResult.getLastError(), this.mOraResult.getLastException().toString());
            } else {
                this.setTableData();
            }
            c.commit();
            c.closeConnection();
        }
        catch (Throwable e) {
            c.rollback();
            c.closeConnection();
            e.printStackTrace();
            ShowErrorDialog.showErrorDialog("Unexpected Exception", e.toString());
        }
    }

    private void setTableData() {
        if (this.mOraResult == null) {
            return;
        }
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return StatementWindow.this.mOraResult.getColumnName(col);
            }

            @Override
            public int getRowCount() {
                return StatementWindow.this.mOraResult.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return StatementWindow.this.mOraResult.getColumnCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                String result = "";
                try {
                    result = StatementWindow.this.mOraResult.getData((int)row, (int)col).mData;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return result;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.jLabelTableSize.setText("Size: " + this.mOraResult.getRowCount() + "x" + this.mOraResult.getColumnCount());
        this.jTableResult.setModel(model);
    }

    private void clearAllFields() {
        ++this.mInComboAdd;
        ++this.mInDBAdd;
        ++this.mClassSetting;
        this.setStatement(new UserSQLStatement());
        --this.mInComboAdd;
        --this.mInDBAdd;
        --this.mClassSetting;
    }

    @Override
    public void deIconified() {
    }
}

