/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.Global;
import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.jdbc.UserSQLStatementXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class UserSQLStatement
implements Serializable,
Cloneable {
    public String mKlasse;
    public String mName;
    public String mDescribtion;
    public String mStatement;
    public String mDBConnection;
    private HashMap mVars = new HashMap();
    private HashMap mStatements = new HashMap();
    private static UserSQLStatementXMLHandler XMLHANDLER = new UserSQLStatementXMLHandler();

    private String exportXML() {
        String s = new String();
        s = s + "\t<Statement>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mKlasse) + "</Class>\n";
        s = s + "\t\t<Describtion>" + UtilityString.toXML(this.mDescribtion) + "</Describtion>\n";
        s = s + "\t\t<SQLStatement>" + UtilityString.toXML(this.mStatement) + "</SQLStatement>\n";
        s = s + "\t\t<DBConnection>" + UtilityString.toXML(this.mDBConnection) + "</DBConnection>\n";
        s = s + "\t\t<Variables>\n";
        for (int i = 0; i < this.getVarNumberStatement(); ++i) {
            String var = this.getVarString(i);
            String comment = this.getVarComment(i);
            if (var == null) {
                var = new String();
            }
            if (comment == null) {
                comment = new String();
            }
            s = s + "\t\t\t<Variable>\n";
            s = s + "\t\t\t\t<Position>" + i + "</Position>\n";
            s = s + "\t\t\t\t<VariableContent>" + UtilityString.toXML(var) + "</VariableContent>\n";
            s = s + "\t\t\t\t<Comment>" + UtilityString.toXML(comment) + "</Comment>\n";
            s = s + "\t\t\t</Variable>\n";
        }
        s = s + "\t\t</Variables>\n";
        s = s + "\t</Statement>\n";
        return s;
    }

    public Object clone() throws CloneNotSupportedException {
        UserSQLStatement c = new UserSQLStatement();
        c.mKlasse = this.mKlasse;
        c.mName = this.mName;
        c.mDescribtion = this.mDescribtion;
        c.mStatement = this.mStatement;
        c.mDBConnection = this.mDBConnection;
        c.mVars = new HashMap();
        int i = 0;
        String s = this.getVarString(i);
        while (s != null) {
            String cm = this.getVarComment(i);
            c.setVar(i, s, cm);
            s = this.getVarString(i);
            ++i;
        }
        c.mStatements = new HashMap();
        return c;
    }

    public UserSQLStatement() {
        this.mName = new String();
        this.mDescribtion = new String();
        this.mStatement = new String();
        this.mDBConnection = new String();
        this.mKlasse = new String();
    }

    public UserSQLStatement getCountStatement() {
        UserSQLStatement count = null;
        try {
            count = (UserSQLStatement)this.clone();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String statement = count.getStatement();
        statement = UtilityString.replaceWhiteSpaces(statement, " ");
        int index = statement.toUpperCase().indexOf(" FROM ");
        String rep = statement.substring(index);
        count.mStatement = "select count(*) " + rep;
        return count;
    }

    public UserSQLStatement getSumCountStatement() {
        UserSQLStatement count = null;
        try {
            count = (UserSQLStatement)this.clone();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String statement = count.getStatement();
        statement = UtilityString.replaceWhiteSpaces(statement, " ");
        int index = statement.toUpperCase().indexOf(" FROM ");
        String rep = statement.substring(index);
        count.mStatement = "select sum(count(*)) " + rep;
        return count;
    }

    public String getStatement() {
        return this.mStatement;
    }

    public String getVarString(int v) {
        Var var = (Var)this.mVars.get(v);
        if (var != null) {
            return var.st;
        }
        return null;
    }

    public String getVarComment(int v) {
        Var var = (Var)this.mVars.get(v);
        if (var != null) {
            return var.co;
        }
        return null;
    }

    public String getBuildStatement() {
        String build = this.mStatement;
        for (int i = 0; i < this.getVarNumberStatement(); ++i) {
            String var = this.getVarString(i);
            if (var == null) continue;
            build = UtilityString.replace(build, "$v" + i, var);
        }
        return build;
    }

    public int getVarNumberStatement() {
        int count = 0;
        int start = 0;
        while (start != -1) {
            if ((start = this.mStatement.indexOf("$v", start)) == -1) continue;
            ++count;
            ++start;
        }
        return count;
    }

    public int getStatementNumberStatement() {
        int count = 0;
        int start = 0;
        while (start != -1) {
            if ((start = this.mStatement.indexOf("$s", start)) == -1) continue;
            ++count;
        }
        return count;
    }

    public int getVarNumberSet() {
        return this.mVars.size();
    }

    public void setVar(int i, String s, String c) {
        Var var = new Var(i, s, c);
        this.mVars.put(i, var);
    }

    public void clearVars() {
        this.mVars.clear();
    }

    public String toString() {
        return this.mName;
    }

    public static UserSQLStatementXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<UserSQLStatement> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename);
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllStatements>\n");
            for (UserSQLStatement item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllStatements>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, UserSQLStatement> getHashMapFromXML(String filename) {
        HashMap<String, UserSQLStatement> userSQLStatement = new HashMap<String, UserSQLStatement>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            UserSQLStatementXMLHandler h = UserSQLStatement.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            userSQLStatement = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ShowWarningDialog.showWarningDialog("Statements Lade Problem...", e.toString());
        }
        return userSQLStatement;
    }

    class Var
    implements Serializable {
        public int no;
        public String st;
        public String co;

        public Var(int n, String s, String c) {
            this.no = n;
            this.st = s;
            this.co = c;
        }
    }
}

