/*
 * Decompiled with CFR 0.152.
 */
package de.malban.script;

import de.malban.Global;
import de.malban.script.ExportDataXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ExportData {
    protected String mClass = "";
    public String mName = "";
    protected String mComment = "";
    protected String mScript = "";
    private static ExportDataXMLHandler XMLHANDLER = new ExportDataXMLHandler();

    public String getComment() {
        return this.mComment;
    }

    public void setComment(String Comment2) {
        this.mComment = Comment2;
    }

    public String getScript() {
        return this.mScript;
    }

    public void setScript(String Script) {
        this.mScript = Script;
    }

    private String exportXML() {
        String s = new String();
        s = s + "\t<ExportData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<Comment>" + UtilityString.toXML(this.mComment) + "</Comment>\n";
        s = s + "\t\t<Script>" + UtilityString.toXML(this.mScript) + "</Script>\n";
        s = s + "\t</ExportData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static ExportDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ExportData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllExportData>\n");
            for (ExportData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllExportData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, ExportData> getHashMapFromXML(String filename) {
        HashMap<String, ExportData> filters = new HashMap<String, ExportData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ExportDataXMLHandler h = ExportData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ExportData Load Error...", 1);
        }
        return filters;
    }
}

