/*
 * Decompiled with CFR 0.152.
 */
package de.malban.script;

import de.malban.graphics.ImageSequenceData;
import de.malban.graphics.ImageSourceEdit;
import de.malban.script.ExportData;
import de.malban.script.ExportDataPool;
import de.malban.script.ScriptEnvironment;
import de.malban.util.syntax.Syntax.HighlightedDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;

public class ExportDataPanel
extends JPanel {
    private HighlightedDocument document = new HighlightedDocument(-1);
    private ExportData mExportData = new ExportData();
    private ExportDataPool mExportDataPool;
    private int mClassSetting = 0;
    private String mType = "NONE";
    Collection mCollection = null;
    ImageSourceEdit imageSourceEdit = null;
    private JButton jButton2;
    private JButton jButtonDelete;
    private JButton jButtonExecute;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JTextArea jTextAreaComment;
    private JTextArea jTextAreaOutput;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextPane jTextPaneScript;

    public ExportDataPanel() {
        this.initComponents();
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(false, "");
        this.jLabel1.setVisible(false);
    }

    public void setData(ImageSourceEdit ise) {
        this.jLabel1.setVisible(false);
        this.imageSourceEdit = ise;
        this.mType = "ImageSequence Batch";
    }

    public void setData(Collection col) {
        this.mCollection = col;
        if (col == null) {
            return;
        }
        if (col.isEmpty()) {
            return;
        }
        if (col.toArray()[0] instanceof ImageSequenceData) {
            this.mType = "ImageSequence";
        }
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(false, this.mType);
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        this.jComboBoxKlasse.removeAllItems();
        this.jComboBoxKlasse.addItem(klasseToSet);
        this.jTextFieldKlasse.setText(klasseToSet);
        this.jComboBoxKlasse.setSelectedIndex(0);
        Collection<ExportData> colC = this.mExportDataPool.getMapForKlasse(klasseToSet).values();
        Iterator<ExportData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        int i = 0;
        while (iterC.hasNext()) {
            ExportData item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mExportData = this.mExportDataPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mExportData.mName);
        this.jTextFieldName.setText(this.mExportData.mName);
        this.jTextAreaComment.setText(this.mExportData.mComment);
        this.jTextPaneScript.setText(this.mExportData.mScript);
        this.jTextAreaOutput.setText("");
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mExportData.mClass = this.jTextFieldKlasse.getText();
        this.mExportData.mName = this.jTextFieldName.getText();
        this.mExportData.mComment = this.jTextAreaComment.getText();
        this.mExportData.mScript = this.jTextPaneScript.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPaneScript = new JTextPane();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jLabel6 = new JLabel();
        this.jButtonExecute = new JButton();
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setEnabled(false);
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jTextFieldKlasse.setEditable(false);
        this.jTextFieldKlasse.setEnabled(false);
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldName, GroupLayout.Alignment.LEADING, -1, 243, Short.MAX_VALUE).addComponent(this.jTextFieldKlasse, GroupLayout.Alignment.LEADING, -1, 243, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKlasse, 0, 243, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, 243, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jButtonNew)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setPreferredSize(new Dimension(674, 100));
        this.jTextPaneScript.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExportDataPanel.this.jTextPaneScriptFocusLost(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTextPaneScript);
        this.jLabel5.setText("Script");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel2.setText("Coment");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5).addContainerGap()).addComponent(this.jScrollPane4));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4)));
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaOutput);
        this.jLabel6.setText("Output");
        this.jButtonExecute.setText("Execute");
        this.jButtonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonExecuteActionPerformed(evt);
            }
        });
        this.jButton2.setText("Help");
        this.jLabel1.setForeground(new Color(255, 0, 0));
        this.jLabel1.setText("ImageSourceEdit Batching");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonExecute).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2)).addComponent(this.jScrollPane2).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonExecute).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(60, 60, 60).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 382, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel3, -1, 520, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 501, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        this.clearAll();
        this.resetConfigPool(false, "");
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mExportDataPool.put(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mExportData.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mExportData = new ExportData();
        this.readAllToCurrent();
        this.mExportDataPool.putAsNew(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mExportData.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mExportDataPool.remove(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
    }

    private void jTextPaneScriptFocusLost(FocusEvent evt) {
    }

    private void jButtonExecuteActionPerformed(ActionEvent evt) {
        String script = this.jTextPaneScript.getText();
        ScriptEnvironment ev = new ScriptEnvironment(script);
        if (this.mType.equals("ImageSequence")) {
            ev.setData(this.mCollection);
        } else if (this.mType.equals("ImageSequence Batch")) {
            ev.setData(this.imageSourceEdit);
        }
        ev.execute();
        this.jTextAreaOutput.setText(ev.getOutString());
    }
}

