/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound;

import de.malban.sound.AudioPlayable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PlaySound
implements AudioPlayable,
Runnable {
    private String filename;
    private Position curPosition;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    Thread player = null;
    SourceDataLine auline = null;

    public PlaySound() {
    }

    public PlaySound(String wavfile) {
        this.filename = wavfile;
        this.curPosition = Position.NORMAL;
    }

    public PlaySound(String wavfile, Position p) {
        this.filename = wavfile;
        this.curPosition = p;
    }

    @Override
    public boolean play() {
        Thread player = new Thread(this);
        player.start();
        return true;
    }

    @Override
    public void deinit() {
        if (this.player != null) {
            this.player.interrupt();
            this.player = null;
        }
        if (this.auline != null) {
            this.auline.drain();
            this.auline.close();
            this.auline = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playVectrex(byte[] data2) {
        AudioInputStream audioInputStream;
        ByteArrayInputStream bis = new ByteArrayInputStream(data2);
        try {
            audioInputStream = AudioSystem.getAudioInputStream(bis);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(info);
            this.auline.open(format);
        }
        catch (LineUnavailableException e) {
            this.auline = null;
            return;
        }
        catch (Exception e) {
            this.auline = null;
            return;
        }
        if (this.auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl pan = (FloatControl)this.auline.getControl(FloatControl.Type.PAN);
            if (this.curPosition == Position.RIGHT) {
                pan.setValue(1.0f);
            } else if (this.curPosition == Position.LEFT) {
                pan.setValue(-1.0f);
            }
        }
        this.auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead < 0) continue;
                this.auline.write(abData, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            return;
        }
        finally {
            this.auline.drain();
            this.auline.close();
            this.auline = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File soundFile = new File(this.filename);
        if (!soundFile.exists()) {
            return;
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (UnsupportedAudioFileException e1) {
            return;
        }
        catch (IOException e1) {
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(info);
            this.auline.open(format);
        }
        catch (LineUnavailableException e) {
            this.auline = null;
            return;
        }
        catch (Exception e) {
            this.auline = null;
            return;
        }
        if (this.auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl pan = (FloatControl)this.auline.getControl(FloatControl.Type.PAN);
            if (this.curPosition == Position.RIGHT) {
                pan.setValue(1.0f);
            } else if (this.curPosition == Position.LEFT) {
                pan.setValue(-1.0f);
            }
        }
        this.auline.start();
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
                if (nBytesRead < 0) continue;
                this.auline.write(abData, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            return;
        }
        finally {
            this.auline.drain();
            this.auline.close();
            this.auline = null;
        }
    }

    public static enum Position {
        LEFT,
        RIGHT,
        NORMAL;

    }
}

