/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.tinysound.Music;
import de.malban.sound.tinysound.Sound;
import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.internal.ByteList;
import de.malban.sound.tinysound.internal.MemMusic;
import de.malban.sound.tinysound.internal.MemSound;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.StreamInfo;
import de.malban.sound.tinysound.internal.StreamMusic;
import de.malban.sound.tinysound.internal.StreamSound;
import de.malban.sound.tinysound.internal.StreamStreamMod;
import de.malban.sound.tinysound.internal.StreamStreamVectrex;
import de.malban.sound.tinysound.internal.StreamStreamWav1Channel;
import de.malban.sound.tinysound.internal.StreamStreamWav2Channel;
import de.malban.sound.tinysound.internal.UpdateRunner;
import de.malban.vide.VideConfig;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class TinySound {
    public static final String VERSION = "1.1.1";
    public static final AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    private static Mixer mixer;
    private static SourceDataLine outLine;
    private static boolean inited;
    private static UpdateRunner autoUpdater;
    private static int soundCount;

    public static void init() {
        if (inited) {
            return;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, FORMAT);
        if (!AudioSystem.isLineSupported(info)) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unsupported output format!", LogPanel.WARN);
            return;
        }
        outLine = TinySound.tryGetLine();
        if (outLine == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Output line unavailable!", LogPanel.WARN);
            return;
        }
        outLine.start();
        TinySound.finishInit();
        double v = (double)VideConfig.getConfig().masterVolume / 255.0;
        TinySound.setGlobalVolume(v);
    }

    public static void init(Mixer.Info info) throws LineUnavailableException, SecurityException, IllegalArgumentException {
        if (inited) {
            return;
        }
        javax.sound.sampled.Mixer mixer = AudioSystem.getMixer(info);
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, FORMAT);
        outLine = (SourceDataLine)mixer.getLine(lineInfo);
        outLine.open(FORMAT);
        outLine.start();
        TinySound.finishInit();
    }

    private static void finishInit() {
        mixer = new Mixer();
        autoUpdater = new UpdateRunner(mixer, outLine);
        Thread updateThread = new Thread((Runnable)autoUpdater, "TinySound Updater");
        try {
            updateThread.setDaemon(true);
            updateThread.setPriority(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        inited = true;
        updateThread.start();
        Thread.yield();
    }

    public static void shutdown() {
        if (!inited) {
            return;
        }
        inited = false;
        autoUpdater.stop();
        autoUpdater = null;
        outLine.stop();
        outLine.flush();
        mixer.clearMusic();
        mixer.clearSounds();
        mixer = null;
    }

    public static boolean isInitialized() {
        return inited;
    }

    public static double getGlobalVolume() {
        if (!inited) {
            return -1.0;
        }
        return mixer.getVolume();
    }

    public static void setGlobalVolume(double volume) {
        if (!inited) {
            return;
        }
        mixer.setVolume(volume);
    }

    public static Music loadMusic(String name) {
        return TinySound.loadMusic(name, false);
    }

    public static Music loadMusic(String name, boolean streamFromFile) {
        URL url;
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (name == null) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = TinySound.class.getResource(name)) == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unable to find resource " + name + "!", LogPanel.WARN);
            return null;
        }
        return TinySound.loadMusic(url, streamFromFile);
    }

    public static Music loadMusic(File file) {
        return TinySound.loadMusic(file, false);
    }

    public static Music loadMusic(File file, boolean streamFromFile) {
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (file == null) {
            return null;
        }
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unable to find resource " + file + "!", LogPanel.WARN);
            return null;
        }
        return TinySound.loadMusic(url, streamFromFile);
    }

    public static Music loadMusic(URL url) {
        return TinySound.loadMusic(url, false);
    }

    public static Music loadMusic(URL url, boolean streamFromFile) {
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (url == null) {
            return null;
        }
        AudioInputStream audioStream = TinySound.getValidAudioStream(url);
        if (audioStream == null) {
            return null;
        }
        byte[][] data2 = TinySound.readAllBytes(audioStream);
        if (data2 == null) {
            return null;
        }
        if (streamFromFile) {
            StreamInfo info = TinySound.createFileStream(data2);
            if (info == null) {
                return null;
            }
            StreamMusic sm = null;
            try {
                sm = new StreamMusic(info.URL, info.NUM_BYTES_PER_CHANNEL, mixer);
            }
            catch (IOException e) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed to create StreamMusic!", LogPanel.WARN);
            }
            return sm;
        }
        return new MemMusic(data2[0], data2[1], mixer);
    }

    public static Sound loadSound(String name) {
        return TinySound.loadSound(name, false);
    }

    public static Sound loadSound(String name, boolean streamFromFile) {
        URL url;
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (name == null) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = TinySound.class.getResource(name)) == null) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unable to find resource " + name + "!", LogPanel.WARN);
            return null;
        }
        return TinySound.loadSound(url, streamFromFile);
    }

    public static Sound loadSound(File file) {
        return TinySound.loadSound(file, false);
    }

    public static Sound loadSound(File file, boolean streamFromFile) {
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (file == null) {
            return null;
        }
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unable to find file " + file + "!", LogPanel.WARN);
            return null;
        }
        return TinySound.loadSound(url, streamFromFile);
    }

    public static Sound loadSound(URL url) {
        return TinySound.loadSound(url, false);
    }

    public static Sound loadSound(URL url, boolean streamFromFile) {
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if (url == null) {
            return null;
        }
        AudioInputStream audioStream = TinySound.getValidAudioStream(url);
        return TinySound.loadSound(audioStream, streamFromFile);
    }

    public static Sound loadSound(AudioInputStream audioStream, boolean streamFromFile) {
        if (!inited) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: TinySound not initialized!", LogPanel.WARN);
            return null;
        }
        if ((audioStream = TinySound.ensureFormat(audioStream)) == null) {
            return null;
        }
        byte[][] data2 = TinySound.readAllBytes(audioStream);
        if (data2 == null) {
            return null;
        }
        if (streamFromFile) {
            StreamInfo info = TinySound.createFileStream(data2);
            if (info == null) {
                return null;
            }
            StreamSound ss = null;
            try {
                ss = new StreamSound(info.URL, info.NUM_BYTES_PER_CHANNEL, mixer, soundCount);
                ++soundCount;
            }
            catch (IOException e) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed to create StreamSound!", LogPanel.WARN);
            }
            return ss;
        }
        return new MemSound(data2[0], data2[1], mixer, ++soundCount);
    }

    public static Stream getOutStreamVectrex() {
        return new StreamStreamVectrex(mixer, soundCount++, 0);
    }

    public static Stream getOutStreamMod() {
        return new StreamStreamMod(mixer, soundCount++, 0);
    }

    public static Stream getOutStream() {
        return new StreamStreamWav1Channel(mixer, soundCount++, 0);
    }

    public static Stream getOutStream2() {
        return new StreamStreamWav2Channel(mixer, soundCount++, 0);
    }

    private static byte[][] readAllBytes(AudioInputStream stream) {
        Object data2 = null;
        int numChannels = stream.getFormat().getChannels();
        if (numChannels == 1) {
            byte[] left = TinySound.readAllBytesOneChannel(stream);
            if (left == null) {
                return null;
            }
            data2 = new byte[2][];
            data2[0] = left;
            data2[1] = left;
        } else if (numChannels == 2) {
            data2 = TinySound.readAllBytesTwoChannel(stream);
        } else {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unable to read " + numChannels + " channels!", LogPanel.WARN);
        }
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAllBytesOneChannel(AudioInputStream stream) {
        byte[] data2 = null;
        try {
            data2 = TinySound.getBytes(stream);
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error reading all bytes from stream!", LogPanel.WARN);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[][] readAllBytesTwoChannel(AudioInputStream stream) {
        Object data2 = null;
        try {
            byte[] allBytes = TinySound.getBytes(stream);
            byte[] left = new byte[allBytes.length / 2];
            byte[] right = new byte[allBytes.length / 2];
            int i = 0;
            int j = 0;
            while (i < allBytes.length) {
                left[j] = allBytes[i];
                left[j + 1] = allBytes[i + 1];
                right[j] = allBytes[i + 2];
                right[j + 1] = allBytes[i + 3];
                i += 4;
                j += 2;
            }
            data2 = new byte[2][];
            data2[0] = left;
            data2[1] = right;
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error reading all bytes from stream!", LogPanel.WARN);
            byte[][] byArray = null;
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return data2;
    }

    private static AudioInputStream getValidAudioStream(URL url) {
        try {
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(url);
            audioStream = TinySound.ensureFormat(audioStream);
            return audioStream;
        }
        catch (UnsupportedAudioFileException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Unsupported audio resource!\n" + e.getMessage(), LogPanel.WARN);
            return null;
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error getting resource stream!\n" + e.getMessage(), LogPanel.WARN);
            return null;
        }
    }

    private static AudioInputStream ensureFormat(AudioInputStream audioStream) {
        if (audioStream == null) {
            return null;
        }
        try {
            AudioFormat streamFormat = audioStream.getFormat();
            AudioFormat mono16 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
            AudioFormat mono8 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 1, 1, 44100.0f, false);
            AudioFormat stereo8 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 2, 2, 44100.0f, false);
            if (streamFormat.matches(FORMAT) || streamFormat.matches(mono16)) {
                return audioStream;
            }
            if (AudioSystem.isConversionSupported(FORMAT, streamFormat)) {
                audioStream = AudioSystem.getAudioInputStream(FORMAT, audioStream);
            } else if (AudioSystem.isConversionSupported(mono16, streamFormat)) {
                audioStream = AudioSystem.getAudioInputStream(mono16, audioStream);
            } else if (streamFormat.matches(stereo8) || AudioSystem.isConversionSupported(stereo8, streamFormat)) {
                if (!streamFormat.matches(stereo8)) {
                    audioStream = AudioSystem.getAudioInputStream(stereo8, audioStream);
                }
                audioStream = TinySound.convertStereo8Bit(audioStream);
            } else if (streamFormat.matches(mono8) || AudioSystem.isConversionSupported(mono8, streamFormat)) {
                if (!streamFormat.matches(mono8)) {
                    audioStream = AudioSystem.getAudioInputStream(mono8, audioStream);
                }
                audioStream = TinySound.convertMono8Bit(audioStream);
            } else {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound:Unable to convert audio resource!\n" + audioStream + "\n" + streamFormat, LogPanel.WARN);
                audioStream.close();
                return null;
            }
            long frameLength = audioStream.getFrameLength();
            if (frameLength > Integer.MAX_VALUE) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Audio resource too long!", LogPanel.WARN);
                return null;
            }
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error getting resource stream!\n" + e.getMessage(), LogPanel.WARN);
            return null;
        }
        return audioStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AudioInputStream convertMono8Bit(AudioInputStream stream) {
        byte[] newData = null;
        try {
            byte[] data2 = TinySound.getBytes(stream);
            int newNumBytes = data2.length * 2;
            if (newNumBytes < 0) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Audio resource too long!", LogPanel.WARN);
                AudioInputStream audioInputStream = null;
                return audioInputStream;
            }
            newData = new byte[newNumBytes];
            int i = 0;
            int j = 0;
            while (i < data2.length) {
                double floatVal;
                if ((floatVal /= (floatVal = (double)data2[i]) < 0.0 ? 128.0 : 127.0) < -1.0) {
                    floatVal = -1.0;
                } else if (floatVal > 1.0) {
                    floatVal = 1.0;
                }
                int val = (int)(floatVal * 32767.0);
                newData[j + 1] = (byte)(val >> 8 & 0xFF);
                newData[j] = (byte)(val & 0xFF);
                ++i;
                j += 2;
            }
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error reading all bytes from stream!", LogPanel.WARN);
            AudioInputStream audioInputStream = null;
            return audioInputStream;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        AudioFormat mono16 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false);
        return new AudioInputStream(new ByteArrayInputStream(newData), mono16, newData.length / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AudioInputStream convertStereo8Bit(AudioInputStream stream) {
        byte[] newData = null;
        try {
            byte[] data2 = TinySound.getBytes(stream);
            int newNumBytes = data2.length * 2 * 2;
            if (newNumBytes < 0) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Audio resource too long!", LogPanel.WARN);
                AudioInputStream audioInputStream = null;
                return audioInputStream;
            }
            newData = new byte[newNumBytes];
            int i = 0;
            int j = 0;
            while (i < data2.length) {
                double leftFloatVal = data2[i];
                double rightFloatVal = data2[i + 1];
                leftFloatVal /= leftFloatVal < 0.0 ? 128.0 : 127.0;
                rightFloatVal /= rightFloatVal < 0.0 ? 128.0 : 127.0;
                if (leftFloatVal < -1.0) {
                    leftFloatVal = -1.0;
                } else if (leftFloatVal > 1.0) {
                    leftFloatVal = 1.0;
                }
                if (rightFloatVal < -1.0) {
                    rightFloatVal = -1.0;
                } else if (rightFloatVal > 1.0) {
                    rightFloatVal = 1.0;
                }
                int leftVal = (int)(leftFloatVal * 32767.0);
                int rightVal = (int)(rightFloatVal * 32767.0);
                newData[j + 1] = (byte)(leftVal >> 8 & 0xFF);
                newData[j] = (byte)(leftVal & 0xFF);
                newData[j + 3] = (byte)(rightVal >> 8 & 0xFF);
                newData[j + 2] = (byte)(rightVal & 0xFF);
                i += 2;
                j += 4;
            }
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Error reading all bytes from stream!", LogPanel.WARN);
            AudioInputStream audioInputStream = null;
            return audioInputStream;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        AudioFormat stereo16 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
        return new AudioInputStream(new ByteArrayInputStream(newData), stereo16, newData.length / 4);
    }

    private static byte[] getBytes(AudioInputStream stream) throws IOException {
        int bufSize = (int)FORMAT.getSampleRate() * FORMAT.getChannels() * FORMAT.getFrameSize();
        byte[] buf = new byte[bufSize];
        ByteList list2 = new ByteList(bufSize);
        int numRead = 0;
        while ((numRead = stream.read(buf)) > -1) {
            for (int i = 0; i < numRead; ++i) {
                list2.add(buf[i]);
            }
        }
        return list2.asArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StreamInfo createFileStream(byte[][] data2) {
        File temp = null;
        try {
            temp = File.createTempFile("tiny", "sound");
            temp.deleteOnExit();
        }
        catch (IOException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed to create file for streaming!", LogPanel.WARN);
            return null;
        }
        URL url = null;
        try {
            url = temp.toURI().toURL();
        }
        catch (MalformedURLException e1) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed to get URL for stream file!", LogPanel.WARN);
            return null;
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(temp), 524288);
        }
        catch (FileNotFoundException e) {
            ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed to open stream file for writing!", LogPanel.WARN);
            return null;
        }
        try {
            for (int i = 0; i < data2[0].length; i += 2) {
                try {
                    ((OutputStream)out).write(data2[0], i, 2);
                    ((OutputStream)out).write(data2[1], i, 2);
                    continue;
                }
                catch (IOException e) {
                    ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed writing bytes to stream file!", LogPanel.WARN);
                    StreamInfo streamInfo = null;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e2) {
                        ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed closing stream file after writing!", LogPanel.WARN);
                    }
                    return streamInfo;
                }
            }
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                ((LogPanel)Configuration.getConfiguration().getDebugEntity()).addLog("TinySound: Failed closing stream file after writing!", LogPanel.WARN);
            }
        }
        return new StreamInfo(url, data2[0].length);
    }

    private static SourceDataLine tryGetLine() {
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, FORMAT);
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfos.length; ++i) {
            javax.sound.sampled.Mixer mixer = null;
            try {
                mixer = AudioSystem.getMixer(mixerInfos[i]);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (mixer == null || !mixer.isLineSupported(lineInfo)) continue;
            SourceDataLine line = null;
            try {
                line = (SourceDataLine)mixer.getLine(lineInfo);
                if (!line.isOpen()) {
                    line.open(FORMAT);
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (line == null || !line.isOpen()) continue;
            return line;
        }
        return null;
    }

    static {
        inited = false;
        soundCount = 0;
    }
}

