/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Music;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.MusicReference;

public class MemMusic
implements Music {
    private byte[] left;
    private byte[] right;
    private Mixer mixer;
    private MusicReference reference;

    public MemMusic(byte[] left, byte[] right, Mixer mixer) {
        this.left = left;
        this.right = right;
        this.mixer = mixer;
        this.reference = new MemMusicReference(this.left, this.right, false, false, 0, 0, 1.0, 0.0);
        this.mixer.registerMusicReference(this.reference);
    }

    @Override
    public void play(boolean loop) {
        this.reference.setLoop(loop);
        this.reference.setPlaying(true);
    }

    @Override
    public void play(boolean loop, double volume) {
        this.setLoop(loop);
        this.setVolume(volume);
        this.reference.setPlaying(true);
    }

    @Override
    public void play(boolean loop, double volume, double pan) {
        this.setLoop(loop);
        this.setVolume(volume);
        this.setPan(pan);
        this.reference.setPlaying(true);
    }

    @Override
    public void stop() {
        this.reference.setPlaying(false);
        this.rewind();
    }

    @Override
    public void pause() {
        this.reference.setPlaying(false);
    }

    @Override
    public void resume() {
        this.reference.setPlaying(true);
    }

    @Override
    public void rewind() {
        this.reference.setPosition(0L);
    }

    @Override
    public void rewindToLoopPosition() {
        long byteIndex = this.reference.getLoopPosition();
        this.reference.setPosition(byteIndex);
    }

    @Override
    public boolean playing() {
        return this.reference.getPlaying();
    }

    @Override
    public boolean done() {
        return this.reference.done();
    }

    @Override
    public boolean loop() {
        return this.reference.getLoop();
    }

    @Override
    public void setLoop(boolean loop) {
        this.reference.setLoop(loop);
    }

    @Override
    public int getLoopPositionByFrame() {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = this.reference.getLoopPosition();
        return (int)(byteIndex / (long)bytesPerChannelForFrame);
    }

    @Override
    public double getLoopPositionBySeconds() {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = this.reference.getLoopPosition();
        return (float)byteIndex / (TinySound.FORMAT.getFrameRate() * (float)bytesPerChannelForFrame);
    }

    @Override
    public void setLoopPositionByFrame(int frameIndex) {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = frameIndex * bytesPerChannelForFrame;
        this.reference.setLoopPosition(byteIndex);
    }

    @Override
    public void setLoopPositionBySeconds(double seconds) {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = (long)(seconds * (double)TinySound.FORMAT.getFrameRate()) * (long)bytesPerChannelForFrame;
        this.reference.setLoopPosition(byteIndex);
    }

    @Override
    public double getVolume() {
        return this.reference.getVolume();
    }

    @Override
    public void setVolume(double volume) {
        if (volume >= 0.0) {
            this.reference.setVolume(volume);
        }
    }

    @Override
    public double getPan() {
        return this.reference.getPan();
    }

    @Override
    public void setPan(double pan) {
        if (pan >= -1.0 && pan <= 1.0) {
            this.reference.setPan(pan);
        }
    }

    @Override
    public void unload() {
        this.mixer.unRegisterMusicReference(this.reference);
        this.reference.dispose();
        this.mixer = null;
        this.left = null;
        this.right = null;
        this.reference = null;
    }

    private static class MemMusicReference
    implements MusicReference {
        private byte[] left;
        private byte[] right;
        private boolean playing;
        private boolean loop;
        private int loopPosition;
        private int position;
        private double volume;
        private double pan;

        public MemMusicReference(byte[] left, byte[] right, boolean playing, boolean loop, int loopPosition, int position, double volume, double pan) {
            this.left = left;
            this.right = right;
            this.playing = playing;
            this.loop = loop;
            this.loopPosition = loopPosition;
            this.position = position;
            this.volume = volume;
            this.pan = pan;
        }

        @Override
        public synchronized boolean getPlaying() {
            return this.playing;
        }

        @Override
        public synchronized boolean getLoop() {
            return this.loop;
        }

        @Override
        public synchronized long getPosition() {
            return this.position;
        }

        @Override
        public synchronized long getLoopPosition() {
            return this.loopPosition;
        }

        @Override
        public synchronized double getVolume() {
            return this.volume;
        }

        @Override
        public synchronized double getPan() {
            return this.pan;
        }

        @Override
        public synchronized void setPlaying(boolean playing) {
            this.playing = playing;
        }

        @Override
        public synchronized void setLoop(boolean loop) {
            this.loop = loop;
        }

        @Override
        public synchronized void setPosition(long position) {
            if (position >= 0L && position < (long)this.left.length) {
                this.position = (int)position;
            }
        }

        @Override
        public synchronized void setLoopPosition(long loopPosition) {
            if (loopPosition >= 0L && loopPosition < (long)this.left.length) {
                this.loopPosition = (int)loopPosition;
            }
        }

        @Override
        public synchronized void setVolume(double volume) {
            this.volume = volume;
        }

        @Override
        public synchronized void setPan(double pan) {
            this.pan = pan;
        }

        @Override
        public synchronized long bytesAvailable() {
            return this.left.length - this.position;
        }

        @Override
        public synchronized boolean done() {
            long available = this.left.length - this.position;
            return available <= 0L && !this.playing;
        }

        @Override
        public synchronized void skipBytes(long num) {
            int i = 0;
            while ((long)i < num) {
                ++this.position;
                if (this.position >= this.left.length) {
                    if (this.loop) {
                        this.position = this.loopPosition;
                    } else {
                        this.playing = false;
                    }
                }
                ++i;
            }
        }

        @Override
        public synchronized void nextTwoBytes(int[] data2, boolean bigEndian) {
            if (bigEndian) {
                data2[0] = this.left[this.position] << 8 | this.left[this.position + 1] & 0xFF;
                data2[1] = this.right[this.position] << 8 | this.right[this.position + 1] & 0xFF;
            } else {
                data2[0] = this.left[this.position + 1] << 8 | this.left[this.position] & 0xFF;
                data2[1] = this.right[this.position + 1] << 8 | this.right[this.position] & 0xFF;
            }
            this.position += 2;
            if (this.position >= this.left.length) {
                if (this.loop) {
                    this.position = this.loopPosition;
                } else {
                    this.playing = false;
                }
            }
        }

        @Override
        public synchronized void dispose() {
            this.playing = false;
            this.position = this.left.length + 1;
            this.left = null;
            this.right = null;
        }
    }
}

