/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Sound;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.PositionListener;
import de.malban.sound.tinysound.internal.SoundReference;
import java.util.ArrayList;

public class MemSound
implements Sound {
    private byte[] left;
    private byte[] right;
    private Mixer mixer;
    private final int ID;
    MemSoundReference ref = null;
    ArrayList<PositionListener> listeners = new ArrayList();

    public void addPositionListener(PositionListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removePositionListener(PositionListener listener) {
        this.listeners.remove(listener);
    }

    void positionChanged(int p) {
        for (PositionListener l : this.listeners) {
            l.positionChanged(p);
        }
    }

    public MemSound(byte[] left, byte[] right, Mixer mixer, int id) {
        this.left = left;
        this.right = right;
        this.mixer = mixer;
        this.ID = id;
    }

    public byte[] getLeftData() {
        return this.left;
    }

    public void setLeftData(byte[] l) {
        this.left = l;
    }

    public byte[] getRightData() {
        return this.right;
    }

    public void setRightData(byte[] r) {
        this.right = r;
    }

    public byte[] getData() {
        byte[] data2 = new byte[this.left.length * 2];
        for (int i = 0; i < this.left.length / 2; ++i) {
            data2[i * 4 + 0] = this.left[i * 2 + 0];
            data2[i * 4 + 1] = this.left[i * 2 + 1];
            data2[i * 4 + 2] = this.right[i * 2 + 0];
            data2[i * 4 + 3] = this.right[i * 2 + 1];
        }
        return data2;
    }

    public void playRange(int startFrame, int endFrame) {
        this.ref = new MemSoundReference(this.left, this.right, 1.0, 0.0, this.ID, this);
        this.ref.setRange(startFrame, endFrame);
        this.mixer.registerSoundReference(this.ref);
    }

    public void cutRange(int startFrame, int endFrame) {
        int sizeInByte = (endFrame - startFrame) * 2;
        byte[] nleft = new byte[this.left.length - sizeInByte];
        byte[] nright = new byte[this.right.length - sizeInByte];
        System.arraycopy(this.left, 0, nleft, 0, startFrame * 2);
        System.arraycopy(this.right, 0, nright, 0, startFrame * 2);
        int sizeInRest = this.left.length - startFrame * 2 - sizeInByte;
        System.arraycopy(this.left, endFrame * 2, nleft, startFrame * 2, sizeInRest);
        System.arraycopy(this.right, endFrame * 2, nright, startFrame * 2, sizeInRest);
        this.left = nleft;
        this.right = nright;
    }

    @Override
    public void play() {
        this.play(1.0);
    }

    @Override
    public void play(double volume) {
        this.play(volume, 0.0);
    }

    @Override
    public void play(double volume, double pan) {
        this.ref = new MemSoundReference(this.left, this.right, volume, pan, this.ID, this);
        this.mixer.registerSoundReference(this.ref);
    }

    public int getPosition() {
        if (this.ref == null) {
            return -1;
        }
        return this.ref.getPosition();
    }

    public int get16BitDataAt(int p, int c) {
        if (c == 0) {
            return this.left[p + 1] << 8 | this.left[p] & 0xFF;
        }
        return this.right[p + 1] << 8 | this.right[p] & 0xFF;
    }

    @Override
    public void stop() {
        this.mixer.unRegisterSoundReference(this.ID);
        this.ref = null;
    }

    @Override
    public void unload() {
        this.mixer.unRegisterSoundReference(this.ID);
        this.mixer = null;
        this.left = null;
        this.right = null;
        this.listeners = null;
        this.ref = null;
    }

    private static class MemSoundReference
    implements SoundReference {
        public final int SOUND_ID;
        private byte[] left;
        private byte[] right;
        private int position;
        private int endPosition;
        private double volume;
        private double pan;
        MemSound memSound;

        public MemSoundReference(byte[] left, byte[] right, double volume, double pan, int soundID, MemSound ms) {
            this.left = left;
            this.right = right;
            this.volume = volume >= 0.0 ? volume : 1.0;
            this.pan = pan >= -1.0 && pan <= 1.0 ? pan : 0.0;
            this.position = 0;
            this.SOUND_ID = soundID;
            this.memSound = ms;
            this.endPosition = this.left.length;
        }

        @Override
        public int getSoundID() {
            return this.SOUND_ID;
        }

        @Override
        public double getVolume() {
            return this.volume;
        }

        @Override
        public double getPan() {
            return this.pan;
        }

        @Override
        public long bytesAvailable() {
            return this.endPosition - this.position;
        }

        @Override
        public synchronized void skipBytes(long num) {
            this.position = (int)((long)this.position + num);
            this.memSound.positionChanged(this.position);
        }

        public int getPosition() {
            return this.position;
        }

        public void setRange(int startFrame, int endFrame) {
            this.position = startFrame * 2;
            this.endPosition = endFrame * 2;
        }

        @Override
        public void nextTwoBytes(int[] data2, boolean bigEndian) {
            if (bigEndian) {
                data2[0] = this.left[this.position] << 8 | this.left[this.position + 1] & 0xFF;
                data2[1] = this.right[this.position] << 8 | this.right[this.position + 1] & 0xFF;
            } else {
                data2[0] = this.left[this.position + 1] << 8 | this.left[this.position] & 0xFF;
                data2[1] = this.right[this.position + 1] << 8 | this.right[this.position] & 0xFF;
            }
            this.position += 2;
            this.memSound.positionChanged(this.position);
        }

        @Override
        public void dispose() {
            this.position = this.left.length + 1;
            this.left = null;
            this.right = null;
            this.memSound.positionChanged(this.position);
        }
    }
}

