/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.util.DownloaderXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class Downloader {
    protected String mClass = "";
    public String mName = "";
    protected String mURL = "";
    protected boolean misZip = false;
    protected Vector<String> mFileInZip = new Vector();
    protected Vector<String> mFileUnpacked = new Vector();
    protected boolean mUnpackAll = false;
    protected String mDestinationDirAll = "";
    private static DownloaderXMLHandler XMLHANDLER = new DownloaderXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public String getURL() {
        return this.mURL;
    }

    public void setURL(String URL2) {
        this.mURL = URL2;
    }

    public boolean getisZip() {
        return this.misZip;
    }

    public void setisZip(boolean isZip) {
        this.misZip = isZip;
    }

    public Vector<String> getFileInZip() {
        return this.mFileInZip;
    }

    public void setFileInZip(Vector<String> FileInZip) {
        this.mFileInZip = FileInZip;
    }

    public Vector<String> getFileUnpacked() {
        return this.mFileUnpacked;
    }

    public void setFileUnpacked(Vector<String> FileUnpacked) {
        this.mFileUnpacked = FileUnpacked;
    }

    public boolean getUnpackAll() {
        return this.mUnpackAll;
    }

    public void setUnpackAll(boolean UnpackAll) {
        this.mUnpackAll = UnpackAll;
    }

    public String getDestinationDirAll() {
        return this.mDestinationDirAll;
    }

    public void setDestinationDirAll(String DestinationDirAll) {
        this.mDestinationDirAll = DestinationDirAll;
    }

    private String exportXML() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("\t<Downloader>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<URL>" + UtilityString.toXML(this.mURL) + "</URL>\n");
        s.append("\t\t<isZip>" + this.misZip + "</isZip>\n");
        s.append("\t\t<FileInZips>\n");
        for (i = 0; i < this.mFileInZip.size(); ++i) {
            s.append("\t\t\t<FileInZip>" + UtilityString.toXML(this.mFileInZip.elementAt(i)) + "</FileInZip>\n");
        }
        s.append("\t\t</FileInZips>\n");
        s.append("\t\t<FileUnpackeds>\n");
        for (i = 0; i < this.mFileUnpacked.size(); ++i) {
            s.append("\t\t\t<FileUnpacked>" + UtilityString.toXML(this.mFileUnpacked.elementAt(i)) + "</FileUnpacked>\n");
        }
        s.append("\t\t</FileUnpackeds>\n");
        s.append("\t\t<UnpackAll>" + this.mUnpackAll + "</UnpackAll>\n");
        s.append("\t\t<DestinationDirAll>" + UtilityString.toXML(this.mDestinationDirAll) + "</DestinationDirAll>\n");
        s.append("\t</Downloader>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static DownloaderXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<Downloader> col) {
        return Downloader.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<Downloader> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllDownloader>\n");
            for (Downloader item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllDownloader>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, Downloader> getHashMapFromXML(String filename) {
        HashMap<String, Downloader> filters = new HashMap<String, Downloader>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DownloaderXMLHandler h = Downloader.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Downloader Load Error...", 1);
        }
        return filters;
    }
}

