/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.HotKey;
import de.malban.gui.components.CSAInternalFrame;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.gui.dialogs.ShowInfoDialog;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Downloader;
import de.malban.util.DownloaderPool;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DownloaderPanel
extends JPanel {
    transient LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private Downloader mDownloader = new Downloader();
    private DownloaderPool mDownloaderPool;
    private int mClassSetting = 0;
    boolean forcedClass = false;
    String className = "";
    static String lastImagePath = "";
    private JButton jButtonDelete;
    private JButton jButtonFileSelect10;
    private JButton jButtonFileSelect11;
    private JButton jButtonFileSelect4;
    private JButton jButtonFileSelect5;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    static int loaded;
    static boolean finished;

    public DownloaderPanel() {
        this.initComponents();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldKlasse);
            HotKey.addMacDefaults(this.jTextFieldName);
            HotKey.addMacDefaults(this.jTextField1);
            HotKey.addMacDefaults(this.jTextField4);
            HotKey.addMacDefaults(this.jTextField5);
            HotKey.addMacDefaults(this.jTextField6);
        }
        this.mDownloaderPool = new DownloaderPool();
        this.jTabbedPane1.removeAll();
        this.resetConfigPool(false, "");
        if (lastImagePath.length() == 0) {
            Path currentRelativePath = Paths.get(".", new String[0]);
            lastImagePath = currentRelativePath.toAbsolutePath().toString();
        }
    }

    public Downloader getDownloader() {
        this.readAllToCurrent();
        return this.mDownloader;
    }

    public void setValues(String cn, String selectedItemName, boolean fc) {
        this.forcedClass = fc;
        this.className = cn;
        this.resetConfigPool(true, this.className);
        this.jComboBoxName.setSelectedItem(selectedItemName);
        this.jComboBoxKlasse.setEnabled(!this.forcedClass);
        this.jTextFieldKlasse.setEnabled(!this.forcedClass);
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mDownloaderPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        if (this.forcedClass) {
            if (!klasse.equals(this.className)) {
                this.jComboBoxKlasse.addItem(this.className);
            }
            klasse = this.className;
            this.jComboBoxKlasse.setSelectedItem(this.className);
            this.jTextFieldKlasse.setText(this.className);
        }
        Collection<Downloader> colC = this.mDownloaderPool.getMapForKlasse(klasse).values();
        Iterator<Downloader> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            Downloader item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mDownloader = this.mDownloaderPool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mDownloader = new Downloader();
        this.mDownloader.mClass = this.forcedClass ? this.className : "Cartridge";
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxKlasse.setSelectedItem(this.mDownloader.mClass);
        this.jTextFieldKlasse.setText(this.mDownloader.mClass);
        this.jComboBoxName.setSelectedItem(this.mDownloader.mName);
        this.jTextFieldName.setText(this.mDownloader.mName);
        this.jTabbedPane1.removeAll();
        this.jTextField1.setText(this.mDownloader.mURL);
        this.jTextField6.setText(this.mDownloader.mDestinationDirAll);
        this.jCheckBox1.setSelected(this.mDownloader.misZip);
        this.jCheckBox2.setSelected(this.mDownloader.mUnpackAll);
        for (int i = 0; i < this.mDownloader.mFileInZip.size(); ++i) {
            JPanel jPanel3 = new JPanel();
            JLabel jLabel6 = new JLabel();
            JTextField jTextField4 = new JTextField();
            JLabel jLabel7 = new JLabel();
            JTextField jTextField5 = new JTextField();
            JButton jButtonFileSelect4 = new JButton();
            jTextField4.setPreferredSize(new Dimension(6, 21));
            jTextField5.setPreferredSize(new Dimension(6, 21));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Zip"));
            jLabel6.setText("Name in Zip");
            jLabel7.setText("Name unpacked");
            jButtonFileSelect4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
            jButtonFileSelect4.setMargin(new Insets(0, 1, 0, -1));
            final JTextField bla = jTextField5;
            jButtonFileSelect4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    InternalFrameFileChoser fc = new InternalFrameFileChoser();
                    fc.setMultiSelectionEnabled(false);
                    fc.setCurrentDirectory(new File(lastImagePath));
                    int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
                    if (r != 0) {
                        return;
                    }
                    File files = fc.getSelectedFile();
                    if (files != null) {
                        String fullPath = fc.getSelectedFile().getAbsolutePath();
                        lastImagePath = fc.getSelectedFile().getParent();
                        bla.setText(Utility.makeVideRelative(fullPath));
                    }
                }
            });
            GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
            jPanel3.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel7).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField4).addGroup(jPanel3Layout.createSequentialGroup().addComponent(jTextField5, -2, 382, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jButtonFileSelect4).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(jTextField5, -2, -1, -2))).addComponent(jButtonFileSelect4)).addGap(0, 10, Short.MAX_VALUE)));
            jTextField4.setText(this.mDownloader.mFileInZip.elementAt(i));
            jTextField5.setText(this.mDownloader.mFileUnpacked.elementAt(i));
            this.jTabbedPane1.addTab("File " + (i + 1), jPanel3);
        }
        this.jButtonFileSelect10.setEnabled(this.jCheckBox1.isSelected());
        this.jButtonFileSelect11.setEnabled(this.jCheckBox1.isSelected());
        this.jCheckBox2.setEnabled(this.jCheckBox1.isSelected());
        this.jTabbedPane1.setEnabled(this.jCheckBox1.isSelected());
        if (this.jCheckBox2.isSelected()) {
            this.jTabbedPane1.setEnabled(false);
        }
        this.setTabEnabled();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mDownloader.mClass = this.jTextFieldKlasse.getText();
        this.mDownloader.mName = this.jTextFieldName.getText();
        this.mDownloader.mURL = this.jTextField1.getText();
        this.mDownloader.mDestinationDirAll = this.jTextField6.getText();
        this.mDownloader.misZip = this.jCheckBox1.isSelected();
        this.mDownloader.mUnpackAll = this.jCheckBox2.isSelected();
        this.mDownloader.mFileInZip.clear();
        this.mDownloader.mFileUnpacked.clear();
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            JPanel p = (JPanel)this.jTabbedPane1.getComponentAt(i);
            JTextField t = (JTextField)p.getComponent(2);
            this.mDownloader.mFileInZip.addElement(t.getText());
            t = (JTextField)p.getComponent(3);
            this.mDownloader.mFileUnpacked.addElement(t.getText());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jButtonFileSelect4 = new JButton();
        this.jButtonFileSelect10 = new JButton();
        this.jButtonFileSelect11 = new JButton();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jButtonFileSelect5 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setPreferredSize(new Dimension(150, 21));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setPreferredSize(new Dimension(150, 21));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jTextFieldName.setPreferredSize(new Dimension(150, 21));
        this.jTextFieldKlasse.setPreferredSize(new Dimension(150, 21));
        this.jButtonNew.setText("New");
        this.jButtonNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setPreferredSize(new Dimension(130, 21));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(130, 21));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldKlasse, -2, -1, -2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jComboBoxName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDelete, -2, -1, -2).addComponent(this.jButtonSaveAsNew, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonNew, -2, -1, -2).addComponent(this.jButtonDelete, -2, -1, -2).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew, -2, -1, -2).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jComboBoxName, -2, -1, -2).addComponent(this.jTextFieldName, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel4)).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jLabel3))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("URL");
        this.jTextField1.setPreferredSize(new Dimension(600, 21));
        this.jCheckBox1.setText("isZip");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jTabbedPane1.setEnabled(false);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Zip"));
        this.jLabel6.setText("Name in Zip");
        this.jTextField4.setPreferredSize(new Dimension(6, 21));
        this.jLabel7.setText("Name unpacked");
        this.jTextField5.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect4.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonFileSelect4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField4, -2, 417, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jTextField5, -2, 382, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFileSelect4))).addContainerGap(76, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField5, -2, -1, -2)).addComponent(this.jButtonFileSelect4)).addGap(0, 47, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("File #", this.jPanel3);
        this.jButtonFileSelect10.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonFileSelect10.setEnabled(false);
        this.jButtonFileSelect10.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonFileSelect10ActionPerformed(evt);
            }
        });
        this.jButtonFileSelect11.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonFileSelect11.setEnabled(false);
        this.jButtonFileSelect11.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonFileSelect11ActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("complete Unzip");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Destination");
        this.jTextField6.setToolTipText("Complete Unzip - or single file");
        this.jTextField6.setPreferredSize(new Dimension(6, 21));
        this.jButtonFileSelect5.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        this.jButtonFileSelect5.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloaderPanel.this.jButtonFileSelect5ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField6, -2, 535, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFileSelect5)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBox1).addGap(18, 18, 18).addComponent(this.jButtonFileSelect10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2)).addComponent(this.jTabbedPane1).addComponent(this.jTextField1, -1, -1, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jButtonFileSelect10).addComponent(this.jButtonFileSelect11).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField6, -2, -1, -2).addComponent(this.jLabel8))).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonFileSelect5))).addGap(70, 70, 70)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mDownloader = new Downloader();
        this.clearAll();
        if (this.forcedClass) {
            this.resetConfigPool(false, this.className);
        } else {
            this.resetConfigPool(false, "");
        }
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mDownloaderPool.put(this.mDownloader);
        String name = this.mDownloader.mName;
        this.mDownloaderPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        --this.mClassSetting;
        this.jComboBoxName.setSelectedItem(name);
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mDownloader = new Downloader();
        this.readAllToCurrent();
        this.mDownloaderPool.putAsNew(this.mDownloader);
        this.mDownloaderPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        this.jComboBoxName.setSelectedItem(this.mDownloader.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mDownloaderPool.remove(this.mDownloader);
        this.mDownloaderPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        if (this.jComboBoxName.getItemCount() == 0) {
            this.jButtonNewActionPerformed(null);
            --this.mClassSetting;
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mDownloader = this.mDownloaderPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mDownloader = this.mDownloaderPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mDownloader = this.mDownloaderPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButtonFileSelect4ActionPerformed(ActionEvent evt) {
    }

    private void jButtonFileSelect10ActionPerformed(ActionEvent evt) {
        JPanel jPanel3 = new JPanel();
        JLabel jLabel6 = new JLabel();
        JTextField jTextField4 = new JTextField();
        JLabel jLabel7 = new JLabel();
        JTextField jTextField5 = new JTextField();
        JButton jButtonFileSelect4 = new JButton();
        jTextField4.setPreferredSize(new Dimension(6, 21));
        jTextField5.setPreferredSize(new Dimension(6, 21));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Zip"));
        jLabel6.setText("Name in Zip");
        jLabel7.setText("Name unpacked");
        jButtonFileSelect4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/folder_go.png")));
        jButtonFileSelect4.setMargin(new Insets(0, 1, 0, -1));
        final JTextField bla = jTextField5;
        jButtonFileSelect4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameFileChoser fc = new InternalFrameFileChoser();
                fc.setMultiSelectionEnabled(false);
                fc.setCurrentDirectory(new File(lastImagePath));
                int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
                if (r != 0) {
                    return;
                }
                File files = fc.getSelectedFile();
                if (files != null) {
                    String fullPath = fc.getSelectedFile().getAbsolutePath();
                    lastImagePath = fc.getSelectedFile().getParent();
                    bla.setText(Utility.makeVideRelative(fullPath));
                }
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel7).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTextField4).addGroup(jPanel3Layout.createSequentialGroup().addComponent(jTextField5, -2, 382, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jButtonFileSelect4).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(jTextField5, -2, -1, -2))).addComponent(jButtonFileSelect4)).addGap(0, 10, Short.MAX_VALUE)));
        this.mDownloader.mFileInZip.addElement("");
        this.mDownloader.mFileUnpacked.addElement("");
        this.jTabbedPane1.addTab("File " + this.mDownloader.mFileInZip.size(), jPanel3);
    }

    private void jButtonFileSelect11ActionPerformed(ActionEvent evt) {
        if (this.mDownloader.mFileInZip.size() == 0) {
            return;
        }
        this.mDownloader.mFileInZip.removeElementAt(this.mDownloader.mFileInZip.size() - 1);
        this.mDownloader.mFileUnpacked.removeElementAt(this.mDownloader.mFileUnpacked.size() - 1);
        this.jTabbedPane1.remove(this.jTabbedPane1.getTabCount() - 1);
    }

    private void jButtonFileSelect5ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File(lastImagePath));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        File files = fc.getSelectedFile();
        if (files != null) {
            String fullPath = fc.getSelectedFile().getAbsolutePath();
            lastImagePath = fc.getSelectedFile().getParent();
            this.jTextField6.setText(Utility.makeVideRelative(fullPath));
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.jButtonFileSelect10.setEnabled(this.jCheckBox1.isSelected());
        this.jButtonFileSelect11.setEnabled(this.jCheckBox1.isSelected());
        this.jCheckBox2.setEnabled(this.jCheckBox1.isSelected());
        this.jTabbedPane1.setEnabled(this.jCheckBox1.isSelected());
        if (this.jCheckBox2.isSelected()) {
            this.jTabbedPane1.setEnabled(false);
        }
        this.setTabEnabled();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setEnabled(this.jCheckBox1.isSelected());
        if (this.jCheckBox2.isSelected()) {
            this.jTabbedPane1.setEnabled(false);
        }
        this.setTabEnabled();
    }

    void setTabEnabled() {
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            ((JPanel)this.jTabbedPane1.getComponentAt(i)).setEnabled(this.jTabbedPane1.isEnabled());
            for (int ii = 0; ii < ((JPanel)this.jTabbedPane1.getComponentAt(i)).getComponentCount(); ++ii) {
                JComponent c = (JComponent)((JPanel)this.jTabbedPane1.getComponentAt(i)).getComponent(ii);
                c.setEnabled(this.jTabbedPane1.isEnabled());
            }
        }
    }

    public static Downloader getDownloader(String mClass, String mName) {
        DownloaderPool downloaderPool = new DownloaderPool();
        Collection<Downloader> colC = downloaderPool.getMapForKlasse(mClass).values();
        for (Downloader item : colC) {
            if (!item.mName.equals(mName)) continue;
            return item;
        }
        return null;
    }

    public static String saveUrl(String _url, String destinationName) {
        if (!finished) {
            return null;
        }
        loaded = 0;
        finished = false;
        WorkerThread runner = new WorkerThread();
        runner._url = _url;
        runner.destinationName = destinationName;
        runner.start();
        ShowInfoDialog dialog = new ShowInfoDialog();
        dialog.setButtonVisible(false);
        dialog.setText("Loading file from internet...");
        CSAInternalFrame frame = new CSAInternalFrame();
        Rectangle bb = frame.getBounds();
        frame.setBounds(bb.x, bb.y, 400, 150);
        frame.setParent(Configuration.getConfiguration().getMainFrame());
        frame.addPanel(dialog);
        Configuration.getConfiguration().getMainFrame().addInternalFrame(frame);
        frame.setVisible(true);
        while (!finished) {
            try {
                Thread.sleep(100L);
                dialog.setText("Loading file from internet... " + loaded + " bytes...");
            }
            catch (Throwable throwable) {}
        }
        frame.setVisible(false);
        Configuration.getConfiguration().getMainFrame().removeInternalFrame(frame);
        return runner.getResult();
    }

    public static String saveUrlInternal(String _url, String destinationName) {
        File ff = new File(destinationName);
        if (ff.exists()) {
            finished = true;
            return destinationName;
        }
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        Proxy p = null;
        p = Proxy.NO_PROXY;
        try {
            URL url = new URL(_url);
            File f = new File(destinationName);
            BufferedInputStream in = new BufferedInputStream(url.openConnection(p).getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            byte[] b = new byte[10000];
            int len = in.read(b);
            while (len != -1) {
                out.write(b, 0, len);
                len = in.read(b);
                loaded += len;
            }
            in.close();
            out.close();
        }
        catch (Throwable e) {
            log.addLog(e, LogPanel.ERROR);
            finished = true;
            return null;
        }
        log.addLog("Download from " + _url + " -> " + destinationName + " - done", LogPanel.INFO);
        finished = true;
        return destinationName;
    }

    public static boolean ensureLocalFile(String mClass, String mName, String localFile) {
        if (mName == null) {
            return true;
        }
        if (mName.trim().length() == 0) {
            return true;
        }
        File f = new File(DownloaderPanel.convertSeperator(localFile));
        if (!f.isDirectory() && f.exists()) {
            return true;
        }
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        boolean ret = true;
        Downloader downloader = DownloaderPanel.getDownloader(mClass, mName);
        if (downloader == null) {
            log.addLog("DownloaderPanel: download config not found: " + mClass + "->" + mName, LogPanel.WARN);
            return false;
        }
        if (!downloader.misZip) {
            String name = Global.mainPathPrefix + DownloaderPanel.convertSeperator(downloader.mDestinationDirAll);
            f = new File(name);
            if (f.exists()) {
                return true;
            }
            String savedName = DownloaderPanel.saveUrl(downloader.mURL, name);
            if (savedName == null) {
                return false;
            }
            f = new File(name);
            return f.exists();
        }
        int last = downloader.mURL.lastIndexOf("/");
        if (last == -1) {
            log.addLog("DownloaderPanel: url is weird: " + downloader.mURL, LogPanel.WARN);
            return false;
        }
        String[] adder = mName.split(" ");
        String loadedZipName = "";
        loadedZipName = !downloader.mURL.toUpperCase().contains("TOSEC") ? Global.mainPathPrefix + "download" + File.separator + "zips" + File.separator + adder[0] + downloader.mURL.substring(last + 1) : Global.mainPathPrefix + "download" + File.separator + "zips" + File.separator + downloader.mURL.substring(last + 1);
        String savedName = loadedZipName;
        if (!new File(loadedZipName).exists()) {
            savedName = DownloaderPanel.saveUrl(downloader.mURL, loadedZipName);
        }
        if (savedName == null) {
            return false;
        }
        try {
            if (downloader.mUnpackAll) {
                UtilityFiles.unzip(savedName, Global.mainPathPrefix + downloader.mDestinationDirAll);
            } else {
                UtilityFiles.unzip(savedName, Global.mainPathPrefix + "tmp");
                for (int i = 0; i < downloader.mFileInZip.size(); ++i) {
                    if (downloader.mFileInZip.elementAt(i).toLowerCase().endsWith(".zip")) {
                        UtilityFiles.unzip(Global.mainPathPrefix + "tmp" + File.separator + DownloaderPanel.convertSeperator(downloader.mFileInZip.elementAt(i)), Global.mainPathPrefix + "tmp" + File.separator + "1");
                        ArrayList<String> unzippedZipZipFiles = UtilityFiles.getFilesWith(Global.mainPathPrefix + "tmp" + File.separator + "1", ".bin");
                        if (unzippedZipZipFiles.size() != 1) {
                            log.addLog("TOSEC suspected, but multiple entries found - no extraction!", 64);
                            return false;
                        }
                        UtilityFiles.copyOneFile(Global.mainPathPrefix + "tmp" + File.separator + "1" + File.separator + unzippedZipZipFiles.get(0), Global.mainPathPrefix + DownloaderPanel.convertSeperator(downloader.mFileUnpacked.elementAt(i)));
                        UtilityFiles.deleteDirectoryRecursive(Global.mainPathPrefix + "tmp" + File.separator + "1");
                        continue;
                    }
                    UtilityFiles.copyOneFile(Global.mainPathPrefix + "tmp" + File.separator + DownloaderPanel.convertSeperator(downloader.mFileInZip.elementAt(i)), Global.mainPathPrefix + DownloaderPanel.convertSeperator(downloader.mFileUnpacked.elementAt(i)));
                }
            }
            UtilityFiles.cleanDirectory(Global.mainPathPrefix + "tmp");
        }
        catch (Throwable e) {
            log.addLog(e, 64);
            return false;
        }
        return ret;
    }

    public static String convertSeperator(String filename) {
        String ret = UtilityString.replace(filename, "/", File.separator);
        ret = UtilityString.replace(ret, "\\", File.separator);
        return ret;
    }

    static {
        finished = true;
    }

    static class WorkerThread
    extends Thread {
        String result;
        String _url;
        String destinationName;

        WorkerThread() {
        }

        @Override
        public void run() {
            this.result = DownloaderPanel.saveUrlInternal(this._url, this.destinationName);
        }

        public String getResult() {
            return this.result;
        }
    }
}

