/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.util.Downloader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class DownloaderPool {
    public static final String DEFAULT_XML_NAME = new String("Downloader.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, Downloader> mDownloader = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public DownloaderPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public DownloaderPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error Downloader...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mDownloader = Downloader.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        Downloader.saveCollectionAsXML(this.mFileName, this.mDownloader.values());
        this.buildKlassenMap();
    }

    public void remove(Downloader st) {
        this.mDownloader.remove(st.mName);
    }

    public void put(Downloader st) {
        this.mDownloader.remove(st.mName);
        this.mDownloader.put(st.mName, st);
    }

    public void putAsNew(Downloader st) {
        this.mDownloader.put(st.mName, st);
    }

    public Downloader get(String key) {
        return this.mDownloader.get(key);
    }

    public HashMap<String, Downloader> getHashMap() {
        return this.mDownloader;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, Downloader>> entries = this.mDownloader.entrySet();
        for (Map.Entry<String, Downloader> entry : entries) {
            Downloader value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, Downloader> getMapForKlasse(String klasse) {
        HashMap<String, Downloader> ret = new HashMap<String, Downloader>();
        Set<Map.Entry<String, Downloader>> entries = this.mDownloader.entrySet();
        for (Map.Entry<String, Downloader> entry : entries) {
            Downloader value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

